var gulp = require('gulp');
var path = require('path');
var ts = require('gulp-typescript');
var sourcemaps = require('gulp-sourcemaps');

gulp.task('build:server', function() {
    var tsProject = ts.createProject(
        path.resolve('./server/tsconfig.json')
    );
    var tsResult = gulp.src(['./server/**/*.ts'])
        .pipe(sourcemaps.init())
        .pipe(ts(tsProject));
    return tsResult.js
        .pipe(sourcemaps.write())
        .pipe(gulp.dest(
            path.resolve('./dist/server')
        ));
});

gulp.task('build', ['build:server']);

gulp.task('default', ['build']);