import * as express from 'express';
import * as IndexRoute from './routes/index';

export class Server {
    private app: express.Express;

    public static bootstrap() : Server {
        return new Server();
    }

    constructor() {
        this.app = express();

        this.setRoutes();
    }

    private setRoutes() {
        let router : express.Router = express.Router();        

        router.use(IndexRoute.Index.routes());

        this.app.use(router);
    }

    public startServer() {
        this.app.listen(3000, function() {
            console.log('Application listening on 3000');
        });
    }
}