import * as express from 'express';
import * as Product from '../model/product';

export class Products {
    private productList : Array<Product.Product> = [];

    public static routes() : express.Router {
        let router : express.Router = express.Router();
        let productsRoute : Products = new Products();

        router.get('/products/', productsRoute.index.bind(productsRoute)); 

        return router;
    }

    constructor() {
        this.productList.push(new Product.Product(1, 'ABC', 1));
        this.productList.push(new Product.Product(2, 'DEF', 12));
        this.productList.push(new Product.Product(3, 'GHI'));
    }

    public index(req : express.Request, res : express.Response) {
        res.json(this.productList);
    }
}