import * as express from 'express';
import * as Product from '../model/product';

export class Products {
    private productList : Array<Product.Product> = [];

    public static routes() : express.Router {
        let router : express.Router = express.Router();
        let productsRoute : Products = new Products();

        router.get('/products/', productsRoute.index.bind(productsRoute));
        router.post('/products/', productsRoute.create.bind(productsRoute));
        router.get('/products/:product_id', productsRoute.fetch.bind(productsRoute)); 

        return router;
    }

    constructor() {
        this.productList.push(new Product.Product(1, 'ABC', 1));
        this.productList.push(new Product.Product(2, 'DEF', 12));
        this.productList.push(new Product.Product(3, 'GHI'));
    }

    public index(req : express.Request, res : express.Response) {
        res.json(this.productList);
    }

    public create(req : express.Request, res : express.Response) {
        let productName : string = req.body.product_name;
        let productQuantity : number = parseInt(req.body.quantity) || 0;

        if (!productName) {
            res.status(500).send('Product name not found');
            return;
        }

        this.productList.push(new Product.Product(-1, productName, productQuantity));

        res.json(this.productList);
    }

    public fetch(req : express.Request, res : express.Response) {
        let productId : number = parseInt(req.params.product_id);

        if (!productId) {
            res.status(404).send('Product not found');
            return;
        }

        let product : Product.Product = this.productList.filter(
            (product : Product.Product) => product.getId() === productId
        ).shift();

        if (!product) {
            res.status(404).send('Product not found');
            return;
        }

        res.json(product);
    }
}