import * as ProductModel from './product';

export class Products {
    private productsList : Array<ProductModel.Product>;

    constructor(products : Array<ProductModel.Product> = []) {
        this.productsList = new Array<ProductModel.Product>();

        products.forEach(
            (product) => this.productsList.push(product)
        );
    }

    public list() : Array<ProductModel.Product> {
        return this.productsList;
    }

    public add(product : ProductModel.Product) {
        this.productsList.push(product);

        return this.productsList;
    }

    public fetch(productId : number) : ProductModel.Product {
        return this.productsList.filter(
            (product : ProductModel.Product) => product.getId() === productId
        ).shift();
    }
}