import { Component } from '@angular/core';

export class Product {
  name: string;
  quantity: number;
}

@Component({
  selector: 'my-app',
  template: `<h1>Products</h1>
  <ul class="products">
    <li *ngFor="let product of products">
       {{product.name}}
       <span class="quantity">{{product.quantity}}</span>
    </li>
  </ul>
  `
})
export class AppComponent {
  products: Product[] = [
    { name: 'Test', quantity: 1 },
    { name: 'aaa', quantity: 5 },
    { name: 'bbb', quantity: 3 },
  ];
  selectedProduct: Product;
}