import { Component, OnInit } from '@angular/core';

import { Product } from './product';
import { ProductService } from './product.service';

@Component({
  selector: 'my-app',
  template: `<h1>Products</h1>
  <ul class="products">
    <li *ngFor="let product of products">
       {{product.name}}
       <span class="quantity">{{product.quantity}}</span>
    </li>
  </ul>
  `,
  providers: [ProductService]
})
export class AppComponent implements OnInit {
  products: Product[];
  selectedProduct: Product;

  constructor(private productService: ProductService) { }

  getProducts(): void {
    this.productService.getProducts()
      .then(products => this.products = products);
  }

  ngOnInit(): void {
    this.getProducts();
  }
}