import { Component, OnInit } from '@angular/core';

import { Product } from './product';
import { ProductService } from './product.service';

@Component({
  selector: 'my-app',
  template: `<h1>Products</h1>
  <ul class="products">
    <li *ngFor="let product of products" (click)="onSelect(product)"
      [class.selected]="product === selectedProduct"
    >
       <span class="quantity">{{product.quantity}}</span>
       {{product.name}}
    </li>
  </ul>
  <div *ngIf="selectedProduct">
    <h2>{{selectedProduct.name}} - {{selectedProduct.quantity}}</h2>
    <div><label>id: </label>{{selectedProduct.id}}</div>
    <div>
      <label>name: </label>
      <input [(ngModel)]="selectedProduct.name" placeholder="name" />
      <label>quantity: </label>
      <input [(ngModel)]="selectedProduct.quantity" placeholder="quantity" />
    </div>
  </div>
  `,
  styles: [
    `
    .selected {
      background-color: #CFD8DC !important;
      color: white;
    }
    .products {
      margin: 0 0 2em 0;
      list-style-type: none;
      padding: 0;
      width: 15em;
    }
    .products li {
      cursor: pointer;
      position: relative;
      left: 0;
      background-color: #EEE;
      margin: .5em;
      padding: .3em 0;
      height: 1.6em;
      border-radius: 4px;
    }
    .products li.selected:hover {
      background-color: #BBD8DC !important;
      color: white;
    }
    .products li:hover {
      color: #607D8B;
      background-color: #DDD;
      left: .1em;
    }

    .products .quantity {
      display: inline-block;
      font-size: small;
      color: white;
      padding: 0.8em 0.7em 0 0.7em;
      background-color: #607D8B;
      line-height: 1em;
      position: relative;
      left: -1px;
      top: -4px;
      height: 1.8em;
      margin-right: .8em;
      border-radius: 4px 0 0 4px;
      width: 30px;
      text-align: center;
    }
    `
  ],
  providers: [ProductService]
})
export class AppComponent implements OnInit {
  products: Product[];
  selectedProduct: Product;

  constructor(private productService: ProductService) { }

  getProducts(): void {
    this.productService.getProducts()
      .then(products => this.products = products);
  }

  onSelect(product: Product): void {
    this.selectedProduct = product;
  }

  ngOnInit(): void {
    this.getProducts();
  }
}