SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=623 ;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 713, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":{"6":1},"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 18, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(8, 1, 19, 304, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 305, 306, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 307, 308, 1, 'com_installer', 'com_installer', '{"core.admin":[],"core.manage":{"7":0},"core.delete":{"7":0},"core.edit.state":{"7":0}}'),
(11, 1, 309, 310, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 311, 312, 1, 'com_login', 'com_login', '{}'),
(13, 1, 313, 314, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 315, 316, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 317, 318, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1}}'),
(16, 1, 319, 320, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 321, 322, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 323, 496, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 497, 500, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(20, 1, 501, 502, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 503, 504, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 505, 506, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 507, 508, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 509, 512, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(25, 1, 513, 516, 1, 'com_weblinks', 'com_weblinks', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(26, 1, 517, 518, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 23, 2, 'com_content.category.2', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(30, 19, 498, 499, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(31, 25, 514, 515, 2, 'com_weblinks.category.6', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(32, 24, 510, 511, 1, 'com_users.category.7', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(33, 1, 519, 520, 1, 'com_finder', 'com_finder', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(34, 1, 521, 522, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{"core.admin":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}'),
(35, 1, 523, 524, 1, 'com_tags', 'com_tags', '{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 1, 525, 526, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 527, 528, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 529, 530, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 324, 325, 2, 'com_modules.module.2', 'Login', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 18, 326, 327, 2, 'com_modules.module.3', 'Popular Articles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 18, 328, 329, 2, 'com_modules.module.4', 'Recently Added Articles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(43, 18, 330, 331, 2, 'com_modules.module.8', 'Toolbar', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(44, 18, 332, 333, 2, 'com_modules.module.9', 'Quick Icons', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(45, 18, 334, 335, 2, 'com_modules.module.10', 'Logged-in Users', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(46, 18, 336, 337, 2, 'com_modules.module.12', 'Admin Menu', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(47, 18, 338, 339, 2, 'com_modules.module.13', 'Admin Submenu', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(48, 18, 340, 341, 2, 'com_modules.module.14', 'User Status', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(49, 18, 342, 343, 2, 'com_modules.module.15', 'Title', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(52, 18, 344, 345, 2, 'com_modules.module.79', 'Multilanguage status', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(53, 18, 346, 347, 2, 'com_modules.module.86', 'Joomla Version', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(54, 18, 348, 349, 2, 'com_modules.module.87', 'Komento activities', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(55, 18, 350, 351, 2, 'com_modules.module.88', 'Komento comments', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(61, 18, 352, 353, 2, 'com_modules.module.93', 'Superfish menu', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(62, 18, 354, 355, 2, 'com_modules.module.94', 'Recent templates', ''),
(63, 1, 531, 532, 1, 'com_kunena', 'com_kunena', '{}'),
(64, 8, 24, 85, 2, 'com_content.category.8', 'Home', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(65, 8, 86, 115, 2, 'com_content.category.9', 'About', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(66, 8, 116, 119, 2, 'com_content.category.10', 'Policies', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(67, 8, 120, 125, 2, 'com_content.category.11', 'Blog', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(74, 475, 232, 239, 4, 'com_content.category.18', 'Accordions and Toggles', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(81, 342, 165, 178, 3, 'com_content.category.25', 'History', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(82, 342, 179, 202, 3, 'com_content.category.26', 'Team', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(83, 342, 203, 216, 3, 'com_content.category.27', 'FAQs', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(84, 342, 217, 230, 3, 'com_content.category.28', 'Testimonials', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(85, 8, 126, 129, 2, 'com_content.category.29', 'Help', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(91, 66, 117, 118, 3, 'com_content.article.6', 'Privacy policy', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(96, 67, 123, 124, 3, 'com_content.article.11', 'New Tesla Model X is now available', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(101, 74, 233, 234, 5, 'com_content.article.16', 'Qualified Staff', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(102, 74, 235, 236, 5, 'com_content.article.17', 'Satisfaction Guarantee', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(103, 74, 237, 238, 5, 'com_content.article.18', '24/7 Support', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(120, 81, 166, 167, 4, 'com_content.article.35', 'Our first steps on the market', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(121, 81, 168, 169, 4, 'com_content.article.36', 'Continuous innovation and transformation', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(122, 81, 170, 171, 4, 'com_content.article.37', 'Further development', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(123, 81, 172, 173, 4, 'com_content.article.38', 'Company acquisition', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(124, 81, 174, 175, 4, 'com_content.article.39', 'Where our solutions come from', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(125, 81, 176, 177, 4, 'com_content.article.40', 'The new era of Co Name', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(126, 82, 180, 181, 4, 'com_content.article.41', 'John Franklin ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(127, 82, 182, 183, 4, 'com_content.article.42', 'Tom Nelson', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(128, 82, 184, 185, 4, 'com_content.article.43', 'Richard Cox', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(129, 82, 186, 187, 4, 'com_content.article.44', 'Michael Freeman', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(130, 82, 188, 189, 4, 'com_content.article.45', 'David Hope', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(131, 82, 190, 191, 4, 'com_content.article.46', 'Michael Rat', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(133, 84, 218, 219, 4, 'com_content.article.48', 'Jack Thompson', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(134, 84, 220, 221, 4, 'com_content.article.49', 'Kenneth Edwards', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(135, 84, 222, 223, 4, 'com_content.article.50', 'Adam Cooper', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(136, 83, 204, 205, 4, 'com_content.article.51', '6. Do I need an account and what are the benefits?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(137, 83, 206, 207, 4, 'com_content.article.52', '5. How long will my order take to be delivered?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(138, 83, 208, 209, 4, 'com_content.article.53', '4. Can I return an item?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(139, 83, 210, 211, 4, 'com_content.article.54', '3. Can I track my order?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(140, 83, 212, 213, 4, 'com_content.article.55', '2. How can I pay for my order?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(141, 83, 214, 215, 4, 'com_content.article.56', '1. How can I change something in my order?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(142, 85, 127, 128, 3, 'com_content.article.57', 'Template settings', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(144, 7, 16, 17, 2, 'com_contact.category.30', 'Website Administrators', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(146, 18, 356, 357, 2, 'com_modules.module.97', 'Social media', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(167, 18, 358, 359, 2, 'com_modules.module.103', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(168, 18, 360, 361, 2, 'com_modules.module.104', 'JoomGallery News', ''),
(169, 1, 549, 636, 1, 'com_joomgallery', 'joomgallery', '{}'),
(170, 169, 550, 635, 2, 'com_joomgallery.category.2', 'Gallery', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(171, 170, 551, 564, 3, 'com_joomgallery.category.3', 'Gallery 1', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(182, 170, 565, 578, 3, 'com_joomgallery.category.4', 'Gallery 2', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(183, 170, 579, 592, 3, 'com_joomgallery.category.5', 'Gallery 3', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(198, 27, 21, 22, 3, 'com_content.article.65', '404 Page', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(201, 1, 637, 638, 1, 'com_socialloginandsocialshare', 'socialloginandsocialshare', '{}'),
(202, 18, 362, 363, 2, 'com_modules.module.107', 'Login or register', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(206, 18, 364, 365, 2, 'com_modules.module.111', 'Pinterest feed', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(208, 18, 366, 367, 2, 'com_modules.module.113', 'Pinterest feed', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(210, 18, 368, 369, 2, 'com_modules.module.115', 'TM Ajax Contact Form', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(213, 170, 593, 606, 3, 'com_joomgallery.category.6', 'Gallery 4', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(214, 170, 607, 620, 3, 'com_joomgallery.category.7', 'Gallery 5', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(215, 170, 621, 634, 3, 'com_joomgallery.category.8', 'Gallery 6', '{"joom.upload":[],"joom.upload.inown":[],"core.create":{"6":1,"3":1},"joom.create.inown":[],"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(273, 8, 130, 143, 2, 'com_content.category.31', 'Our Latest Works', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(274, 273, 131, 132, 3, 'com_content.article.66', 'Popular', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(275, 273, 133, 134, 3, 'com_content.article.67', 'Top-grade safety', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(276, 273, 135, 136, 3, 'com_content.article.68', 'Individual approach', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(277, 273, 137, 138, 3, 'com_content.article.69', 'Extensive inventory', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(278, 273, 139, 140, 3, 'com_content.article.70', 'Affordable prices', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(279, 273, 141, 142, 3, 'com_content.article.71', '24/7 support', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(284, 342, 145, 164, 3, 'com_content.category.32', 'Pricing table', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(285, 304, 153, 154, 5, 'com_content.article.75', 'PERSONAL', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(286, 304, 151, 152, 5, 'com_content.article.76', 'PROFESSIONAL', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(287, 304, 149, 150, 5, 'com_content.article.77', 'BUSINESS', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(288, 304, 147, 148, 5, 'com_content.article.78', 'PREMIUM', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(289, 18, 370, 371, 2, 'com_modules.module.118', 'Detailed', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(290, 65, 87, 96, 3, 'com_content.category.33', 'Counters', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(291, 290, 88, 89, 4, 'com_content.article.79', 'Happy clients', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(292, 290, 90, 91, 4, 'com_content.article.80', 'services', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(293, 290, 92, 93, 4, 'com_content.article.81', 'Special offers', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(304, 284, 146, 155, 4, 'com_content.category.35', 'Detailed', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(305, 284, 156, 163, 4, 'com_content.category.36', 'Simple', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(307, 305, 157, 158, 5, 'com_content.article.88', 'PERSONAL', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(308, 305, 159, 160, 5, 'com_content.article.89', 'PROFESSIONAL', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(309, 305, 161, 162, 5, 'com_content.article.90', 'BUSINESS', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(310, 18, 372, 373, 2, 'com_modules.module.122', 'Simple', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(313, 18, 374, 375, 2, 'com_modules.module.124', 'Main menu', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(315, 18, 376, 377, 2, 'com_modules.module.126', 'Lorem ipsum', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(316, 18, 378, 379, 2, 'com_modules.module.127', 'Dolor sit', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(317, 18, 380, 381, 2, 'com_modules.module.128', 'Fusce molestie', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(318, 18, 382, 383, 2, 'com_modules.module.129', 'Aenean sem', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(319, 18, 384, 385, 2, 'com_modules.module.130', 'Duis vitae', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(320, 18, 386, 387, 2, 'com_modules.module.131', 'Maecenas vestibulum', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(335, 18, 388, 389, 2, 'com_modules.module.134', 'Address', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(342, 8, 144, 291, 2, 'com_content.category.43', 'Pages', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(344, 18, 390, 391, 2, 'com_modules.module.141', 'Map', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(345, 18, 392, 393, 2, 'com_modules.module.142', 'Counters', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(347, 18, 394, 395, 2, 'com_modules.module.144', 'Progress Bars', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(348, 18, 396, 397, 2, 'com_modules.module.145', 'Accordion 1', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(353, 438, 245, 246, 5, 'com_content.article.100', 'Tab Title 3', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(354, 438, 243, 244, 5, 'com_content.article.101', 'Tab Title 2', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(355, 438, 241, 242, 5, 'com_content.article.102', 'Tab Title 1', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(356, 18, 398, 399, 2, 'com_modules.module.149', 'Testimonials', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(357, 84, 224, 225, 4, 'com_content.article.103', 'Ann Smith', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(358, 84, 226, 227, 4, 'com_content.article.104', 'Bryan Thompson', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(359, 84, 228, 229, 4, 'com_content.article.105', 'Antony Moore', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(364, 18, 400, 401, 2, 'com_modules.module.153', 'Meet', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(374, 342, 273, 290, 3, 'com_content.category.46', 'Careers', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(375, 374, 274, 275, 4, 'com_content.article.110', 'We truly believe that the success of our business depends on our employees.', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(376, 374, 276, 283, 4, 'com_content.category.47', 'Careers additional info', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(377, 18, 402, 403, 2, 'com_modules.module.159', 'Careers accordion', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(378, 374, 284, 285, 4, 'com_content.article.111', 'The Sunday Times Best Company to work for', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(379, 374, 286, 287, 4, 'com_content.article.112', 'IT Careers', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(380, 18, 404, 405, 2, 'com_modules.module.160', 'Apply now', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(381, 374, 288, 289, 4, 'com_content.article.113', 'Machine learning', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(382, 18, 406, 407, 2, 'com_modules.module.161', 'Requirements', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(383, 18, 408, 409, 2, 'com_modules.module.162', 'What we Expect from you?', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(384, 376, 277, 278, 5, 'com_content.article.114', 'Business intelligence (BI) professionals', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(385, 376, 279, 280, 5, 'com_content.article.115', 'Business Program Managers (BPM)', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(386, 376, 281, 282, 5, 'com_content.article.116', 'Software Engineers (SWE)', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(387, 18, 410, 411, 2, 'com_modules.module.163', 'Careers accordion', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(388, 18, 412, 413, 2, 'com_modules.module.164', 'Careers accordion', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(389, 18, 414, 415, 2, 'com_modules.module.165', 'Careers accordion', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(390, 18, 416, 417, 2, 'com_modules.module.166', 'Pages', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(391, 18, 418, 419, 2, 'com_modules.module.167', 'Blog posts', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(392, 18, 420, 421, 2, 'com_modules.module.168', 'Portfolio posts', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(393, 18, 422, 423, 2, 'com_modules.module.169', 'User menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(395, 18, 424, 425, 2, 'com_modules.module.170', 'Breadcrumbs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(398, 18, 426, 427, 2, 'com_modules.module.171', 'Our team', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(400, 18, 428, 429, 2, 'com_modules.module.173', 'Frequently asked questions', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(413, 8, 292, 303, 2, 'com_content.category.55', 'Megamenu', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(414, 413, 293, 296, 3, 'com_content.category.56', 'About', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(425, 67, 121, 122, 3, 'com_content.article.118', 'Pay no commission when selling a hybrid car', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(432, 18, 430, 431, 2, 'com_modules.module.180', 'TM Ajax Style Switcher', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(433, 475, 270, 271, 4, 'com_content.article.121', 'Elements', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(434, 18, 432, 433, 2, 'com_modules.module.181', 'Olark', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(437, 18, 434, 435, 2, 'com_modules.module.183', 'Tabs', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(438, 475, 240, 247, 4, 'com_content.category.57', 'Tabs', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(442, 18, 436, 437, 2, 'com_modules.module.184', 'Accordion 2', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(444, 18, 438, 439, 2, 'com_modules.module.186', 'Progress Bars Horizontal', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(446, 475, 248, 269, 4, 'com_content.category.58', 'Progress Bars', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(447, 446, 249, 258, 5, 'com_content.category.59', 'Horizontal', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(448, 446, 259, 268, 5, 'com_content.category.60', 'Circle', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(449, 447, 250, 251, 6, 'com_content.article.125', 'Leadership', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(450, 447, 252, 253, 6, 'com_content.article.126', 'Management', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(451, 447, 254, 255, 6, 'com_content.article.127', 'Innovation and creativity', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(452, 448, 260, 261, 6, 'com_content.article.128', 'Leadership', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(453, 448, 262, 263, 6, 'com_content.article.129', 'Management', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(454, 448, 264, 265, 6, 'com_content.article.130', 'Innovation and creativity', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(456, 18, 440, 441, 2, 'com_modules.module.189', 'Pricing Tables', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(457, 18, 442, 443, 2, 'com_modules.module.190', 'Simple', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(459, 18, 444, 445, 2, 'com_modules.module.192', 'Accordions and Toggles', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(465, 18, 446, 447, 2, 'com_modules.module.198', 'Login or register', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(467, 82, 192, 201, 4, 'com_content.category.61', 'Team skills', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(468, 467, 193, 194, 5, 'com_content.article.131', 'Leadership/Management Skills.', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(469, 467, 195, 196, 5, 'com_content.article.132', 'Computer/Technical Knowledge.', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(470, 467, 197, 198, 5, 'com_content.article.133', 'Communication Skills.', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(471, 467, 199, 200, 5, 'com_content.article.134', 'Analytical/Research Skills.', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(472, 18, 448, 449, 2, 'com_modules.module.200', 'Youtube', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(475, 342, 231, 272, 3, 'com_content.category.62', 'Elements', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(476, 447, 256, 257, 6, 'com_content.article.135', 'Resilience', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(477, 448, 266, 267, 6, 'com_content.article.136', 'Resilience', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(478, 64, 25, 32, 3, 'com_content.category.63', 'Slider', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(479, 478, 26, 27, 4, 'com_content.article.137', 'QUALITY CAR', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(480, 478, 28, 29, 4, 'com_content.article.138', 'YOUR ONE STOP', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(481, 478, 30, 31, 4, 'com_content.article.139', 'COMPLETE', '{"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(487, 18, 450, 451, 2, 'com_modules.module.206', 'Parallax', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(513, 18, 452, 453, 2, 'com_modules.module.210', 'Swiper', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(518, 18, 454, 455, 2, 'com_modules.module.212', 'Komento Activities', '{}'),
(519, 18, 456, 457, 2, 'com_modules.module.213', 'Komento Comments', '{}'),
(520, 1, 711, 712, 1, 'com_komento', 'com_komento', '{}'),
(521, 18, 458, 459, 2, 'com_modules.module.214', 'Address', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(522, 18, 460, 461, 2, 'com_modules.module.215', 'Work time', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(523, 18, 462, 463, 2, 'com_modules.module.216', 'Telephones', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(525, 290, 94, 95, 4, 'com_content.article.143', 'models served', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(526, 64, 33, 34, 3, 'com_content.article.144', 'Footer post', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(527, 18, 464, 465, 2, 'com_modules.module.217', 'Footer post', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(528, 18, 466, 467, 2, 'com_modules.module.218', 'Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(529, 64, 35, 36, 3, 'com_content.article.145', 'COMPLETE AUTO SERVICE', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(530, 64, 37, 38, 3, 'com_content.article.146', 'About Our Company', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(531, 64, 39, 40, 3, 'com_content.article.147', 'IN A NUTSHELL About CaRrepair', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(532, 64, 41, 42, 3, 'com_content.article.148', 'OBI II Diagnostic system', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(533, 18, 468, 469, 2, 'com_modules.module.219', 'COMPLETE', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(534, 18, 470, 471, 2, 'com_modules.module.220', 'WHAT', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(535, 64, 43, 56, 3, 'com_content.category.64', 'Car manufacturers we work with', '{}'),
(536, 535, 44, 45, 4, 'com_content.article.149', 'Brand1', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(537, 535, 46, 47, 4, 'com_content.article.150', 'Brand2', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(538, 535, 48, 49, 4, 'com_content.article.151', 'Brand3', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(539, 535, 50, 51, 4, 'com_content.article.152', 'Brand4', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(540, 535, 52, 53, 4, 'com_content.article.153', 'Brand5', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(541, 535, 54, 55, 4, 'com_content.article.154', 'Brand6', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(542, 18, 472, 473, 2, 'com_modules.module.221', 'car manufacturers', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(543, 18, 474, 475, 2, 'com_modules.module.222', 'About', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(544, 64, 57, 66, 3, 'com_content.category.65', 'Services', '{}'),
(545, 544, 58, 59, 4, 'com_content.article.155', 'car MOTOR repair', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(546, 544, 60, 61, 4, 'com_content.article.156', 'CAR BODY repair', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(547, 544, 62, 63, 4, 'com_content.article.157', 'CHASSIS repair', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(548, 544, 64, 65, 4, 'com_content.article.158', 'TRANSMISSION repair', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(549, 18, 476, 477, 2, 'com_modules.module.223', 'Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(550, 64, 67, 74, 3, 'com_content.category.66', 'CAR REPAIR CAN HANDLE ALL OF YOUR AUTO REPAIR SERVICES INCLUDING', '{}'),
(551, 550, 68, 69, 4, 'com_content.article.159', 'List 1', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(552, 550, 70, 71, 4, 'com_content.article.160', 'List 2', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(553, 550, 72, 73, 4, 'com_content.article.161', 'List 3', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(554, 18, 478, 479, 2, 'com_modules.module.224', 'CAR REPAIR CAN HANDLE ALL OF', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(555, 64, 75, 84, 3, 'com_content.category.67', 'Services List', '{}'),
(556, 555, 76, 77, 4, 'com_content.article.162', 'MOTOR REPAIR', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(557, 555, 78, 79, 4, 'com_content.article.163', 'TRANSMISSION REPAIR', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(558, 555, 80, 81, 4, 'com_content.article.164', 'CHASSIS REPAIR', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(559, 555, 82, 83, 4, 'com_content.article.165', 'CAR BODY REPAIR', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(560, 18, 480, 481, 2, 'com_modules.module.225', 'Services list', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(561, 413, 297, 302, 3, 'com_content.category.68', 'Services', '{}'),
(562, 561, 298, 299, 4, 'com_content.article.166', 'List 1', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(563, 561, 300, 301, 4, 'com_content.article.167', 'List 2', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(564, 414, 294, 295, 4, 'com_content.article.168', 'About', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(565, 18, 482, 483, 2, 'com_modules.module.226', 'Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(566, 18, 484, 485, 2, 'com_modules.module.227', 'About', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(567, 65, 97, 104, 3, 'com_content.category.69', 'Company Automotive SERVICES', '{}'),
(568, 567, 98, 99, 4, 'com_content.article.169', 'List 3', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(569, 567, 100, 101, 4, 'com_content.article.170', 'List 2', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(570, 567, 102, 103, 4, 'com_content.article.171', 'List 1', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(571, 18, 486, 487, 2, 'com_modules.module.228', 'Company', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(572, 18, 488, 489, 2, 'com_modules.module.229', 'Services 2', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(573, 65, 105, 114, 3, 'com_content.category.70', 'Services', '{}'),
(574, 573, 106, 107, 4, 'com_content.article.172', 'Memorial Day Offer', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(575, 573, 108, 109, 4, 'com_content.article.173', 'Interstate Batteries', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(576, 573, 110, 111, 4, 'com_content.article.174', 'Standard or Lifetime Brake Service', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(577, 573, 112, 113, 4, 'com_content.article.175', 'car care class', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(578, 18, 490, 491, 2, 'com_modules.module.230', 'OBI II', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(579, 18, 492, 493, 2, 'com_modules.module.231', 'Parallax 2', '{"core.delete":[],"core.edit":[],"core.edit.state":[],"module.edit.frontend":[]}'),
(580, 18, 494, 495, 2, 'com_modules.module.232', 'IN A NUTSHELL', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"module.edit.frontend":[]}'),
(587, 171, 552, 553, 4, 'com_joomgallery.image.80', 'gallery-image1', '{}'),
(588, 171, 554, 555, 4, 'com_joomgallery.image.81', 'gallery-image2', '{}'),
(589, 171, 556, 557, 4, 'com_joomgallery.image.82', 'gallery-image3', '{}'),
(590, 171, 558, 559, 4, 'com_joomgallery.image.83', 'gallery-image4', '{}'),
(591, 171, 560, 561, 4, 'com_joomgallery.image.84', 'gallery-image5', '{}'),
(592, 171, 562, 563, 4, 'com_joomgallery.image.85', 'gallery-image6', '{}'),
(593, 182, 566, 567, 4, 'com_joomgallery.image.86', 'gallery-image7', '{}'),
(594, 182, 568, 569, 4, 'com_joomgallery.image.87', 'gallery-image8', '{}'),
(595, 182, 570, 571, 4, 'com_joomgallery.image.88', 'gallery-image9', '{}'),
(596, 182, 572, 573, 4, 'com_joomgallery.image.89', 'gallery-image10', '{}'),
(597, 182, 574, 575, 4, 'com_joomgallery.image.90', 'gallery-image11', '{}'),
(598, 182, 576, 577, 4, 'com_joomgallery.image.91', 'gallery-image12', '{}'),
(599, 183, 580, 581, 4, 'com_joomgallery.image.92', 'gallery-image13', '{}'),
(600, 183, 582, 583, 4, 'com_joomgallery.image.93', 'gallery-image14', '{}'),
(601, 183, 584, 585, 4, 'com_joomgallery.image.94', 'gallery-image15', '{}'),
(602, 183, 586, 587, 4, 'com_joomgallery.image.95', 'gallery-image16', '{}'),
(603, 183, 588, 589, 4, 'com_joomgallery.image.96', 'gallery-image17', '{}'),
(604, 183, 590, 591, 4, 'com_joomgallery.image.97', 'gallery-image18', '{}'),
(605, 213, 594, 595, 4, 'com_joomgallery.image.98', 'gallery-image19', '{}'),
(606, 213, 596, 597, 4, 'com_joomgallery.image.99', 'gallery-image20', '{}'),
(607, 213, 598, 599, 4, 'com_joomgallery.image.100', 'gallery-image21', '{}'),
(608, 213, 600, 601, 4, 'com_joomgallery.image.101', 'gallery-image22', '{}'),
(609, 213, 602, 603, 4, 'com_joomgallery.image.102', 'gallery-image23', '{}'),
(610, 213, 604, 605, 4, 'com_joomgallery.image.103', 'gallery-image24', '{}'),
(611, 214, 608, 609, 4, 'com_joomgallery.image.104', 'gallery-image25', '{}'),
(612, 214, 610, 611, 4, 'com_joomgallery.image.105', 'gallery-image26', '{}'),
(613, 214, 612, 613, 4, 'com_joomgallery.image.106', 'gallery-image27', '{}'),
(614, 214, 614, 615, 4, 'com_joomgallery.image.107', 'gallery-image28', '{}'),
(615, 214, 616, 617, 4, 'com_joomgallery.image.108', 'gallery-image29', '{}'),
(616, 214, 618, 619, 4, 'com_joomgallery.image.109', 'gallery-image30', '{}'),
(617, 215, 622, 623, 4, 'com_joomgallery.image.110', 'gallery-image31', '{}'),
(618, 215, 624, 625, 4, 'com_joomgallery.image.111', 'gallery-image32', '{}'),
(619, 215, 626, 627, 4, 'com_joomgallery.image.112', 'gallery-image33', '{}'),
(620, 215, 628, 629, 4, 'com_joomgallery.image.113', 'gallery-image34', '{}'),
(621, 215, 630, 631, 4, 'com_joomgallery.image.114', 'gallery-image35', '{}'),
(622, 215, 632, 633, 4, 'com_joomgallery.image.115', 'gallery-image36', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=71 ;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 83, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '{}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 29, 30, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 31, 32, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 33, 34, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 35, 36, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 37, 38, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 64, 1, 3, 14, 1, 'home', 'com_content', 'Home', 'home', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:19:19', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 65, 1, 15, 22, 1, 'about', 'com_content', 'About', 'about', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:19:39', 0, '0000-00-00 00:00:00', 0, '*', 1),
(10, 66, 1, 25, 26, 1, 'policies', 'com_content', 'Policies', 'policies', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:20:09', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 67, 1, 23, 24, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:20:26', 0, '0000-00-00 00:00:00', 0, '*', 1),
(18, 74, 62, 67, 68, 3, 'pages/elements/accordions-and-toggles', 'com_content', 'Accordions and Toggles', 'accordions-and-toggles', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:21:56', 846, '2015-06-03 09:45:38', 0, '*', 1),
(25, 81, 43, 56, 57, 2, 'pages/history', 'com_content', 'History', 'history', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:23:32', 846, '2015-05-04 15:13:23', 0, '*', 1),
(26, 82, 43, 52, 55, 2, 'pages/team', 'com_content', 'Team', 'team', '', '<p><strong>Our management team is comprised of savvy entrepreneurs and industry experts, bringing years of experience to a young company. They cultivate our strong culture, and work tirelessly to help our team scale, grow, and succeed.</strong></p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:23:46', 283, '2016-01-14 09:20:21', 0, '*', 1),
(27, 83, 43, 50, 51, 2, 'pages/faqs', 'com_content', 'FAQs', 'faqs', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:23:57', 846, '2015-05-04 15:13:23', 0, '*', 1),
(28, 84, 43, 58, 59, 2, 'pages/testimonials', 'com_content', 'Testimonials', 'testimonials', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:24:11', 846, '2015-05-04 15:13:23', 0, '*', 1),
(29, 85, 1, 27, 28, 1, 'help', 'com_content', 'Help', 'help', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 19:24:23', 0, '0000-00-00 00:00:00', 0, '*', 1),
(30, 144, 1, 39, 40, 1, 'website-administrators', 'com_contact', 'Website Administrators', 'website-administrators', '', '<p>''Website Administrators'' contact category description. Ut sapien enim, rhoncus sit amet fermentum at, sagittis ac massa. Fusce quis odio sit amet ipsum gravida faucibus vel et turpis. Aliquam a dui pretium elit feugiat interdum. Suspendisse tortor velit, bibendum vitae sollicitudin non, congue quis risus. Aliquam lacus nibh, viverra ut porta ac, luctus sit amet orci. Etiam euismod lacinia lectus et pulvinar. Integer dictum, dui id fermentum auctor, sem nunc ultricies ipsum, sed sagittis est justo nec neque. Integer sit amet justo elit, a dictum nisl.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-05-02 21:36:47', 0, '0000-00-00 00:00:00', 0, '*', 1),
(31, 273, 1, 41, 42, 1, 'our-latest-works', 'com_content', 'Our Latest Works', 'our-latest-works', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-12-08 08:14:50', 846, '2015-01-05 08:06:36', 0, '*', 1),
(32, 284, 43, 44, 49, 2, 'pages/pricing-table', 'com_content', 'Pricing table', 'pricing-table', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-12-10 08:39:33', 846, '2015-01-14 09:00:49', 0, '*', 1),
(33, 290, 9, 16, 17, 2, 'about/counters', 'com_content', 'Counters', 'counters', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2014-12-10 09:12:15', 846, '2015-04-23 13:14:21', 0, '*', 1),
(35, 304, 32, 45, 46, 3, 'pages/pricing-table/detailed', 'com_content', 'Detailed', 'detailed', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-12-23 08:28:55', 0, '0000-00-00 00:00:00', 0, '*', 1),
(36, 305, 32, 47, 48, 3, 'pages/pricing-table/simple', 'com_content', 'Simple', 'simple', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2014-12-23 08:29:24', 0, '0000-00-00 00:00:00', 0, '*', 1),
(43, 342, 1, 43, 76, 1, 'pages', 'com_content', 'Pages', 'pages', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-01-09 15:05:01', 846, '2015-06-03 09:43:22', 0, '*', 1),
(46, 374, 43, 60, 63, 2, 'pages/careers', 'com_content', 'Careers', 'careers', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-01-23 08:43:21', 846, '2015-06-03 09:44:50', 0, '*', 1),
(47, 376, 46, 61, 62, 3, 'pages/careers/careers-additional-info', 'com_content', 'Careers additional info', 'careers-additional-info', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2015-01-23 08:52:39', 0, '0000-00-00 00:00:00', 0, '*', 1),
(55, 413, 1, 77, 82, 1, 'megamenu', 'com_content', 'Megamenu', 'megamenu', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2015-02-17 20:42:31', 0, '0000-00-00 00:00:00', 0, '*', 1),
(56, 414, 55, 78, 79, 2, 'megamenu/about', 'com_content', 'About', 'about', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 474, '2015-02-17 20:42:42', 0, '0000-00-00 00:00:00', 0, '*', 1),
(57, 438, 62, 65, 66, 3, 'pages/elements/tabs', 'com_content', 'Tabs', 'tabs', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-04-23 09:21:25', 846, '2015-06-03 09:45:55', 0, '*', 1),
(58, 446, 62, 69, 74, 3, 'pages/elements/progress-bars', 'com_content', 'Progress Bars', 'progress-bars', 'For "Elements" page', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-04-23 13:13:37', 846, '2015-06-03 09:46:07', 0, '*', 1),
(59, 447, 58, 70, 71, 4, 'pages/elements/progress-bars/horizontal', 'com_content', 'Horizontal', 'horizontal', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-04-23 13:45:35', 846, '2015-04-23 13:45:54', 0, '*', 1),
(60, 448, 58, 72, 73, 4, 'pages/elements/progress-bars/vertical', 'com_content', 'Circle', 'vertical', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-04-23 13:46:11', 846, '2015-06-03 09:45:19', 0, '*', 1),
(61, 467, 26, 53, 54, 3, 'pages/team/team-skills', 'com_content', 'Team skills', 'team-skills', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-05-04 15:15:46', 846, '2015-06-03 09:52:25', 0, '*', 1),
(62, 475, 43, 64, 75, 2, 'pages/elements', 'com_content', 'Elements', 'elements', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-06-03 09:43:36', 0, '2015-06-03 09:43:36', 0, '*', 1),
(63, 478, 8, 4, 5, 2, 'home/slider', 'com_content', 'Slider', 'slider', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 474, '2015-06-04 11:52:51', 0, '2015-06-04 11:52:51', 0, '*', 1),
(64, 535, 8, 6, 7, 2, 'home/car-manufacturers-we-work-with', 'com_content', 'Car manufacturers we work with', 'car-manufacturers-we-work-with', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-10 13:03:50', 0, '2016-06-10 13:03:50', 0, '*', 1),
(65, 544, 8, 8, 9, 2, 'home/services', 'com_content', 'Services', 'services', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-10 15:29:04', 0, '2016-06-10 15:29:04', 0, '*', 1),
(66, 550, 8, 10, 11, 2, 'home/car-repair-can-handle-all-of-your-auto-repair-services-including', 'com_content', 'CAR REPAIR CAN HANDLE ALL OF YOUR AUTO REPAIR SERVICES INCLUDING', 'car-repair-can-handle-all-of-your-auto-repair-services-including', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-10 15:59:42', 0, '2016-06-10 15:59:42', 0, '*', 1),
(67, 555, 8, 12, 13, 2, 'home/services-list', 'com_content', 'Services List', 'services-list', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-10 16:17:02', 0, '2016-06-10 16:17:02', 0, '*', 1),
(68, 561, 55, 80, 81, 2, 'megamenu/services', 'com_content', 'Services', 'services', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-11 08:06:13', 0, '2016-06-11 08:06:13', 0, '*', 1),
(69, 567, 9, 18, 19, 2, 'about/company-automotive-services', 'com_content', 'Company Automotive SERVICES', 'company-automotive-services', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-11 09:06:00', 0, '2016-06-11 09:06:00', 0, '*', 1),
(70, 573, 9, 20, 21, 2, 'about/services', 'com_content', 'Services', 'services', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"","image_alt":""}', '', '', '{"author":"","robots":""}', 846, '2016-06-11 09:13:58', 0, '2016-06-11 09:13:58', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Website Owner', 'website-owner', 'website owner', '138 Atlantis Ln', 'Kingsport', 'Illinois', 'U.S.', '121164', '800-2345-6789', '800-2345-6789', '<p>Email us with any questions or inquiries or use our contact data.</p>', '', 'mail@demolink.org', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_tags":"","show_name":"0","show_position":"0","show_email":"1","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"","show_telephone":"1","show_mobile":"0","show_fax":"1","show_webpage":"","show_misc":"1","show_image":"0","allow_vcard":"1","show_articles":"0","articles_display_num":"","show_profile":"0","show_links":"0","linka_name":"","linka":false,"linkb_name":"","linkb":false,"linkc_name":"","linkc":false,"linkd_name":"","linkd":false,"linke_name":"","linke":false,"contact_layout":"","show_email_form":"0","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 846, 30, 1, '+1 959 603 6035', 'http://demolink.org', '', '', '', '*', '2014-05-02 21:36:02', 474, '', '2015-10-20 11:47:58', 846, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 8, 671);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=176 ;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(6, 91, 'Privacy policy', 'privacy-policy', '<h4>What does this privacy policy cover?</h4>\r\n<p>We take your privacy very seriously. This privacy policy governs and details the main privacy principles we apply to the data we collect through our services.Click here to access our privacy policy governing our corporate website.</p>\r\n\r\n<h4>About our services</h4>\r\n<p>We specialize in a variety of services. Our aim is to deliver services based on your recent browsing behavior. With our service, you should receive personalized help that is more relevant for you than the standard one you would receive without us. Click here for more information on our services.</p>\r\n\r\n<h4>User Choices</h4>\r\n<p>If you do not want to receive ads displayed by us, on your current browser and browsers we have linked to your technical identifier you can disable the display of our ads here.If you only want to opt out from your current browser uncheck the opt-out box.You can also opt-out of all matched browsers and know more about user choices.</p>\r\n\r\n<h4>Our commitments and adherence</h4>\r\n<p>Our company is an early adopter to initiatives of greater transparency and control for users. Read more about transparency and control.</p>\r\n\r\n<h4>Our Technology</h4>\r\n<p>We collect information via technical cookies placed on your browser. Read more about our technology.</p>\r\n\r\n<h4>Data security and retention</h4>\r\n<p>The security of your information is fundamental to us. We have implemented industry-standard security measures, which include the use of firewalls and encryption. Read more about data security and retention.</p>\r\n\r\n<p>Please note that we may update or change this privacy policy. If we revise our privacy policy, we will post those changes to this privacy statement, and to other places we deem appropriate, so that you are aware of what information we collect, how we use it, and under what circumstances, if any we disclose it. If we make any material changes we will notify you by means of a notice on this site prior to the change becoming effective. Please click here for the latest version of the privacy policy.</p>\r\n\r\n<p>E-mail: <a href="mailto:info@demolink.org">info@demolink.org</a></p>', '', 1, 10, '2014-05-02 19:36:00', 474, '', '2015-10-16 11:37:57', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:36:00', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 1, '', '', 1, 75, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(11, 96, 'New Tesla Model X is now available', 'new-tesla-model-x-is-now-available', '<p>A brand new electric SUV Tesla Model X is available in our store. Buy it now and get a coupon for 1 year of free service maintenance. Support environment-friendly technologies with our company.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 11, '2014-05-02 19:47:40', 474, '', '2016-06-11 11:19:52', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:47:40', '0000-00-00 00:00:00', '{"image_intro":"images\\/blog\\/blog-img1.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/blog\\/blog-img1.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:blog","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 42, 1, '', '', 1, 495, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(16, 101, 'Qualified Staff', 'qualified-staff', '<p>Our dedicated support team is available 24 hours a day, seven days a week and provides clients with immediate support for any issue.</p>', '', 1, 18, '2014-05-02 19:54:26', 474, '', '2016-06-10 10:27:05', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:54:26', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(17, 102, 'Satisfaction Guarantee', 'satisfaction-guarantee', '<p>Our dedicated support team is available 24 hours a day, seven days a week and provides clients with immediate support for any issue.</p>', '', 1, 18, '2014-05-02 19:55:12', 474, '', '2016-06-10 10:27:06', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:55:12', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(18, 103, '24/7 Support', '24-7-support', '<p>Our dedicated support team is available 24 hours a day, seven days a week and provides clients with immediate support for any issue.</p>', '', 1, 18, '2014-05-02 19:56:26', 474, '', '2016-06-10 10:27:07', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:56:26', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(35, 120, 'Our first steps on the market', 'excepteur-sint-occaecat-cupidatat', '<p>Our history begins back in 1998, when the first European office was opened in Cham, Switzerland, by the Anglo-Swiss Company. The founder of the company, himself an immigrant from Germany, was instrumental in turning his Company towards international expansion from the very start. We owe more than our name, our logo and our first product to our founder. He embodied many of the key attitudes and values that form part and parcel of our corporate culture: pragmatism, flexibility, the willingness to learn, an open mind and respect for other people and cultures.</p>', '', 1, 25, '2014-05-02 20:22:23', 474, '', '2015-10-12 09:20:31', 55, 0, '0000-00-00 00:00:00', '1998-05-02 20:22:00', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 1, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(36, 121, 'Continuous innovation and transformation', 'phasellus-vitae-risus-non-erat-euismod', '<p>Continuous innovation and rapid transformation have been themes throughout our history, which the company traces to the 1998 with the installation of the first computer system for commercial use in the United States at General Electric’s Park facility. The company has built its solid reputation thanks to thorough employees selection. By the 2001, the company began offering a new breed of solutions to clients - solutions that aligned organizations'' technologies, processes and people with their strategies.</p>', '', 1, 25, '2014-05-02 20:25:03', 474, '', '2015-10-12 09:21:54', 55, 0, '0000-00-00 00:00:00', '2001-06-22 20:25:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/history\\/history-1.jpg","image_intro_alt":"","image_intro_caption":"","float_intro":"none","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 2, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(37, 122, 'Further development', 'etiam-dignissim-leo-quam', '<p>Throughout its history, the company has expanded its offerings and capitalized on evolving management trends and technologies to benefit its clients. The company pioneered systems integration and business integration; led the deployment of enterprise resource planning, customer relationship management and electronic services; and has established itself as a leader in today''s global marketplace. Combining unparalleled experience, comprehensive capabilities across all industries and business functions, and extensive research on the world’s most successful companies, we collaborate with clients to help them in each and every requirement.<br /><br /></p>', '', 1, 25, '2014-05-02 20:26:03', 474, '', '2015-10-12 09:22:38', 55, 0, '0000-00-00 00:00:00', '2006-03-07 20:26:00', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(38, 123, 'Company acquisition', 'nullam-auctor-vehicula-dui', '<p>In 2009 the Co Name Group was acquired from Co Name, thereby creating one of the leading European companies. At the time of the acquisition, Co Name Group employed 20,000 staff and generated annual revenues of approximately EUR 2.4 billion. Co Name employed 26,500 staff, generating annual revenues of more than EUR 3 billion. The acquisition of Co Name and the beneficial partnership is the logical continuation of the company strategy. With a workforce of more than 48,000 employees, Co Name generated revenues of over EUR 5 billion during the year.</p>', '', 1, 25, '2014-05-02 20:26:24', 474, '', '2015-10-12 09:23:57', 55, 0, '0000-00-00 00:00:00', '2009-11-25 20:26:00', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 4, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(39, 124, 'Where our solutions come from', 'etiam-in-neque-non-sapien-lobortis', '<p>Our solutions and services were formed during a groundbreaking merger in 2011 which saw Co Name (Germany), Co Name (Austria), Co Name (India), Co Name (Switzerland) and Co Name (Greece) united under the umbrella of Co Name - called internally a division of Co Name. Made up of two business units, company solutions and outsourcing services, Co Name provides strong business technology as well as an extensive range of services and solutions. </p>', '', 1, 25, '2014-05-02 20:26:43', 474, '', '2015-10-12 09:24:32', 55, 0, '0000-00-00 00:00:00', '2011-08-17 20:26:00', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 5, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(40, 125, 'The new era of Co Name', 'phasellus-id-urna-non-lectus', '<p>On January 30, 2012, shareholders were asked by the Board of Directors to decide on the status transformation of Co Name, the Holding company of Co Name Group, from a French society to a European society. Following the acquisition of Co Name on November 25, 2009, Co Name has become a European leader in rendering the specific services. 85 percent of our turnover and 75 percent of our workforce is now spread equally across the main European countries including; Germany, France, United Kingdom, the Netherlands, Spain, Austria, Scandinavia and Central Europe.</p>', '', 1, 25, '2014-05-02 20:27:03', 474, '', '2015-10-12 09:25:18', 55, 0, '0000-00-00 00:00:00', '2012-01-30 20:27:00', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 6, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(41, 126, 'John Franklin ', 'john-franklin', '<p>Started with us in 2013, he has continued to grow in his knowledge of auto repair.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 26, '2014-05-02 20:28:35', 474, '', '2016-06-11 09:37:56', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:28:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/team-1.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/team\\/team-1.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 1, '', '', 1, 10, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(42, 127, 'Tom Nelson', 'tom-nelson', '<p>Tom is the man who takes you to and from work or home while your vehicle is being serviced.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 26, '2014-05-02 20:29:17', 474, '', '2016-06-11 09:37:55', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:29:17', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/team-2.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/team\\/team-2.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 2, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(43, 128, 'Richard Cox', 'richard-cox', '<p>Richard is usually the first face to greet you when you arrive to our shop.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 26, '2014-05-02 20:30:03', 474, '', '2016-06-11 09:38:26', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:30:03', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/team-3.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/team\\/team-3.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 3, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(44, 129, 'Michael Freeman', 'michael-freeman', '<p>Michael is company  Manager. He also keeps our office computers up and running.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 26, '2014-05-02 20:30:47', 474, '', '2016-06-11 09:38:59', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:30:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/team-4.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/team\\/team-4.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 4, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(45, 130, 'David Hope', 'david-hope', '<p>Started with us in 2013, he has continued to grow in his knowledge of auto repair.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 26, '2014-05-02 20:31:39', 474, '', '2016-06-11 09:39:32', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:31:39', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/team-5.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/team\\/team-5.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(46, 131, 'Michael Rat', 'richard-pool', '<p>Michael is the man who takes you to and from work or home while your vehicle is being serviced.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 26, '2014-05-02 20:32:22', 474, '', '2016-06-11 09:39:23', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:32:22', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/team-6.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/team\\/team-6.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(48, 133, 'Jack Thompson', 'jack-thompson', '<blockquote><p><i class="material-design-google125"></i>Your service is often a source of inspiration. It simplifies our lives and makes usually complicated processes easy.</p></blockquote>', '', 1, 28, '2014-05-02 20:33:47', 474, '', '2016-06-10 12:42:45', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:33:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/testimonials\\/testimonials-3.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/testimonials\\/testimonials-3.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"1","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(49, 134, 'Kenneth Edwards', 'kenneth-edwards', '<blockquote><p><i class="material-design-google125"></i>Your service has really cut my working time by 80%. It gives me goosebumps thinking about all that extra time I have.</p></blockquote>', '', 1, 28, '2014-05-02 20:34:08', 474, '', '2016-06-10 12:42:41', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:34:08', '0000-00-00 00:00:00', '{"image_intro":"images\\/testimonials\\/testimonials-2.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/testimonials\\/testimonials-2.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"1","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(50, 135, 'Adam Cooper', 'adam-cooper', '<blockquote><p><i class="material-design-google125"></i>The guys at your company are amazing! Your service has added a great value to my life. I love that I can jump to your site any time and have access to support 24/7.</p></blockquote>', '', 1, 28, '2014-05-02 20:34:27', 474, '', '2016-06-10 12:42:37', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:34:27', '0000-00-00 00:00:00', '{"image_intro":"images\\/testimonials\\/testimonials-1.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/testimonials\\/testimonials-1.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"1","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 3, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(51, 136, '6. Do I need an account and what are the benefits?', '6-do-i-need-an-account-and-what-are-the-benefits', '<p>It''s not required to create an account. But, having an account provides easier checkout, the ability to create and send a wishlist, and a customized shopping experience.</p>', '', 1, 27, '2014-05-02 20:35:26', 474, '', '2015-10-13 09:40:30', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:35:26', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(52, 137, '5. How long will my order take to be delivered?', '5-how-long-will-my-order-take-to-be-delivered', '<p>Delivery times will depend on your location. Once payment is confirmed your order will be packaged. Delivery can be expected within 10 business days.</p>', '', 1, 27, '2014-05-02 20:35:46', 474, '', '2015-10-13 09:39:51', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:35:46', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(53, 138, '4. Can I return an item?', '4-can-i-return-an-item', '<p>Please visit our Returns & Exchanges page for more information.</p>', '', 1, 27, '2014-05-02 20:36:06', 474, '', '2015-10-13 09:39:17', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:36:06', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(54, 139, '3. Can I track my order?', '3-can-i-track-my-order', '<p>Yes, you can! After placing your order you will receive an order confirmation via email. Each order starts production 24 hours after your order is placed. Within 72 hours of you placing your order, you will receive an expected delivery date. When the order ships, you will receive another email with the tracking number and a link to trace the order online with the carrier.</p>', '', 1, 27, '2014-05-02 20:36:29', 474, '', '2015-10-13 09:38:31', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:36:29', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(55, 140, '2. How can I pay for my order?', '2-how-can-i-pay-for-my-order', '<p>We accept Visa, MasterCard, and American Express credit and debit cards for your convenience.</p>', '', 1, 27, '2014-05-02 20:36:55', 474, '', '2015-10-13 09:37:48', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:36:55', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(56, 141, '1. How can I change something in my order?', '1-how-can-i-change-something-in-my-order', '<p>If you need to change something your order, please contact us immediately. We usually process orders within 2-4 hours, and once we have processed your order, we will be unable to make any changes.</p>', '', 1, 27, '2014-05-02 20:37:13', 474, '', '2015-10-13 09:28:30', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:37:13', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 6, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(57, 142, 'Template settings', 'template-settings', '<h5>Modules configuration table</h5>\r\n<p>This table shows theme modules settings. Please make sure you have read <a href="http://www.templatemonster.com/help/quick-start-guide/joomla-templates/v3-2/index_en.html#modules-config-table" target="_blank">theme documentation. </a> </p>\r\n\r\n<div id="mod_table">\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>1 - Social media</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> footer</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 4</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>2 - Search</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_search</li>\r\n				<li><strong>Position:</strong> 404-search</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 0</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>3 - Login or register</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_socialloginandsocialshare</li>\r\n				<li><strong>Position:</strong> fixed-sidebar-right</li>\r\n				<li><strong>Class Suffix:</strong> login login_shell</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>4 - TM Ajax Contact Form</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_ajax_contact_form</li>\r\n				<li><strong>Position:</strong> contact-form</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Contacts</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>5 - Detailed</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> pricing_detailed</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 14</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Pricing</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>6 - Simple</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> pricing_simple</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 22</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Pricing</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>7 - Main menu</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_icemegamenu</li>\r\n				<li><strong>Position:</strong> header</li>\r\n				<li><strong>Class Suffix:</strong> home_menu</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>8 - Address</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> footer</li>\r\n				<li><strong>Class Suffix:</strong> address</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 3</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>9 - Map</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> map</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home<br />Contacts</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>10 - Counters</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> counters</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 20</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>11 - Progress Bars</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> progbars_circle</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 18</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>12 - Accordion 1</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> custom</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 4</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>13 - Testimonials</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 15</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Testimonials</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>14 - Meet</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> mainbottom-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> About</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>15 - Careers accordion</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-1</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>16 - Apply now</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_ajax_contact_form</li>\r\n				<li><strong>Position:</strong> aside-right</li>\r\n				<li><strong>Class Suffix:</strong> careers_form</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Careers</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>17 - Requirements</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> careers-accordion-requirements</li>\r\n				<li><strong>Class Suffix:</strong>  requirements</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>18 - What we Expect from you?</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> careers-accordion-expect</li>\r\n				<li><strong>Class Suffix:</strong>  expect</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>19 - Careers accordion</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>20 - Careers accordion</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>21 - Careers accordion</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> careers-accordion-4</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>22 - Pages</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Site map</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>23 - Blog posts</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_category</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong>  site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Site map</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>24 - Portfolio posts</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_category</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong>  site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Site map</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>25 - User menu</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> site_map</li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Site map</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>26 - Breadcrumbs</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_breadcrumbs</li>\r\n				<li><strong>Position:</strong> breadcrumbs</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> -Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>27 - Our team</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> team_team</li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 10</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Our team</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>28 - Frequently asked questions</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 8</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> FAQs</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>29 - TM Ajax Style Switcher</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_style_switcher</li>\r\n				<li><strong>Position:</strong> fixed-sidebar-left</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>30 - Olark</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_olark_chat</li>\r\n				<li><strong>Position:</strong> fixed-sidebar-right</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>31 - Tabs</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstraptabs</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>32 - Accordion 2</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_bootstrap_collapse</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 3</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>33 - Progress Bars Horizontal</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 19</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>34 - Pricing Tables</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 6</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>35 - Simple</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 7</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>36 - Accordions and Toggles</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_custom</li>\r\n				<li><strong>Position:</strong> content-bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 2</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Elements</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>37 - Login or register</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_socialloginandsocialshare</li>\r\n				<li><strong>Position:</strong> modal</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>38 - Youtube</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_bg_youtube</li>\r\n				<li><strong>Position:</strong> bottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>39 - Parallax</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_parallax</li>\r\n				<li><strong>Position:</strong> mainbottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>40 - Swiper</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_swiper</li>\r\n				<li><strong>Position:</strong> showcase</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>41 - Address</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> top</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>42 - Work time</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> top</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>43 - Telephones</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> top</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>44 - Footer post</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> footer</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>45 - Services</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_menu</li>\r\n				<li><strong>Position:</strong> footer</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 2</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>46 - COMPLETE</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> </li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>47 - WHAT</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> mainbottom-4</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>48 - car manufacturers</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> mainbottom-2</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>49 - About</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> </li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>50 - Services</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> mainbottom-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>51 - CAR REPAIR CAN HANDLE ALL OF</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> content-top</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>52 - Services list</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> maintop</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> Home</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>53 - Services</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> megamenu</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>54 - About</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> megamenu</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>55 - Company</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> mainbottom-4</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> About</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>56 - Services 2</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_news_adv</li>\r\n				<li><strong>Position:</strong> mainbottom-3</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> About</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>57 - OBI II</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> </li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> All</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>58 - Parallax 2</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_tm_parallax</li>\r\n				<li><strong>Position:</strong> mainbottom</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> no</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> About</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n\r\n	<div class=''module''>\r\n	<div class=''row-fluid''>\r\n		<div class=''span3''><b>59 - IN A NUTSHELL</b></div>\r\n\r\n		<div class=''span4''>\r\n			<ul>\r\n				<li><strong>Type:</strong> mod_articles_single</li>\r\n				<li><strong>Position:</strong> content-top</li>\r\n				<li><strong>Class Suffix:</strong> </li>\r\n				<li><strong>Show Title:</strong> yes</li>\r\n				<li><strong>Order:</strong> 1</li>				\r\n			</ul>\r\n		</div>\r\n		<div class=''span5''>\r\n			<ul>\r\n				<li><strong>Pages:</strong> About</li>\r\n				<li><strong>Additional info:</strong> &nbsp;</li>\r\n			</ul>\r\n		</div>\r\n		<div class=''clearfix''></div>\r\n	</div>\r\n	</div>\r\n</div>', '', 1, 29, '2014-05-02 20:38:07', 474, '', '2016-06-11 11:13:32', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:38:07', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, '', '', 1, 70, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(65, 198, '404 Page', '404-page', '<div class="row-fluid">\r\n<div class="span6">\r\n<div class="big-404">\r\n<img src="images/img_404.png" alt="" />\r\n</div>\r\n</div>\r\n<div class="span6">\r\n<h2>Sorry!<br>Page Not Found</h2>\r\n<big>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</big>\r\n<p>Please try using our search box below to look for information on the internet.</p>\r\n<div class="row-fluid">\r\n{loadposition 404-search}\r\n</div>\r\n</div>\r\n</div>', '', 1, 2, '2014-09-22 08:18:23', 474, '', '2015-03-26 13:19:51', 846, 0, '0000-00-00 00:00:00', '2014-09-22 08:18:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 14, 1, '', '', 1, 270, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(66, 274, 'Popular', 'in-hac-habitasse', '<p>Here you will find artworks that are most frequently viewed and liked by site visitors.</p>\r\n', '\r\n<ul class="portfolio-meta-list">\r\n<li><strong class="portfolio-meta-key">Client:</strong><span>Popular</span></li>\r\n<li><strong class="portfolio-meta-key">Date:</strong><span>07/07/2012</span></li>\r\n<li><strong class="portfolio-meta-key">Info:</strong><span>Mighty creative studio</span></li>\r\n</ul>\r\n<br>\r\n<a href="#" target="_blank" class="btn btn-info">View Project</a>\r\n<br><br>\r\n<p> Would you like to know what do other people love the most? Click here and view. You will come across a really inspiring stuff. Have creative works of your own to show to the public? Post them and see if they are enjoyed by many people. This maybe your own way to popularity. As a rule, if some content becomes really popular on the Internet, the users tend to make a research about its author. Every gifted person has chances to become appreciated, loved and followed.</p>', 1, 31, '2014-05-02 19:35:27', 474, '', '2015-10-14 13:50:32', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:35:27', '0000-00-00 00:00:00', '{"image_intro":"images\\/portfolio\\/project-thumb1.jpg","image_intro_alt":"","image_intro_caption":"","float_intro":"none","image_fulltext":"images\\/portfolio\\/project-thumb1.jpg","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":"left"}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:gallery","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 37, 1, '', '', 1, 212, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(67, 275, 'Top-grade safety', 'top-grade-safety', '<p>Every car that you buy from us is checked with the newest computer equipment.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 31, '2014-05-02 19:35:27', 474, '', '2016-06-11 11:08:00', 846, 0, '0000-00-00 00:00:00', '2014-05-01 19:35:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/portfolio\\/project-thumb2.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/portfolio\\/project-thumb2.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:gallery","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 26, 2, '', '', 1, 44, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(68, 276, 'Individual approach', 'individual-approach', '<p>We prefer working with each client individually.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 31, '2014-05-02 19:35:27', 474, '', '2016-06-11 11:08:12', 846, 0, '0000-00-00 00:00:00', '2014-05-03 19:35:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/portfolio\\/project-thumb3.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/portfolio\\/project-thumb3.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:gallery","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 21, 3, '', '', 1, 24, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(69, 277, 'Extensive inventory', 'extensive-inventory', '<p>Our inventory is updated daily.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 31, '2014-05-02 19:35:27', 474, '', '2016-06-11 11:08:24', 846, 0, '0000-00-00 00:00:00', '2014-04-30 19:35:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/portfolio\\/project-thumb4.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/portfolio\\/project-thumb4.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:gallery","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 23, 4, '', '', 1, 6, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(70, 278, 'Affordable prices', 'affordable-prices', '<p>Our prices are the lowest on the market.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 31, '2014-05-02 19:35:27', 474, '', '2016-06-11 11:08:37', 846, 0, '0000-00-00 00:00:00', '2014-05-04 19:35:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/portfolio\\/project-thumb5.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/portfolio\\/project-thumb5.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:gallery","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 23, 5, '', '', 1, 9, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(71, 279, '24/7 support', '24-7-support', '<p>Our experts work day and night to solve all your car-related problems.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 31, '2014-05-02 19:35:27', 474, '', '2016-06-11 11:08:50', 846, 0, '0000-00-00 00:00:00', '2014-04-29 19:35:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/portfolio\\/project-thumb6.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/portfolio\\/project-thumb6.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:gallery","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 23, 6, '', '', 1, 17, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(75, 285, 'PERSONAL', 'first-package', '<div class="price">\r\n$29\r\n<small>/month</small>\r\n</div>\r\n<ul>\r\n<li><span>1 INSTALL</span></li>\r\n<li><span>25K VISITS/MO.</span></li>\r\n<li><span>10GB LOCAL STORAGE</span></li>\r\n<li><span>UNLIMITED DATA TRANSFER</span></li>\r\n</ul>', '', 1, 35, '2014-12-10 08:40:32', 474, '', '2016-06-10 10:50:17', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(76, 286, 'PROFESSIONAL', 'second-package', '<div class="price">\r\n$99\r\n<small>/month</small>\r\n</div>\r\n<ul>\r\n<li><span>10 INSTALLS</span></li>\r\n<li><span>100K VISITS/MO.</span></li>\r\n<li><span>20GB LOCAL STORAGE</span></li>\r\n<li><span>UNLIMITED DATA TRANSFER</span></li>\r\n</ul>', '', 1, 35, '2014-12-10 08:40:32', 474, '', '2016-06-10 10:50:13', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(77, 287, 'BUSINESS', 'third-package', '<div class="price">\r\n$249\r\n<small>/month</small>\r\n</div>\r\n<ul>\r\n<li><span>25 INSTALLS</span></li>\r\n<li><span>400K VISITS/MO.</span></li>\r\n<li><span>30GB LOCAL STORAGE</span></li>\r\n<li><span>UNLIMITED DATA TRANSFER</span></li>\r\n</ul>', '', 1, 35, '2014-12-10 08:40:32', 474, '', '2016-06-10 10:50:10', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(78, 288, 'PREMIUM', 'fourth-package', '<div class="price">\r\n<strong>Starting at</strong>\r\n$399\r\n<small>/month</small>\r\n</div>\r\n<ul>\r\n<li><span>150 INSTALLS</span></li>\r\n<li><span>1 MILLION +</span></li>\r\n<li><span>100-300GB LOCAL STORAGE</span></li>\r\n<li><span>UNLIMITED DATA TRANSFER</span></li>\r\n</ul>\r\n', '\r\n<p>For brands and growing businesses, it’s critical your website stays up and running at all times. Our dedicated plan combines the power and flexibility of dedicated resources with the customer service and innovation that has made our hosting engine an industry leader.</p>', -2, 35, '2014-12-10 08:40:32', 474, '', '2015-10-13 07:52:00', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"fa fa-key","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(79, 291, 'Happy clients', 'happy-clients', '1234', '', 1, 33, '2014-12-10 09:14:09', 474, '', '2016-06-10 11:00:08', 846, 0, '0000-00-00 00:00:00', '2014-12-10 09:14:09', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(80, 292, 'services', 'services', '647', '', 1, 33, '2014-12-10 09:14:09', 474, '', '2016-06-10 11:00:28', 846, 0, '0000-00-00 00:00:00', '2014-12-10 09:14:09', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(81, 293, 'Special offers', 'special-offers', '454', '', 1, 33, '2014-12-10 09:14:09', 474, '', '2016-06-10 11:00:42', 846, 0, '0000-00-00 00:00:00', '2014-12-10 09:14:09', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(88, 307, 'PERSONAL', 'first-package', '<p>Looking to run just one site or test us out for a bigger project? Creatives, marketers, and developers can utilize the powerful technology and bulletproof customer service that comes stock with every plan.</p>\r\n<div class="price">\r\n$29\r\n<small>/month</small>\r\n</div>', '', 1, 36, '2014-12-10 08:40:32', 474, '', '2016-06-10 10:54:36', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(89, 308, 'PROFESSIONAL', 'second-package', '<p>Whether you’re managing one site with steady traffic, numerous smaller sites, or hosting for your clients, the Professional plan provides flexibility. When you’re ready to take your work to the next level, we’re here to help.</p>\r\n<div class="price">\r\n$99\r\n<small>/month</small>\r\n</div>', '', 1, 36, '2014-12-10 08:40:32', 474, '', '2016-06-10 10:54:44', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(90, 309, 'BUSINESS', 'third-package', '<p>Your business is your passion, and helping you reach your audience is ours. The Business plan provides higher traffic and install limits and access to cutting edge technology like GeoIP, but still at an affordable shared environment price.</p>\r\n<div class="price">\r\n$249\r\n<small>/month</small>\r\n</div>', '', 1, 36, '2014-12-10 08:40:32', 474, '', '2016-06-10 10:54:53', 846, 0, '0000-00-00 00:00:00', '2014-12-10 08:40:32', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(100, 353, 'Tab Title 3', 'tab-title-3', '<p>If you have a problem with your car, we''ll quickly and effectively eliminate the problem, perform all work connected with the repair of your vehicle, efficiently and inexpensive. We are ready to provide you with a full range of services for warranty and post-warranty maintenance and repair of any car.  Also timely diagnostics and maintenance will prevent serious breakage and help to be sure in good technical condition of the car. Our service works honestly and offers its clients to pay for the cost of only really necessary servicing and car repairs.</p>', '', 1, 57, '2014-05-02 19:54:26', 474, '', '2016-06-10 10:11:46', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:54:26', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, -1, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(101, 354, 'Tab Title 2', 'tab-title-2', '<p>If you have a problem with your car, we''ll quickly and effectively eliminate the problem, perform all work connected with the repair of your vehicle, efficiently and inexpensive. We are ready to provide you with a full range of services for warranty and post-warranty maintenance and repair of any car.  Also timely diagnostics and maintenance will prevent serious breakage and help to be sure in good technical condition of the car. Our service works honestly and offers its clients to pay for the cost of only really necessary servicing and car repairs.</p>', '', 1, 57, '2014-05-02 19:54:26', 474, '', '2016-06-10 10:11:44', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:54:26', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(102, 355, 'Tab Title 1', 'tab-title-1', '<p>If you have a problem with your car, we''ll quickly and effectively eliminate the problem, perform all work connected with the repair of your vehicle, efficiently and inexpensive. We are ready to provide you with a full range of services for warranty and post-warranty maintenance and repair of any car.  Also timely diagnostics and maintenance will prevent serious breakage and help to be sure in good technical condition of the car. Our service works honestly and offers its clients to pay for the cost of only really necessary servicing and car repairs.</p>', '', 1, 57, '2014-05-02 19:54:26', 474, '', '2016-06-10 10:11:41', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:54:26', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(103, 357, 'Ann Smith', 'ann-smith', '<blockquote><p><i class="material-design-google125"></i>Good, reliable service is offered here - with attention to detail and with clear communication about possible problems I should be aware of.</p></blockquote>', '', 1, 28, '2014-05-02 20:34:27', 474, '', '2016-06-10 12:42:34', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:34:27', '0000-00-00 00:00:00', '{"image_intro":"images\\/testimonials\\/testimonials-4.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/testimonials\\/testimonials-1.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"1","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(104, 358, 'Bryan Thompson', 'bryan-thompson', '<blockquote><p><i class="material-design-google125"></i>I have been using CarRepair for two years now. They keep my FJ in tip top condition. And the best thing as a single woman is being able to trust them.</p></blockquote>', '', 1, 28, '2014-05-02 20:34:08', 474, '', '2016-06-10 12:42:31', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:34:08', '0000-00-00 00:00:00', '{"image_intro":"images\\/testimonials\\/testimonials-5.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/testimonials\\/testimonials-2.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"1","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(105, 359, 'Antony Moore', 'antony-moore', '<blockquote><p><i class="material-design-google125"></i>Everyone here is professional and they treat you like a person unlike many of the name brand shops. They are honest and will work with you.</p></blockquote>', '', 1, 28, '2014-05-02 20:33:47', 474, '', '2016-06-10 12:42:27', 846, 0, '0000-00-00 00:00:00', '2014-05-02 20:33:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/testimonials\\/testimonials-6.jpg","float_intro":"left","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/testimonials\\/testimonials-3.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"1","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(110, 375, 'We truly believe that the success of our business depends on our employees.', 'lorem-ipsum-dolor-sit-amet', '<p>We offer excellent opportunities for individuals seeking to strive and flourish in the research and consultancy industry, focusing on their professional as well as personal development. Our distinctive environment offers careers that are exciting, challenging and rewarding. We encourage our people to learn, experiment and grow - for both their own personal benefit and the company’s.</p>\r\n{loadposition careers-accordion-1}', '', 1, 46, '2015-01-23 08:48:54', 474, '', '2015-10-14 11:40:35', 846, 0, '0000-00-00 00:00:00', '2015-01-23 08:48:54', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, -1, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(111, 378, 'The Sunday Times Best Company to work for', 'etiam-in-neque-non-sapien-lobortis', '<p>We’re proud to say that our office has made The Sunday Times Best Small Companies to work for list at our first attempt. Our Company is the top-ranking research consultancy in the small companies category to have achieved a listing, achieving 50th place out of the top 100  companies  recognised as great places to work in the UK. The accolade acknowledges “that senior employees truly live the values of the firm”, that people say “their jobs are good for growth” and the company “clearly values new ideas from employees”. We received top rankings for the My Manager, Personal Growth and Fair Deal categories. This is truly a testament to the talented collection of people, special energy and morale we have at The Futures Company.</p>\r\n{loadposition careers-accordion-2}', '', 1, 46, '2015-01-23 08:48:54', 474, '', '2015-10-14 09:34:54', 846, 0, '0000-00-00 00:00:00', '2015-01-23 08:48:54', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, -1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(112, 379, 'IT Careers', 'porro-magni-dolore-eos-eius-ducimus', '<p>Each day our world creates new technology: devices, apps, and services. Which means new ways to do things, new ways to connect, new things to learn. While each holds the promise of helping us get more done with less effort, they also can become one more thing competing for our scarce time and attention.</p>\r\n{loadposition careers-accordion-3}', '', 1, 46, '2015-01-23 08:48:54', 474, '', '2015-10-14 11:01:08', 846, 0, '0000-00-00 00:00:00', '2015-01-23 08:48:54', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 1, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(113, 381, 'Machine learning', 'vestibulum-commodo-mollis', '<p>We are looking to hire mathematically minded people who have the talent to analyze and derive meaning from data, as well as those who know how to deploy techniques of machine learning. We work with a diverse set of technologies, including deep learning, probabilistic programming, large-scale learning, and causal reasoning. For scientists who’ve got algorithmic ability, this skill set can be the ticket to one of the hottest jobs on the market.</p>\r\n{loadposition careers-accordion-4}', '', 1, 46, '2015-01-23 08:48:54', 474, '', '2015-10-14 11:05:07', 846, 0, '0000-00-00 00:00:00', '2015-01-23 08:48:54', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(114, 384, 'Business intelligence (BI) professionals', 'business-intelligence-bi-professionals', '{loadposition careers-accordion-requirements}', '', 1, 47, '2015-01-23 14:57:20', 474, '', '2015-10-14 11:41:24', 846, 0, '0000-00-00 00:00:00', '2015-01-23 14:57:20', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(115, 385, 'Business Program Managers (BPM)', 'business-program-managers-bpm', '{loadposition careers-accordion-expect}', '', 1, 47, '2015-01-23 14:58:01', 474, '', '2015-10-14 11:39:14', 846, 0, '0000-00-00 00:00:00', '2015-01-23 14:58:01', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(116, 386, 'Software Engineers (SWE)', 'software-engineers-swe', '<p>They’re responsible for production code quality and service performance, and accountable for automation of test cases to enable flighting. These engineers can evaluate requirements, estimate costs, design, implement, validate and measure to understand the quality of the end users’ experience. They can improve engineering processes, assure quality, communicate status, and manage risks.</p>', '', 1, 47, '2015-01-23 15:00:12', 474, '', '2015-10-14 11:38:21', 846, 0, '0000-00-00 00:00:00', '2015-01-23 15:00:12', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(118, 425, 'Pay no commission when selling a hybrid car', 'pay-no-commission-when-selling-a-hybrid-car', '<p>From now on you don’t pay a standard commission when selling a hybrid car through our marketplace. We support green technologies, and think that it would be great to support those who care about the environment. Earlier we removed the commission for any deals with electric cars.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advise you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed to halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 11, '2014-05-02 19:47:40', 474, '', '2016-07-01 07:56:59', 846, 0, '0000-00-00 00:00:00', '2015-02-19 00:00:00', '0000-00-00 00:00:00', '{"image_intro":"images\\/blog\\/blog-img2.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/blog\\/blog-img2.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"theme3288:blog","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 47, 1, '', '', 1, 305, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(121, 433, 'Elements', 'elements', '<div class="center">\r\n	<h4 class="heading-style-1">Heading style 1</h4>\r\n	<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale.</p>\r\n	<h4 class="heading-style-2">Heading style 2</h4>\r\n	<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale.</p>\r\n	<h4 class="heading-style-3">Heading style 3</h4>\r\n	<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale.</p>\r\n	<h4 class="heading-style-4">Heading style 4</h4>\r\n	<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale.</p>\r\n	<h4 class="heading-style-5">Heading style 5</h4>\r\n	<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale.</p>\r\n	<h4 class="heading-style-6">Heading style 6</h4>\r\n	<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale.</p>\r\n</div>\r\n<div class="spacer"></div>\r\n<div class="row-fluid">\r\n	<div class="span4">\r\n		<div class="item_img img-intro__none">\r\n			<img src="images/elements_img1.jpg" alt="" />\r\n		</div>\r\n		<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models.</p>\r\n	</div>\r\n	<div class="span8">\r\n		<div class="item_img img-intro__left rounded">\r\n			<img src="images/elements_img2.jpg" alt="" />\r\n		</div>\r\n		<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models.</p>\r\n		<p>We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles.</p>\r\n		<div class="row-fluid">\r\n			<div class="span12">\r\n				<p>We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale. </p>\r\n			</div>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class="spacer"></div>\r\n<div class="row-fluid">\r\n	<div class="span4">\r\n		<ul>\r\n			<li><a href="#">COMPUTER DIAGNOSTICS</a></li>\r\n			<li><a href="#">COMPLETE SAFETY ANALYSIS</a></li>\r\n			<li><a href="#">DRIVABILITY PROBLEMS</a></li>\r\n			<li><a href="#">TUNE-UPS</a></li>\r\n			<li><a href="#">OIL CHANGES</a></li>\r\n			<li><a href="#">TIRES</a></li>\r\n		</ul>\r\n	</div>\r\n	<div class="span4">\r\n		<ol>\r\n			<li><a href="#">COMPUTER DIAGNOSTICS</a></li>\r\n			<li><a href="#">COMPLETE SAFETY ANALYSIS</a></li>\r\n			<li><a href="#">DRIVABILITY PROBLEMS</a></li>\r\n			<li><a href="#">TUNE-UPS</a></li>\r\n			<li><a href="#">OIL CHANGES</a></li>\r\n			<li><a href="#">TIRES</a></li>\r\n		</ol>\r\n	</div>\r\n	<div class="span4">\r\n		<ul class="list">\r\n			<li><a href="#">COMPUTER DIAGNOSTICS</a></li>\r\n			<li><a href="#">COMPLETE SAFETY ANALYSIS</a></li>\r\n			<li><a href="#">DRIVABILITY PROBLEMS</a></li>\r\n			<li><a href="#">TUNE-UPS</a></li>\r\n			<li><a href="#">OIL CHANGES</a></li>\r\n			<li><a href="#">TIRES</a></li>\r\n		</ul>\r\n	</div>\r\n</div>\r\n<div class="spacer"></div>\r\n<div class="page_header">\r\n	<h1 class="center">get started</h1>\r\n</div>\r\n<div class="row-fluid">\r\n	<form>\r\n		<div class="span8">\r\n			<div class="row-fluid">\r\n				<div class="span6">\r\n					<div class="controls">\r\n						<input type="text" placeholder="Text input" class="error"><mark><label class="error">This field is required.</label></mark>\r\n					</div>\r\n					<div class="controls">\r\n						<input type="text" placeholder="Text input">\r\n					</div>\r\n				</div>\r\n				<div class="span6">\r\n					<div class="controls">\r\n						<textarea placeholder="Text area field"></textarea>\r\n					</div>\r\n				</div>\r\n				<div class="span12">\r\n					<a href="#" class="btn">send message</a>\r\n				</div>\r\n			</div>\r\n		</div>\r\n		<div class="span4">\r\n			<div class="control">\r\n				<select>\r\n					<option disabled selected value="">Select option</option>\r\n					<option>Option 1</option>\r\n					<option>Option 2</option>\r\n				</select>\r\n			</div>\r\n			<div class="row-fluid">\r\n				<div class="span6">\r\n					<div class="control-group reset-margin">\r\n						<input type="checkbox" id="checkbox_1" checked>\r\n						<label for="checkbox_1" class="inline">Checkbox label</label>\r\n					</div>\r\n					<div class="control-group">\r\n						<input type="checkbox" id="checkbox_2">\r\n						<label for="checkbox_2" class="inline">Checkbox label</label>\r\n					</div>\r\n				</div>\r\n				<div class="span6">\r\n					<div class="control-group reset-margin">\r\n						<input type="radio" id="radio_1" name="radio" checked>\r\n						<label for="radio_1" class="inline">Radio label</label>\r\n					</div>\r\n					<div class="control-group">\r\n						<input type="radio" id="radio_2" name="radio">\r\n						<label for="radio_2" class="inline">Radio label</label>\r\n					</div>\r\n				</div>\r\n			</div>\r\n		</div>\r\n	</form>\r\n</div>', '', 1, 62, '2015-03-02 12:54:45', 474, '', '2016-06-11 08:22:39', 846, 0, '0000-00-00 00:00:00', '2015-03-02 12:54:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 101, 0, '', '', 1, 1832, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(125, 449, 'Leadership', 'conse-ctetu', '', '', 1, 59, '2014-12-10 10:05:32', 474, '', '2015-10-15 07:19:54', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:05:32', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"0","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(126, 450, 'Management', 'dolor-sit-amet-conse', '', '', 1, 59, '2014-12-10 10:06:07', 474, '', '2015-10-15 07:20:12', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:07', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"25","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(127, 451, 'Innovation and creativity', 'sit-amet-conse', '', '', 1, 59, '2014-12-10 10:06:44', 474, '', '2015-10-15 07:20:28', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:44', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"75","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(128, 452, 'Leadership', 'conse-ctetu', '', '', 1, 60, '2014-12-10 10:05:32', 474, '', '2015-10-15 07:21:28', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:05:32', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"0","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(129, 453, 'Management', 'dolor-sit-amet-conse', '', '', 1, 60, '2014-12-10 10:06:07', 474, '', '2015-10-15 07:21:57', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:07', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"25","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(130, 454, 'Innovation and creativity', 'sit-amet-conse', '', '', 1, 60, '2014-12-10 10:06:44', 474, '', '2015-10-15 07:22:26', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:44', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"75","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(131, 468, 'Leadership/Management Skills.', 'sit-amet-conse', '', '', 1, 61, '2014-12-10 10:06:44', 474, '', '2015-10-13 12:00:10', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:44', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"75","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(132, 469, 'Computer/Technical Knowledge.', 'dolor-sit-amet-conse', '', '', 1, 61, '2014-12-10 10:06:07', 474, '', '2015-10-20 08:01:27', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:07', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"55","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(133, 470, 'Communication Skills.', 'conse-ctetu', '', '', 1, 61, '2014-12-10 10:05:32', 474, '', '2015-10-20 08:00:59', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:05:32', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"25","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(134, 471, 'Analytical/Research Skills.', 'dipiscing-elit', '', '', 1, 61, '2014-12-10 10:05:32', 474, '', '2015-10-13 11:59:21', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:05:32', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"90","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(135, 476, 'Resilience', 'sit-amet-consectetur', '', '', 1, 59, '2014-12-10 10:06:44', 474, '', '2015-10-15 07:20:45', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:44', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"100","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(136, 477, 'Resilience', 'sit-amet-consectetur', '', '', 1, 60, '2014-12-10 10:06:44', 474, '', '2015-10-15 07:21:08', 846, 0, '0000-00-00 00:00:00', '2014-12-10 10:06:44', '0000-00-00 00:00:00', '{"image_intro":"","image_intro_alt":"","image_intro_caption":"100","float_intro":"","image_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":"","float_fulltext":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(137, 479, 'QUALITY CAR', 'quality-car', 'MAINTENANCE', '', 1, 63, '2014-05-02 19:35:27', 474, '', '2016-06-10 09:38:50', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:35:27', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/slider\\/slide-1.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(138, 480, 'YOUR ONE STOP', 'your-one-stop', 'CAR CARE SERVICES', '', 1, 63, '2014-05-02 19:34:33', 474, '', '2016-06-10 09:38:35', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:34:33', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/slider\\/slide-2.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(139, 481, 'COMPLETE', 'complete', 'AUTO SERVICE', '', 1, 63, '2014-05-02 19:34:02', 474, '', '2016-06-10 09:38:24', 846, 0, '0000-00-00 00:00:00', '2014-05-02 19:34:02', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/slider\\/slide-3.jpg","float_fulltext":"none","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(143, 525, 'models served', 'models-served', '985', '', 1, 33, '2014-12-10 09:14:09', 474, '', '2016-06-10 11:01:42', 846, 0, '0000-00-00 00:00:00', '2014-12-10 09:14:09', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(144, 526, 'Footer post', 'footer-post', '<p>Our goal is to gain your trust and confidence so that when you leave the shop, you are certain that your vehicle has been properly repaired by highly trained and certified technicians.</p>', '', 1, 8, '2016-06-10 11:33:45', 846, '', '2016-06-10 11:33:45', 0, 0, '0000-00-00 00:00:00', '2016-06-10 11:33:45', '0000-00-00 00:00:00', '{"image_intro":"images\\/footer_logo.png","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(145, 529, 'COMPLETE AUTO SERVICE', 'complete-auto-service', 'We are a full service automotive and repair and maintenance facility serving the area with consistent, honest, reliable and friendly service. Car Repair Auto Service is in business to service and repair your vehicle. We will do everything possible to make you feel welcome, comfortable and satisfied with your service experience.', '', 1, 8, '2016-06-10 11:56:01', 846, '', '2016-06-10 11:56:01', 0, 0, '0000-00-00 00:00:00', '2016-06-10 11:56:01', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(146, 530, 'About Our Company', 'about-our-company', 'If you have a problem with your car, we''ll quickly and effectively eliminate the problem, perform all work connected with the repair of your vehicle, efficiently and inexpensive. We are ready to provide you with a full range of services for warranty and post-warranty maintenance and repair of any car.', '', 1, 8, '2016-06-10 11:56:29', 846, '', '2016-06-10 11:56:29', 0, 0, '0000-00-00 00:00:00', '2016-06-10 11:56:29', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(147, 531, 'IN A NUTSHELL About CaRrepair', 'in-a-nutshell-about-carrepair', '<p>CarRepair is a full-service auto repair shop providing complete car repair and service on most domestic and import makes and models. We employ ASE certified technicians and use high quality parts. All of our work is guaranteed for 12 months or 12,000 miles. We pledge honesty, integrity, quality, and excellent customer service, all at a fair price. We will never sell you something you don’t need, and we won’t pressure you or resort to scare tactics to make a sale. \r\nWe believe in giving you all the facts – the results of any tests or inspections we perform – and explaining your options while educating you about anything you would like to understand better, and then letting you decide what the best choice is for yourself at that time.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 8, '2016-06-10 11:59:18', 846, '', '2016-06-10 11:59:18', 0, 0, '0000-00-00 00:00:00', '2016-06-10 11:59:18', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(148, 532, 'OBI II Diagnostic system', 'obi-ii-diagnostic-system', '<p>Modern vehicles come equipped with an onboard computer diagnostic system (OBD II) that monitors your vehicle’s operations. The OBD II system monitors emissions control systems. That means the monitors can detect anything from a loose fuel cap to a clogged catalytic converter.</p>', '', 1, 8, '2016-06-10 11:59:50', 846, '', '2016-06-10 11:59:50', 0, 0, '0000-00-00 00:00:00', '2016-06-10 11:59:50', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(149, 536, 'Brand1', 'brand1', '', '', 1, 64, '2016-06-10 13:06:33', 846, '', '2016-06-10 13:08:18', 846, 0, '0000-00-00 00:00:00', '2016-06-10 13:06:33', '0000-00-00 00:00:00', '{"image_intro":"images\\/brands\\/brand1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(150, 537, 'Brand2', 'brand2', '', '', 1, 64, '2016-06-10 13:06:33', 846, '', '2016-06-10 13:08:18', 846, 0, '0000-00-00 00:00:00', '2016-06-10 13:06:33', '0000-00-00 00:00:00', '{"image_intro":"images\\/brands\\/brand2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(151, 538, 'Brand3', 'brand3', '', '', 1, 64, '2016-06-10 13:06:33', 846, '', '2016-06-10 13:08:17', 846, 0, '0000-00-00 00:00:00', '2016-06-10 13:06:33', '0000-00-00 00:00:00', '{"image_intro":"images\\/brands\\/brand3.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(152, 539, 'Brand4', 'brand4', '', '', 1, 64, '2016-06-10 13:06:33', 846, '', '2016-06-10 13:08:17', 846, 0, '0000-00-00 00:00:00', '2016-06-10 13:06:33', '0000-00-00 00:00:00', '{"image_intro":"images\\/brands\\/brand4.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(153, 540, 'Brand5', 'brand5', '', '', 1, 64, '2016-06-10 13:06:33', 846, '', '2016-06-10 13:08:16', 846, 0, '0000-00-00 00:00:00', '2016-06-10 13:06:33', '0000-00-00 00:00:00', '{"image_intro":"images\\/brands\\/brand5.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(154, 541, 'Brand6', 'brand6', '', '', 1, 64, '2016-06-10 13:06:33', 846, '', '2016-06-10 13:08:15', 846, 0, '0000-00-00 00:00:00', '2016-06-10 13:06:33', '0000-00-00 00:00:00', '{"image_intro":"images\\/brands\\/brand6.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(155, 545, 'car MOTOR repair', 'car-motor-repair', '<p>The motor is one of the most basic mechanisms of the car, one of the most difficult to repair.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 65, '2016-06-10 15:36:35', 846, '', '2016-06-10 15:36:35', 0, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image1.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/services\\/image1.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(156, 546, 'CAR BODY repair', 'car-body-repair', '<p>We save your car from damage. You won''t recognize your car, it will look like new one.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 65, '2016-06-10 15:36:35', 846, '', '2016-06-10 15:38:17', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image2.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/services\\/image2.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(157, 547, 'CHASSIS repair', 'chassis-repair', '<p>Our service will gladly offer its clients a full range of car chassis repairs.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 65, '2016-06-10 15:36:35', 846, '', '2016-06-10 15:38:27', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image3.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/services\\/image3.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(158, 548, 'TRANSMISSION repair', 'transmission-repair', '<p>Thanks to the spare parts, company guarantees minimum turnaround time.</p>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 65, '2016-06-10 15:36:35', 846, '', '2016-07-01 07:51:13', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image4.jpg","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/services\\/image4.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(159, 551, 'List 1', 'list-1', '<ul>\r\n	<li>COMPUTER DIAGNOSTICS</li>\r\n	<li>COMPLETE SAFETY ANALYSIS</li>\r\n	<li>DRIVABILITY PROBLEMS</li>\r\n	<li>TUNE-UPS</li>\r\n	<li>OIL CHANGES</li>\r\n	<li>TIRES</li>\r\n</ul>', '', 1, 66, '2016-06-10 16:01:53', 846, '', '2016-06-10 16:01:53', 0, 0, '0000-00-00 00:00:00', '2016-06-10 16:01:53', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(160, 552, 'List 2', 'list-2', '<ul>\r\n	<li>EMISSION REPAIR FACILITY</li>\r\n	<li>AIR CONDITIONING SERVICE</li>\r\n	<li>ELECTRICAL SYSTEMS</li>\r\n	<li>FLEET MAINTENANCE</li>\r\n	<li>ENGINE WORK</li>\r\n	<li>MARYLAND STATE INSPECTIONS</li>\r\n</ul>', '', 1, 66, '2016-06-10 16:02:01', 846, '', '2016-06-10 16:02:01', 0, 0, '0000-00-00 00:00:00', '2016-06-10 16:02:01', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(161, 553, 'List 3', 'list-3', '<ul>\r\n	<li>BRAKE REPAIR SPECIALISTS</li>\r\n	<li>MUFFLERS AND EXHAUST SYSTEMS</li>\r\n	<li>STEERING AND SUSPENSIONS</li>\r\n	<li>ALIGNMENTS</li>\r\n	<li>FUEL SYSTEM SERVICES</li>\r\n	<li>COOLANT SYSTEMS</li>\r\n</ul>', '', 1, 66, '2016-06-10 16:02:11', 846, '', '2016-06-10 16:02:11', 0, 0, '0000-00-00 00:00:00', '2016-06-10 16:02:11', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(162, 556, 'MOTOR REPAIR', 'motor-repair', '', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 67, '2016-06-10 16:18:10', 846, '', '2016-06-10 16:18:10', 0, 0, '0000-00-00 00:00:00', '2016-06-10 16:18:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/icon1.png","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 6, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(163, 557, 'TRANSMISSION REPAIR', 'transmission-repair', '', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 67, '2016-06-10 16:18:10', 846, '', '2016-06-10 16:19:15', 846, 0, '0000-00-00 00:00:00', '2016-06-10 16:18:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/icon2.png","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(164, 558, 'CHASSIS REPAIR', 'chassis-repair', '', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 67, '2016-06-10 16:18:10', 846, '', '2016-06-10 16:19:15', 846, 0, '0000-00-00 00:00:00', '2016-06-10 16:18:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/icon3.png","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(165, 559, 'CAR BODY REPAIR', 'car-body-repair', '', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 67, '2016-06-10 16:18:10', 846, '', '2016-06-10 16:19:14', 846, 0, '0000-00-00 00:00:00', '2016-06-10 16:18:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/icon4.png","float_intro":"none","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(166, 562, 'List 1', 'list-1', '<ul class="list">\r\n	<li><a href="#">COMPUTER DIAGNOSTICS</a></li>\r\n	<li><a href="#">COMPLETE SAFETY ANALYSIS</a></li>\r\n	<li><a href="#">DRIVABILITY PROBLEMS</a></li>\r\n	<li><a href="#">TUNE-UPS</a></li>\r\n	<li><a href="#">OIL CHANGES</a></li>\r\n	<li><a href="#">TIRES</a></li>\r\n</ul>', '', 1, 68, '2016-06-11 08:07:41', 846, '', '2016-06-11 08:26:13', 846, 0, '0000-00-00 00:00:00', '2016-06-11 08:07:41', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(167, 563, 'List 2', 'list-2', '<ul class="list">\r\n	<li><a href="#">EMISSION REPAIR FACILITY</a></li>\r\n	<li><a href="#">AIR CONDITIONING SERVICE</a></li>\r\n	<li><a href="#">ELECTRICAL SYSTEMS</a></li>\r\n	<li><a href="#">FLEET MAINTENANCE</a></li>\r\n	<li><a href="#">ENGINE WORK</a></li>\r\n	<li><a href="#">MARYLAND STATE INSPECTIONS</a></li>\r\n</ul>', '', 1, 68, '2016-06-11 08:07:55', 846, '', '2016-06-11 08:26:10', 846, 0, '0000-00-00 00:00:00', '2016-06-11 08:07:55', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(168, 564, 'About', 'about', '<p>If you have a problem with your car, we''ll quickly and effectively eliminate the problem, perform all work connected with the repair of your vehicle, efficiently and inexpensive. We are ready to provide you with a full range of services for warranty and post-warranty maintenance and repair of any car.</p>', '', 1, 56, '2016-06-11 08:08:24', 846, '', '2016-06-11 08:08:24', 0, 0, '0000-00-00 00:00:00', '2016-06-11 08:08:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(169, 568, 'List 3', 'list-3', '<ul>\r\n	<li>Belt and Hose Replacement</li>\r\n	<li>Diesel Service and Repair</li>\r\n	<li>Fuel Injection Service</li>\r\n	<li>Transmission</li>\r\n	<li>Power Steering</li>\r\n	<li>Cooling System Flush</li>\r\n</ul>', '', 1, 69, '2016-06-10 16:02:11', 846, '', '2016-06-11 09:10:45', 846, 0, '0000-00-00 00:00:00', '2016-06-10 16:02:11', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(170, 569, 'List 2', 'list-2', '<ul>\r\n	<li>Suspension</li>\r\n	<li>Electrical</li>\r\n	<li>Full Brake Service</li>\r\n	<li>Shocks</li>\r\n	<li>Oil and Lube</li>\r\n	<li>Suspension and Shock Repair</li>\r\n</ul>', '', 1, 69, '2016-06-10 16:02:01', 846, '', '2016-06-11 09:10:41', 846, 0, '0000-00-00 00:00:00', '2016-06-10 16:02:01', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(171, 570, 'List 1', 'list-1', '<ul>\r\n	<li>Tune ups</li>\r\n	<li>Wheel Alignment</li>\r\n	<li>Engine Repair</li>\r\n	<li>Smog & Emissions Testing</li>\r\n	<li>Tire Service</li>\r\n	<li>Exhaust System</li>\r\n</ul>', '', 1, 69, '2016-06-10 16:01:53', 846, '', '2016-06-11 09:10:39', 846, 0, '0000-00-00 00:00:00', '2016-06-10 16:01:53', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(172, 574, 'Memorial Day Offer', 'memorial-day-offer', '<div class="price"><small>$</small>29.99</div>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 70, '2016-06-10 15:36:35', 846, '', '2016-06-11 09:25:59', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image5.jpg","float_intro":"none","image_intro_alt":"Offer","image_intro_caption":"Memorial Day ","image_fulltext":"images\\/services\\/image5.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(173, 575, 'Interstate Batteries', 'interstate-batteries', '<div class="price"><small>$</small>19.99</div>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 70, '2016-06-10 15:36:35', 846, '', '2016-06-11 09:26:06', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image6.jpg","float_intro":"none","image_intro_alt":"Batteries","image_intro_caption":"Interstate ","image_fulltext":"images\\/services\\/image6.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(174, 576, 'Standard or Lifetime Brake Service', 'standard-or-lifetime-brake-service', '<div class="price"><small>$</small>79.99</div>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 70, '2016-06-10 15:36:35', 846, '', '2016-06-11 09:26:12', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image7.jpg","float_intro":"none","image_intro_alt":"Brake Service","image_intro_caption":"Standard or Lifetime ","image_fulltext":"images\\/services\\/image7.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(175, 577, 'car care class', 'car-care-class', '<div class="price"><small>$</small>47.99</div>\r\n\r\n', '\r\n\r\n<p>Looking for the original spare parts for your car can be a real problem, especially if your ride is a rare or old model. But we can find any detail for any car you can imagine – quickly. Our company collaborates with thousands of collectors, warehouses and private workshops to obtain even the rarest automotive goods. We offer car parts for over 2000 of models. Learn more by talking to our representatives.</p>\r\n\r\n<p>When you purchase from us, you can be sure that you get the best service possible. Our job is to give you what you need – and we do it perfectly. You can find service centers of our company all over the world – from the USA to Japan. There is no better and cheaper way to buy, sell, rent or repair a car than to use our services. If you have any questions concerning our job, our support team will be glad to answer them.</p>\r\n\r\n<p>Sell or buy cars easier than ever. Our specialists will advice you a vehicle that meets your requirements on request. We offer a wide range of vehicles: sedans, SUVs, pick-ups, trucks, limousines, and even water and aerial vehicles. Every car passes through the process of thorough testing and verification. Additionally you can order paint job, tires replacement and repair, or car interior accessories without leaving this website.</p>\r\n\r\n<p>What makes a high-quality used car? Moderate mileage, absence of mechanical damage and integrity of all its details. But confidence that the car will last you a long time is above all. That’s why we use newest hi-tech equipment to double-check each and any aspect of your future vehicle. We are an all-in-one resource, providing you with a unique online experience that will help you find the perfect used car.</p>\r\n\r\n<p>We reinvented the car rental process to deliver you top-grade customer experience at low prices. Our commitment to price transparency is beyond comparison. You will get exactly what you want, without overpaying a single penny. We receive our wares directly from the manufacturers, so we can offer you the lowest prices on the automotive market.</p>\r\n\r\n<p>We go green to meet ever-tighter global emissions standards. Our production chain is now equipped with modern emission counters and brand new filters. Last year we managed halve the carbon monoxide emission, so be sure that buying from us you are not harming the environment. We care about nature, that’s why we encourage usage of electric and hybrid cars. No commission is applied to any electric or hybrid car sold via our marketplace.</p>', 1, 70, '2016-06-10 15:36:35', 846, '', '2016-06-11 09:26:18', 846, 0, '0000-00-00 00:00:00', '2016-06-10 15:36:35', '0000-00-00 00:00:00', '{"image_intro":"images\\/services\\/image8.jpg","float_intro":"none","image_intro_alt":"class","image_intro_caption":"car care ","image_fulltext":"images\\/services\\/image8.jpg","float_fulltext":"left","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 1, 11, 7, '2016-06-11 11:19:52', 1),
('com_content.article', 1, 11, 17, '2016-06-11 11:19:52', 1);

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(76, 1);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=16 ;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}, "special":{"fulltext":"fulltext"}}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{}}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special":{}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(11, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(12, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(13, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(14, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(15, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10135 ;

INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":"","filename":"mailto"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":"","filename":"wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":"","filename":"banners"}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":"","save_history":"0","history_limit":5}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"Unknown","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '{"contact_layout":"_:default","show_contact_category":"hide","save_history":"0","history_limit":5,"show_contact_list":"1","presentation_style":"plain","show_name":"0","show_position":"0","show_email":"0","show_street_address":"0","show_suburb":"0","show_state":"0","show_postcode":"0","show_country":"0","show_telephone":"0","show_mobile":"0","show_fax":"0","show_webpage":"0","show_misc":"1","show_image":"0","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_tags":"1","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"0","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_items":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"1","show_fax_headings":"1","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_pagination":"2","show_pagination_results":"1","initial_sort":"ordering","captcha":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":"","filename":"media"}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"newsfeed_layout":"_:default","save_history":"0","history_limit":5,"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_character_count":"0","feed_display_order":"des","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_items":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"1","show_articles":"0","show_link":"1","show_pagination":"1","show_pagination_results":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":"","filename":"search"}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"0","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{"name":"com_weblinks","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":""}', '{"target":"0","save_history":"0","history_limit":5,"count_clicks":"1","icons":1,"link_icons":"","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_num_links":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_links_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"0","show_link_description":"1","show_link_hits":"1","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","info_block_position":"0","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_readmore":"1","show_readmore_title":"0","readmore_limit":"100","show_tags":"1","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","save_history":"0","history_limit":10,"show_urls_images_frontend":"1","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"none","float_fulltext":"left","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"0","show_empty_categories":"0","show_no_articles":"0","show_subcat_desc":"0","show_cat_num_articles":"0","show_base_description":"0","maxLevelcat":"1","show_empty_categories_cat":"0","show_subcat_desc_cat":"0","show_cat_num_articles_cat":"0","num_leading_articles":"0","num_intro_articles":"4","num_columns":"1","num_links":"0","multi_column_order":"0","show_subcategory_content":"-1","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"order","order_date":"published","show_pagination":"0","show_pagination_results":"0","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"9":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"2":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":"","filename":"users"}', '{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"9","sendpassword":"1","useractivation":"1","mail_to_admin":"0","captcha":"0","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","minimum_length":"4","minimum_integers":"0","minimum_symbols":"0","minimum_uppercase":"0","save_history":"1","history_limit":5,"mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":""}', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stemmer":"snowball"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"tag_layout":"_:default","save_history":"0","history_limit":5,"show_tag_title":"0","tag_list_show_tag_image":"1","tag_list_show_tag_description":"1","tag_list_image":"","show_tag_num_items":"0","tag_list_orderby":"c.core_title","tag_list_orderby_direction":"ASC","show_headings":"1","tag_list_show_date":"published","tag_list_show_item_image":"1","tag_list_show_item_description":"1","tag_list_item_maximum_characters":10000,"min_term_length":"3","return_any_or_all":"1","include_children":"0","maximum":200,"tag_list_language_filter":"all","tags_layout":"_:default","all_tags_orderby":"publish_up","all_tags_orderby_direction":"ASC","all_tags_show_tag_image":"1","all_tags_show_tag_descripion":"1","all_tags_tag_maximum_characters":10000,"all_tags_show_tag_hits":"0","filter_field":"0","show_pagination_limit":"0","show_pagination":"2","show_pagination_results":"1","tag_field_ajax_mode":"0","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":"","filename":"contenthistory"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":"","filename":"ajax"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, 'false', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{"name":"SimplePie","type":"library","creationDate":"2004","author":"SimplePie","copyright":"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon","authorEmail":"","authorUrl":"http:\\/\\/simplepie.org\\/","version":"1.2","description":"LIB_SIMPLEPIE_XML_DESCRIPTION","group":"","filename":"simplepie"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 'phputf8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"phputf8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":"","filename":"phputf8"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 'Joomla! Platform', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"Joomla! Platform","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"mediaversion":"d22b630ba38a07428401915df45b12d0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 'IDNA Convert', 'library', 'idna_convert', '', 0, 1, 1, 1, '{"name":"IDNA Convert","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":"","filename":"idna_convert"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2015-04-22 13:15:32","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2015 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.4.3","description":"LIB_FOF_XML_DESCRIPTION","group":"","filename":"fof"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 'PHPass', 'library', 'phpass', '', 0, 1, 1, 1, '{"name":"PHPass","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":"","filename":"phpass"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":"","filename":"mod_articles_archive"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_articles_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":"","filename":"mod_banners"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":"","filename":"mod_breadcrumbs"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":"","filename":"mod_footer"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":"","filename":"mod_articles_news"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":"","filename":"mod_random_image"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":"","filename":"mod_related_items"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":"","filename":"mod_search"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":"","filename":"mod_syndicate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":"","filename":"mod_users_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":"","filename":"mod_whosonline"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":"","filename":"mod_wrapper"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":"","filename":"mod_articles_category"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":"","filename":"mod_articles_categories"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":"","filename":"mod_languages"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":"","filename":"mod_custom"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":"","filename":"mod_feed"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":"","filename":"mod_latest"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":"","filename":"mod_logged"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":"","filename":"mod_login"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":"","filename":"mod_menu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_popular"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":"","filename":"mod_quickicon"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":"","filename":"mod_status"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":"","filename":"mod_submenu"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":"","filename":"mod_title"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":"","filename":"mod_toolbar"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":"","filename":"mod_multilangstatus"}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":""}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":"","filename":"mod_stats_admin"}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":"","filename":"mod_tags_popular"}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":"","filename":"mod_tags_similar"}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":"","filename":"gmail"}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":"","filename":"ldap"}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":"","filename":"contact"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(404, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 0, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":"","filename":"emailcloak"}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(406, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":"","filename":"loadmodule"}', '{"style":"xhtml"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(407, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(408, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":"","filename":"pagenavigation"}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(409, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":"","filename":"vote"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(410, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"Copyright (C) 2014 by Marijn Haverbeke <marijnh@gmail.com> and others","authorEmail":"marijnh@gmail.com","authorUrl":"http:\\/\\/codemirror.net\\/","version":"5.6","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":"","filename":"codemirror"}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"September 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":"","filename":"none"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2014","author":"Moxiecode Systems AB","copyright":"Moxiecode Systems AB","authorEmail":"N\\/A","authorUrl":"tinymce.moxiecode.com","version":"4.1.7","description":"PLG_TINY_XML_DESCRIPTION","group":"","filename":"tinymce"}', '{"mode":"1","skin":"0","mobile":"0","entity_encoding":"raw","lang_mode":"1","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","html_height":"550","html_width":"750","resizing":"1","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","colors":"1","table":"1","smilies":"1","hr":"1","link":"1","media":"1","print":"1","directionality":"1","fullscreen":"1","alignment":"1","visualchars":"1","visualblocks":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(413, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":"","filename":"article"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":"","filename":"image"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":"","filename":"pagebreak"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":"","filename":"readmore"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":"","filename":"languagefilter"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(423, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":"","filename":"p3p"}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(424, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":"","filename":"cache"}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 21, 0),
(425, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":"","filename":"debug"}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 13, 0),
(426, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":"","filename":"log"}', '', '', '', 0, '0000-00-00 00:00:00', 14, 0),
(427, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION","group":"","filename":"redirect"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(428, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":"","filename":"remember"}', '', '', '', 0, '0000-00-00 00:00:00', 17, 0),
(429, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":"","filename":"sef"}', '', '', '', 0, '0000-00-00 00:00:00', 18, 0),
(430, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":"","filename":"logout"}', '', '', '', 0, '0000-00-00 00:00:00', 12, 0),
(431, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":"","filename":"contactcreator"}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '{"strong_passwords":"1","autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 1, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":"","filename":"profile"}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":"","filename":"joomla"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(436, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":"","filename":"languagecode"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(437, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":"","filename":"joomlaupdate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":"","filename":"extensionupdate"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":"","filename":"recaptcha"}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 16, 0),
(441, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 1, 1, 0, '{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(442, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":"","filename":"categories"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":"","filename":"contacts"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":"","filename":"content"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":"","filename":"newsfeeds"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_weblinks","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":"","filename":"totp"}', '{"section":"3"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":"","filename":"yubikey"}', '{"section":"3"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":"","filename":"tags"}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"hathor@tarrconsulting.com","authorUrl":"http:\\/\\/www.tarrconsulting.com","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"showSiteName":"0","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":"","filename":"templateDetails"}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.3","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (en-GB)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.4.3","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"September 2015","author":"Joomla! Project","copyright":"(C) 2005 - 2015 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 'mod_articles_single', 'module', 'mod_articles_single', '', 0, 1, 0, 0, '{"name":"mod_articles_single","type":"module","creationDate":"Unknown","author":"Unknown","copyright":"","authorEmail":"","authorUrl":"","version":"1.2.2","description":"MOD_ARTICLES_SINGLE_XML_DESCRIPTION","group":""}', '{"item_heading":"h4","item_title":"0","published_on":"0","show_intro_image":"1","readmore":"0","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 'mod_articles_news_adv', 'module', 'mod_articles_news_adv', '', 0, 1, 0, 0, '{"name":"mod_articles_news_adv","type":"module","creationDate":"April 2013","author":"Joomla! Project","copyright":"Copyright (c) 2012-2014 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.5.5","description":"MOD_ARTICLES_NEWS_ADV_XML_DESCRIPTION","group":""}', '{"catid":"","show_child_category_articles":"0","levels":"1","count":"5","columns":"1","ordering":"a.publish_up","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","item_title":"0","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","masonry":"0","cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10011, 'mod_tm_templates', 'module', 'mod_tm_templates', '', 1, 1, 2, 0, '{"name":"mod_tm_templates","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"1.0.0","description":"MOD_TM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10012, 'System - Google Maps', 'plugin', 'plugin_googlemap3', 'system', 0, 1, 1, 0, '{"name":"System - Google Maps","type":"plugin","creationDate":"July 2014","author":"Mike Reumer","copyright":"(C) 2014 Reumer","authorEmail":"tech@reumer.net","authorUrl":"tech.reumer.net","version":"3.3","description":"PLUGIN_GOOGLE_MAP3_INSTALLATION","group":"","filename":"plugin_googlemap3"}', '{"publ":"1","debug":"0","plugincode":"mosmap","brackets":"{","Google_API_version":"3.exp","visualrefresh":"1","signedin":"0","show":"1","mapprint":"none","mapclass":"","mapcss":"\\/* For img in the map remove borders, shadow, no margin and no max-width\\r\\n*\\/\\r\\n.map img, .svPanel img {\\r\\n    border: 0px;\\r\\n    box-shadow: none;\\r\\n    margin: 0px !important;\\r\\n    padding: 0px !important;\\r\\n    max-width: none !important;\\r\\n    background: none !important;\\r\\n}\\r\\n\\r\\n\\/* Make sure the directions are below the map\\r\\n*\\/\\r\\n.directions {\\r\\n    clear: left;\\r\\n}\\r\\n\\r\\n.adp-directions {\\r\\n    width: 100%;\\r\\n}\\r\\n\\r\\n\\/* Solve problems in chrome with the show of the direction steps in full width\\r\\n*\\/\\r\\n.adp-placemark {\\r\\n    width : 100%;\\r\\n}\\r\\n\\r\\n\\/* Padding for image overlay\\r\\n*\\/\\r\\n.controlDiv {\\r\\n    padding : 5px;\\r\\n}\\r\\n","loadmootools":"0","timeinterval":"500","Google_API_key":"","Google_Multi_API_key":"","urlsetting":"http_host","googlewebsite":"maps.google.com","styledmap":"[\\r\\n    {\\r\\n        \\"featureType\\": \\"all\\",\\r\\n        \\"elementType\\": \\"labels.text.fill\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"saturation\\": 36\\r\\n            },\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 40\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"all\\",\\r\\n        \\"elementType\\": \\"labels.text.stroke\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"visibility\\": \\"on\\"\\r\\n            },\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 16\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"all\\",\\r\\n        \\"elementType\\": \\"labels.icon\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"visibility\\": \\"off\\"\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"administrative\\",\\r\\n        \\"elementType\\": \\"geometry.fill\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 20\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"administrative\\",\\r\\n        \\"elementType\\": \\"geometry.stroke\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 17\\r\\n            },\\r\\n            {\\r\\n                \\"weight\\": 1.2\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"landscape\\",\\r\\n        \\"elementType\\": \\"geometry\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 20\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"poi\\",\\r\\n        \\"elementType\\": \\"geometry\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 21\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"road.highway\\",\\r\\n        \\"elementType\\": \\"geometry.fill\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 17\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"road.highway\\",\\r\\n        \\"elementType\\": \\"geometry.stroke\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 29\\r\\n            },\\r\\n            {\\r\\n                \\"weight\\": 0.2\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"road.arterial\\",\\r\\n        \\"elementType\\": \\"geometry\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 18\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"road.local\\",\\r\\n        \\"elementType\\": \\"geometry\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 16\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"transit\\",\\r\\n        \\"elementType\\": \\"geometry\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 19\\r\\n            }\\r\\n        ]\\r\\n    },\\r\\n    {\\r\\n        \\"featureType\\": \\"water\\",\\r\\n        \\"elementType\\": \\"geometry\\",\\r\\n        \\"stylers\\": [\\r\\n            {\\r\\n                \\"color\\": \\"#000000\\"\\r\\n            },\\r\\n            {\\r\\n                \\"lightness\\": 17\\r\\n            }\\r\\n        ]\\r\\n    }\\r\\n]\\r\\n\\r\\n","align":"center","langtype":"site","lang":"","width":"100%","height":"391px","effect":"none","lat":"40.749032","lon":"-73.937254","centerlat":"","centerlon":"","address":"","geoloc":"0","geocenter":"0","controltype":"UI","zoomType":"None","svcontrol":"1","returncontrol":"0","zoom":"13","corzoom":"0","minzoom":"0","maxzoom":"19","rotation":"1","zoomnew":"0","zoomWheel":"0","keyboard":"0","mapType":"Normal","showmaptype":"1","showNormalMaptype":"1","showSatelliteMaptype":"1","showHybridMaptype":"1","showTerrainMaptype":"1","showscale":"0","overview":"0","dragging":"1","marker":"1","icon":"","iconwidth":"","iconheight":"","iconanchorx":"","iconanchory":"","iconshadow":"","iconshadowwidth":"","iconshadowheight":"","iconimagemap":"","traffic":"0","transit":"0","bicycle":"0","panoramio":"0","panominzoom":"none","panomaxzoom":"none","pano_userid":"","pano_tag":"","weather":"0","weathercloud":"0","weatherinfo":"1","weathertempunit":"celsius","weatherwindunit":"km","dir":"0","dirtype":"D","formdirtype":"0","avoidhighways":"0","avoidtoll":"0","diroptimize":"0","diralternatives":"0","showdir":"1","animdir":"0","animspeed":"1","animautostart":"0","animunit":"kilometers","formspeed":"0","formaddress":"0","formdir":"0","autocompl":"both","langanim":"en;The requested panorama could not be displayed|Could not generate a route for the current start and end addresses|Street View coverage is not available for this route|You have reached your destination|miles|miles|ft|kilometers|kilometer|meters|In|You will reach your destination|Stop|Drive|Press Drive to follow your route|Route|Speed|Fast|Medium|Slow","txtdir":"Directions: ","txtgetdir":"Get Directions","txtfrom":"From here","txtto":"To here","txtdiraddr":"Address: ","txt_driving":"","txt_avhighways":"","txt_avtoll":"","txt_walking":"","txt_bicycle":"","txt_transit":"","txt_optimize":"","txt_alternatives":"","inputsize":"25","dirdefault":"0","gotoaddr":"0","gotoaddrzoom":"0","gotoaddrtimeout":"5000","txtaddr":"Address: ##","erraddr":"Address ## not found!","txtgotoaddr":"Goto","clientgeotype":"google","lightbox":"0","txtlightbox":"Open lightbox","lbxcaption":"","lbxwidth":"1600","lbxheight":"800","lbxcenterlat":"","lbxcenterlon":"","lbxzoom":"","sv":"none","svpano":"","svwidth":"100%","svheight":"300","svyaw":"0","svpitch":"0","svzoom":"","svautorotate":"0","svaddress":"1","kmlrenderer":"google","kmlsidebar":"none","kmlsbwidth":"200","kmlfoldersopen":"0","kmlhide":"0","kmlscale":"0","kmlopenmethod":"click","kmlsbsort":"none","kmllightbox":"0","kmlmessshow":"0","kmlclickablemarkers":"1","kmlzoommarkers":"0","kmlopendivmarkers":"","kmlcontentlinkmarkers":"0","kmllinkablemarkers":"0","kmllinktarget":"_self","kmllinkmethod":"dblclick","kmlhighlite":"{ ''color'': ''#aaffff'', ''opacity'': 0.3,  ''textcolor'': ''#000000'' }","kmlmarkerlabel":"100","kmlmarkerlabelclass":"","kmlpolylabel":"100","kmlpolylabelclass":"","proxy":"0","txtsrchnrby":"Search nearby","txtzoomhere":"Zoom Here","txtaddrstart":"Start address:","txtkmlgetdir":"Go","txtback":"« Back","txtsearchnearby":"Search nearby: e.g. pizza","txtsearch":"Go","maxcluster":"","clustericonurl":"\\/media\\/plugin_googlemap3\\/site\\/geoxmlv3\\/images\\/m","gridsize":"","minmarkerscluster":"","maxlinesinfocluster":"","clusterinfowindow":"click","clusterzoom":"dblclick","clustermarkerzoom":"16","txtzoomin":"Zoom in to show more","txtclustercount1":"...and","txtclustercount2":"more","tilelayer":"","tilemethod":"","tileopacity":"1","tilebounds":"","tileminzoom":"0","tilemaxzoom":"19","imageurl":"","imageposition":"RIGHT_TOP","imageindex":"1","imagewidth":"","imageheight":"","twittername":"","twittertweets":"15","twittericon":"\\/media\\/plugin_googlemap3\\/site\\/Twitter\\/twitter_map_icon.png","twitterline":"#ff0000ff","twitterlinewidth":"4","twitterstartloc":"0,0,0","twitterconsumerkey":"","twitterconsumersecret":"","twitteraccesstoken":"","twitteraccesstokensecret":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10013, 'Content - TM AddThis', 'plugin', 'tmaddthis', 'content', 0, 1, 1, 0, '{"name":"Content - TM AddThis","type":"plugin","creationDate":"April 2013","author":"TM","copyright":"Copyright (C) 2012 All rights reserved.","authorEmail":"","authorUrl":"","version":"1.0.8","description":"AddThis content plugin","group":""}', '{"addthis_id":"ra-5497f2254123130b","addthis_categories":["2","10","29","62"]}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10014, 'bundle', 'package', 'pkg_bundle', '', 0, 1, 1, 0, '{"name":"bundle","type":"package","creationDate":"Unknown","author":"Unknown","copyright":"","authorEmail":"","authorUrl":"","version":"1.6.5","description":"\\n\\t\\t\\n\\t\\t\\t<p>This package installs the following Joomla extensions:<\\/p>\\n\\t\\t\\t<ul>\\n\\t\\t\\t\\t<li>Module Articles Single<\\/li>\\n\\t\\t\\t\\t<li>Module Newsflash Advanced<\\/li>\\n\\t\\t\\t\\t<li>Module Image Swoop<\\/li>\\n\\t\\t\\t\\t<li>Module Superfish Menu<\\/li>\\n\\t\\t\\t\\t<li>Plugin Google Map<\\/li>\\n\\t\\t\\t\\t<li>Plugin AddThis<\\/li>\\n\\t\\t\\t\\t<li>Module CarouFredSel<\\/li>\\n\\t\\t\\t\\t<li>Module Recent templates (admin panel)<\\/li>\\n\\t\\t\\t<\\/ul>\\n\\t\\t\\n\\t","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 'plg_system_kunena', 'plugin', 'kunena', 'system', 0, 1, 1, 0, '{"name":"plg_system_kunena","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_SYSTEM_KUNENA_DESC","group":""}', '{"jcontentevents":"0","jcontentevent_target":"body"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10016, 'plg_quickicon_kunena', 'plugin', 'kunena', 'quickicon', 0, 1, 1, 0, '{"name":"plg_quickicon_kunena","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_QUICKICON_KUNENA_DESC","group":""}', '{"context":"mod_quickicon"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10018, 'Kunena Media Files', 'file', 'kunena_media', '', 0, 1, 0, 0, '{"name":"Kunena Media Files","type":"file","creationDate":"2014-07-28","author":"Kunena Team","copyright":"(C) 2008 - 2014 Kunena Team. All rights reserved.","authorEmail":"kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"Kunena media files.","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10019, 'com_kunena', 'component', 'com_kunena', '', 1, 1, 0, 0, '{"name":"com_kunena","type":"component","creationDate":"2014-07-28","author":"Kunena Team","copyright":"(C) 2008 - 2014 Kunena Team. All rights reserved.","authorEmail":"kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"COM_KUNENA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10020, 'kunena', 'package', 'pkg_kunena', '', 0, 1, 1, 0, '{"name":"Kunena Forum Package","type":"package","creationDate":"2014-07-28","author":"Kunena Team","copyright":"(C) 2008 - 2014 Kunena Team. All rights reserved.","authorEmail":"kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"Kunena Forum Package.","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 'plg_kunena_alphauserpoints', 'plugin', 'alphauserpoints', 'kunena', 0, 0, 1, 0, '{"name":"plg_kunena_alphauserpoints","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_ALPHAUSERPOINTS_DESCRIPTION","group":""}', '{"activity":"1","avatar":"1","profile":"1","activity_points_limit":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10022, 'plg_kunena_community', 'plugin', 'community', 'kunena', 0, 0, 1, 0, '{"name":"plg_kunena_community","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_COMMUNITY_DESCRIPTION","group":""}', '{"access":"1","login":"1","activity":"1","avatar":"1","profile":"1","private":"1","activity_points_limit":"0","activity_stream_limit":"0"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10023, 'plg_kunena_comprofiler', 'plugin', 'comprofiler', 'kunena', 0, 0, 1, 0, '{"name":"plg_kunena_comprofiler","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_COMPROFILER_DESCRIPTION","group":""}', '{"access":"1","login":"1","activity":"1","avatar":"1","profile":"1","private":"1"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10024, 'plg_kunena_gravatar', 'plugin', 'gravatar', 'kunena', 0, 0, 1, 0, '{"name":"plg_kunena_gravatar","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_GRAVATAR_DESCRIPTION","group":""}', '{"avatar":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10025, 'plg_kunena_uddeim', 'plugin', 'uddeim', 'kunena', 0, 0, 1, 0, '{"name":"plg_kunena_uddeim","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_UDDEIM_DESCRIPTION","group":""}', '{"private":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10026, 'plg_kunena_kunena', 'plugin', 'kunena', 'kunena', 0, 1, 1, 0, '{"name":"plg_kunena_kunena","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_KUNENA_DESCRIPTION","group":""}', '{"avatar":"1","profile":"1"}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10027, 'plg_kunena_joomla', 'plugin', 'joomla', 'kunena', 0, 1, 1, 0, '{"name":"plg_kunena_joomla","type":"plugin","creationDate":"2014-07-28","author":"Kunena Team","copyright":"www.kunena.org","authorEmail":"Kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"PLG_KUNENA_JOOMLA_25_30_DESCRIPTION","group":""}', '{"access":"1","login":"1"}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10028, 'theme3288', 'template', 'theme3288', '', 0, 1, 1, 0, '{"name":"theme3288","type":"template","creationDate":"April 2014","author":"Unknown","copyright":"Copyright  2003-2012 template-help.com. All Rights Reserved.","authorEmail":"info@template-help.com","authorUrl":"","version":"3.0","description":"\\n        \\n            <p>Template for Joomla! 3.x Content Management System provided by <!-- {%TEMPLATE_VENDOR} --><br\\/>\\n            Copyright  2003-2012 template-help.com. All Rights Reserved.<br\\/>\\n            Joomla! CMS files are covered by http:\\/\\/www.gnu.org\\/copyleft\\/gpl.html GNU\\/GPL; <!-- {%LICENCE_LINK} --><\\/p>\\n            <p>Please check detailed tutorials on how to work with our templates at <a href=\\"http:\\/\\/info.template-help.com\\/help\\/cms-blog-templates\\/joomla\\/joomla-tutorials\\/\\">info.template-help.com<\\/a>.<\\/p>\\n        \\n    ","group":""}', '{"themeLayout":"0","logoFile":"","footerLogo":"0","footerLogoFile":"","footerCopy":"1","footerYear":"1","privacyLink":"1","privacy_link_title":"","termsLink":"0","terms_link_title":"","featuredPageHeading":"h1","featuredItemHeading":"h3","categoryPageHeading":"h1","categoryItemHeading":"h3","blogPageHeading":"h1","blogItemHeading":"h3","itemItemHeading":"h3","itemBlogItemHeading":"h3","totop":"1","totop_text":"Back to top","todesktop":"1","todesktop_text":"Back to desktop version","tomobile_text":"Back to mobile version","blackandwhite":"1","invertHoverEffect":"1","fadeIn":"500","fadeOut":"500"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10031, 'Kunena Framework', 'library', 'kunena', '', 0, 1, 1, 0, '{"name":"Kunena Framework","type":"library","creationDate":"2014-07-28","author":"Kunena Team","copyright":"(C) 2008 - 2014 Kunena Team. All rights reserved.","authorEmail":"kunena@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"3.0.6","description":"Kunena Framework.","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10032, 'JoomGallery', 'component', 'com_joomgallery', '', 1, 1, 0, 0, '{"name":"JoomGallery","type":"component","creationDate":"2015\\/07\\/26","author":"JoomGallery::ProjectTeam","copyright":"This component is released under the GNU\\/GPL License","authorEmail":"team@joomgallery.net","authorUrl":"http:\\/\\/www.joomgallery.net","version":"3.2.2","description":"JoomGallery 3 is a native Joomla! 3.x gallery component","group":"","filename":"joomgallery"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 'PLG_JOOMGALLERY_JOOMFANCYBOX', 'plugin', 'joomfancybox', 'joomgallery', 0, 1, 1, 0, '{"name":"PLG_JOOMGALLERY_JOOMFANCYBOX","type":"plugin","creationDate":"20.01.2013","author":"fabrice jossa","copyright":"Copyright (C) 2013 - 2013 Open Source Matters. All rights reserved.","authorEmail":"team@joomgallery.net","authorUrl":"http:\\/\\/www.en.joomgallery.net","version":"1.1","description":"PLG_JOOMGALLERY_JOOMFANCYBOX_XML_DESCRIPTION","group":""}', '{"global_box_existent":"1","mousewheel":"0","buttons":"0","thumbs":"0","init_script":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10034, 'Social Login', 'module', 'mod_socialloginandsocialshare', '', 0, 1, 0, 0, '{"name":"Social Login","type":"module","creationDate":"2012-01-01","author":"LoginRadius","copyright":"Copyright (C) 2012 - till Open Source Matters. All rights reserved.","authorEmail":"developers@loginradius.com","authorUrl":"www.LoginRadius.com","version":"4.0","description":"LoginRadius enables social login and social share for your joomla websites.","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10035, 'System - Social Login And Social Share', 'plugin', 'socialloginandsocialshare', 'system', 0, 1, 1, 0, '{"name":"System - Social Login And Social Share","type":"plugin","creationDate":"2012-01-01","author":"LoginRadius","copyright":"2012 to till","authorEmail":"developers@loginradius.com","authorUrl":"http:\\/\\/www.loginradius.com","version":"4.0","description":"\\n\\tLoginRadius enables social login for your joomla websites.\\n","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10036, 'Content - Social Share', 'plugin', 'socialshare', 'content', 0, 0, 1, 0, '{"name":"Content - Social Share","type":"plugin","creationDate":"2012-01-01","author":"LoginRadius","copyright":"2012 to till","authorEmail":"developers@loginradius.com","authorUrl":"http:\\/\\/www.loginradius.com","version":"4.0","description":"LoginRadius enables social share for your joomla websites.","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10037, 'socialloginandsocialshare', 'component', 'com_socialloginandsocialshare', '', 1, 1, 0, 0, '{"name":"Social Login And Social Share","type":"component","creationDate":"2012-01-01","author":"LoginRadius","copyright":"2013, LoginRadius","authorEmail":"developers@loginradius.com","authorUrl":"http:\\/\\/www.loginradius.com","version":"4.0","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 'system - EUCookieDirectiveLite', 'plugin', 'EUCookieDirectiveLite', 'system', 0, 0, 1, 0, '{"name":"system - EUCookieDirectiveLite","type":"plugin","creationDate":"2013-11-19","author":"Channel Digital.","copyright":"All rights reserved by channeldigital.co.uk 2013.","authorEmail":"info@channeldigital.co.uk","authorUrl":"www.channeldigital.co.uk","version":"1.1.1","description":"Displays a cookie acceptance banner at the top of the site to warn about the site using cookies.","group":""}', '{"width":"0","warningMessage":"We use cookies to improve our website and your experience when using it. Cookies used for the essential operation of this site have already been set.","detailsUrl":"index.php"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10044, 'TM Ajax Contact Form', 'module', 'mod_tm_ajax_contact_form', '', 0, 1, 0, 0, '{"name":"TM Ajax Contact Form","type":"module","creationDate":"August ,2014","author":"TemplateMonster","copyright":"Copyright (c) 2012-2014 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.0","description":"MOD_TM_AJAX_CONTACT_FORM_XML_DESCRIPTION","group":""}', '{"email_req":"required","phone_req":"required","admin_email":"","cc_email":"","bcc_email":"","success_notify":"Thank You! Your message has been sent.","failure_notify":"Something went wrong, please try again later.","recaptcha_failure_notify":"Please enter a correct Captcha answer.","msg_minlength":"0","errors_position":"right-top","captcha_req":"0","public_key":"","private_key":"","captcha_theme":"red","email_publish":"1","phone_publish":"1","subject_publish":"1","subject_type":"1","reset_publish":"1","name_name":"Name","email_name":"Email","phone_name":"Phone","subject_name":"Subject","message_name":"Message","br_name":"Clear","bs_name":"Send","labels_pos":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10063, 'IceMegaMenu Module', 'module', 'mod_icemegamenu', '', 0, 1, 0, 0, '{"name":"IceMegaMenu Module","type":"module","creationDate":"March 2011","author":"IceTheme","copyright":"GNU \\/ GPL","authorEmail":"info@icetheme.com","authorUrl":"http:\\/\\/www.icetheme.com","version":"3.0.1","description":"IceMegaMenu extension is a powerful Joomla (module + plugin) to help you take the most from the navigation system. Top features includes ability to split dropdown columns, option to load modules inside the dropdown, works without JavaScript and much more.","group":""}', '{"theme_style":"","vertical_direction":"1","startLevel":"1","endLevel":"0","showAllChildren":"1","resizable_menu":"1","":"","class_sfx":"","window_open":"","tag_id":"","moduleclass_sfx":"","cache":"1","cache_time":"30","enable_bootrap":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10064, 'IceMegaMenu Plugin', 'plugin', 'icemegamenu', 'system', 0, 1, 1, 0, '{"name":"IceMegaMenu Plugin","type":"plugin","creationDate":"Mrch 2011","author":"www.icetheme.com","copyright":"Copyright (C) Copyright  2008 - 2011 IceTheme.com. All rights reserved.","authorEmail":"info@icethemes.com","authorUrl":"http:\\/\\/www.icethemes.com","version":"3.0.0","description":"IceMegaMenu plugin used in conjuction with the IceMegaMenu Module. You may change the paramters to each menu item throught the Menu Manager","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10065, 'Bootstrap Collapse', 'module', 'mod_bootstrap_collapse', '', 0, 1, 0, 0, '{"name":"Bootstrap Collapse","type":"module","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (c) 2012-20013 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.0","description":"MOD_BOOTSTRAP_COLLAPSE_XML_DESCRIPTION","group":""}', '{"catid":"","count":"5","ordering":"a.publish_up","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10066, 'Bootstrap Tabs', 'module', 'mod_bootstraptabs', '', 0, 1, 0, 0, '{"name":"Bootstrap Tabs","type":"module","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (c) 2012-20013 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.2","description":"MOD_BOOTSTRAPTABS_XML_DESCRIPTION","group":""}', '{"catid":"","count":"5","ordering":"a.publish_up","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","cache":"1","cache_time":"900","cachemode":"itemid"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10073, 'mod_tm_style_switcher', 'module', 'mod_tm_style_switcher', '', 0, 1, 0, 0, '{"name":"mod_tm_style_switcher","type":"module","creationDate":"February, 2013","author":"TemplateMonster","copyright":"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.0","description":"MOD_TM_STYLE_SWITCHER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10080, 'mod_tm_olark_chat', 'module', 'mod_tm_olark_chat', '', 0, 1, 1, 0, '{"name":"mod_tm_olark_chat","type":"module","creationDate":"January 2015","author":"TemplateMonster","copyright":"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.0","description":"MOD_TM_OLARK_CHAT_XML_DESCRIPTION","group":"","filename":"mod_tm_olark_chat"}', '{"cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10098, 'mod_counters', 'module', 'mod_counters', '', 0, 1, 0, 0, '{"name":"mod_counters","type":"module","creationDate":"April 2015","author":"TemplateMonster","copyright":"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.0","description":"MOD_COUNTERS_XML_DESCRIPTION","group":"","filename":"mod_counters"}', '{"date":"","max_dim":"3","min_dim":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10099, 'mod_tm_bg_youtube', 'module', 'mod_tm_bg_youtube', '', 0, 1, 1, 0, '{"name":"mod_tm_bg_youtube","type":"module","creationDate":"May 2015","author":"TemplateMonster","copyright":"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.2","description":"MOD_TM_BG_YOUTUBE_XML_DESCRIPTION","group":"","filename":"mod_tm_bg_youtube"}', '{"cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10103, 'plg_system_tmwrapper', 'plugin', 'tmwrapper', 'system', 0, 1, 1, 0, '{"name":"TM Wrapper","type":"plugin","creationDate":"2015-05-29","author":"Template Monster","copyright":"Copyright 2014 Template Monster. All rights reserved.","authorEmail":"","authorUrl":"","version":"1.0.0","description":"PLG_TMWRAPPER_XML_DESCRIPTION","group":"","filename":"tmwrapper"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10105, 'TM Parallax', 'module', 'mod_tm_parallax', '', 0, 1, 0, 0, '{"name":"TM Parallax","type":"module","creationDate":"Jule 2015","author":"TemplateMonster","copyright":"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.1.0","description":"Module allows you to create background image with parallax scrolling effect","group":"","filename":"mod_tm_parallax"}', '{"prepare_content":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10106, 'plg_system_smoothscroll', 'plugin', 'smoothscroll', 'system', 0, 0, 1, 0, '{"name":"plg_system_smoothscroll","type":"plugin","creationDate":"2015-09-22","author":"Template Monster","copyright":"Copyright 2015 Template Monster. All rights reserved.","authorEmail":"","authorUrl":"","version":"1.0.0","description":"PLG_SMOOTHSCROLL_XML_DESCRIPTION","group":"","filename":"smoothscroll"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10120, 'mod_swiper', 'module', 'mod_swiper', '', 0, 1, 0, 0, '{"name":"mod_swiper","type":"module","creationDate":"September 2012","author":"Template Monster","copyright":"Copyright (c) 2012-2015 by TemplateMonster - www.templatemonster.com ","authorEmail":"","authorUrl":"www.templatemonster.com","version":"1.0.0","description":"MOD_SWIPER_XML_DESCRIPTION","group":"","filename":"mod_swiper"}', '{"catid":"","image":"0","item_title":"0","item_heading":"h4","published":"0","readmore":"0","count":"5","ordering":"a.publish_up","target":"self","cache":"1","cache_time":"900","cachemode":"itemid","autoplay":"0","autoplay_speed":"7000","height":"50%","minHeight":"200px","slide_animation":"slide","slide_content_animation":"fadeIn","slide_content_animation_delay":"200","navigation":"1","pagination":"0","pagination_clickable":"1","pagination_bullet":"0","show_caption":"1","show_thumbs":"1","thumb_items":"4","thumb_space":"20","thumb_items_768":"3","thumb_space_768":"10","thumb_items_480":"2","thumb_space_480":"10"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10126, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 0, 1, 0, '{"name":"plg_editors-xtd_module","type":"plugin","creationDate":"October 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2016 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_MODULE_XML_DESCRIPTION","group":"","filename":"module"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10127, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 0, 1, 0, '{"name":"plg_system_stats","type":"plugin","creationDate":"November 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2016 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_STATS_XML_DESCRIPTION","group":"","filename":"stats"}', '{"interval":"12","mode":"1","lastrun":"0","debug":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10128, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 0, 1, 0, '{"name":"plg_system_updatenotification","type":"plugin","creationDate":"May 2015","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2016 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.5.0","description":"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION","group":"","filename":"updatenotification"}', '{"email":"","language_override":"","lastrun":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10129, 'com_komento', 'component', 'com_komento', '', 1, 1, 0, 0, '{"name":"com_komento","type":"component","creationDate":"Jan 2012","author":"Stack Ideas","copyright":"Copyright 2012 Stack Ideas. All rights reserved","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"2.0.6","description":"\\n\\t\\tKomento is a Joomla! comment component.\\n\\t","group":"","filename":"komento"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10130, 'Content - Komento', 'plugin', 'komento', 'content', 0, 1, 1, 0, '{"name":"Content - Komento","type":"plugin","creationDate":"01\\/01\\/2012","author":"StackIdeas","copyright":"Copyright (C) 2012 StackIdeas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"1.0","description":"This plugin adds a discussion\\/comment interface at the bottom of the article","group":"","filename":"komento"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10131, 'System - Komento', 'plugin', 'komento', 'system', 0, 1, 1, 0, '{"name":"System - Komento","type":"plugin","creationDate":"07\\/01\\/2012","author":"StackIdeas","copyright":"Copyright (C) 2012 StackIdeas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"1.0","description":"This plugin adds a discussion\\/comment interface at the bottom of the article","group":"","filename":"komento"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10132, 'User - Komento Users', 'plugin', 'komentousers', 'user', 0, 1, 1, 0, '{"name":"User - Komento Users","type":"plugin","creationDate":"February 2012","author":"StackIdeas","copyright":"Copyright 2012 StackIdeas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"1.0.0","description":"Komento user plugin. This plugin is responsible to delete user''s related records.","group":"","filename":"komentousers"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10133, 'Komento Activities', 'module', 'mod_komento_activities', '', 0, 1, 0, 0, '{"name":"Komento Activities","type":"module","creationDate":"May 2012","author":"StackIdeas","copyright":"Copyright 2009 - 2012 Stack Ideas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"1.0.4","description":"Display activities from Komento","group":"","filename":"mod_komento_activities"}', '{"limit":"5","component":"all","includelikes":"1","includecomments":"1","includereplies":"1","showcomment":"1","maxcommentlength":"100","maxtitlelength":"30","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10134, 'Komento Comments', 'module', 'mod_komento_comments', '', 0, 1, 0, 0, '{"name":"Komento Comments","type":"module","creationDate":"May 2012","author":"StackIdeas","copyright":"Copyright 2009 - 2012 Stack Ideas. All rights reserved.","authorEmail":"support@stackideas.com","authorUrl":"http:\\/\\/www.stackideas.com","version":"1.0.7","description":"Display comments from Komento","group":"","filename":"mod_komento_comments"}', '{"limit":"5","component":"all","filter":"all","category":"","articleId":"","userId":"","sort":"latest","random":"0","filtersticked":"0","showtitle":"1","showcomponent":"1","showavatar":"1","showauthor":"1","maxcommentlength":"100","maxtitlelength":"30","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__joomgallery`;
CREATE TABLE IF NOT EXISTS `#__joomgallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `imgtitle` text NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `imgauthor` varchar(50) DEFAULT NULL,
  `imgtext` text NOT NULL,
  `imgdate` datetime NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `downloads` int(11) NOT NULL DEFAULT '0',
  `imgvotes` int(11) NOT NULL DEFAULT '0',
  `imgvotesum` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `imgfilename` varchar(255) NOT NULL,
  `imgthumbname` varchar(255) NOT NULL,
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `owner` int(11) unsigned NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `useruploaded` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_catid` (`catid`),
  KEY `idx_owner` (`owner`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=116 ;

INSERT INTO `#__joomgallery` (`id`, `asset_id`, `catid`, `imgtitle`, `alias`, `imgauthor`, `imgtext`, `imgdate`, `hits`, `downloads`, `imgvotes`, `imgvotesum`, `access`, `published`, `hidden`, `imgfilename`, `imgthumbname`, `checked_out`, `owner`, `approved`, `useruploaded`, `ordering`, `params`, `metakey`, `metadesc`) VALUES
(80, 587, 3, 'gallery-image1', 'gallery-image1-80', '', '', '2016-06-11 11:45:18', 1, 0, 0, 0, 1, 1, 0, 'gallery-image1_20160611_1781351620.jpg', 'gallery-image1_20160611_1781351620.jpg', 0, 0, 1, 0, 1, '', '', ''),
(81, 588, 3, 'gallery-image2', 'gallery-image2-81', '', '', '2016-06-11 11:45:19', 0, 0, 0, 0, 1, 1, 0, 'gallery-image2_20160611_1205431211.jpg', 'gallery-image2_20160611_1205431211.jpg', 0, 0, 1, 0, 2, '', '', ''),
(82, 589, 3, 'gallery-image3', 'gallery-image3-82', '', '', '2016-06-11 11:45:20', 0, 0, 0, 0, 1, 1, 0, 'gallery-image3_20160611_1203559254.jpg', 'gallery-image3_20160611_1203559254.jpg', 0, 0, 1, 0, 3, '', '', ''),
(83, 590, 3, 'gallery-image4', 'gallery-image4-83', '', '', '2016-06-11 11:45:20', 0, 0, 0, 0, 1, 1, 0, 'gallery-image4_20160611_1633224113.jpg', 'gallery-image4_20160611_1633224113.jpg', 0, 0, 1, 0, 4, '', '', ''),
(84, 591, 3, 'gallery-image5', 'gallery-image5-84', '', '', '2016-06-11 11:45:21', 0, 0, 0, 0, 1, 1, 0, 'gallery-image5_20160611_2064681228.jpg', 'gallery-image5_20160611_2064681228.jpg', 0, 0, 1, 0, 5, '', '', ''),
(85, 592, 3, 'gallery-image6', 'gallery-image6-85', '', '', '2016-06-11 11:45:21', 0, 0, 0, 0, 1, 1, 0, 'gallery-image6_20160611_1937936406.jpg', 'gallery-image6_20160611_1937936406.jpg', 0, 0, 1, 0, 6, '', '', ''),
(86, 593, 4, 'gallery-image7', 'gallery-image7-86', '', '', '2016-06-11 11:45:32', 0, 0, 0, 0, 1, 1, 0, 'gallery-image7_20160611_1125289287.jpg', 'gallery-image7_20160611_1125289287.jpg', 0, 0, 1, 0, 1, '', '', ''),
(87, 594, 4, 'gallery-image8', 'gallery-image8-87', '', '', '2016-06-11 11:45:32', 0, 0, 0, 0, 1, 1, 0, 'gallery-image8_20160611_1527532470.jpg', 'gallery-image8_20160611_1527532470.jpg', 0, 0, 1, 0, 2, '', '', ''),
(88, 595, 4, 'gallery-image9', 'gallery-image9-88', '', '', '2016-06-11 11:45:33', 0, 0, 0, 0, 1, 1, 0, 'gallery-image9_20160611_1269573629.jpg', 'gallery-image9_20160611_1269573629.jpg', 0, 0, 1, 0, 3, '', '', ''),
(89, 596, 4, 'gallery-image10', 'gallery-image10-89', '', '', '2016-06-11 11:45:34', 0, 0, 0, 0, 1, 1, 0, 'gallery-image10_20160611_1844006563.jpg', 'gallery-image10_20160611_1844006563.jpg', 0, 0, 1, 0, 4, '', '', ''),
(90, 597, 4, 'gallery-image11', 'gallery-image11-90', '', '', '2016-06-11 11:45:34', 0, 0, 0, 0, 1, 1, 0, 'gallery-image11_20160611_1172091065.jpg', 'gallery-image11_20160611_1172091065.jpg', 0, 0, 1, 0, 5, '', '', ''),
(91, 598, 4, 'gallery-image12', 'gallery-image12-91', '', '', '2016-06-11 11:45:35', 0, 0, 0, 0, 1, 1, 0, 'gallery-image12_20160611_1272088446.jpg', 'gallery-image12_20160611_1272088446.jpg', 0, 0, 1, 0, 6, '', '', ''),
(92, 599, 5, 'gallery-image13', 'gallery-image13-92', '', '', '2016-06-11 11:45:43', 0, 0, 0, 0, 1, 1, 0, 'gallery-image13_20160611_1452322275.jpg', 'gallery-image13_20160611_1452322275.jpg', 0, 0, 1, 0, 1, '', '', ''),
(93, 600, 5, 'gallery-image14', 'gallery-image14-93', '', '', '2016-06-11 11:45:43', 0, 0, 0, 0, 1, 1, 0, 'gallery-image14_20160611_1260932419.jpg', 'gallery-image14_20160611_1260932419.jpg', 0, 0, 1, 0, 2, '', '', ''),
(94, 601, 5, 'gallery-image15', 'gallery-image15-94', '', '', '2016-06-11 11:45:44', 0, 0, 0, 0, 1, 1, 0, 'gallery-image15_20160611_2085345825.jpg', 'gallery-image15_20160611_2085345825.jpg', 0, 0, 1, 0, 3, '', '', ''),
(95, 602, 5, 'gallery-image16', 'gallery-image16-95', '', '', '2016-06-11 11:45:45', 0, 0, 0, 0, 1, 1, 0, 'gallery-image16_20160611_1143840507.jpg', 'gallery-image16_20160611_1143840507.jpg', 0, 0, 1, 0, 4, '', '', ''),
(96, 603, 5, 'gallery-image17', 'gallery-image17-96', '', '', '2016-06-11 11:45:45', 0, 0, 0, 0, 1, 1, 0, 'gallery-image17_20160611_1720244143.jpg', 'gallery-image17_20160611_1720244143.jpg', 0, 0, 1, 0, 5, '', '', ''),
(97, 604, 5, 'gallery-image18', 'gallery-image18-97', '', '', '2016-06-11 11:45:46', 0, 0, 0, 0, 1, 1, 0, 'gallery-image18_20160611_1396378326.jpg', 'gallery-image18_20160611_1396378326.jpg', 0, 0, 1, 0, 6, '', '', ''),
(98, 605, 6, 'gallery-image19', 'gallery-image19-98', '', '', '2016-06-11 11:45:52', 0, 0, 0, 0, 1, 1, 0, 'gallery-image19_20160611_1055833106.jpg', 'gallery-image19_20160611_1055833106.jpg', 0, 0, 1, 0, 1, '', '', ''),
(99, 606, 6, 'gallery-image20', 'gallery-image20-99', '', '', '2016-06-11 11:45:52', 0, 0, 0, 0, 1, 1, 0, 'gallery-image20_20160611_1453773572.jpg', 'gallery-image20_20160611_1453773572.jpg', 0, 0, 1, 0, 2, '', '', ''),
(100, 607, 6, 'gallery-image21', 'gallery-image21-100', '', '', '2016-06-11 11:45:53', 0, 0, 0, 0, 1, 1, 0, 'gallery-image21_20160611_1547663728.jpg', 'gallery-image21_20160611_1547663728.jpg', 0, 0, 1, 0, 3, '', '', ''),
(101, 608, 6, 'gallery-image22', 'gallery-image22-101', '', '', '2016-06-11 11:45:54', 0, 0, 0, 0, 1, 1, 0, 'gallery-image22_20160611_1752235873.jpg', 'gallery-image22_20160611_1752235873.jpg', 0, 0, 1, 0, 4, '', '', ''),
(102, 609, 6, 'gallery-image23', 'gallery-image23-102', '', '', '2016-06-11 11:45:55', 0, 0, 0, 0, 1, 1, 0, 'gallery-image23_20160611_1529202426.jpg', 'gallery-image23_20160611_1529202426.jpg', 0, 0, 1, 0, 5, '', '', ''),
(103, 610, 6, 'gallery-image24', 'gallery-image24-103', '', '', '2016-06-11 11:45:55', 0, 0, 0, 0, 1, 1, 0, 'gallery-image24_20160611_1339525684.jpg', 'gallery-image24_20160611_1339525684.jpg', 0, 0, 1, 0, 6, '', '', ''),
(104, 611, 7, 'gallery-image25', 'gallery-image25-104', '', '', '2016-06-11 11:46:01', 0, 0, 0, 0, 1, 1, 0, 'gallery-image25_20160611_1073562756.jpg', 'gallery-image25_20160611_1073562756.jpg', 0, 0, 1, 0, 1, '', '', ''),
(105, 612, 7, 'gallery-image26', 'gallery-image26-105', '', '', '2016-06-11 11:46:01', 0, 0, 0, 0, 1, 1, 0, 'gallery-image26_20160611_1671556246.jpg', 'gallery-image26_20160611_1671556246.jpg', 0, 0, 1, 0, 2, '', '', ''),
(106, 613, 7, 'gallery-image27', 'gallery-image27-106', '', '', '2016-06-11 11:46:02', 0, 0, 0, 0, 1, 1, 0, 'gallery-image27_20160611_1049217423.jpg', 'gallery-image27_20160611_1049217423.jpg', 0, 0, 1, 0, 3, '', '', ''),
(107, 614, 7, 'gallery-image28', 'gallery-image28-107', '', '', '2016-06-11 11:46:03', 0, 0, 0, 0, 1, 1, 0, 'gallery-image28_20160611_1961052919.jpg', 'gallery-image28_20160611_1961052919.jpg', 0, 0, 1, 0, 4, '', '', ''),
(108, 615, 7, 'gallery-image29', 'gallery-image29-108', '', '', '2016-06-11 11:46:03', 0, 0, 0, 0, 1, 1, 0, 'gallery-image29_20160611_1506379877.jpg', 'gallery-image29_20160611_1506379877.jpg', 0, 0, 1, 0, 5, '', '', ''),
(109, 616, 7, 'gallery-image30', 'gallery-image30-109', '', '', '2016-06-11 11:46:04', 0, 0, 0, 0, 1, 1, 0, 'gallery-image30_20160611_1205611664.jpg', 'gallery-image30_20160611_1205611664.jpg', 0, 0, 1, 0, 6, '', '', ''),
(110, 617, 8, 'gallery-image31', 'gallery-image31-110', '', '', '2016-06-11 11:46:09', 0, 0, 0, 0, 1, 1, 0, 'gallery-image31_20160611_1962171014.jpg', 'gallery-image31_20160611_1962171014.jpg', 0, 0, 1, 0, 1, '', '', ''),
(111, 618, 8, 'gallery-image32', 'gallery-image32-111', '', '', '2016-06-11 11:46:09', 0, 0, 0, 0, 1, 1, 0, 'gallery-image32_20160611_1775373631.jpg', 'gallery-image32_20160611_1775373631.jpg', 0, 0, 1, 0, 2, '', '', ''),
(112, 619, 8, 'gallery-image33', 'gallery-image33-112', '', '', '2016-06-11 11:46:10', 0, 0, 0, 0, 1, 1, 0, 'gallery-image33_20160611_1282984163.jpg', 'gallery-image33_20160611_1282984163.jpg', 0, 0, 1, 0, 3, '', '', ''),
(113, 620, 8, 'gallery-image34', 'gallery-image34-113', '', '', '2016-06-11 11:46:11', 0, 0, 0, 0, 1, 1, 0, 'gallery-image34_20160611_1209230734.jpg', 'gallery-image34_20160611_1209230734.jpg', 0, 0, 1, 0, 4, '', '', ''),
(114, 621, 8, 'gallery-image35', 'gallery-image35-114', '', '', '2016-06-11 11:46:11', 0, 0, 0, 0, 1, 1, 0, 'gallery-image35_20160611_1289053168.jpg', 'gallery-image35_20160611_1289053168.jpg', 0, 0, 1, 0, 5, '', '', ''),
(115, 622, 8, 'gallery-image36', 'gallery-image36-115', '', '', '2016-06-11 11:46:12', 0, 0, 0, 0, 1, 1, 0, 'gallery-image36_20160611_1385260302.jpg', 'gallery-image36_20160611_1385260302.jpg', 0, 0, 1, 0, 6, '', '', '');

DROP TABLE IF EXISTS `#__joomgallery_category_details`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_category_details` (
  `id` int(11) NOT NULL,
  `details_key` varchar(255) NOT NULL,
  `details_value` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`,`details_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_catg`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_catg` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(2048) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(1) unsigned NOT NULL DEFAULT '0',
  `description` text,
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `in_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(100) NOT NULL DEFAULT '',
  `owner` int(11) DEFAULT '0',
  `thumbnail` int(11) DEFAULT NULL,
  `img_position` int(10) DEFAULT '0',
  `catpath` varchar(2048) NOT NULL,
  `params` text NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `exclude_toplists` int(1) NOT NULL,
  `exclude_search` int(1) NOT NULL,
  PRIMARY KEY (`cid`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT INTO `#__joomgallery_catg` (`cid`, `asset_id`, `name`, `alias`, `parent_id`, `lft`, `rgt`, `level`, `description`, `access`, `published`, `hidden`, `in_hidden`, `password`, `owner`, `thumbnail`, `img_position`, `catpath`, `params`, `metakey`, `metadesc`, `exclude_toplists`, `exclude_search`) VALUES
(1, 0, 'ROOT', 'root', 0, 0, 15, 0, NULL, 1, 1, 0, 0, '', 0, NULL, 0, '', '', '', '', 0, 0),
(2, 170, 'Gallery', 'gallery', 1, 1, 14, 1, '', 1, 1, 0, 0, '', 846, 0, -1, 'gallery_2', '', '', '', 0, 0),
(3, 171, 'Gallery 1', 'gallery/gallery-1', 2, 2, 3, 2, '', 1, 1, 0, 0, '', 846, 0, -1, 'gallery_2/gallery_1_3', '', '', '', 0, 0),
(4, 182, 'Gallery 2', 'gallery/gallery-2', 2, 4, 5, 2, '', 1, 1, 0, 0, '', 846, 0, -1, 'gallery_2/gallery_2_4', '', '', '', 0, 0),
(5, 183, 'Gallery 3', 'gallery/gallery-3', 2, 6, 7, 2, '', 1, 1, 0, 0, '', 846, 0, -1, 'gallery_2/gallery_3_5', '', '', '', 0, 0),
(6, 213, 'Gallery 4', 'gallery/gallery-4', 2, 8, 9, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_4_6', '', '', '', 0, 0),
(7, 214, 'Gallery 5', 'gallery/gallery-5', 2, 10, 11, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_5_7', '', '', '', 0, 0),
(8, 215, 'Gallery 6', 'gallery/gallery-6', 2, 12, 13, 2, '', 1, 1, 0, 0, '', 0, 0, -1, 'gallery_2/gallery_6_8', '', '', '', 0, 0);

DROP TABLE IF EXISTS `#__joomgallery_comments`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_comments` (
  `cmtid` int(11) NOT NULL AUTO_INCREMENT,
  `cmtpic` int(11) NOT NULL DEFAULT '0',
  `cmtip` varchar(15) NOT NULL DEFAULT '',
  `userid` int(11) unsigned NOT NULL DEFAULT '0',
  `cmtname` varchar(50) NOT NULL DEFAULT '',
  `cmttext` text NOT NULL,
  `cmtdate` datetime NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cmtid`),
  KEY `idx_cmtpic` (`cmtpic`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__joomgallery_config`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_config` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `ordering` int(11) NOT NULL,
  `jg_pathimages` varchar(100) NOT NULL,
  `jg_pathoriginalimages` varchar(100) NOT NULL,
  `jg_paththumbs` varchar(100) NOT NULL,
  `jg_pathftpupload` varchar(100) NOT NULL,
  `jg_pathtemp` varchar(100) NOT NULL,
  `jg_wmpath` varchar(100) NOT NULL,
  `jg_wmfile` varchar(50) NOT NULL,
  `jg_use_real_paths` int(1) NOT NULL,
  `jg_checkupdate` int(1) NOT NULL,
  `jg_filenamewithjs` int(1) NOT NULL,
  `jg_filenamereplace` text NOT NULL,
  `jg_thumbcreation` varchar(5) NOT NULL,
  `jg_fastgd2thumbcreation` int(1) NOT NULL,
  `jg_impath` varchar(50) NOT NULL,
  `jg_resizetomaxwidth` int(1) NOT NULL,
  `jg_maxwidth` int(5) NOT NULL,
  `jg_picturequality` int(3) NOT NULL,
  `jg_useforresizedirection` int(1) NOT NULL,
  `jg_cropposition` int(1) NOT NULL,
  `jg_thumbwidth` int(5) NOT NULL,
  `jg_thumbheight` int(5) NOT NULL,
  `jg_thumbquality` int(3) NOT NULL,
  `jg_uploadorder` int(1) NOT NULL,
  `jg_useorigfilename` int(1) NOT NULL,
  `jg_filenamenumber` int(1) NOT NULL,
  `jg_delete_original` int(1) NOT NULL,
  `jg_msg_upload_type` int(1) NOT NULL,
  `jg_msg_upload_recipients` text NOT NULL,
  `jg_msg_download_type` int(1) NOT NULL,
  `jg_msg_download_recipients` text NOT NULL,
  `jg_msg_zipdownload` int(1) NOT NULL,
  `jg_msg_comment_type` int(1) NOT NULL,
  `jg_msg_comment_recipients` text NOT NULL,
  `jg_msg_comment_toowner` int(1) NOT NULL,
  `jg_msg_nametag_type` int(1) NOT NULL,
  `jg_msg_nametag_recipients` text NOT NULL,
  `jg_msg_nametag_totaggeduser` int(1) NOT NULL,
  `jg_msg_nametag_toowner` int(1) NOT NULL,
  `jg_msg_report_type` int(1) NOT NULL,
  `jg_msg_report_recipients` text NOT NULL,
  `jg_msg_report_toowner` int(1) NOT NULL,
  `jg_msg_rejectimg_type` int(1) NOT NULL,
  `jg_msg_global_from` int(1) NOT NULL,
  `jg_realname` int(1) NOT NULL,
  `jg_cooliris` int(1) NOT NULL,
  `jg_coolirislink` int(1) NOT NULL,
  `jg_contentpluginsenabled` int(1) NOT NULL,
  `jg_itemid` varchar(10) NOT NULL,
  `jg_ajaxcategoryselection` int(1) NOT NULL,
  `jg_disableunrequiredchecks` int(1) NOT NULL,
  `jg_userspace` int(1) NOT NULL,
  `jg_useruploaddefaultcat` int(1) NOT NULL,
  `jg_approve` int(1) NOT NULL,
  `jg_unregistered_permissions` int(1) NOT NULL,
  `jg_maxusercat` int(5) NOT NULL,
  `jg_maxuserimage` int(9) NOT NULL,
  `jg_maxuserimage_timespan` int(9) NOT NULL,
  `jg_maxfilesize` int(9) NOT NULL,
  `jg_usercatacc` int(1) NOT NULL,
  `jg_usercatthumbalign` int(1) NOT NULL,
  `jg_useruploadsingle` int(1) NOT NULL,
  `jg_maxuploadfields` int(3) NOT NULL,
  `jg_useruploadajax` int(1) NOT NULL,
  `jg_useruploadbatch` int(1) NOT NULL,
  `jg_useruploadjava` int(1) NOT NULL,
  `jg_useruseorigfilename` int(1) NOT NULL,
  `jg_useruploadnumber` int(1) NOT NULL,
  `jg_special_gif_upload` int(1) NOT NULL,
  `jg_delete_original_user` int(1) NOT NULL,
  `jg_newpiccopyright` int(1) NOT NULL,
  `jg_newpicnote` int(1) NOT NULL,
  `jg_redirect_after_upload` int(1) NOT NULL,
  `jg_download` int(1) NOT NULL,
  `jg_download_unreg` int(1) NOT NULL,
  `jg_download_hint` int(1) NOT NULL,
  `jg_downloadfile` int(1) NOT NULL,
  `jg_downloadwithwatermark` int(1) NOT NULL,
  `jg_showrating` int(1) NOT NULL,
  `jg_maxvoting` int(1) NOT NULL,
  `jg_ratingcalctype` int(1) NOT NULL,
  `jg_ratingdisplaytype` int(1) NOT NULL,
  `jg_ajaxrating` int(1) NOT NULL,
  `jg_votingonlyonce` int(1) NOT NULL,
  `jg_votingonlyreg` int(1) NOT NULL,
  `jg_showcomment` int(1) NOT NULL,
  `jg_anoncomment` int(1) NOT NULL,
  `jg_namedanoncomment` int(1) NOT NULL,
  `jg_anonapprovecom` int(1) NOT NULL,
  `jg_approvecom` int(1) NOT NULL,
  `jg_bbcodesupport` int(1) NOT NULL,
  `jg_smiliesupport` int(1) NOT NULL,
  `jg_anismilie` int(1) NOT NULL,
  `jg_smiliescolor` varchar(10) NOT NULL,
  `jg_report_images` int(1) NOT NULL,
  `jg_report_unreg` int(1) NOT NULL,
  `jg_report_hint` int(1) NOT NULL,
  `jg_alternative_layout` varchar(255) NOT NULL,
  `jg_anchors` int(1) NOT NULL,
  `jg_tooltips` int(1) NOT NULL,
  `jg_dyncrop` int(1) NOT NULL,
  `jg_dyncropposition` int(1) NOT NULL,
  `jg_dyncropwidth` int(5) NOT NULL,
  `jg_dyncropheight` int(5) NOT NULL,
  `jg_dyncropbgcol` varchar(12) NOT NULL,
  `jg_hideemptycats` int(1) NOT NULL,
  `jg_skipcatview` int(1) NOT NULL,
  `jg_imgalign` int(3) NOT NULL,
  `jg_showrestrictedcats` int(1) NOT NULL,
  `jg_showrestrictedhint` int(1) NOT NULL,
  `jg_firstorder` varchar(20) NOT NULL,
  `jg_secondorder` varchar(20) NOT NULL,
  `jg_thirdorder` varchar(20) NOT NULL,
  `jg_pagetitle_cat` text NOT NULL,
  `jg_pagetitle_detail` text NOT NULL,
  `jg_showgalleryhead` int(1) NOT NULL,
  `jg_showpathway` int(1) NOT NULL,
  `jg_completebreadcrumbs` int(1) NOT NULL,
  `jg_search` int(1) NOT NULL,
  `jg_searchcols` int(1) NOT NULL,
  `jg_searchthumbalign` int(1) NOT NULL,
  `jg_searchtextalign` int(1) NOT NULL,
  `jg_showsearchdownload` int(1) NOT NULL,
  `jg_showsearchfavourite` int(1) NOT NULL,
  `jg_search_report_images` int(1) NOT NULL,
  `jg_showsearcheditorlinks` int(1) NOT NULL,
  `jg_showallpics` int(1) NOT NULL,
  `jg_showallhits` int(1) NOT NULL,
  `jg_showbacklink` int(1) NOT NULL,
  `jg_suppresscredits` int(1) NOT NULL,
  `jg_showuserpanel` int(1) NOT NULL,
  `jg_showuserpanel_hint` int(1) NOT NULL,
  `jg_showuserpanel_unreg` int(1) NOT NULL,
  `jg_showallpicstoadmin` int(1) NOT NULL,
  `jg_showminithumbs` int(1) NOT NULL,
  `jg_openjs_padding` int(3) NOT NULL,
  `jg_openjs_background` varchar(12) NOT NULL,
  `jg_dhtml_border` varchar(12) NOT NULL,
  `jg_show_title_in_popup` int(1) NOT NULL,
  `jg_show_description_in_popup` int(1) NOT NULL,
  `jg_lightbox_speed` int(3) NOT NULL,
  `jg_lightbox_slide_all` int(1) NOT NULL,
  `jg_resize_js_image` int(1) NOT NULL,
  `jg_disable_rightclick_original` int(1) NOT NULL,
  `jg_showgallerysubhead` int(1) NOT NULL,
  `jg_showallcathead` int(1) NOT NULL,
  `jg_colcat` int(1) NOT NULL,
  `jg_catperpage` int(1) NOT NULL,
  `jg_ordercatbyalpha` int(1) NOT NULL,
  `jg_showgallerypagenav` int(1) NOT NULL,
  `jg_showcatcount` int(1) NOT NULL,
  `jg_showcatthumb` int(1) NOT NULL,
  `jg_showrandomcatthumb` int(1) NOT NULL,
  `jg_ctalign` int(1) NOT NULL,
  `jg_showtotalcatimages` int(1) NOT NULL,
  `jg_showtotalcathits` int(1) NOT NULL,
  `jg_showcatasnew` int(1) NOT NULL,
  `jg_catdaysnew` int(3) NOT NULL,
  `jg_showdescriptioningalleryview` int(1) NOT NULL,
  `jg_uploadicongallery` int(1) NOT NULL,
  `jg_showsubsingalleryview` int(1) NOT NULL,
  `jg_category_rss` int(9) NOT NULL,
  `jg_category_rss_icon` varchar(10) NOT NULL,
  `jg_uploadiconcategory` int(1) NOT NULL,
  `jg_showcathead` int(1) NOT NULL,
  `jg_usercatorder` int(1) NOT NULL,
  `jg_usercatorderlist` varchar(50) NOT NULL,
  `jg_showcatdescriptionincat` int(1) NOT NULL,
  `jg_showpagenav` int(1) NOT NULL,
  `jg_showpiccount` int(1) NOT NULL,
  `jg_perpage` int(3) NOT NULL,
  `jg_catthumbalign` int(1) NOT NULL,
  `jg_colnumb` int(3) NOT NULL,
  `jg_detailpic_open` varchar(50) NOT NULL,
  `jg_lightboxbigpic` int(1) NOT NULL,
  `jg_showtitle` int(1) NOT NULL,
  `jg_showpicasnew` int(1) NOT NULL,
  `jg_daysnew` int(3) NOT NULL,
  `jg_showhits` int(1) NOT NULL,
  `jg_showdownloads` int(1) NOT NULL,
  `jg_showauthor` int(1) NOT NULL,
  `jg_showowner` int(1) NOT NULL,
  `jg_showcatcom` int(1) NOT NULL,
  `jg_showcatrate` int(1) NOT NULL,
  `jg_showcatdescription` int(1) NOT NULL,
  `jg_showcategorydownload` int(1) NOT NULL,
  `jg_showcategoryfavourite` int(1) NOT NULL,
  `jg_category_report_images` int(1) NOT NULL,
  `jg_showcategoryeditorlinks` int(1) NOT NULL,
  `jg_showsubcathead` int(1) NOT NULL,
  `jg_showsubcatcount` int(1) NOT NULL,
  `jg_colsubcat` int(3) NOT NULL,
  `jg_subperpage` int(3) NOT NULL,
  `jg_showpagenavsubs` int(1) NOT NULL,
  `jg_subcatthumbalign` int(1) NOT NULL,
  `jg_showsubthumbs` int(1) NOT NULL,
  `jg_showrandomsubthumb` int(1) NOT NULL,
  `jg_showdescriptionincategoryview` int(1) NOT NULL,
  `jg_ordersubcatbyalpha` int(1) NOT NULL,
  `jg_showtotalsubcatimages` int(1) NOT NULL,
  `jg_showtotalsubcathits` int(1) NOT NULL,
  `jg_uploadiconsubcat` int(1) NOT NULL,
  `jg_showdetailpage` int(1) NOT NULL,
  `jg_disabledetailpage` int(1) NOT NULL,
  `jg_showdetailnumberofpics` int(1) NOT NULL,
  `jg_cursor_navigation` int(1) NOT NULL,
  `jg_disable_rightclick_detail` int(1) NOT NULL,
  `jg_detail_report_images` int(1) NOT NULL,
  `jg_showdetaileditorlinks` int(1) NOT NULL,
  `jg_showdetailtitle` int(1) NOT NULL,
  `jg_showdetail` int(1) NOT NULL,
  `jg_showdetailaccordion` int(1) NOT NULL,
  `jg_accordionduration` int(3) NOT NULL,
  `jg_accordiondisplay` int(3) NOT NULL,
  `jg_accordionopacity` int(1) NOT NULL,
  `jg_accordionalwayshide` int(1) NOT NULL,
  `jg_accordioninitialeffect` int(1) NOT NULL,
  `jg_showdetaildescription` int(1) NOT NULL,
  `jg_showdetaildatum` int(1) NOT NULL,
  `jg_showdetailhits` int(1) NOT NULL,
  `jg_showdetaildownloads` int(1) NOT NULL,
  `jg_showdetailrating` int(1) NOT NULL,
  `jg_showdetailfilesize` int(1) NOT NULL,
  `jg_showdetailauthor` int(1) NOT NULL,
  `jg_showoriginalfilesize` int(1) NOT NULL,
  `jg_showdetaildownload` int(1) NOT NULL,
  `jg_watermark` int(1) NOT NULL,
  `jg_watermarkpos` int(1) NOT NULL,
  `jg_bigpic` int(1) NOT NULL,
  `jg_bigpic_unreg` int(1) NOT NULL,
  `jg_bigpic_open` varchar(50) NOT NULL,
  `jg_bbcodelink` int(1) NOT NULL,
  `jg_showcommentsunreg` int(1) NOT NULL,
  `jg_showcommentsarea` int(1) NOT NULL,
  `jg_send2friend` int(1) NOT NULL,
  `jg_minis` int(1) NOT NULL,
  `jg_motionminis` int(1) NOT NULL,
  `jg_motionminiWidth` int(3) NOT NULL,
  `jg_motionminiHeight` int(3) NOT NULL,
  `jg_miniWidth` int(3) NOT NULL,
  `jg_miniHeight` int(3) NOT NULL,
  `jg_minisprop` int(1) NOT NULL,
  `jg_nameshields` int(1) NOT NULL,
  `jg_nameshields_others` int(1) NOT NULL,
  `jg_nameshields_unreg` int(1) NOT NULL,
  `jg_show_nameshields_unreg` int(1) NOT NULL,
  `jg_nameshields_height` int(3) NOT NULL,
  `jg_nameshields_width` int(3) NOT NULL,
  `jg_slideshow` int(1) NOT NULL,
  `jg_slideshow_timer` int(3) NOT NULL,
  `jg_slideshow_transition` int(1) NOT NULL,
  `jg_slideshow_transtime` int(3) NOT NULL,
  `jg_slideshow_maxdimauto` int(1) NOT NULL,
  `jg_slideshow_width` int(3) NOT NULL,
  `jg_slideshow_heigth` int(3) NOT NULL,
  `jg_slideshow_infopane` int(1) NOT NULL,
  `jg_slideshow_carousel` int(1) NOT NULL,
  `jg_slideshow_arrows` int(1) NOT NULL,
  `jg_slideshow_repeat` int(1) NOT NULL,
  `jg_showexifdata` int(1) NOT NULL,
  `jg_showgeotagging` int(1) NOT NULL,
  `jg_geotaggingkey` text NOT NULL,
  `jg_subifdtags` text NOT NULL,
  `jg_ifdotags` text NOT NULL,
  `jg_gpstags` text NOT NULL,
  `jg_showiptcdata` int(1) NOT NULL,
  `jg_iptctags` text NOT NULL,
  `jg_showtoplist` int(1) NOT NULL,
  `jg_toplist` int(3) NOT NULL,
  `jg_topthumbalign` int(1) NOT NULL,
  `jg_toptextalign` int(1) NOT NULL,
  `jg_toplistcols` int(3) NOT NULL,
  `jg_whereshowtoplist` int(1) NOT NULL,
  `jg_showrate` int(1) NOT NULL,
  `jg_showlatest` int(1) NOT NULL,
  `jg_showcom` int(1) NOT NULL,
  `jg_showthiscomment` int(1) NOT NULL,
  `jg_showmostviewed` int(1) NOT NULL,
  `jg_showtoplistdownload` int(1) NOT NULL,
  `jg_showtoplistfavourite` int(1) NOT NULL,
  `jg_toplist_report_images` int(1) NOT NULL,
  `jg_showtoplisteditorlinks` int(1) NOT NULL,
  `jg_favourites` int(1) NOT NULL,
  `jg_showdetailfavourite` int(1) NOT NULL,
  `jg_favouritesshownotauth` int(1) NOT NULL,
  `jg_maxfavourites` int(5) NOT NULL,
  `jg_zipdownload` int(1) NOT NULL,
  `jg_usefavouritesforpubliczip` int(1) NOT NULL,
  `jg_usefavouritesforzip` int(1) NOT NULL,
  `jg_allimagesofcategory` int(1) NOT NULL,
  `jg_showfavouritesdownload` int(1) NOT NULL,
  `jg_showfavouriteseditorlinks` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__joomgallery_config` (`id`, `group_id`, `ordering`, `jg_pathimages`, `jg_pathoriginalimages`, `jg_paththumbs`, `jg_pathftpupload`, `jg_pathtemp`, `jg_wmpath`, `jg_wmfile`, `jg_use_real_paths`, `jg_checkupdate`, `jg_filenamewithjs`, `jg_filenamereplace`, `jg_thumbcreation`, `jg_fastgd2thumbcreation`, `jg_impath`, `jg_resizetomaxwidth`, `jg_maxwidth`, `jg_picturequality`, `jg_useforresizedirection`, `jg_cropposition`, `jg_thumbwidth`, `jg_thumbheight`, `jg_thumbquality`, `jg_uploadorder`, `jg_useorigfilename`, `jg_filenamenumber`, `jg_delete_original`, `jg_msg_upload_type`, `jg_msg_upload_recipients`, `jg_msg_download_type`, `jg_msg_download_recipients`, `jg_msg_zipdownload`, `jg_msg_comment_type`, `jg_msg_comment_recipients`, `jg_msg_comment_toowner`, `jg_msg_nametag_type`, `jg_msg_nametag_recipients`, `jg_msg_nametag_totaggeduser`, `jg_msg_nametag_toowner`, `jg_msg_report_type`, `jg_msg_report_recipients`, `jg_msg_report_toowner`, `jg_msg_rejectimg_type`, `jg_msg_global_from`, `jg_realname`, `jg_cooliris`, `jg_coolirislink`, `jg_contentpluginsenabled`, `jg_itemid`, `jg_ajaxcategoryselection`, `jg_disableunrequiredchecks`, `jg_userspace`, `jg_useruploaddefaultcat`, `jg_approve`, `jg_unregistered_permissions`, `jg_maxusercat`, `jg_maxuserimage`, `jg_maxuserimage_timespan`, `jg_maxfilesize`, `jg_usercatacc`, `jg_usercatthumbalign`, `jg_useruploadsingle`, `jg_maxuploadfields`, `jg_useruploadajax`, `jg_useruploadbatch`, `jg_useruploadjava`, `jg_useruseorigfilename`, `jg_useruploadnumber`, `jg_special_gif_upload`, `jg_delete_original_user`, `jg_newpiccopyright`, `jg_newpicnote`, `jg_redirect_after_upload`, `jg_download`, `jg_download_unreg`, `jg_download_hint`, `jg_downloadfile`, `jg_downloadwithwatermark`, `jg_showrating`, `jg_maxvoting`, `jg_ratingcalctype`, `jg_ratingdisplaytype`, `jg_ajaxrating`, `jg_votingonlyonce`, `jg_votingonlyreg`, `jg_showcomment`, `jg_anoncomment`, `jg_namedanoncomment`, `jg_anonapprovecom`, `jg_approvecom`, `jg_bbcodesupport`, `jg_smiliesupport`, `jg_anismilie`, `jg_smiliescolor`, `jg_report_images`, `jg_report_unreg`, `jg_report_hint`, `jg_alternative_layout`, `jg_anchors`, `jg_tooltips`, `jg_dyncrop`, `jg_dyncropposition`, `jg_dyncropwidth`, `jg_dyncropheight`, `jg_dyncropbgcol`, `jg_hideemptycats`, `jg_skipcatview`, `jg_imgalign`, `jg_showrestrictedcats`, `jg_showrestrictedhint`, `jg_firstorder`, `jg_secondorder`, `jg_thirdorder`, `jg_pagetitle_cat`, `jg_pagetitle_detail`, `jg_showgalleryhead`, `jg_showpathway`, `jg_completebreadcrumbs`, `jg_search`, `jg_searchcols`, `jg_searchthumbalign`, `jg_searchtextalign`, `jg_showsearchdownload`, `jg_showsearchfavourite`, `jg_search_report_images`, `jg_showsearcheditorlinks`, `jg_showallpics`, `jg_showallhits`, `jg_showbacklink`, `jg_suppresscredits`, `jg_showuserpanel`, `jg_showuserpanel_hint`, `jg_showuserpanel_unreg`, `jg_showallpicstoadmin`, `jg_showminithumbs`, `jg_openjs_padding`, `jg_openjs_background`, `jg_dhtml_border`, `jg_show_title_in_popup`, `jg_show_description_in_popup`, `jg_lightbox_speed`, `jg_lightbox_slide_all`, `jg_resize_js_image`, `jg_disable_rightclick_original`, `jg_showgallerysubhead`, `jg_showallcathead`, `jg_colcat`, `jg_catperpage`, `jg_ordercatbyalpha`, `jg_showgallerypagenav`, `jg_showcatcount`, `jg_showcatthumb`, `jg_showrandomcatthumb`, `jg_ctalign`, `jg_showtotalcatimages`, `jg_showtotalcathits`, `jg_showcatasnew`, `jg_catdaysnew`, `jg_showdescriptioningalleryview`, `jg_uploadicongallery`, `jg_showsubsingalleryview`, `jg_category_rss`, `jg_category_rss_icon`, `jg_uploadiconcategory`, `jg_showcathead`, `jg_usercatorder`, `jg_usercatorderlist`, `jg_showcatdescriptionincat`, `jg_showpagenav`, `jg_showpiccount`, `jg_perpage`, `jg_catthumbalign`, `jg_colnumb`, `jg_detailpic_open`, `jg_lightboxbigpic`, `jg_showtitle`, `jg_showpicasnew`, `jg_daysnew`, `jg_showhits`, `jg_showdownloads`, `jg_showauthor`, `jg_showowner`, `jg_showcatcom`, `jg_showcatrate`, `jg_showcatdescription`, `jg_showcategorydownload`, `jg_showcategoryfavourite`, `jg_category_report_images`, `jg_showcategoryeditorlinks`, `jg_showsubcathead`, `jg_showsubcatcount`, `jg_colsubcat`, `jg_subperpage`, `jg_showpagenavsubs`, `jg_subcatthumbalign`, `jg_showsubthumbs`, `jg_showrandomsubthumb`, `jg_showdescriptionincategoryview`, `jg_ordersubcatbyalpha`, `jg_showtotalsubcatimages`, `jg_showtotalsubcathits`, `jg_uploadiconsubcat`, `jg_showdetailpage`, `jg_disabledetailpage`, `jg_showdetailnumberofpics`, `jg_cursor_navigation`, `jg_disable_rightclick_detail`, `jg_detail_report_images`, `jg_showdetaileditorlinks`, `jg_showdetailtitle`, `jg_showdetail`, `jg_showdetailaccordion`, `jg_accordionduration`, `jg_accordiondisplay`, `jg_accordionopacity`, `jg_accordionalwayshide`, `jg_accordioninitialeffect`, `jg_showdetaildescription`, `jg_showdetaildatum`, `jg_showdetailhits`, `jg_showdetaildownloads`, `jg_showdetailrating`, `jg_showdetailfilesize`, `jg_showdetailauthor`, `jg_showoriginalfilesize`, `jg_showdetaildownload`, `jg_watermark`, `jg_watermarkpos`, `jg_bigpic`, `jg_bigpic_unreg`, `jg_bigpic_open`, `jg_bbcodelink`, `jg_showcommentsunreg`, `jg_showcommentsarea`, `jg_send2friend`, `jg_minis`, `jg_motionminis`, `jg_motionminiWidth`, `jg_motionminiHeight`, `jg_miniWidth`, `jg_miniHeight`, `jg_minisprop`, `jg_nameshields`, `jg_nameshields_others`, `jg_nameshields_unreg`, `jg_show_nameshields_unreg`, `jg_nameshields_height`, `jg_nameshields_width`, `jg_slideshow`, `jg_slideshow_timer`, `jg_slideshow_transition`, `jg_slideshow_transtime`, `jg_slideshow_maxdimauto`, `jg_slideshow_width`, `jg_slideshow_heigth`, `jg_slideshow_infopane`, `jg_slideshow_carousel`, `jg_slideshow_arrows`, `jg_slideshow_repeat`, `jg_showexifdata`, `jg_showgeotagging`, `jg_geotaggingkey`, `jg_subifdtags`, `jg_ifdotags`, `jg_gpstags`, `jg_showiptcdata`, `jg_iptctags`, `jg_showtoplist`, `jg_toplist`, `jg_topthumbalign`, `jg_toptextalign`, `jg_toplistcols`, `jg_whereshowtoplist`, `jg_showrate`, `jg_showlatest`, `jg_showcom`, `jg_showthiscomment`, `jg_showmostviewed`, `jg_showtoplistdownload`, `jg_showtoplistfavourite`, `jg_toplist_report_images`, `jg_showtoplisteditorlinks`, `jg_favourites`, `jg_showdetailfavourite`, `jg_favouritesshownotauth`, `jg_maxfavourites`, `jg_zipdownload`, `jg_usefavouritesforpubliczip`, `jg_usefavouritesforzip`, `jg_allimagesofcategory`, `jg_showfavouritesdownload`, `jg_showfavouriteseditorlinks`) VALUES
(1, 1, 1, 'images/joomgallery/details/', 'images/joomgallery/originals/', 'images/joomgallery/thumbnails/', 'administrator/components/com_joomgallery/temp/ftp_upload/', 'administrator/components/com_joomgallery/temp/', 'media/joomgallery/images/', 'watermark.png', 1, 1, 1, 'Š|S,Œ|O,Ž|Z,š|s,œ|oe,ž|z,Ÿ|Y,¥|Y,µ|u,À|A,Á|A,Â|A,Ã|A,Ä|AE,Å|A,Æ|A,Ç|C,È|E,É|E,Ê|E,Ë|E,Ì|I,Í|I,Î|I,Ï|I,Ð|D,Ñ|N,Ò|O,Ó|O,Ô|O,Õ|O,Ö|OE,Ø|O,Ù|U,Ú|U,Û|U,Ü|UE,Ý|Y,à|a,á|a,â|a,ã|a,ä|ae,å|a,æ|a,ç|c,è|e,é|e,ê|e,ë|e,ì|i,í|i,î|i,ï|i,ð|o,ñ|n,ò|o,ó|o,ô|o,õ|o,ö|oe,ø|o,ù|u,ú|u,û|u,ü|ue,ý|y,ÿ|y,ß|ss,ă|a,ş|s,ţ|t,ț|t,Ț|T,Ș|S,ș|s,Ş|S', 'gd2', 1, '', 1, 1900, 100, 2, 2, 768, 523, 100, 2, 1, 1, 1, 2, '-1', 2, '-1', 0, 2, '-1', 0, 2, '-1', 1, 0, 2, '-1', 0, 1, 0, 0, 0, 0, 1, '', 0, 0, 0, 0, 0, 0, 10, 500, 0, 2000000, 1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 2, 1, 1, 1, 0, 1, 1, 2, 1, 0, 5, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 'grey', 0, 1, 1, '_:default', 0, 0, 0, 2, 100, 100, '#ffffff', 0, 0, 0, 1, 0, 'ordering ASC', 'imgdate DESC', 'imgtitle DESC', '#page_title - [! COM_JOOMGALLERY_COMMON_CATEGORY!]: #cat', '#page_title - [! COM_JOOMGALLERY_COMMON_CATEGORY!]: #cat - [! COM_JOOMGALLERY_COMMON_IMAGE!]:  #img', 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '#000000', '#808080', 1, 1, 5, 1, 1, 1, 1, 0, 3, 9, 0, 1, 0, 1, 3, 3, 0, 0, 0, 7, 0, 0, 0, 10, '0', 0, 0, 0, 'date', 0, 3, 0, 9, 3, 3, 'fancyBox', 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 9, 1, 3, 2, 3, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 300, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, '6', 0, 0, 1, 0, 0, 2, 400, 50, 28, 28, 2, 0, 1, 1, 0, 10, 6, 0, 6000, 0, 2000, 0, 640, 480, 0, 0, 0, 0, 0, 0, '', '', '', '', 0, '', 0, 12, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

DROP TABLE IF EXISTS `#__joomgallery_countstop`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_countstop` (
  `cspicid` int(11) NOT NULL DEFAULT '0',
  `csip` varchar(20) NOT NULL,
  `cssessionid` varchar(200) DEFAULT NULL,
  `cstime` datetime DEFAULT NULL,
  KEY `idx_cspicid` (`cspicid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__joomgallery_countstop` (`cspicid`, `csip`, `cssessionid`, `cstime`) VALUES
(80, '127.0.0.1', 'z8s1pku3MjlkknmUB9cFflUTADJMnA4w', '2016-06-11 14:47:09');

DROP TABLE IF EXISTS `#__joomgallery_image_details`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_image_details` (
  `id` int(11) NOT NULL,
  `details_key` varchar(255) NOT NULL,
  `details_value` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`,`details_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__joomgallery_maintenance`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_maintenance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `owner` int(11) NOT NULL,
  `title` text NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `img` varchar(255) NOT NULL,
  `orig` varchar(255) NOT NULL,
  `thumborphan` int(11) NOT NULL,
  `imgorphan` int(11) NOT NULL,
  `origorphan` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__joomgallery_nameshields`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_nameshields` (
  `nid` int(11) NOT NULL AUTO_INCREMENT,
  `npicid` int(11) NOT NULL DEFAULT '0',
  `nuserid` int(11) unsigned NOT NULL DEFAULT '0',
  `nxvalue` int(11) NOT NULL DEFAULT '0',
  `nyvalue` int(11) NOT NULL DEFAULT '0',
  `by` int(11) NOT NULL DEFAULT '0',
  `nuserip` varchar(15) NOT NULL DEFAULT '0',
  `ndate` datetime NOT NULL,
  `nzindex` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`),
  KEY `idx_picid` (`npicid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__joomgallery_orphans`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_orphans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullpath` varchar(255) NOT NULL,
  `type` varchar(7) NOT NULL,
  `refid` int(11) NOT NULL,
  `title` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fullpath` (`fullpath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__joomgallery_users`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_users` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `uuserid` int(11) NOT NULL DEFAULT '0',
  `piclist` text,
  `layout` int(1) NOT NULL,
  `time` datetime NOT NULL,
  `zipname` varchar(70) NOT NULL,
  PRIMARY KEY (`uid`),
  KEY `idx_uid` (`uuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__joomgallery_votes`;
CREATE TABLE IF NOT EXISTS `#__joomgallery_votes` (
  `voteid` int(11) NOT NULL AUTO_INCREMENT,
  `picid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) unsigned NOT NULL DEFAULT '0',
  `userip` varchar(15) NOT NULL DEFAULT '0',
  `datevoted` datetime NOT NULL,
  `vote` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`voteid`),
  KEY `idx_picid` (`picid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_acl`;
CREATE TABLE IF NOT EXISTS `#__komento_acl` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cid` varchar(255) NOT NULL,
  `component` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `komento_acl_content_type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

INSERT INTO `#__komento_acl` (`id`, `cid`, `component`, `type`, `rules`) VALUES
(1, '1', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":false,"report_comment":false,"share_comment":true,"reply_comment":false,"upload_attachment":false,"download_attachment":true,"edit_own_comment":false,"delete_own_comment":false,"delete_own_attachment":false,"author_edit_comment":false,"author_delete_comment":false,"author_publish_comment":false,"author_unpublish_comment":false,"author_stick_comment":false,"author_delete_attachment":false,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":false,"unpublish_all_comment":false,"stick_all_comment":false,"delete_all_attachment":false,"read_others_comment":true}'),
(2, '9', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":false,"report_comment":false,"share_comment":true,"reply_comment":false,"upload_attachment":false,"download_attachment":true,"edit_own_comment":false,"delete_own_comment":false,"delete_own_attachment":false,"author_edit_comment":false,"author_delete_comment":false,"author_publish_comment":false,"author_unpublish_comment":false,"author_stick_comment":false,"author_delete_attachment":false,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":false,"unpublish_all_comment":false,"stick_all_comment":false,"delete_all_attachment":false,"read_others_comment":true}'),
(3, '2', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":false,"delete_own_comment":false,"delete_own_attachment":false,"author_edit_comment":false,"author_delete_comment":false,"author_publish_comment":false,"author_unpublish_comment":false,"author_stick_comment":false,"author_delete_attachment":false,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":false,"unpublish_all_comment":false,"stick_all_comment":false,"delete_all_attachment":false,"read_others_comment":true}'),
(4, '6', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":true,"delete_own_comment":true,"delete_own_attachment":true,"author_edit_comment":false,"author_delete_comment":false,"author_publish_comment":false,"author_unpublish_comment":false,"author_stick_comment":false,"author_delete_attachment":false,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":false,"unpublish_all_comment":false,"stick_all_comment":false,"delete_all_attachment":false,"read_others_comment":true}'),
(5, '7', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":true,"delete_own_comment":true,"delete_own_attachment":true,"author_edit_comment":false,"author_delete_comment":false,"author_publish_comment":false,"author_unpublish_comment":false,"author_stick_comment":false,"author_delete_attachment":false,"edit_all_comment":true,"delete_all_comment":true,"publish_all_comment":true,"unpublish_all_comment":true,"stick_all_comment":true,"delete_all_attachment":true,"read_others_comment":true}'),
(6, '3', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":true,"delete_own_comment":false,"delete_own_attachment":false,"author_edit_comment":true,"author_delete_comment":true,"author_publish_comment":true,"author_unpublish_comment":true,"author_stick_comment":true,"author_delete_attachment":true,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":false,"unpublish_all_comment":false,"stick_all_comment":false,"delete_all_attachment":false,"read_others_comment":true}'),
(7, '4', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":true,"delete_own_comment":false,"delete_own_attachment":false,"author_edit_comment":true,"author_delete_comment":true,"author_publish_comment":true,"author_unpublish_comment":true,"author_stick_comment":true,"author_delete_attachment":true,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":false,"unpublish_all_comment":false,"stick_all_comment":false,"delete_all_attachment":false,"read_others_comment":true}'),
(8, '5', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":true,"delete_own_comment":false,"delete_own_attachment":false,"author_edit_comment":true,"author_delete_comment":true,"author_publish_comment":true,"author_unpublish_comment":true,"author_stick_comment":true,"author_delete_attachment":true,"edit_all_comment":false,"delete_all_comment":false,"publish_all_comment":true,"unpublish_all_comment":true,"stick_all_comment":true,"delete_all_attachment":false,"read_others_comment":true}'),
(9, '8', 'com_content', 'usergroup', '{"read_comment":true,"read_stickies":true,"read_lovies":true,"add_comment":true,"like_comment":true,"report_comment":true,"share_comment":true,"reply_comment":true,"upload_attachment":true,"download_attachment":true,"edit_own_comment":true,"delete_own_comment":true,"delete_own_attachment":true,"author_edit_comment":true,"author_delete_comment":true,"author_publish_comment":true,"author_unpublish_comment":true,"author_stick_comment":true,"author_delete_attachment":true,"edit_all_comment":true,"delete_all_comment":true,"publish_all_comment":true,"unpublish_all_comment":true,"stick_all_comment":true,"delete_all_attachment":true,"read_others_comment":true}');

DROP TABLE IF EXISTS `#__komento_actions`;
CREATE TABLE IF NOT EXISTS `#__komento_actions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `comment_id` bigint(20) unsigned NOT NULL,
  `action_by` bigint(20) unsigned NOT NULL DEFAULT '0',
  `actioned` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `komento_actions` (`type`,`comment_id`,`action_by`),
  KEY `komento_actions_comment_id` (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_activities`;
CREATE TABLE IF NOT EXISTS `#__komento_activities` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `comment_id` bigint(20) NOT NULL,
  `uid` bigint(20) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_captcha`;
CREATE TABLE IF NOT EXISTS `#__komento_captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `response` varchar(5) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_comments`;
CREATE TABLE IF NOT EXISTS `#__komento_comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL,
  `cid` bigint(20) unsigned NOT NULL,
  `comment` text,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `ip` varchar(255) DEFAULT '',
  `created_by` bigint(20) unsigned DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) unsigned DEFAULT '0',
  `modified` datetime DEFAULT '0000-00-00 00:00:00',
  `deleted_by` bigint(20) unsigned DEFAULT '0',
  `deleted` datetime DEFAULT '0000-00-00 00:00:00',
  `flag` tinyint(1) DEFAULT '0',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `sticked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sent` tinyint(1) DEFAULT '0',
  `parent_id` int(11) unsigned DEFAULT '0',
  `lft` int(11) unsigned NOT NULL DEFAULT '0',
  `rgt` int(11) unsigned NOT NULL DEFAULT '0',
  `depth` int(11) unsigned NOT NULL DEFAULT '0',
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `address` text,
  `params` text,
  `ratings` int(11) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `komento_threaded` (`component`,`cid`,`published`,`lft`,`rgt`),
  KEY `komento_threaded_reverse` (`component`,`cid`,`published`,`rgt`),
  KEY `komento_module_comments` (`component`,`cid`,`published`,`created`),
  KEY `komento_backend` (`parent_id`,`created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `#__komento_comments` (`id`, `component`, `cid`, `comment`, `name`, `title`, `email`, `url`, `ip`, `created_by`, `created`, `modified_by`, `modified`, `deleted_by`, `deleted`, `flag`, `published`, `publish_up`, `publish_down`, `sticked`, `sent`, `parent_id`, `lft`, `rgt`, `depth`, `latitude`, `longitude`, `address`, `params`, `ratings`) VALUES
(4, 'com_content', 118, 'fdghfsdfg', 'asdasd', '', 'asdas@r.ru', '', '192.168.9.111', 0, '2015-07-03 14:13:52', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 9, 10, 0, '', '', '', NULL, 0),
(5, 'com_content', 118, 'DSFGJHGDFDGH', 'asdsad', '', 'ssad@r.ru', '', '192.168.9.111', 0, '2015-07-03 14:21:06', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, 2, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 0, 0, 11, 12, 0, '', '', '', NULL, 0);

DROP TABLE IF EXISTS `#__komento_configs`;
CREATE TABLE IF NOT EXISTS `#__komento_configs` (
  `component` varchar(255) NOT NULL,
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__komento_configs` (`component`, `params`) VALUES
('com_komento_comments_columns', '{"column_comment":"1","column_published":"1","column_sticked":"1","column_link":"1","column_edit":"1","column_component":"1","column_article":"1","column_date":"1","column_author":"1","column_id":"1","column_email":"1","column_homepage":"0","column_ip":"0","column_latitude":"0","column_longitude":"0","column_address":"0"}'),
('com_komento_pending_columns', '{"column_comment":1,"column_published":1,"column_link":1,"column_edit":1,"column_component":1,"column_article":1,"column_date":1,"column_author":1,"column_id":1}'),
('com_komento_reports_columns', '{"column_comment":1,"column_published":1,"column_link":1,"column_edit":1,"column_component":1,"column_article":1,"column_date":1,"column_author":1,"column_id":1}'),
('com_komento', '{"profile_enable":"0","profile_tab_comments":"1","profile_tab_activities":"1","profile_tab_popular":"1","profile_tab_sticked":"1","name_type":"default","layout_avatar_integration":"gravatar","layout_phpbb_path":"","layout_phpbb_url":"","profile_activities_comments":"1","profile_activities_replies":"1","profile_activities_likes":"1"}'),
('com_content', '{"enable_komento":"1","disable_komento_on_tmpl_component":"1","allowed_categories_mode":"1","allowed_categories":["11","12","13","14","15","48","49","50","51","52","53","54"],"enable_orphanitem_convert":"0","orphanitem_ownership":"0","enable_login_form":"0","login_provider":"joomla","enable_moderation":"1","requires_moderation":["1","9","2"],"subscription_auto":"0","subscription_confirmation":"0","pagebreak_load":"last","antispam_akismet":"0","antispam_akismet_key":"","antispam_akismet_trackback":"0","antispam_flood_control":"0","antispam_flood_interval":"10","antispam_min_length_enable":"0","antispam_min_length":"10","antispam_max_length_enable":"0","antispam_max_length":"300","filter_word":"0","filter_word_text":"","blacklist_ip":"","antispam_captcha_enable":"0","antispam_captcha_type":"0","show_captcha":["1"],"antispam_recaptcha_ssl":"0","antispam_recaptcha_public_key":"","antispam_recaptcha_private_key":"","antispam_recaptcha_theme":"clean","antispam_recaptcha_lang":"en","layout_theme":"kuro","enable_responsive":"1","tabbed_comments":"0","max_threaded_level":"5","enable_threaded":"1","thread_indentation":"20","show_sort_buttons":"0","default_sort":"oldest","load_previous":"0","max_comments_per_page":"10","layout_template_override":"1","layout_component_override":"1","layout_inherit_kuro_css":"0","layout_css_admin":"kmt-comment-item-admin","layout_css_registered":"kmt-comment-item-registered","layout_css_author":"kmt-comment-item-author","layout_css_public":"kmt-comment-item-public","name_type":"default","guest_label":"1","auto_hyperlink":"1","links_nofollow":"1","datetime_permalink":"1","date_format":"l, M j Y g:i:sa","max_image_width":"300","max_image_height":"300","allow_video":"1","bbcode_video_width":"350","bbcode_video_height":"350","layout_frontpage_comment":"1","layout_frontpage_readmore":"1","layout_frontpage_readmore_use_joomla":"1","layout_frontpage_hits":"0","layout_frontpage_alignment":"left","enable_lapsed_time":"1","layout_avatar_enable":"1","enable_guest_link":"0","enable_permalink":"0","enable_share":"1","enable_likes":"1","enable_reply":"1","enable_report":"0","enable_location":"0","enable_info":"0","enable_syntax_highlighting":"0","enable_id":"0","enable_reply_reference":"1","enable_rank_bar":"0","enable_live_notification":"1","live_notification_interval":"30","form_position":"0","form_toggle_button":"0","autohide_form_notification":"1","form_show_moderate_message":"1","scroll_to_comment":"1","show_location":"0","enable_bbcode":"0","enable_subscription":"0","tnc_text":"Before submitting the comment, you agree that:\\r\\n\\r\\na. To accept full responsibility for the comment that you submit.\\r\\nb. To use this function only for lawful purposes.\\r\\nc. Not to post defamatory, abusive, offensive, racist, sexist, threatening, vulgar, obscene, hateful or otherwise inappropriate comments, or to post comments which will constitute a criminal offense or give rise to civil liability.\\r\\nd. Not to post or make available any material which is protected by copyright, trade mark or other proprietary right without the express permission of the owner of the copyright, trade mark or any other proprietary right.\\r\\ne. To evaluate for yourself the accuracy of any opinion, advice or other content.","show_name":"1","show_email":"1","show_website":"1","require_name":"1","require_email":"1","require_website":"0","enable_email_regex":"1","email_regex":["%5CS%2B%40%5CS%2B"],"enable_website_regex":"1","website_regex":["%28http%3A%2F%2F%7Cftp%3A%2F%2F%7Cwww%29%5CS%2B"],"layout_avatar_integration":"gravatar","use_komento_profile":"1","easysocial_profile_popbox":"0","gravatar_default_avatar":"mm","layout_phpbb_path":"","layout_phpbb_url":"","bbcode_bold":"1","bbcode_italic":"1","bbcode_underline":"1","bbcode_link":"1","bbcode_picture":"1","bbcode_video":"1","bbcode_bulletlist":"1","bbcode_numericlist":"1","bbcode_bullet":"1","bbcode_quote":"1","bbcode_code":"1","bbcode_clean":"1","bbcode_smile":"1","bbcode_happy":"1","bbcode_surprised":"1","bbcode_tongue":"1","bbcode_unhappy":"1","bbcode_wink":"1","smileycode":[],"smileypath":[],"share_facebook":"1","share_twitter":"1","share_googleplus":"1","share_linkedin":"1","share_tumblr":"1","share_digg":"1","share_delicious":"1","share_reddit":"1","share_stumbleupon":"1","enable_conversation_bar":"0","conversation_bar_max_authors":"10","conversation_bar_include_guest":"0","enable_stickies":"0","max_stickies":"5","enable_lovies":"0","minimum_likes_lovies":"0","max_lovies":"5","syntaxhighlighter_theme":"default","notification_enable":"0","notification_sendmailonpageload":"0","notification_sendmailinhtml":"0","notification_event_new_comment":"0","notification_event_new_reply":"0","notification_event_new_pending":"0","notification_event_reported_comment":"0","notification_to_author":"0","notification_to_subscribers":"0","activities_comment":"1","activities_reply":"1","activities_like":"1","trigger_method":"component","target":"com_content","tnc":"","show_tnc":[],"notification_to_usergroup_comment":[],"notification_to_usergroup_reply":[],"notification_to_usergroup_pending":[],"notification_to_usergroup_reported":[],"notification_es_to_usergroup_comment":[],"notification_es_to_usergroup_reply":[],"notification_es_to_usergroup_like":[]}');

DROP TABLE IF EXISTS `#__komento_hashkeys`;
CREATE TABLE IF NOT EXISTS `#__komento_hashkeys` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `uid` bigint(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `key` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_ipfilter`;
CREATE TABLE IF NOT EXISTS `#__komento_ipfilter` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `component` varchar(255) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `komento_ipfilter` (`component`,`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_mailq`;
CREATE TABLE IF NOT EXISTS `#__komento_mailq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mailfrom` varchar(255) DEFAULT NULL,
  `fromname` varchar(255) DEFAULT NULL,
  `recipient` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `created` datetime NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'text',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `komento_mailq_status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_subscription`;
CREATE TABLE IF NOT EXISTS `#__komento_subscription` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `component` varchar(255) NOT NULL,
  `cid` bigint(20) unsigned NOT NULL,
  `userid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `fullname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `komento_subscription` (`type`,`component`,`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__komento_uploads`;
CREATE TABLE IF NOT EXISTS `#__komento_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `filename` text NOT NULL,
  `hashname` text NOT NULL,
  `path` text,
  `created` datetime NOT NULL,
  `created_by` bigint(20) unsigned DEFAULT '0',
  `published` tinyint(1) NOT NULL,
  `mime` text NOT NULL,
  `size` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_aliases`;
CREATE TABLE IF NOT EXISTS `#__kunena_aliases` (
  `alias` varchar(255) NOT NULL,
  `type` varchar(10) NOT NULL,
  `item` varchar(32) NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT '0',
  UNIQUE KEY `alias` (`alias`),
  KEY `state` (`state`),
  KEY `item` (`item`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_aliases` (`alias`, `type`, `item`, `state`) VALUES
('announcement', 'view', 'announcement', 1),
('category', 'view', 'category', 1),
('category/create', 'layout', 'category.create', 1),
('category/default', 'layout', 'category.default', 1),
('category/edit', 'layout', 'category.edit', 1),
('category/manage', 'layout', 'category.manage', 1),
('category/moderate', 'layout', 'category.moderate', 1),
('category/user', 'layout', 'category.user', 1),
('common', 'view', 'common', 1),
('create', 'layout', 'category.create', 0),
('credits', 'view', 'credits', 1),
('default', 'layout', 'category.default', 0),
('edit', 'layout', 'category.edit', 0),
('home', 'view', 'home', 1),
('ideal-forum', 'catid', '5', 0),
('kunena-the-communication-platform-for-joomla', 'catid', '4', 0),
('main-forum', 'catid', '1', 1),
('manage', 'layout', 'category.manage', 0),
('misc', 'view', 'misc', 1),
('moderate', 'layout', 'category.moderate', 0),
('more-about-the-kunena', 'catid', '6', 0),
('search', 'view', 'search', 1),
('statistics', 'view', 'statistics', 1),
('suggestion-box', 'catid', '3', 1),
('topic', 'view', 'topic', 1),
('topics', 'view', 'topics', 1),
('user', 'view', 'user', 1),
('welcome-mat', 'catid', '2', 1);

DROP TABLE IF EXISTS `#__kunena_announcement`;
CREATE TABLE IF NOT EXISTS `#__kunena_announcement` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `sdescription` text NOT NULL,
  `description` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `showdate` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_attachments`;
CREATE TABLE IF NOT EXISTS `#__kunena_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mesid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `hash` char(32) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `folder` varchar(255) NOT NULL,
  `filetype` varchar(20) NOT NULL,
  `filename` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mesid` (`mesid`),
  KEY `userid` (`userid`),
  KEY `hash` (`hash`),
  KEY `filename` (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_categories`;
CREATE TABLE IF NOT EXISTS `#__kunena_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `name` tinytext,
  `alias` varchar(255) NOT NULL,
  `icon_id` tinyint(4) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `accesstype` varchar(20) NOT NULL DEFAULT 'joomla.level',
  `access` int(11) NOT NULL DEFAULT '0',
  `pub_access` int(11) NOT NULL DEFAULT '1',
  `pub_recurse` tinyint(4) DEFAULT '1',
  `admin_access` int(11) NOT NULL DEFAULT '0',
  `admin_recurse` tinyint(4) DEFAULT '1',
  `ordering` smallint(6) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `channels` text,
  `checked_out` tinyint(4) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review` tinyint(4) NOT NULL DEFAULT '0',
  `allow_anonymous` tinyint(4) NOT NULL DEFAULT '0',
  `post_anonymous` tinyint(4) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `headerdesc` text NOT NULL,
  `class_sfx` varchar(20) NOT NULL,
  `allow_polls` tinyint(4) NOT NULL DEFAULT '0',
  `topic_ordering` varchar(16) NOT NULL DEFAULT 'lastpost',
  `numTopics` mediumint(8) NOT NULL DEFAULT '0',
  `numPosts` mediumint(8) NOT NULL DEFAULT '0',
  `last_topic_id` int(11) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `last_post_time` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `category_access` (`accesstype`,`access`),
  KEY `published_pubaccess_id` (`published`,`pub_access`,`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT INTO `#__kunena_categories` (`id`, `parent_id`, `name`, `alias`, `icon_id`, `locked`, `accesstype`, `access`, `pub_access`, `pub_recurse`, `admin_access`, `admin_recurse`, `ordering`, `published`, `channels`, `checked_out`, `checked_out_time`, `review`, `allow_anonymous`, `post_anonymous`, `hits`, `description`, `headerdesc`, `class_sfx`, `allow_polls`, `topic_ordering`, `numTopics`, `numPosts`, `last_topic_id`, `last_post_id`, `last_post_time`, `params`) VALUES
(1, 0, 'Main Forum', 'main-forum', 0, 0, 'joomla.group', 0, 1, 1, 0, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'This is the main forum section. It serves as a container for categories for your topics.', 'The section header is used to display additional information about the categories of topics that it contains.', '', 0, 'lastpost', 0, 0, 0, 0, 0, ''),
(2, 1, 'Welcome Mat', 'welcome-mat', 0, 0, 'joomla.group', 1, 1, 1, 0, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'We encourage new members to introduce themselves here. Get to know one another and share your interests.', 'Welcome to the Kunena forum! Tell us and our members who you are, what you like and why you became a member of this site. We welcome all new members and hope to see you around a lot!', '', 0, 'lastpost', 1, 1, 1, 1, 1399057228, '{"access_post":["6","2","8"],"access_reply":["6","2","8"]}'),
(3, 1, 'Suggestion Box', 'suggestion-box', 0, 0, 'joomla.group', 0, 1, 1, 0, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Have some feedback and input to share? \n Don''t be shy and drop us a note. We want to hear from you and strive to make our site better and more user friendly for our guests and members a like.', 'This is the optional category header for the Suggestion Box.', '', 1, 'lastpost', 0, 0, 0, 0, 0, ''),
(4, 0, 'Kunena, the Communication Platform for Joomla', 'kunena-the-communication-platform-for-joomla', 0, 0, 'joomla.level', 1, 1, 1, 8, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Kunena is the ideal forum extension for Joomla. It''s free, fully integrated, and no bridges or hacks are required.', 'Want to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', '', 0, 'lastpost', 0, 0, 0, 0, 0, '{}'),
(5, 4, 'Ideal forum', 'ideal-forum', 0, 0, 'joomla.level', 1, 1, 1, 8, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Kunena is the ideal forum extension for Joomla. It''s free, fully integrated, and no bridges or hacks are required.', 'Kunena is the ideal forum extension for Joomla. It''s free, fully integrated, and no bridges or hacks are required.', '', 0, 'lastpost', 1, 4, 2, 5, 1418121786, '{"access_post":["6","2","8"],"access_reply":["6","2","8"]}'),
(6, 4, 'More about the Kunena', 'more-about-the-kunena', 0, 0, 'joomla.level', 1, 1, 1, 8, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Want to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', 'Want to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', '', 0, 'lastpost', 1, 2, 3, 7, 1418122011, '{"access_post":["6","2","8"],"access_reply":["6","2","8"]}');

DROP TABLE IF EXISTS `#__kunena_configuration`;
CREATE TABLE IF NOT EXISTS `#__kunena_configuration` (
  `id` int(11) NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_configuration` (`id`, `params`) VALUES
(1, '{"board_title":"Kunena","email":"","board_offline":"0","offline_message":"<h2>The Forum is currently offline for maintenance.<\\/h2>\\r\\n<div>Check back soon!<\\/div>","enablerss":"1","threads_per_page":"20","messages_per_page":"6","messages_per_page_search":"15","showhistory":"1","historylimit":"6","shownew":"1","disemoticons":"0","template":"custom","showannouncement":"1","avataroncat":"0","catimagepath":"category_images","showchildcaticon":"1","rtewidth":"450","rteheight":"300","enableforumjump":"1","reportmsg":"1","username":"1","askemail":"0","showemail":"0","showuserstats":"1","showkarma":"1","useredit":"1","useredittime":"0","useredittimegrace":"600","editmarkup":"1","allowsubscriptions":"1","subscriptionschecked":"1","allowfavorites":"1","maxsubject":"50","maxsig":"300","regonly":"0","pubwrite":"0","floodprotection":"0","mailmod":"0","mailadmin":"0","captcha":"0","mailfull":"1","allowavatarupload":"1","allowavatargallery":"1","avatarquality":"75","avatarsize":"2048","imageheight":"800","imagewidth":"800","imagesize":"150","filetypes":"txt,rtf,pdf,zip,tar.gz,tgz,tar.bz2","filesize":"120","showranking":"1","rankimages":"1","userlist_rows":"30","userlist_online":"1","userlist_avatar":"1","userlist_name":"1","userlist_posts":"1","userlist_karma":"1","userlist_email":"0","userlist_joindate":"1","userlist_lastvisitdate":"1","userlist_userhits":"1","latestcategory":"","showstats":"1","showwhoisonline":"1","showgenstats":"1","showpopuserstats":"1","popusercount":"5","showpopsubjectstats":"1","popsubjectcount":"5","usernamechange":"0","showspoilertag":"1","showvideotag":"1","showebaytag":"1","trimlongurls":"1","trimlongurlsfront":"40","trimlongurlsback":"20","autoembedyoutube":"1","autoembedebay":"1","ebaylanguagecode":"en-us","sessiontimeout":"1800","highlightcode":"0","rss_type":"topic","rss_timelimit":"month","rss_limit":"100","rss_included_categories":"","rss_excluded_categories":"","rss_specification":"rss2.0","rss_allow_html":"1","rss_author_format":"name","rss_author_in_title":"1","rss_word_count":"0","rss_old_titles":"1","rss_cache":"900","defaultpage":"recent","default_sort":"asc","sef":"1","showimgforguest":"1","showfileforguest":"1","pollnboptions":"4","pollallowvoteone":"1","pollenabled":"1","poppollscount":"5","showpoppollstats":"1","polltimebtvotes":"00:15:00","pollnbvotesbyuser":"100","pollresultsuserslist":"1","maxpersotext":"50","ordering_system":"mesid","post_dateformat":"ago","post_dateformat_hover":"datetime","hide_ip":"1","imagetypes":"jpg,jpeg,gif,png","checkmimetypes":"1","imagemimetypes":"image\\/jpeg,image\\/jpg,image\\/gif,image\\/png","imagequality":"50","thumbheight":"32","thumbwidth":"32","hideuserprofileinfo":"put_empty","boxghostmessage":"0","userdeletetmessage":"0","latestcategory_in":"1","topicicons":"0","debug":"0","catsautosubscribed":0,"showbannedreason":"0","version_check":"1","showthankyou":"1","showpopthankyoustats":"1","popthankscount":"5","mod_see_deleted":"0","bbcode_img_secure":"text","listcat_show_moderators":"1","lightbox":"1","show_list_time":"720","show_session_type":"0","show_session_starttime":"0","userlist_allowed":"0","userlist_count_users":"1","enable_threaded_layouts":"0","category_subscriptions":"post","topic_subscriptions":"every","pubprofile":"1","thankyou_max":"10","email_recipient_count":"0","email_recipient_privacy":"bcc","email_visible_address":"","captcha_post_limit":"0","recaptcha_publickey":"","recaptcha_privatekey":"","recaptcha_theme":"white","keywords":0,"userkeywords":0,"image_upload":"registered","file_upload":"registered","topic_layout":"flat","time_to_create_page":"0","show_imgfiles_manage_profile":"1","hold_newusers_posts":"0","hold_guest_posts":"0","attachment_limit":"8","pickup_category":"0","article_display":"intro","send_emails":"1","stopforumspam_key":"","fallback_english":"1","cache":"1","cache_time":"60","ebay_affiliate_id":"5337089937","iptracking":"1","rss_feedburner_url":"","autolink":"1","access_component":"1","statslink_allowed":"1","superadmin_userlist":"0","plugins":{"plg_system_kunena":{"jcontentevents":"0","jcontentevent_target":"body"}}}');

DROP TABLE IF EXISTS `#__kunena_keywords`;
CREATE TABLE IF NOT EXISTS `#__kunena_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `public_count` int(11) NOT NULL,
  `total_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `public_count` (`public_count`),
  KEY `total_count` (`total_count`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_keywords_map`;
CREATE TABLE IF NOT EXISTS `#__kunena_keywords_map` (
  `keyword_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  UNIQUE KEY `keyword_user_topic` (`keyword_id`,`user_id`,`topic_id`),
  KEY `user_id` (`user_id`),
  KEY `topic_user` (`topic_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__kunena_messages`;
CREATE TABLE IF NOT EXISTS `#__kunena_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) DEFAULT '0',
  `thread` int(11) DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `name` tinytext,
  `userid` int(11) NOT NULL DEFAULT '0',
  `email` tinytext,
  `subject` tinytext,
  `time` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(128) DEFAULT NULL,
  `topic_emoticon` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) DEFAULT '0',
  `hits` int(11) DEFAULT '0',
  `moved` tinyint(4) DEFAULT '0',
  `modified_by` int(7) DEFAULT NULL,
  `modified_time` int(11) DEFAULT NULL,
  `modified_reason` tinytext,
  PRIMARY KEY (`id`),
  KEY `thread` (`thread`),
  KEY `ip` (`ip`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `locked` (`locked`),
  KEY `hold_time` (`hold`,`time`),
  KEY `parent_hits` (`parent`,`hits`),
  KEY `catid_parent` (`catid`,`parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `#__kunena_messages` (`id`, `parent`, `thread`, `catid`, `name`, `userid`, `email`, `subject`, `time`, `ip`, `topic_emoticon`, `locked`, `hold`, `ordering`, `hits`, `moved`, `modified_by`, `modified_time`, `modified_reason`) VALUES
(1, 0, 1, 2, '', 317, '', 'Welcome to Kunena!', 1399057228, '127.0.0.1', 0, 0, 0, 0, 0, 0, 846, 1423728734, ''),
(2, 0, 2, 5, 'demo', 846, '', 'Morbi tincidunt sodales neque eu rutrum', 1415103771, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444812838, ''),
(3, 2, 2, 5, 'demo', 846, '', 'General Template Issues, Questions And Problems', 1415179292, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444813202, ''),
(4, 2, 2, 5, 'lorem_ipsum', 847, '', 'Personal diary in Kunena Forum', 1418121749, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444813240, ''),
(5, 2, 2, 5, 'lorem_ipsum', 847, '', 'Multiples templates (linked to forum categories)', 1418121786, '192.168.9.17', 0, 0, 0, 0, 0, 0, 846, 1444813776, ''),
(6, 0, 3, 6, 'lorem_ipsum', 847, '', 'Pellentesque non libero', 1418121957, '192.168.9.17', 0, 0, 0, 0, 0, 0, NULL, NULL, ''),
(7, 6, 3, 6, 'dolor_sit', 848, '', 'Pellentesque non libero', 1418122011, '192.168.9.17', 0, 0, 0, 0, 0, 0, NULL, NULL, '');

DROP TABLE IF EXISTS `#__kunena_messages_text`;
CREATE TABLE IF NOT EXISTS `#__kunena_messages_text` (
  `mesid` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  PRIMARY KEY (`mesid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_messages_text` (`mesid`, `message`) VALUES
(1, 'Thank you for choosing Kunena for your community forum needs in Joomla. \r\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \r\nAdditional Kunena Resources\r\nKunena Documentation: [url]http://www.kunena.org/docs[/url] \r\nKunena Support Forum: [url]http://www.kunena.org/forum[/url] \r\nKunena Downloads: [url]http://www.kunena.org/download[/url] \r\nKunena Blog: [url]http://www.kunena.org/blog[/url] \r\nFollow Kunena on Twitter: [url]http://www.kunena.org/twitter[/url]'),
(2, 'Kunena is the ideal forum extension for Joomla. It''s free, fully integrated, and no bridges or hacks are required.\r\n\r\nWant to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.'),
(3, 'This is a community-driven self-help category to ask questions about designing or developing your own Kunena template. Please be aware that there are rules that apply to topics posted in this category:\r\n\r\n[b]Do not use this category for:[/b]\r\nasking questions about how to make simple changes to a template designed by the Kunena project team (use K 3.0 Templates instead);\r\nadvertising your own template designs.\r\n\r\nTopics that do not meet the above guidelines may be removed without notice.'),
(4, 'Hello mates. Can i setup Kunena Forum so that some user''s notes (but not all) will be availible for other users and some not by their wish? The main idea is to create personalized diary of the users and functionality of Kunena Forum seems to be most suitable for this.'),
(5, 'Hi.\r\n\r\nI''m looking to have 1 template for 1 categorie and an other template for all others catégories.\r\nSomeone he already well-considered the problem ?\r\n\r\nRegards.'),
(6, 'Sed justo felis, lacinia at scelerisque a, semper et ante. Fusce posuere lacus eu mi lacinia et fringilla elit sollicitudin. Maecenas non odio nunc. In ut sollicitudin magna. Sed sit amet tincidunt odio. Mauris pharetra adipiscing urna ut accumsan. Suspendisse nec risus in felis fermentum blandit.\r\n\r\nNam nec lectus ut orci porta volutpat id at purus. Sed sagittis congue dapibus. Proin dolor metus, pharetra ut pulvinar nec, condimentum quis libero. Sed fermentum tortor ac elit tristique vel dapibus sem porta. Suspendisse aliquet posuere ultrices. Proin facilisis libero lacinia erat pretium faucibus. In tortor nunc, posuere eget commodo et, eleifend vel risus.'),
(7, 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam erat volutpat. Pellentesque non libero dui, vitae pharetra urna. Vestibulum accumsan pulvinar magna sed consectetur. Nulla congue condimentum aliquam. Donec non libero lectus, id mollis nisi. Morbi turpis magna, varius in ullamcorper nec, suscipit sagittis nibh. Nam elementum aliquam turpis eget egestas. Cras ligula nisi, interdum et vulputate nec, sagittis a tellus. In hac habitasse platea dictumst. In in sem libero. Fusce cursus, metus eu commodo hendrerit, arcu nibh consequat lectus, nec suscipit eros urna in ipsum. Praesent et enim a nisl commodo sodales non id neque. Ut sodales dignissim massa vitae hendrerit. Sed porttitor purus ut ante fermentum quis mollis velit pellentesque.\r\n\r\nEtiam nisi felis, fermentum vitae ultrices non, euismod in magna. In mattis velit ut eros tristique a congue erat consequat. Suspendisse consequat, justo eu gravida semper, ligula turpis dignissim dolor, vitae lacinia velit metus id libero. Nullam consectetur rhoncus magna, quis pharetra tortor bibendum quis. Curabitur ac ante nisl. Nullam mauris arcu, malesuada eu consectetur non, eleifend quis est. Nullam dictum, leo vulputate elementum porttitor, enim mi posuere augue, id porttitor leo sapien sed libero. Quisque est velit, aliquam bibendum vestibulum eget, tristique a odio.');

DROP TABLE IF EXISTS `#__kunena_polls`;
CREATE TABLE IF NOT EXISTS `#__kunena_polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `threadid` int(11) NOT NULL,
  `polltimetolive` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `threadid` (`threadid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_polls_options`;
CREATE TABLE IF NOT EXISTS `#__kunena_polls_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pollid` int(11) DEFAULT NULL,
  `text` varchar(100) DEFAULT NULL,
  `votes` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pollid` (`pollid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_polls_users`;
CREATE TABLE IF NOT EXISTS `#__kunena_polls_users` (
  `pollid` int(11) DEFAULT NULL,
  `userid` int(11) DEFAULT NULL,
  `votes` int(11) DEFAULT NULL,
  `lasttime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvote` int(11) DEFAULT NULL,
  UNIQUE KEY `pollid` (`pollid`,`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__kunena_ranks`;
CREATE TABLE IF NOT EXISTS `#__kunena_ranks` (
  `rank_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `rank_title` varchar(255) NOT NULL DEFAULT '',
  `rank_min` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rank_special` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `rank_image` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`rank_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `#__kunena_ranks` (`rank_id`, `rank_title`, `rank_min`, `rank_special`, `rank_image`) VALUES
(1, 'New Member', 0, 0, 'rank1.gif'),
(2, 'Junior Member', 20, 0, 'rank2.gif'),
(3, 'Senior Member', 40, 0, 'rank3.gif'),
(4, 'Premium Member', 80, 0, 'rank4.gif'),
(5, 'Elite Member', 160, 0, 'rank5.gif'),
(6, 'Platinum Member', 320, 0, 'rank6.gif'),
(7, 'Administrator', 0, 1, 'rankadmin.gif'),
(8, 'Moderator', 0, 1, 'rankmod.gif'),
(9, 'Spammer', 0, 1, 'rankspammer.gif'),
(10, 'Banned', 0, 1, 'rankbanned.gif');

DROP TABLE IF EXISTS `#__kunena_sessions`;
CREATE TABLE IF NOT EXISTS `#__kunena_sessions` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `allowed` text,
  `lasttime` int(11) NOT NULL DEFAULT '0',
  `readtopics` text,
  `currvisit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `currvisit` (`currvisit`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_sessions` (`userid`, `allowed`, `lasttime`, `readtopics`, `currvisit`) VALUES
(55, 'na', 1444224132, '0', 1445433740),
(283, 'na', 1452089892, '0', 1452517940),
(846, 'na', 1444738495, '0', 1444814130),
(847, 'na', 1416912031, '0', 1418121958),
(848, 'na', 1432031594, '0', 1432036031),
(969, 'na', 1456752937, '0', 1457599351);

DROP TABLE IF EXISTS `#__kunena_smileys`;
CREATE TABLE IF NOT EXISTS `#__kunena_smileys` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `code` varchar(12) NOT NULL DEFAULT '',
  `location` varchar(50) NOT NULL DEFAULT '',
  `greylocation` varchar(60) NOT NULL DEFAULT '',
  `emoticonbar` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=67 ;

INSERT INTO `#__kunena_smileys` (`id`, `code`, `location`, `greylocation`, `emoticonbar`) VALUES
(1, 'B)', 'cool.png', 'cool-grey.png', 1),
(2, '8)', 'cool.png', 'cool-grey.png', 0),
(3, '8-)', 'cool.png', 'cool-grey.png', 0),
(4, ':-(', 'sad.png', 'sad-grey.png', 0),
(5, ':(', 'sad.png', 'sad-grey.png', 1),
(6, ':sad:', 'sad.png', 'sad-grey.png', 0),
(7, ':cry:', 'sad.png', 'sad-grey.png', 0),
(8, ':)', 'smile.png', 'smile-grey.png', 1),
(9, ':-)', 'smile.png', 'smile-grey.png', 0),
(10, ':cheer:', 'cheerful.png', 'cheerful-grey.png', 1),
(11, ';)', 'wink.png', 'wink-grey.png', 1),
(12, ';-)', 'wink.png', 'wink-grey.png', 0),
(13, ':wink:', 'wink.png', 'wink-grey.png', 0),
(14, ';-)', 'wink.png', 'wink-grey.png', 0),
(15, ':P', 'tongue.png', 'tongue-grey.png', 1),
(16, ':p', 'tongue.png', 'tongue-grey.png', 0),
(17, ':-p', 'tongue.png', 'tongue-grey.png', 0),
(18, ':-P', 'tongue.png', 'tongue-grey.png', 0),
(19, ':razz:', 'tongue.png', 'tongue-grey.png', 0),
(20, ':angry:', 'angry.png', 'angry-grey.png', 1),
(21, ':mad:', 'angry.png', 'angry-grey.png', 0),
(22, ':unsure:', 'unsure.png', 'unsure-grey.png', 1),
(23, ':o', 'shocked.png', 'shocked-grey.png', 0),
(24, ':-o', 'shocked.png', 'shocked-grey.png', 0),
(25, ':O', 'shocked.png', 'shocked-grey.png', 0),
(26, ':-O', 'shocked.png', 'shocked-grey.png', 0),
(27, ':eek:', 'shocked.png', 'shocked-grey.png', 0),
(28, ':ohmy:', 'shocked.png', 'shocked-grey.png', 1),
(29, ':huh:', 'wassat.png', 'wassat-grey.png', 1),
(30, ':?', 'confused.png', 'confused-grey.png', 0),
(31, ':-?', 'confused.png', 'confused-grey.png', 0),
(32, ':???', 'confused.png', 'confused-grey.png', 0),
(33, ':dry:', 'ermm.png', 'ermm-grey.png', 1),
(34, ':ermm:', 'ermm.png', 'ermm-grey.png', 0),
(35, ':lol:', 'grin.png', 'grin-grey.png', 1),
(36, ':X', 'sick.png', 'sick-grey.png', 0),
(37, ':x', 'sick.png', 'sick-grey.png', 0),
(38, ':sick:', 'sick.png', 'sick-grey.png', 1),
(39, ':silly:', 'silly.png', 'silly-grey.png', 1),
(40, ':y32b4:', 'silly.png', 'silly-grey.png', 0),
(41, ':blink:', 'blink.png', 'blink-grey.png', 1),
(42, ':blush:', 'blush.png', 'blush-grey.png', 1),
(43, ':oops:', 'blush.png', 'blush-grey.png', 1),
(44, ':kiss:', 'kissing.png', 'kissing-grey.png', 1),
(45, ':rolleyes:', 'blink.png', 'blink-grey.png', 0),
(46, ':roll:', 'blink.png', 'blink-grey.png', 0),
(47, ':woohoo:', 'w00t.png', 'w00t-grey.png', 1),
(48, ':side:', 'sideways.png', 'sideways-grey.png', 1),
(49, ':S', 'dizzy.png', 'dizzy-grey.png', 1),
(50, ':s', 'dizzy.png', 'dizzy-grey.png', 0),
(51, ':evil:', 'devil.png', 'devil-grey.png', 1),
(52, ':twisted:', 'devil.png', 'devil-grey.png', 0),
(53, ':whistle:', 'whistling.png', 'whistling-grey.png', 1),
(54, ':pinch:', 'pinch.png', 'pinch-grey.png', 1),
(55, ':D', 'laughing.png', 'laughing-grey.png', 0),
(56, ':-D', 'laughing.png', 'laughing-grey.png', 0),
(57, ':grin:', 'laughing.png', 'laughing-grey.png', 0),
(58, ':laugh:', 'laughing.png', 'laughing-grey.png', 0),
(59, ':|', 'neutral.png', 'neutral-grey.png', 0),
(60, ':-|', 'neutral.png', 'neutral-grey.png', 0),
(61, ':neutral:', 'neutral.png', 'neutral-grey.png', 0),
(62, ':mrgreen:', 'mrgreen.png', 'mrgreen-grey.png', 0),
(63, ':?:', 'question.png', 'question-grey.png', 0),
(64, ':!:', 'exclamation.png', 'exclamation-grey.png', 0),
(65, ':arrow:', 'arrow.png', 'arrow-grey.png', 0),
(66, ':idea:', 'idea.png', 'idea-grey.png', 0);

DROP TABLE IF EXISTS `#__kunena_thankyou`;
CREATE TABLE IF NOT EXISTS `#__kunena_thankyou` (
  `postid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `targetuserid` int(11) NOT NULL,
  `time` datetime NOT NULL,
  UNIQUE KEY `postid` (`postid`,`userid`),
  KEY `userid` (`userid`),
  KEY `targetuserid` (`targetuserid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_thankyou` (`postid`, `userid`, `targetuserid`, `time`) VALUES
(6, 848, 847, '2014-12-09 10:46:29');

DROP TABLE IF EXISTS `#__kunena_topics`;
CREATE TABLE IF NOT EXISTS `#__kunena_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `subject` tinytext,
  `icon_id` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `attachments` int(11) NOT NULL DEFAULT '0',
  `poll_id` int(11) NOT NULL DEFAULT '0',
  `moved_id` int(11) NOT NULL DEFAULT '0',
  `first_post_id` int(11) NOT NULL DEFAULT '0',
  `first_post_time` int(11) NOT NULL DEFAULT '0',
  `first_post_userid` int(11) NOT NULL DEFAULT '0',
  `first_post_message` text,
  `first_post_guest_name` tinytext,
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `last_post_time` int(11) NOT NULL DEFAULT '0',
  `last_post_userid` int(11) NOT NULL DEFAULT '0',
  `last_post_message` text,
  `last_post_guest_name` tinytext,
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `locked` (`locked`),
  KEY `hold` (`hold`),
  KEY `posts` (`posts`),
  KEY `hits` (`hits`),
  KEY `first_post_userid` (`first_post_userid`),
  KEY `last_post_userid` (`last_post_userid`),
  KEY `first_post_time` (`first_post_time`),
  KEY `last_post_time` (`last_post_time`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `#__kunena_topics` (`id`, `category_id`, `subject`, `icon_id`, `locked`, `hold`, `ordering`, `posts`, `hits`, `attachments`, `poll_id`, `moved_id`, `first_post_id`, `first_post_time`, `first_post_userid`, `first_post_message`, `first_post_guest_name`, `last_post_id`, `last_post_time`, `last_post_userid`, `last_post_message`, `last_post_guest_name`, `params`) VALUES
(1, 2, 'Welcome to Kunena!', 0, 0, 0, 0, 1, 9, 0, 0, 0, 1, 1399057228, 317, 'Thank you for choosing Kunena for your community forum needs in Joomla. \r\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \r\nAdditional Kunena Resources\r\nKunena Documentation: [url]http://www.kunena.org/docs[/url] \r\nKunena Support Forum: [url]http://www.kunena.org/forum[/url] \r\nKunena Downloads: [url]http://www.kunena.org/download[/url] \r\nKunena Blog: [url]http://www.kunena.org/blog[/url] \r\nFollow Kunena on Twitter: [url]http://www.kunena.org/twitter[/url]', '', 1, 1399057228, 317, 'Thank you for choosing Kunena for your community forum needs in Joomla. \r\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \r\nAdditional Kunena Resources\r\nKunena Documentation: [url]http://www.kunena.org/docs[/url] \r\nKunena Support Forum: [url]http://www.kunena.org/forum[/url] \r\nKunena Downloads: [url]http://www.kunena.org/download[/url] \r\nKunena Blog: [url]http://www.kunena.org/blog[/url] \r\nFollow Kunena on Twitter: [url]http://www.kunena.org/twitter[/url]', '', ''),
(2, 5, 'General template issues, questions and problems', 0, 0, 0, 0, 4, 15, 0, 0, 0, 2, 1415103771, 846, 'Kunena is the ideal forum extension for Joomla. It''s free, fully integrated, and no bridges or hacks are required.\r\n\r\nWant to know more about the Kunena Project? See how the open source philosophy drives our community, follow our development on GitHub, and how you can participate to make Kunena even better.', 'demo', 5, 1418121786, 847, 'Hi.\r\n\r\nI''m looking to have 1 template for 1 categorie and an other template for all others catégories.\r\nSomeone he already well-considered the problem ?\r\n\r\nRegards.', 'lorem_ipsum', ''),
(3, 6, 'Pellentesque non libero', 0, 0, 0, 0, 2, 3, 0, 0, 0, 6, 1418121957, 847, 'Sed justo felis, lacinia at scelerisque a, semper et ante. Fusce posuere lacus eu mi lacinia et fringilla elit sollicitudin. Maecenas non odio nunc. In ut sollicitudin magna. Sed sit amet tincidunt odio. Mauris pharetra adipiscing urna ut accumsan. Suspendisse nec risus in felis fermentum blandit.\r\n\r\nNam nec lectus ut orci porta volutpat id at purus. Sed sagittis congue dapibus. Proin dolor metus, pharetra ut pulvinar nec, condimentum quis libero. Sed fermentum tortor ac elit tristique vel dapibus sem porta. Suspendisse aliquet posuere ultrices. Proin facilisis libero lacinia erat pretium faucibus. In tortor nunc, posuere eget commodo et, eleifend vel risus.', 'lorem_ipsum', 7, 1418122011, 848, 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam erat volutpat. Pellentesque non libero dui, vitae pharetra urna. Vestibulum accumsan pulvinar magna sed consectetur. Nulla congue condimentum aliquam. Donec non libero lectus, id mollis nisi. Morbi turpis magna, varius in ullamcorper nec, suscipit sagittis nibh. Nam elementum aliquam turpis eget egestas. Cras ligula nisi, interdum et vulputate nec, sagittis a tellus. In hac habitasse platea dictumst. In in sem libero. Fusce cursus, metus eu commodo hendrerit, arcu nibh consequat lectus, nec suscipit eros urna in ipsum. Praesent et enim a nisl commodo sodales non id neque. Ut sodales dignissim massa vitae hendrerit. Sed porttitor purus ut ante fermentum quis mollis velit pellentesque.\r\n\r\nEtiam nisi felis, fermentum vitae ultrices non, euismod in magna. In mattis velit ut eros tristique a congue erat consequat. Suspendisse consequat, justo eu gravida semper, ligula turpis dignissim dolor, vitae lacinia velit metus id libero. Nullam consectetur rhoncus magna, quis pharetra tortor bibendum quis. Curabitur ac ante nisl. Nullam mauris arcu, malesuada eu consectetur non, eleifend quis est. Nullam dictum, leo vulputate elementum porttitor, enim mi posuere augue, id porttitor leo sapien sed libero. Quisque est velit, aliquam bibendum vestibulum eget, tristique a odio.', 'dolor_sit', '');

DROP TABLE IF EXISTS `#__kunena_users`;
CREATE TABLE IF NOT EXISTS `#__kunena_users` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `view` varchar(8) NOT NULL DEFAULT '',
  `signature` text,
  `moderator` int(11) DEFAULT '0',
  `banned` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `posts` int(11) DEFAULT '0',
  `avatar` varchar(255) DEFAULT NULL,
  `karma` int(11) DEFAULT '0',
  `karma_time` int(11) DEFAULT '0',
  `group_id` int(4) DEFAULT '1',
  `uhits` int(11) DEFAULT '0',
  `personalText` tinytext,
  `gender` tinyint(4) NOT NULL DEFAULT '0',
  `birthdate` date NOT NULL DEFAULT '0001-01-01',
  `location` varchar(50) DEFAULT NULL,
  `icq` varchar(50) DEFAULT NULL,
  `aim` varchar(50) DEFAULT NULL,
  `yim` varchar(50) DEFAULT NULL,
  `msn` varchar(50) DEFAULT NULL,
  `skype` varchar(50) DEFAULT NULL,
  `twitter` varchar(50) DEFAULT NULL,
  `facebook` varchar(50) DEFAULT NULL,
  `gtalk` varchar(50) DEFAULT NULL,
  `myspace` varchar(50) DEFAULT NULL,
  `linkedin` varchar(50) DEFAULT NULL,
  `delicious` varchar(50) DEFAULT NULL,
  `friendfeed` varchar(50) DEFAULT NULL,
  `digg` varchar(50) DEFAULT NULL,
  `blogspot` varchar(50) DEFAULT NULL,
  `flickr` varchar(50) DEFAULT NULL,
  `bebo` varchar(50) DEFAULT NULL,
  `websitename` varchar(50) DEFAULT NULL,
  `websiteurl` varchar(50) DEFAULT NULL,
  `rank` tinyint(4) NOT NULL DEFAULT '0',
  `hideEmail` tinyint(1) NOT NULL DEFAULT '1',
  `showOnline` tinyint(1) NOT NULL DEFAULT '1',
  `thankyou` int(11) DEFAULT '0',
  PRIMARY KEY (`userid`),
  KEY `group_id` (`group_id`),
  KEY `posts` (`posts`),
  KEY `uhits` (`uhits`),
  KEY `banned` (`banned`),
  KEY `moderator` (`moderator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_users` (`userid`, `view`, `signature`, `moderator`, `banned`, `ordering`, `posts`, `avatar`, `karma`, `karma_time`, `group_id`, `uhits`, `personalText`, `gender`, `birthdate`, `location`, `icq`, `aim`, `yim`, `msn`, `skype`, `twitter`, `facebook`, `gtalk`, `myspace`, `linkedin`, `delicious`, `friendfeed`, `digg`, `blogspot`, `flickr`, `bebo`, `websitename`, `websiteurl`, `rank`, `hideEmail`, `showOnline`, `thankyou`) VALUES
(55, '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0),
(283, '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0),
(317, '', NULL, 0, NULL, 0, 1, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0),
(741, '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0),
(846, '', '', 0, NULL, 0, 2, NULL, 1, 1435741740, 1, 1, '', 1, '0001-01-01', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 1, 1, 0),
(847, '', NULL, 0, NULL, 0, 3, NULL, 1, 1418121732, 1, 24, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1),
(848, '', NULL, 0, NULL, 0, 1, NULL, 0, 1418121990, 1, 10, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0),
(849, '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0),
(969, '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 0);

DROP TABLE IF EXISTS `#__kunena_users_banned`;
CREATE TABLE IF NOT EXISTS `#__kunena_users_banned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT NULL,
  `ip` varchar(128) DEFAULT NULL,
  `blocked` tinyint(4) NOT NULL DEFAULT '0',
  `expiration` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_time` datetime NOT NULL,
  `reason_private` text,
  `reason_public` text,
  `modified_by` int(11) DEFAULT NULL,
  `modified_time` datetime DEFAULT NULL,
  `comments` text,
  `params` text,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `ip` (`ip`),
  KEY `expiration` (`expiration`),
  KEY `created_time` (`created_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__kunena_user_categories`;
CREATE TABLE IF NOT EXISTS `#__kunena_user_categories` (
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `role` tinyint(4) NOT NULL DEFAULT '0',
  `allreadtime` datetime DEFAULT NULL,
  `subscribed` tinyint(4) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`user_id`,`category_id`),
  KEY `category_subscribed` (`category_id`,`subscribed`),
  KEY `role` (`role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__kunena_user_read`;
CREATE TABLE IF NOT EXISTS `#__kunena_user_read` (
  `user_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `message_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  UNIQUE KEY `user_topic_id` (`user_id`,`topic_id`),
  KEY `category_user_id` (`category_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_user_read` (`user_id`, `topic_id`, `category_id`, `message_id`, `time`) VALUES
(846, 1, 2, 1, 1443626488),
(846, 2, 5, 5, 1444814130),
(847, 2, 5, 5, 1418121885),
(847, 3, 6, 6, 1418121958),
(848, 3, 6, 7, 1418122014);

DROP TABLE IF EXISTS `#__kunena_user_topics`;
CREATE TABLE IF NOT EXISTS `#__kunena_user_topics` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `topic_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  `posts` mediumint(8) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `owner` tinyint(4) NOT NULL DEFAULT '0',
  `favorite` tinyint(4) NOT NULL DEFAULT '0',
  `subscribed` tinyint(4) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  UNIQUE KEY `user_topic_id` (`user_id`,`topic_id`),
  KEY `topic_id` (`topic_id`),
  KEY `posts` (`posts`),
  KEY `owner` (`owner`),
  KEY `favorite` (`favorite`),
  KEY `subscribed` (`subscribed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__kunena_user_topics` (`user_id`, `topic_id`, `category_id`, `posts`, `last_post_id`, `owner`, `favorite`, `subscribed`, `params`) VALUES
(317, 1, 2, 1, 1, 1, 0, 0, ''),
(846, 2, 5, 2, 3, 1, 0, 1, ''),
(847, 2, 5, 2, 5, 0, 0, 1, ''),
(847, 3, 6, 1, 6, 1, 0, 1, ''),
(848, 3, 6, 1, 7, 0, 0, 1, '');

DROP TABLE IF EXISTS `#__kunena_version`;
CREATE TABLE IF NOT EXISTS `#__kunena_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(20) NOT NULL,
  `versiondate` date NOT NULL,
  `installdate` date NOT NULL,
  `build` varchar(20) NOT NULL,
  `versionname` varchar(40) DEFAULT NULL,
  `state` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `#__kunena_version` (`id`, `version`, `versiondate`, `installdate`, `build`, `versionname`, `state`) VALUES
(1, '3.0.5', '2014-03-09', '2014-05-02', '', 'Invecchiato', ''),
(2, '3.0.6', '2014-07-28', '2014-08-05', '', 'Tala', '');

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_image` (`image`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

INSERT INTO `#__languages` (`lang_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 1);

DROP TABLE IF EXISTS `#__loginradius_settings`;
CREATE TABLE IF NOT EXISTS `#__loginradius_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting` varchar(255) NOT NULL,
  `value` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting` (`setting`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=21 ;

INSERT INTO `#__loginradius_settings` (`id`, `setting`, `value`) VALUES
(11, 'fbenable', '1'),
(12, 'logintitle', ''),
(13, 'fbapikey', '930899133604868'),
(14, 'fbapisecret', 'a24c0b46dba2a90abe4bd217ea4dc8e2'),
(15, 'genable', '1'),
(16, 'gapikey', '4ea43331a8b16c6ddb33685fc03635a8'),
(17, 'gapisecret', 'Apmhll5UyD-Llm7-FJRsbWuP'),
(18, 'share', '1'),
(19, 'sharetitle', ''),
(20, 'articles', '');

DROP TABLE IF EXISTS `#__loginradius_users`;
CREATE TABLE IF NOT EXISTS `#__loginradius_users` (
  `id` int(11) DEFAULT NULL,
  `loginradius_id` varchar(255) DEFAULT NULL,
  `provider` varchar(255) DEFAULT NULL,
  `lr_picture` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_path` (`path`(191)),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=535 ;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 341, 0, '*', 0),
(2, 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 0, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'menu', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'menu', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 0, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'menu', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'menu', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 0, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 67, 72, 0, '*', 1),
(8, 'menu', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 0, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 68, 69, 0, '*', 1),
(9, 'menu', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 0, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 70, 71, 0, '*', 1),
(10, 'menu', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 0, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 73, 78, 0, '*', 1),
(11, 'menu', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 74, 75, 0, '*', 1),
(12, 'menu', 'com_messages_read', 'Read Private Message', '', 'Messaging/Read Private Message', 'index.php?option=com_messages', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-read', 0, '', 76, 77, 0, '*', 1),
(13, 'menu', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 79, 84, 0, '*', 1),
(14, 'menu', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 80, 81, 0, '*', 1),
(15, 'menu', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 0, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 82, 83, 0, '*', 1),
(16, 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 0, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 85, 86, 0, '*', 1),
(17, 'menu', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 0, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 87, 88, 0, '*', 1),
(18, 'menu', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', 0, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 89, 94, 0, '*', 1),
(19, 'menu', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', 0, 18, 2, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 90, 91, 0, '*', 1),
(20, 'menu', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 0, 18, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks-cat', 0, '', 92, 93, 0, '*', 1),
(21, 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 0, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 95, 96, 0, '*', 1),
(22, 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 97, 98, 0, '*', 1),
(23, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 0, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 99, 100, 0, '', 1),
(24, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 0, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 101, 102, 0, '*', 1),
(101, 'main-menu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=category&layout=theme3288:category&id=8', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 11, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"0","num_columns":"0","num_links":"0","multi_column_order":"1","show_subcategory_content":"","orderby_pri":"order","orderby_sec":"order","order_date":"","show_pagination":"0","show_pagination_results":"0","show_title":"","link_titles":"0","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"0","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"1","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"fullwidth","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"home","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"2","icemega_width":"100%","icemega_colwidth":"66.5%, 33.5%","icemega_cols_items":"1,1","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 23, 34, 1, '*', 0),
(124, 'kunenamenu', 'Forum', 'forum', '', 'forum', 'index.php?option=com_kunena&view=home&defaultmenu=125', 'component', 1, 1, 1, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"catids":["0"],"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 103, 120, 0, '*', 0),
(125, 'kunenamenu', 'Index', 'index', '', 'forum/index', 'index.php?option=com_kunena&view=category&layout=list&catid=0', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 104, 105, 0, '*', 0),
(126, 'kunenamenu', 'Recent Topics', 'recent', '', 'forum/recent', 'index.php?option=com_kunena&view=topics&mode=replies', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"topics_catselection":"","topics_categories":"","topics_time":720}', 106, 107, 0, '*', 0),
(127, 'kunenamenu', 'New Topic', 'newtopic', '', 'forum/newtopic', 'index.php?option=com_kunena&view=topic&layout=create', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 108, 109, 0, '*', 0),
(128, 'kunenamenu', 'No Replies', 'noreplies', '', 'forum/noreplies', 'index.php?option=com_kunena&view=topics&mode=noreplies', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"topics_catselection":"","topics_categories":"","topics_time":-1}', 110, 111, 0, '*', 0),
(129, 'kunenamenu', 'My Topics', 'mylatest', '', 'forum/mylatest', 'index.php?option=com_kunena&view=topics&layout=user&mode=default', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"topics_catselection":"2","topics_categories":"0","topics_time":-1}', 112, 113, 0, '*', 0),
(130, 'kunenamenu', 'Profile', 'profile', '', 'forum/profile', 'index.php?option=com_kunena&view=user', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"integration":1}', 114, 115, 0, '*', 0),
(131, 'kunenamenu', 'Help', 'help', '', 'forum/help', 'index.php?option=com_kunena&view=misc', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"body":"This help page is a menu item inside [b]Kunena Menu[\\/b], which allows easy navigation in your forum. \\n\\n You can use Joomla Menu Manager to edit items in this menu. Please go to [b]Administration[\\/b] >> [b]Menus[\\/b] >> [b]Kunena Menu[\\/b] >> [b]Help[\\/b] to edit or remove this menu item. \\n\\n In this menu item you can use Plain Text, BBCode or HTML. If you want to bind article into this page, you may use article BBCode (with article id): [code][article=full]123[\\/article][\\/code] \\n\\n If you want to create your own menu for Kunena, please start by creating [b]Home Page[\\/b] first. In that page you can select default menu item, which is shown when you enter to Kunena.","body_format":"bbcode"}', 116, 117, 0, '*', 0),
(132, 'kunenamenu', 'Search', 'search', '', 'forum/search', 'index.php?option=com_kunena&view=search', 'component', 1, 124, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 118, 119, 0, '*', 0),
(134, 'main-menu', 'About', 'about', '', 'about', 'index.php?option=com_content&view=category&layout=theme3288:category&id=9', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"0","num_columns":"0","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"330px","icemega_colwidth":"330px","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 35, 36, 0, '*', 0),
(135, 'main-menu', 'History', 'history', '', 'pages/history', 'index.php?option=com_content&view=category&layout=theme3288:category&id=25', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"10","num_columns":"2","num_links":"","multi_column_order":"1","show_subcategory_content":"","orderby_pri":"order","orderby_sec":"order","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"1","show_item_navigation":"","show_vote":"","show_readmore":"0","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"history","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 44, 45, 0, '*', 0),
(136, 'main-menu', 'Our team', 'our-team', '', 'pages/our-team', 'index.php?option=com_content&view=category&layout=theme3288:category&id=8', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"0","num_columns":"0","num_links":"","multi_column_order":"1","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"0","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"0","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"1","page_heading":"","pageclass_sfx":"team","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"110px","icemega_colwidth":"110px","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 42, 43, 0, '*', 0),
(137, 'main-menu', 'Testimonials', 'testimonials', '', 'pages/testimonials', 'index.php?option=com_content&view=category&layout=theme3288:category&id=28', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"0","num_columns":"0","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"","pageclass_sfx":"testimonials","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 46, 47, 0, '*', 0),
(138, 'main-menu', 'FAQs', 'faqs', '', 'pages/faqs', 'index.php?option=com_content&view=category&layout=theme3288:category&id=27', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"0","num_columns":"","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"0","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"Frequently asked questions","pageclass_sfx":"faqs","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 40, 41, 0, '*', 0),
(142, 'main-menu', 'Contacts', 'contacts', '', 'contacts', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"presentation_style":"plain","show_contact_category":"","show_contact_list":"","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","articles_display_num":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"page_title":"","show_page_heading":"1","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 65, 66, 0, '*', 0),
(148, 'social-media', 'Facebook', '2014-05-03-08-53-37', '', '2014-05-03-08-53-37', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"Facebook","menu-anchor_css":"fa fa-facebook","menu-anchor_rel":"","menu_image":"","menu_text":0,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 11, 12, 0, '*', 0),
(149, 'social-media', 'Google+', '2014-05-03-08-54-19', '', '2014-05-03-08-54-19', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"Google+","menu-anchor_css":"fa fa-google-plus","menu-anchor_rel":"","menu_image":"","menu_text":0,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 15, 16, 0, '*', 0),
(150, 'social-media', 'Twitter', '2014-05-03-08-54-56', '', '2014-05-03-08-54-56', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"Twitter","menu-anchor_css":"fa fa-twitter","menu-anchor_rel":"","menu_image":"","menu_text":0,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 13, 14, 0, '*', 0),
(151, 'social-media', 'Skype', '2014-05-03-08-55-43', '', '2014-05-03-08-55-43', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"Skype","menu-anchor_css":"fa fa-skype hasTooltip","menu_image":"","menu_text":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 17, 18, 0, '*', 0),
(152, 'social-media', 'Instagram', '2014-05-03-08-56-20', '', '2014-05-03-08-56-20', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"Instagram","menu-anchor_css":"fa fa-instagram hasTooltip","menu_image":"","menu_text":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 19, 20, 0, '*', 0),
(153, 'system-menu', 'Archives', 'archives', '', 'archives', 'index.php?option=com_content&view=archive', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"orderby_sec":"rdate","order_date":"published","display_num":"5","filter_field":"","introtext_limit":"10000","show_intro":"","info_block_position":"0","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","link_titles":"1","show_author":"1","link_author":"1","show_create_date":"","show_modify_date":"","show_publish_date":"1","show_item_navigation":"","show_hits":"1","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 121, 122, 0, '*', 0),
(155, 'system-menu', 'Tags', 'tags', '', 'tags', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1}', 123, 154, 0, '*', 0),
(156, 'system-menu', 'motherboard', 'motherboard', '', 'tags/motherboard', 'index.php?option=com_tags&view=tag&id[0]=3&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 124, 125, 0, '*', 0),
(157, 'system-menu', 'chip', 'chip', '', 'tags/chip', 'index.php?option=com_tags&view=tag&id[0]=4&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 126, 127, 0, '*', 0),
(158, 'system-menu', 'computers', 'computers', '', 'tags/computers', 'index.php?option=com_tags&view=tag&id[0]=5&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 128, 129, 0, '*', 0),
(159, 'system-menu', 'tablets', 'tablets', '', 'tags/tablets', 'index.php?option=com_tags&view=tag&id[0]=6&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 132, 133, 0, '*', 0),
(160, 'system-menu', 'laptops', 'laptops', '', 'tags/laptops', 'index.php?option=com_tags&view=tag&id[0]=7&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 130, 131, 0, '*', 0),
(161, 'system-menu', 'usb-devices', 'usb-devices', '', 'tags/usb-devices', 'index.php?option=com_tags&view=tag&id[0]=8&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 134, 135, 0, '*', 0),
(162, 'system-menu', 'keyboards & mice', 'keyboards-mice', '', 'tags/keyboards-mice', 'index.php?option=com_tags&view=tag&id[0]=9&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 136, 137, 0, '*', 0),
(163, 'system-menu', 'hard drives', 'hard-drives', '', 'tags/hard-drives', 'index.php?option=com_tags&view=tag&id[0]=10&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 138, 139, 0, '*', 0),
(164, 'system-menu', 'system units', 'system-units', '', 'tags/system-units', 'index.php?option=com_tags&view=tag&id[0]=11&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 140, 141, 0, '*', 0),
(165, 'system-menu', 'storage', 'storage', '', 'tags/storage', 'index.php?option=com_tags&view=tag&id[0]=12&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 142, 143, 0, '*', 0),
(166, 'system-menu', 'printers', 'printers', '', 'tags/printers', 'index.php?option=com_tags&view=tag&id[0]=13&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 144, 145, 0, '*', 0),
(167, 'system-menu', 'software', 'software', '', 'tags/software', 'index.php?option=com_tags&view=tag&id[0]=14&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 146, 147, 0, '*', 0),
(168, 'system-menu', 'accessories', 'accessories', '', 'tags/accessories', 'index.php?option=com_tags&view=tag&id[0]=15&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 148, 149, 0, '*', 0),
(169, 'system-menu', 'parts', 'qwuu', '', 'tags/qwuu', 'index.php?option=com_tags&view=tag&id[0]=16&types[0]=1', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"c.core_publish_up","tag_list_orderby_direction":"ASC","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"0","show_pagination_limit":"0","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"Blog","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 150, 151, 0, '*', 0),
(170, 'system-menu', 'Template settings', 'template-settings', '', 'template-settings', 'index.php?option=com_content&view=article&id=57', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"template_settings","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 155, 156, 0, '*', 0),
(171, 'main-menu', 'Template settings', '2014-05-03-11-32-48', '', 'pages/2014-05-03-11-32-48', 'index.php?Itemid=', 'alias', 1, 335, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"170","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 58, 59, 0, '*', 0),
(172, 'system-menu', 'Username reminder request', 'username-reminder-request', '', 'username-reminder-request', 'index.php?option=com_users&view=remind', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 157, 158, 0, '*', 0),
(173, 'system-menu', 'Password reset', 'password-reset', '', 'password-reset', 'index.php?option=com_users&view=reset', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 159, 160, 0, '*', 0),
(174, 'system-menu', 'User registration', 'user-registration', '', 'user-registration', 'index.php?option=com_users&view=registration', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 161, 162, 0, '*', 0),
(175, 'system-menu', 'Login form', 'login-form', '', 'login-form', 'index.php?option=com_users&view=login', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"login_redirect_url":"","logindescription_show":"1","login_description":"","login_image":"","logout_redirect_url":"","logoutdescription_show":"1","logout_description":"","logout_image":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 163, 164, 0, '*', 0),
(176, 'system-menu', 'Privacy policy', 'privacy-policy', '', 'privacy-policy', 'index.php?option=com_content&view=article&id=6', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"0","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"privacy_policy","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 165, 166, 0, '*', 0),
(177, 'main', 'COM_KUNENA', 'com-kunena', '', 'com-kunena', 'index.php?option=com_kunena', 'component', 0, 1, 1, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-logo-white.png', 0, '', 167, 190, 0, '', 1),
(178, 'main', 'COM_KUNENA_DASHBOARD', 'com-kunena-dashboard', '', 'com-kunena/com-kunena-dashboard', 'index.php?option=com_kunena&view=cpanel', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-logo-white.png', 0, '', 168, 169, 0, '', 1),
(179, 'main', 'COM_KUNENA_CATEGORY_MANAGER', 'com-kunena-category-manager', '', 'com-kunena/com-kunena-category-manager', 'index.php?option=com_kunena&view=categories', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-categories.png', 0, '', 170, 171, 0, '', 1),
(180, 'main', 'COM_KUNENA_USER_MANAGER', 'com-kunena-user-manager', '', 'com-kunena/com-kunena-user-manager', 'index.php?option=com_kunena&view=users', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-users.png', 0, '', 172, 173, 0, '', 1),
(181, 'main', 'COM_KUNENA_FILE_MANAGER', 'com-kunena-file-manager', '', 'com-kunena/com-kunena-file-manager', 'index.php?option=com_kunena&view=attachments', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-files.png', 0, '', 174, 175, 0, '', 1),
(182, 'main', 'COM_KUNENA_EMOTICON_MANAGER', 'com-kunena-emoticon-manager', '', 'com-kunena/com-kunena-emoticon-manager', 'index.php?option=com_kunena&view=smilies', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-smileys.png', 0, '', 176, 177, 0, '', 1),
(183, 'main', 'COM_KUNENA_RANK_MANAGER', 'com-kunena-rank-manager', '', 'com-kunena/com-kunena-rank-manager', 'index.php?option=com_kunena&view=ranks', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-ranks.png', 0, '', 178, 179, 0, '', 1),
(184, 'main', 'COM_KUNENA_TEMPLATE_MANAGER', 'com-kunena-template-manager', '', 'com-kunena/com-kunena-template-manager', 'index.php?option=com_kunena&view=templates', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-templates.png', 0, '', 180, 181, 0, '', 1),
(185, 'main', 'COM_KUNENA_CONFIGURATION', 'com-kunena-configuration', '', 'com-kunena/com-kunena-configuration', 'index.php?option=com_kunena&view=config', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-prune.png', 0, '', 182, 183, 0, '', 1),
(186, 'main', 'COM_KUNENA_PLUGIN_MANAGER', 'com-kunena-plugin-manager', '', 'com-kunena/com-kunena-plugin-manager', 'index.php?option=com_kunena&view=plugins', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-plugins.png', 0, '', 184, 185, 0, '', 1),
(187, 'main', 'COM_KUNENA_FORUM_TOOLS', 'com-kunena-forum-tools', '', 'com-kunena/com-kunena-forum-tools', 'index.php?option=com_kunena&view=tools', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-config.png', 0, '', 186, 187, 0, '', 1),
(188, 'main', 'COM_KUNENA_TRASH_MANAGER', 'com-kunena-trash-manager', '', 'com-kunena/com-kunena-trash-manager', 'index.php?option=com_kunena&view=trash', 'component', 0, 177, 2, 10019, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-trash.png', 0, '', 188, 189, 0, '', 1),
(203, 'main-menu', 'Gallery', 'gallery', '', 'gallery', 'index.php?option=com_joomgallery&view=category&catid=2', 'component', 1, 1, 1, 10032, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"disable_global_info":"0","menu-anchor_title":"","menu-anchor_css":"gallery","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"3","icemega_width":"100%","icemega_colwidth":"20%, 80%, 100%","icemega_cols_items":"6, 1, 1","icemega_subtype":"menu"}', 63, 64, 0, '*', 0),
(204, 'system-menu', '404 Page', '404', '', '404', 'index.php?option=com_content&view=article&id=65', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"404","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 191, 192, 0, '*', 0),
(215, 'main', 'COM_SOCIALLOGINANDSOCIALSHARE', 'com-socialloginandsocialshare', '', 'com-socialloginandsocialshare', 'index.php?option=com_socialloginandsocialshare', 'component', 0, 1, 1, 10037, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_socialloginandsocialshare/images/favicon.png', 0, '', 193, 194, 0, '', 1);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(280, 'social-media', 'Vimeo', '2015-01-05-08-40-38', '', '2015-01-05-08-40-38', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"Vimeo","menu-anchor_css":"fa fa-vimeo-square hasTooltip","menu_image":"","menu_text":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 21, 22, 0, '*', 0),
(283, 'main-menu', 'Portfolio', 'portfolio', '', 'pages/portfolio', 'index.php?option=com_content&view=category&layout=theme3288:gallery&id=31', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"10","num_columns":"3","num_links":"","multi_column_order":"1","show_subcategory_content":"","show_filter":"0","show_sort":"1","sort_effects":"","show_layout_mode":"0","image_float":"use_article","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"1","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","user_hover":"0","hover_style":"style1","limt_introtext":"0","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"","pageclass_sfx":"works","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"80px","icemega_colwidth":"80px","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchors":"404-search","icemega_anchorsmenuitem":"124"}', 54, 55, 0, '*', 0),
(285, 'main-menu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_content&view=category&layout=blog&id=11', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"3","num_intro_articles":"0","num_columns":"0","num_links":"","multi_column_order":"1","show_subcategory_content":"","orderby_pri":"none","orderby_sec":"rdate","order_date":"","show_pagination":"2","show_pagination_results":"","show_featured":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"1","link_category":"1","show_parent_category":"","link_parent_category":"","show_author":"1","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"1","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"1","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"1","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchors":"mainbottom-5","icemega_anchorsmenuitem":"101"}', 61, 62, 0, '*', 0),
(305, 'main-menu', 'Site map', 'site-map', '', 'pages/site-map', 'index.php?option=com_content&view=category&layout=theme3288:category&id=2', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"0","num_columns":"0","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"site_map","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 48, 49, 0, '*', 0),
(309, 'what-we-offer', 'customer-friendly service', '2015-01-20-16-07-15', '', '2015-01-20-16-07-15', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 195, 196, 0, '*', 0),
(310, 'what-we-offer', '100% satisfaction', '2015-01-20-16-07-34', '', '2015-01-20-16-07-34', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 197, 198, 0, '*', 0),
(311, 'what-we-offer', 'quality guarantee', '2015-01-20-16-07-53', '', '2015-01-20-16-07-53', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 199, 200, 0, '*', 0),
(312, 'what-we-offer', 'reliability', '2015-01-20-16-08-12', '', '2015-01-20-16-08-12', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 201, 202, 0, '*', 0),
(317, 'requirements', 'B.Tech./ B.E / MCA degree in Computer Science, Engineering or a related stream.', 'b-tech-b-e-mca-degree-in-computer-science-engineering-or-a-related-stream', '', 'b-tech-b-e-mca-degree-in-computer-science-engineering-or-a-related-stream', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 203, 204, 0, '*', 0),
(318, 'requirements', '3+ years of software development experience.', '3-years-of-software-development-experience', '', '3-years-of-software-development-experience', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 205, 206, 0, '*', 0),
(319, 'requirements', '3+ years of Python / Java development projects experience.', '3-years-of-python-java-development-projects-experience', '', '3-years-of-python-java-development-projects-experience', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 207, 208, 0, '*', 0),
(320, 'requirements', 'Minimum of 4 live project roll outs.', 'minimum-of-4-live-project-roll-outs', '', 'minimum-of-4-live-project-roll-outs', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 209, 210, 0, '*', 0),
(321, 'requirements', 'Experience with third-party libraries and APIs.', 'experience-with-third-party-libraries-and-apis', '', 'experience-with-third-party-libraries-and-apis', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 211, 212, 0, '*', 0),
(322, 'requirements', 'In depth understanding and experience of either SDLC or PDLC.', 'in-depth-understanding-and-experience-of-either-sdlc-or-pdlc', '', 'in-depth-understanding-and-experience-of-either-sdlc-or-pdlc', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 213, 214, 0, '*', 0),
(323, 'requirements', 'Good Communication Skills', 'good-communication-skills', '', 'good-communication-skills', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 215, 216, 0, '*', 0),
(324, 'requirements', 'Team Player', 'team-player', '', 'team-player', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 217, 218, 0, '*', 0),
(325, 'what-we-expect-from-you', 'Design and build applications/ components using open source technology.', 'design-and-build-applications-components-using-open-source-technology', '', 'design-and-build-applications-components-using-open-source-technology', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 219, 220, 0, '*', 0),
(326, 'what-we-expect-from-you', 'Taking complete ownership of the deliveries assigned.', 'taking-complete-ownership-of-the-deliveries-assigned', '', 'taking-complete-ownership-of-the-deliveries-assigned', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 221, 222, 0, '*', 0),
(327, 'what-we-expect-from-you', 'Collaborate with cross-functional teams to define, design, and ship new features.', 'collaborate-with-cross-functional-teams-to-define-design-and-ship-new-features', '', 'collaborate-with-cross-functional-teams-to-define-design-and-ship-new-features', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 223, 224, 0, '*', 0),
(328, 'what-we-expect-from-you', 'Work with outside data sources and API''s.', 'work-with-outside-data-sources-and-api-s', '', 'work-with-outside-data-sources-and-api-s', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 225, 226, 0, '*', 0),
(329, 'what-we-expect-from-you', 'Unit-test code for robustness, including edge cases, usability, and general reliability.', 'unit-test-code-for-robustness-including-edge-cases-usability-and-general-reliability', '', 'unit-test-code-for-robustness-including-edge-cases-usability-and-general-reliability', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 227, 228, 0, '*', 0),
(330, 'what-we-expect-from-you', 'Work on bug fixing and improving application performance.', 'work-on-bug-fixing-and-improving-application-performance', '', 'work-on-bug-fixing-and-improving-application-performance', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 229, 230, 0, '*', 0),
(331, 'user-menu', 'Login form', '2015-01-26-09-48-59', '', '2015-01-26-09-48-59', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 5, '', 0, '{"aliasoptions":"175","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 231, 232, 0, '*', 0),
(332, 'user-menu', 'User profile', 'user-profile', '', 'user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 233, 234, 0, '*', 0),
(333, 'user-menu', 'Create account', '2015-01-26-09-53-51', '', '2015-01-26-09-53-51', 'index.php?Itemid=', 'alias', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 5, '', 0, '{"aliasoptions":"174","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 235, 236, 0, '*', 0),
(334, 'user-menu', 'Create article', 'create-article', '', 'create-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"enable_category":"1","catid":"11","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 237, 238, 0, '*', 0),
(335, 'main-menu', 'Pages', 'pages', '', 'pages', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_css":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"200px","icemega_colwidth":"200px","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 37, 60, 0, '*', 0),
(336, 'main-menu', 'Pricing', 'pricing', '', 'pages/pricing', 'index.php?option=com_content&view=category&layout=theme3288:category&id=32', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"0","num_columns":"0","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 38, 39, 0, '*', 0),
(342, 'main-menu', 'Forum', '2015-02-25-09-04-57', '', 'pages/2015-02-25-09-04-57', 'index.php?Itemid=124', 'alias', 1, 335, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"124","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 50, 51, 0, '*', 0),
(343, 'main-menu', 'Careers', 'careers', '', 'pages/careers', 'index.php?option=com_content&view=category&layout=theme3288:category&id=46', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 10, '{"layout_type":"blog","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","page_subheading":"","num_leading_articles":"0","num_intro_articles":"4","num_columns":"1","num_links":"0","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"0","show_intro":"","info_block_position":"0","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"careers","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 52, 53, 0, '*', 0),
(347, 'main-menu', 'Categories', '2015-01-20-16-06-33', '', 'home/2015-01-20-16-06-33', '#', 'url', -2, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"","icemega_subtype":"mod","icemega_modules":["155"],"icemega_anchorsmenuitem":"124"}', 24, 25, 0, '*', 0),
(348, 'main-menu', 'Packages', '2015-01-21-15-29-13', '', 'home/2015-01-21-15-29-13', '#', 'url', -2, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"","icemega_subtype":"mod","icemega_modules":["178"]}', 32, 33, 0, '*', 0),
(349, 'main-menu', 'What we offer', '2015-01-21-07-27-49', '', 'home/2015-01-21-07-27-49', '#', 'url', -2, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"","icemega_subtype":"mod","icemega_modules":["156"],"icemega_anchorsmenuitem":"124"}', 26, 27, 0, '*', 0),
(402, 'system-menu', 'Pintex', 'welcome', '', 'welcome', 'index.php?option=com_content&view=article&id=1', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"1","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 239, 240, 0, '*', 0),
(416, 'what-we-do', 'influence policy decisions in favor of customers', '2015-02-17-20-38-27', '', '2015-02-17-20-38-27', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 241, 242, 0, '*', 0),
(417, 'what-we-do', 'support and expand efforts to fill these gaps', '2015-02-17-20-39-08', '', '2015-02-17-20-39-08', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 243, 244, 0, '*', 0),
(418, 'what-we-do', 'highlight the chronic and continuing gaps in the related data', '2015-02-17-20-39-31', '', '2015-02-17-20-39-31', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 245, 246, 0, '*', 0),
(419, 'what-we-do', 'monitor the changing business situation', '2015-02-17-20-39-53', '', '2015-02-17-20-39-53', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 247, 248, 0, '*', 0),
(422, 'system-menu', 'Search', 'search', '', 'search', 'index.php?option=com_search&view=search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"search_areas":"0","show_date":"0","searchphrase":"0","ordering":"newest","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 249, 250, 0, '*', 0),
(423, 'main-menu', 'Services', '2015-02-17-20-50-08', '', 'home/2015-02-17-20-50-08', '#', 'url', 1, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"","icemega_subtype":"mod","icemega_modules":["226"],"icemega_anchorsmenuitem":"525"}', 28, 29, 0, '*', 0),
(424, 'main-menu', 'About', '2015-02-17-20-57-33', '', 'home/2015-02-17-20-57-33', '#', 'url', 1, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"","icemega_subtype":"mod","icemega_modules":["227"],"icemega_anchorsmenuitem":"124"}', 30, 31, 0, '*', 0),
(425, 'system-menu', 'About', 'about-3', '', 'about-3', 'index.php?option=com_content&view=article&id=117', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 251, 252, 0, '*', 0),
(426, 'main-menu', 'Elements', 'elements', '', 'pages/elements', 'index.php?option=com_content&view=article&id=121', 'component', 1, 335, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"elements","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu"}', 56, 57, 0, '*', 0),
(437, 'main-menu', 'Search', '2015-04-24-07-44-18', '', '2015-04-24-07-44-18', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"menu-search","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"1","icemega_subtype":"menu","icemega_modules":[],"icemega_positions":[],"icemega_anchorsmenuitem":"124"}', 253, 256, 0, '*', 0),
(438, 'main-menu', 'Login or register', '2015-04-24-08-31-28', '', '2015-07-10-07-16-24/2015-04-24-08-31-28', '#', 'url', -2, 467, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"330px","icemega_colwidth":"330px","icemega_cols_items":"","icemega_subtype":"mod","icemega_modules":["196"],"icemega_anchorsmenuitem":"124"}', 266, 267, 0, '*', 0),
(439, 'top-menu', 'Login form', '2015-04-24-14-59-37', '', '2015-04-24-14-59-37', '#modal', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 5, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 257, 258, 0, '*', 0),
(440, 'top-menu', 'User profile', 'user-profile-2', '', 'user-profile-2', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 259, 260, 0, '*', 0),
(441, 'top-menu', 'Create account', '2015-04-27-07-43-33', '', '2015-04-27-07-43-33', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 5, '', 0, '{"aliasoptions":"174","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 261, 262, 0, '*', 0),
(442, 'top-menu', 'Create article', 'create-article-2', '', 'create-article-2', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{"enable_category":"1","catid":"11","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"0","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 263, 264, 0, '*', 0),
(452, 'system-menu', 'subwoofer', 'lorem', '', 'tags/lorem', 'index.php?option=com_tags&view=tag&id[0]=17&types[0]=1&types[1]=6', 'component', 1, 155, 2, 29, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"show_tag_title":"","tag_list_show_tag_image":"","tag_list_show_tag_description":"","tag_list_image":"","tag_list_description":"","show_tag_num_items":"","tag_list_orderby":"","tag_list_orderby_direction":"","tag_list_show_item_image":"","tag_list_show_item_description":"","tag_list_item_maximum_characters":0,"filter_field":"","show_pagination_limit":"","show_pagination":"","show_pagination_results":"","return_any_or_all":"","include_children":"","maximum":200,"show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":"","page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 152, 153, 0, '*', 0),
(467, 'main-menu', 'Login', '2015-07-10-07-16-24', '', '2015-07-10-07-16-24', '#', 'url', -2, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"menu-login-form","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"330px","icemega_colwidth":"330px","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 265, 268, 0, '*', 0),
(477, 'main-menu', 'Search field', '2015-07-21-08-59-36', '', '2015-04-24-07-44-18/2015-07-21-08-59-36', '#', 'url', -2, 437, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"100%","icemega_colwidth":"100%","icemega_cols_items":"1","icemega_subtype":"mod","icemega_modules":["195"],"icemega_positions":[],"icemega_anchorsmenuitem":"124"}', 254, 255, 0, '*', 0),
(478, 'main', 'COM_JOOMGALLERY', 'com-joomgallery', '', 'com-joomgallery', 'index.php?option=com_joomgallery', 'component', 0, 1, 1, 10032, 0, '0000-00-00 00:00:00', 0, 1, '../media/joomgallery/images/joom_main.png', 0, '', 269, 296, 0, '', 1),
(479, 'main', 'COM_JOOMGALLERY_CATEGORY_MANAGER', 'com-joomgallery-category-manager', '', 'com-joomgallery/com-joomgallery-category-manager', 'index.php?option=com_joomgallery&controller=categories', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_categories.png', 0, '', 270, 271, 0, '', 1),
(480, 'main', 'COM_JOOMGALLERY_IMAGE_MANAGER', 'com-joomgallery-image-manager', '', 'com-joomgallery/com-joomgallery-image-manager', 'index.php?option=com_joomgallery&controller=images', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_pictures.png', 0, '', 272, 273, 0, '', 1),
(481, 'main', 'COM_JOOMGALLERY_COMMENTS_MANAGER', 'com-joomgallery-comments-manager', '', 'com-joomgallery/com-joomgallery-comments-manager', 'index.php?option=com_joomgallery&controller=comments', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_comments.png', 0, '', 274, 275, 0, '', 1),
(482, 'main', 'COM_JOOMGALLERY_IMAGE_UPLOAD', 'com-joomgallery-image-upload', '', 'com-joomgallery/com-joomgallery-image-upload', 'index.php?option=com_joomgallery&controller=upload', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_pictureupload.png', 0, '', 276, 277, 0, '', 1),
(483, 'main', 'COM_JOOMGALLERY_AJAX_UPLOAD', 'com-joomgallery-ajax-upload', '', 'com-joomgallery/com-joomgallery-ajax-upload', 'index.php?option=com_joomgallery&controller=ajaxupload', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_ajaxupload.png', 0, '', 278, 279, 0, '', 1),
(484, 'main', 'COM_JOOMGALLERY_BATCH_UPLOAD', 'com-joomgallery-batch-upload', '', 'com-joomgallery/com-joomgallery-batch-upload', 'index.php?option=com_joomgallery&controller=batchupload', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_batchupload.png', 0, '', 280, 281, 0, '', 1),
(485, 'main', 'COM_JOOMGALLERY_FTP_UPLOAD', 'com-joomgallery-ftp-upload', '', 'com-joomgallery/com-joomgallery-ftp-upload', 'index.php?option=com_joomgallery&controller=ftpupload', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_ftpupload.png', 0, '', 282, 283, 0, '', 1),
(486, 'main', 'COM_JOOMGALLERY_JAVA_UPLOAD', 'com-joomgallery-java-upload', '', 'com-joomgallery/com-joomgallery-java-upload', 'index.php?option=com_joomgallery&controller=jupload', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_jupload.png', 0, '', 284, 285, 0, '', 1),
(487, 'main', 'COM_JOOMGALLERY_CONFIGURATION_MANAGER', 'com-joomgallery-configuration-manager', '', 'com-joomgallery/com-joomgallery-configuration-manager', 'index.php?option=com_joomgallery&controller=config', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_config.png', 0, '', 286, 287, 0, '', 1),
(488, 'main', 'COM_JOOMGALLERY_CUSTOMIZE_CSS', 'com-joomgallery-customize-css', '', 'com-joomgallery/com-joomgallery-customize-css', 'index.php?option=com_joomgallery&controller=cssedit', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_css.png', 0, '', 288, 289, 0, '', 1),
(489, 'main', 'COM_JOOMGALLERY_MIGRATION_MANAGER', 'com-joomgallery-migration-manager', '', 'com-joomgallery/com-joomgallery-migration-manager', 'index.php?option=com_joomgallery&controller=migration', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_migration.png', 0, '', 290, 291, 0, '', 1),
(490, 'main', 'COM_JOOMGALLERY_MAINTENANCE_MANAGER', 'com-joomgallery-maintenance-manager', '', 'com-joomgallery/com-joomgallery-maintenance-manager', 'index.php?option=com_joomgallery&controller=maintenance', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_maintenance.png', 0, '', 292, 293, 0, '', 1),
(491, 'main', 'COM_JOOMGALLERY_HELP', 'com-joomgallery-help', '', 'com-joomgallery/com-joomgallery-help', 'index.php?option=com_joomgallery&controller=help', 'component', 0, 478, 2, 10032, 0, '0000-00-00 00:00:00', 0, 1, 'media/joomgallery/images/joom_information.png', 0, '', 294, 295, 0, '', 1),
(513, 'user-menu', 'Log  Out', '2015-01-26-09-48-60', '', '2015-01-26-09-48-60', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 2, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"#modal","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 297, 298, 0, '*', 0),
(514, 'top-menu', 'Log Out', '2015-04-24-14-59-38', '', '2015-04-24-14-59-38', '#modal', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 2, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 299, 300, 0, '*', 0),
(515, 'main', 'Komento', 'komento', '', 'komento', 'index.php?option=com_komento', 'component', 0, 1, 1, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/komento-favicon.png', 0, '{}', 301, 320, 0, '', 1),
(516, 'main', 'COM_KOMENTO_MENU_COMMENTS', 'com-komento-menu-comments', '', 'komento/com-komento-menu-comments', 'index.php?option=com_komento&view=comments', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/comments-favicon.png', 0, '{}', 302, 303, 0, '', 1),
(517, 'main', 'COM_KOMENTO_MENU_PENDINGS', 'com-komento-menu-pendings', '', 'komento/com-komento-menu-pendings', 'index.php?option=com_komento&view=pending', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/pending-favicon.png', 0, '{}', 304, 305, 0, '', 1),
(518, 'main', 'COM_KOMENTO_MENU_REPORTS', 'com-komento-menu-reports', '', 'komento/com-komento-menu-reports', 'index.php?option=com_komento&view=reports', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/reports-favicon.png', 0, '{}', 306, 307, 0, '', 1),
(519, 'main', 'COM_KOMENTO_MENU_SUBSCRIBERS', 'com-komento-menu-subscribers', '', 'komento/com-komento-menu-subscribers', 'index.php?option=com_komento&view=subscribers', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/subscribers-favicon.png', 0, '{}', 308, 309, 0, '', 1),
(520, 'main', 'COM_KOMENTO_MENU_INTEGRATIONS', 'com-komento-menu-integrations', '', 'komento/com-komento-menu-integrations', 'index.php?option=com_komento&view=integrations', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/integrations-favicon.png', 0, '{}', 310, 311, 0, '', 1),
(521, 'main', 'COM_KOMENTO_MENU_CONFIGURATION', 'com-komento-menu-configuration', '', 'komento/com-komento-menu-configuration', 'index.php?option=com_komento&view=system', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/system-favicon.png', 0, '{}', 312, 313, 0, '', 1),
(522, 'main', 'COM_KOMENTO_MENU_ACL', 'com-komento-menu-acl', '', 'komento/com-komento-menu-acl', 'index.php?option=com_komento&view=acl', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/acls-favicon.png', 0, '{}', 314, 315, 0, '', 1),
(523, 'main', 'COM_KOMENTO_MENU_MIGRATORS', 'com-komento-menu-migrators', '', 'komento/com-komento-menu-migrators', 'index.php?option=com_komento&view=migrators', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/migrators-favicon.png', 0, '{}', 316, 317, 0, '', 1),
(524, 'main', 'COM_KOMENTO_MENU_MAILQ', 'com-komento-menu-mailq', '', 'komento/com-komento-menu-mailq', 'index.php?option=com_komento&view=mailq', 'component', 0, 515, 2, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_komento/assets/images/mailq-favicon.png', 0, '{}', 318, 319, 0, '', 1),
(525, 'address', '4578 Marmora Road, Glasgow D04 89GR', '2016-06-10-06-40-30', '', '2016-06-10-06-40-30', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"material-design-map103","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"124"}', 321, 322, 0, '*', 0),
(526, 'telephones', '800-2345-6790', '2016-06-10-06-41-17', '', '2016-06-10-06-41-17', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"material-design-phone370","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 323, 324, 0, '*', 0),
(527, 'telephones', '800-2345-6789', '2016-06-10-06-41-46', '', '2016-06-10-06-41-46', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"material-design-phone370","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 325, 326, 0, '*', 0),
(528, 'work-time', '24/7', '24-7', '', '24-7', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"material-design-clock100","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 327, 328, 0, '*', 0),
(529, 'services', 'COMPUTER DIAGNOSTICS', '2016-06-10-11-20-47', '', '2016-06-10-11-20-47', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 329, 330, 0, '*', 0),
(530, 'services', 'COMPLETE SAFETY ANALYSIS', '2016-06-10-11-20-48', '', '2016-06-10-11-20-48', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 331, 332, 0, '*', 0),
(531, 'services', 'DRIVABILITY PROBLEMS', '2016-06-10-11-20-49', '', '2016-06-10-11-20-49', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 333, 334, 0, '*', 0),
(532, 'services', 'TUNE-UPS', '2016-06-10-11-20-50', '', '2016-06-10-11-20-50', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 335, 336, 0, '*', 0),
(533, 'services', 'OIL CHANGES', '2016-06-10-11-20-51', '', '2016-06-10-11-20-51', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 337, 338, 0, '*', 0),
(534, 'services', 'TIRES', '2016-06-10-11-20-52', '', '2016-06-10-11-20-52', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu-anchor_rel":"","menu_image":"","menu_text":1,"menu_show":1,"icemega_subtitle":"","icemega_cols":"1","icemega_width":"","icemega_colwidth":"","icemega_cols_items":"","icemega_subtype":"menu","icemega_anchorsmenuitem":"525"}', 339, 340, 0, '*', 0);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=23 ;

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES
(2, 'kunenamenu', 'Kunena Menu', 'This is the default Kunena menu. It is used as the top navigation for Kunena. It can be publish in any module position. Simply unpublish items that are not required.'),
(3, 'system-menu', 'System Menu', ''),
(5, 'social-media', 'Social Media', ''),
(12, 'main-menu', 'Main menu', ''),
(13, 'what-we-offer', 'What we offer', ''),
(14, 'requirements', 'Requirements', ''),
(15, 'what-we-expect-from-you', 'What we Expect from you?', ''),
(16, 'user-menu', 'User menu', ''),
(17, 'what-we-do', 'What we do', ''),
(18, 'top-menu', 'Top menu', ''),
(19, 'address', 'Address', ''),
(20, 'telephones', 'Telephones', ''),
(21, 'work-time', 'Work time', ''),
(22, 'services', 'Services', '');

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

INSERT INTO `#__messages` (`message_id`, `user_id_from`, `user_id_to`, `folder_id`, `date_time`, `state`, `priority`, `subject`, `message`) VALUES
(1, 846, 910, 0, '2014-09-05 13:25:12', 0, 0, 'An image has been downloaded', 'The image with the title Suspendisse (Filename: first_category_1_20140903_1689763756.jpg) has been downloaded by Guest!'),
(2, 322, 322, 0, '2014-12-09 09:39:28', -2, 0, 'New Comment', 'A new comment from Guest has been submitted. This comment needs to be approved before it can be published.'),
(5, 729, 729, 0, '2015-01-26 14:38:33', 0, 0, 'New Comment', 'A new comment from ejhjkesh has been submitted. This comment needs to be approved before it can be published.'),
(6, 729, 729, 0, '2015-01-26 14:39:10', 0, 0, 'New Comment', 'A new comment from ejhjkesh has been submitted. This comment needs to be approved before it can be published.'),
(7, 729, 729, 0, '2015-01-29 07:56:07', 0, 0, 'New Comment', 'A new comment from dbdrt has been submitted. This comment needs to be approved before it can be published.'),
(8, 729, 729, 0, '2015-01-29 07:56:57', 0, 0, 'New Comment', 'A new comment from rgdrvdr has been submitted. This comment needs to be approved before it can be published.'),
(9, 729, 729, 0, '2015-01-29 08:02:40', 0, 0, 'New Comment', 'A new comment from 65rd has been submitted. This comment needs to be approved before it can be published.'),
(10, 729, 729, 0, '2015-01-29 08:03:29', 0, 0, 'New Comment', 'A new comment from vsrtdrtrd has been submitted. This comment needs to be approved before it can be published.'),
(12, 504, 504, 0, '2015-07-13 07:37:14', 0, 0, 'New Comment', 'A new comment from xcz has been submitted. This comment needs to be approved before it can be published.');

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=233 ;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 56, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 57, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(4, 58, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(8, 59, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 60, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 61, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(12, 62, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 63, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 64, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 65, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 68, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{"layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(86, 69, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(94, 62, 'Recent templates', '', '', 5, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_templates', 1, 1, '', 1, '*'),
(97, 146, 'Social media', '', '', 4, 'footer', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"social-media","base":"","startLevel":"1","endLevel":"0","showAllChildren":"0","tag_id":"","class_sfx":"social","window_open":"","layout":"theme3288:social","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"4","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(103, 167, 'Search', '', '', 0, '404-search', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{"label":"","width":"20","text":"","button":"1","button_pos":"right","imagebutton":"0","button_text":"","opensearch":"1","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(104, 168, 'JoomGallery News', '', '', 1, 'joom_cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_feed', 1, 1, 'cache=1\n    cache_time=15\n    moduleclass_sfx=\n    rssurl=http://www.en.joomgallery.net/feed/rss.html\n    rssrtl=0\n    rsstitle=1\n    rssdesc=0\n    rssimage=1\n    rssitems=3\n    rssitemdesc=1\n    word_count=200', 1, '*'),
(107, 202, 'Login or register', '', '', 1, 'fixed-sidebar-right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_socialloginandsocialshare', 1, 0, '{"layout":"theme3288:right-sidebar-fixed","moduleclass_sfx":"login login_shell","module_tag":"div","bootstrap_size":"0","header_tag":"h5","header_class":"","style":"0"}', 0, '*'),
(115, 210, 'TM Ajax Contact Form', '', '', 1, 'contact-form', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_ajax_contact_form', 1, 0, '{"pretext":"","fields_list":"{\\"label\\":[\\"Name\\",\\"Email\\",\\"Phone\\",\\"Message\\"],\\"name\\":[\\"name\\",\\"email\\",\\"phone\\",\\"message\\"],\\"type\\":[\\"text\\",\\"email\\",\\"text\\",\\"textarea\\"],\\"options_list\\":[\\"{\\\\\\"option_name\\\\\\":[],\\\\\\"option_value\\\\\\":[]}\\",\\"\\",\\"\\",\\"\\"],\\"title\\":[\\"\\",\\"\\",\\"\\",\\"\\"],\\"req\\":[\\"1\\",\\"1\\",\\"0\\",\\"1\\"],\\"bootstrap_size\\":[\\"4\\",\\"4\\",\\"4\\",\\"12\\"]}","admin_email":"admin@admin.com","cc_email":"","bcc_email":"","success_notify":"Thank You! Your message has been sent.","failure_notify":"Something went wrong, please try again later.","captcha_failure_notify":"Please enter a correct Captcha answer.","captcha_req":"0","reset_publish":"1","br_name":"Clear","bs_name":"Send","labels_pos":"1","moduleclass_sfx":"","layout":"_:default","module_tag":"div","bootstrap_size":"12","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(118, 289, 'Detailed', '', '', 14, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["35"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"0","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"right","image":"0","readmore":"1","layout":"theme3288:pricing-table","masonry":"0","moduleclass_sfx":"pricing_detailed","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(122, 310, 'Simple', '', '', 22, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["36"],"show_child_category_articles":"0","levels":"1","count":"3","columns":"3","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"0","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"right","image":"0","readmore":"1","layout":"theme3288:pricing-table","masonry":"0","moduleclass_sfx":"pricing_simple","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(124, 313, 'Main menu', '', '', 1, 'header', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_icemegamenu', 1, 0, '{"theme_style":"default","vertical_direction":"right","menutype":"main-menu","startLevel":"1","endLevel":"0","showAllChildren":"1","resizable_menu":"1","class_sfx":"","window_open":"","tag_id":"","moduleclass_sfx":"home_menu","cache":"1","cache_time":"30","module_tag":"nav","bootstrap_size":"8","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(134, 335, 'Address', '', '<p><i class="material-design-map103"></i> 4578 Marmora Road, Glasgow D04 89GR</p>\r\n<p><i class="material-design-phone370"></i> 800-2345-6790 &nbsp; &nbsp; 800-2345-6789</p>\r\n<p><i class="material-design-clock100"></i> Mon-Sun 0:00 am to 0:00 pm</p>', 3, 'footer', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"address","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"4","header_tag":"h5","header_class":"","style":"0"}', 0, '*'),
(141, 344, 'Map', '', '{mosmap}', 1, 'map', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(142, 345, 'Counters', 'For "Elements" page', '', 20, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["33"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"","item_heading":"h6","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:counters","masonry":"0","moduleclass_sfx":"counters","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(144, 347, 'Progress Bars', 'For "Elements" page', '', 18, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["60"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"0","link_titles":"0","item_heading":"h6","show_introtext":"0","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:progbar-circle","masonry":"0","moduleclass_sfx":"progbars_circle","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(145, 348, 'Accordion 1', 'For "Elements" page', '', 4, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{"catid":["18"],"count":"3","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"custom","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"6","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(149, 356, 'Testimonials', '', '', 15, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["28"],"show_child_category_articles":"0","levels":"1","count":"100","columns":"3","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"0","item_heading":"h5","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:testimonials","masonry":"0","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(153, 364, 'Meet', '', '', 1, 'mainbottom-2', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["26"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"our team","item_title":"1","link_titles":"1","item_heading":"h6","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(159, 377, 'Careers accordion', '', '', 1, 'careers-accordion-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{"catid":["47"],"count":"3","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(160, 380, 'Apply now', '', '', 1, 'aside-right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_ajax_contact_form', 1, 1, '{"pretext":"Nemo, natus voluptatibus adipisci porro magni dolore eos eius ducimus corporis.","fields_list":"{\\"label\\":[\\"Name\\",\\"Last Name\\",\\"Email\\",\\"Age\\",\\"City\\",\\"Position\\",\\"Expected Salary\\",\\"Start Date\\",\\"Website\\",\\"Experience\\",\\"Application\\"],\\"name\\":[\\"name\\",\\"lastname\\",\\"email\\",\\"age\\",\\"city\\",\\"position\\",\\"salary\\",\\"date\\",\\"website\\",\\"experience\\",\\"application\\"],\\"type\\":[\\"text\\",\\"text\\",\\"email\\",\\"text\\",\\"text\\",\\"select\\",\\"text\\",\\"text\\",\\"text\\",\\"textarea\\",\\"textarea\\"],\\"options_list\\":[\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"{\\\\\\"option_name\\\\\\":[\\\\\\"Lorem ipsum dolor sit amet\\\\\\",\\\\\\"Etiam in neque non sapien lobortis\\\\\\",\\\\\\"Porro magni dolore eos eius ducimus\\\\\\",\\\\\\"Vestibulum commodo mollis\\\\\\"],\\\\\\"option_value\\\\\\":[\\\\\\"Lorem ipsum dolor sit amet\\\\\\",\\\\\\"Etiam in neque non sapien lobortis\\\\\\",\\\\\\"Porro magni dolore eos eius ducimus\\\\\\",\\\\\\"Vestibulum commodo mollis\\\\\\"]}\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\"],\\"title\\":[\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\",\\"\\"],\\"req\\":[\\"1\\",\\"1\\",\\"1\\",\\"1\\",\\"1\\",\\"0\\",\\"1\\",\\"0\\",\\"0\\",\\"0\\",\\"1\\"],\\"bootstrap_size\\":[\\"6\\",\\"6\\",\\"12\\",\\"6\\",\\"6\\",\\"12\\",\\"6\\",\\"6\\",\\"12\\",\\"12\\",\\"12\\"]}","admin_email":"admin@admin.com","cc_email":"","bcc_email":"","success_notify":"Thank You! Your message has been sent.","failure_notify":"Something went wrong, please try again later.","captcha_failure_notify":"Please enter a correct Captcha answer.","captcha_req":"0","reset_publish":"0","br_name":"Clear","bs_name":"Send","labels_pos":"1","moduleclass_sfx":"careers_form","layout":"_:default","module_tag":"div","bootstrap_size":"0","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(161, 382, 'Requirements', '', '', 1, 'careers-accordion-requirements', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"requirements","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":" requirements","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(162, 383, 'What we Expect from you?', '', '', 1, 'careers-accordion-expect', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"what-we-expect-from-you","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":" expect","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(163, 387, 'Careers accordion', '', '', 1, 'careers-accordion-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{"catid":["47"],"count":"3","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(164, 388, 'Careers accordion', '', '', 1, 'careers-accordion-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{"catid":["47"],"count":"3","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(165, 389, 'Careers accordion', '', '', 1, 'careers-accordion-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{"catid":["47"],"count":"3","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(166, 390, 'Pages', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"main-menu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"site_map","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"3","header_tag":"h5","header_class":"left","style":"0"}', 0, '*'),
(167, 391, 'Blog posts', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{"mode":"normal","show_on_article_page":"1","count":"0","show_front":"show","category_filtering_type":"1","catid":["11"],"show_child_category_articles":"1","levels":"10","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"publish_up","article_ordering_direction":"DESC","article_grouping":"none","article_grouping_direction":"ksort","month_year_format":"F Y","link_titles":"1","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","show_introtext":"0","introtext_limit":"100","show_readmore":"0","show_readmore_title":"0","readmore_limit":"15","layout":"_:default","moduleclass_sfx":" site_map","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"3","header_tag":"h5","header_class":"left","style":"0"}', 0, '*'),
(168, 392, 'Portfolio posts', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{"mode":"normal","show_on_article_page":"1","count":"0","show_front":"show","category_filtering_type":"1","catid":["31"],"show_child_category_articles":"1","levels":"10","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.ordering","article_ordering_direction":"ASC","article_grouping":"none","article_grouping_direction":"ksort","month_year_format":"F Y","link_titles":"1","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","show_introtext":"0","introtext_limit":"100","show_readmore":"0","show_readmore_title":"0","readmore_limit":"15","layout":"_:default","moduleclass_sfx":" site_map","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"3","header_tag":"h5","header_class":"left","style":"0"}', 0, '*'),
(169, 393, 'User menu', '', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"user-menu","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"site_map","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"3","header_tag":"h5","header_class":"left","style":"0"}', 0, '*'),
(170, 395, 'Breadcrumbs', '', '', 1, 'breadcrumbs', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 0, '{"showHere":"0","showHome":"1","homeText":"","showLast":"1","separator":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(171, 398, 'Our team', '', '', 10, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["26"],"show_child_category_articles":"0","levels":"1","count":"6","columns":"3","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"0","item_heading":"h5","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"team_team","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(173, 400, 'Frequently asked questions', '', '', 8, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 1, '{"catid":["27"],"count":"100","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(180, 432, 'TM Ajax Style Switcher', '', '', 1, 'fixed-sidebar-left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_style_switcher', 1, 1, '{"module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(181, 434, 'Olark', '', '', 1, 'fixed-sidebar-right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tm_olark_chat', 1, 0, '{"site_id":"5615-604-10-1042","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(183, 437, 'Tabs', 'For "Elements" page', '', 1, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstraptabs', 1, 1, '{"catid":["57"],"count":"5","ordering":"a.ordering","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(184, 442, 'Accordion 2', 'For "Elements" page', '', 3, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_bootstrap_collapse', 1, 0, '{"catid":["18"],"count":"3","ordering":"a.ordering","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","show_tags":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"6","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(186, 444, 'Progress Bars Horizontal', 'For "Elements" page', '', 19, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["59"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"2","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"0","link_titles":"0","item_heading":"h6","show_introtext":"0","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:progbar-horizontal","masonry":"0","moduleclass_sfx":"progbars_horizontal","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(189, 456, 'Pricing Tables', 'For "Elements" page', '', 6, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["35"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"0","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"right","image":"0","readmore":"1","layout":"theme3288:pricing-table","masonry":"0","moduleclass_sfx":"pricing_detailed","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(190, 457, 'Simple', 'For "Elements" page', '', 7, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["36"],"show_child_category_articles":"0","levels":"1","count":"3","columns":"3","ordering":"a.ordering","article_ordering_direction":"ASC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"124","pretext":"","item_title":"1","link_titles":"0","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"right","image":"0","readmore":"1","layout":"theme3288:pricing-table","masonry":"0","moduleclass_sfx":"pricing_simple","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(192, 459, 'Accordions and Toggles', 'For "Elements" page', '', 2, 'content-bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"title_only","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"center","style":"0"}', 0, '*'),
(198, 465, 'Login or register', '', '', 1, 'modal', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_socialloginandsocialshare', 1, 0, '{"layout":"theme3288:megamenu","moduleclass_sfx":"login_megamenu login_shell","module_tag":"div","bootstrap_size":"0","header_tag":"h5","header_class":"","style":"0"}', 0, '*'),
(200, 472, 'Youtube', '', '{loadmodule articles_single, COMPLETE}', 1, 'bottom', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_tm_bg_youtube', 1, 0, '{"prepare_content":"1","youtube_url":"https:\\/\\/www.youtube.com\\/watch?v=3zMSlMLofwM&feature=youtu.be","start":"0","mute":"0","play_pause":"0","play_text":"Play video","pause_text":"Pause video","mobile_image":"images\\/video.jpg","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(206, 487, 'Parallax', '', '{loadmodule articles_single, About}\r\n', 1, 'mainbottom', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_tm_parallax', 1, 0, '{"prepare_content":"1","backgroundimage":"images\\/parallax\\/parallax1.jpg","speed":"0.8","direction":"1","mobile":"1","blur":"0","pretext":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(210, 513, 'Swiper', '', '', 1, 'showcase', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_swiper', 1, 0, '{"catid":["63"],"image":"1","item_title":"1","link_titles":"","item_heading":"h1","published":"0","readmore":"0","count":"6","ordering":"a.publish_up","item_url":"","target":"self","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","theme":"1","script":"0","autoplay":"0","autoplay_speed":"7000","height":"34.66796875%","minHeight":"420px","slide_animation":"slide","slide_content_animation":"fadeIn","slide_content_animation_delay":"200","navigation":"1","pagination":"0","pagination_clickable":"0","pagination_bullet":"0","show_caption":"1","show_thumbs":"0","thumb_height":"105px","thumb_space":"20","thumb_space_768":"10","thumb_space_480":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(212, 518, 'Komento Activities', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_komento_activities', 1, 1, '', 0, '*'),
(213, 519, 'Komento Comments', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_komento_comments', 1, 1, '', 0, '*'),
(214, 521, 'Address', '', '', 1, 'top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"address","base":"","startLevel":"1","endLevel":"1","showAllChildren":"0","tag_id":"","class_sfx":"address","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"5","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(215, 522, 'Work time', '', '', 1, 'top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"work-time","base":"","startLevel":"1","endLevel":"1","showAllChildren":"0","tag_id":"","class_sfx":"work_time","window_open":"","layout":"_:default","moduleclass_sfx":"pull-right size","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"1","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(216, 523, 'Telephones', '', '', 1, 'top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"telephones","base":"","startLevel":"1","endLevel":"1","showAllChildren":"0","tag_id":"","class_sfx":"phone","window_open":"","layout":"_:default","moduleclass_sfx":"pull-right","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"5","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(217, 527, 'Footer post', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 0, '{"article_id":"144","item_heading":"h4","item_title":"0","link_titles":"","published_on":"0","show_intro_image":"1","readmore":"0","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"4","header_tag":"h5","header_class":"","style":"0"}', 0, '*'),
(218, 528, 'Services', '', '', 2, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"services","base":"","startLevel":"1","endLevel":"1","showAllChildren":"0","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"4","header_tag":"h5","header_class":"","style":"0"}', 0, '*'),
(219, 533, 'COMPLETE', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{"article_id":"145","item_heading":"h4","item_title":"0","link_titles":"","published_on":"0","show_intro_image":"0","readmore":"0","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"AUTO SERVICE","layout":"_:default","moduleclass_sfx":" center","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(220, 534, 'WHAT', '', '', 1, 'mainbottom-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["28"],"show_child_category_articles":"0","levels":"1","count":"3","columns":"3","ordering":"a.ordering","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"PEOPLE SAY?","item_title":"1","link_titles":"","item_heading":"h6","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:testimonials","masonry":"0","moduleclass_sfx":"center type2","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(221, 542, 'car manufacturers', '', '', 1, 'mainbottom-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["64"],"show_child_category_articles":"0","levels":"1","count":"6","columns":"6","ordering":"a.publish_up","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"we work with","item_title":"0","link_titles":"","item_heading":"h4","show_introtext":"0","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"center type2 brands","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(222, 543, 'About', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{"article_id":"146","item_heading":"h4","item_title":"0","link_titles":"","published_on":"0","show_intro_image":"0","readmore":"0","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"Our Company","layout":"_:default","moduleclass_sfx":" center","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(223, 549, 'Services', '', '', 1, 'mainbottom-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["65"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.publish_up","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"","item_title":"1","link_titles":"","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"1","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:custom","masonry":"0","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(224, 554, 'CAR REPAIR CAN HANDLE ALL OF', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["66"],"show_child_category_articles":"0","levels":"1","count":"3","columns":"3","ordering":"a.ordering","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"YOUR AUTO REPAIR SERVICES INCLUDING","item_title":"0","link_titles":"","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"type1","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(225, 560, 'Services list', '', '', 1, 'maintop', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["67"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.publish_up","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"","item_title":"1","link_titles":"1","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"center list","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(226, 565, 'Services', '', '', 1, 'megamenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["68"],"show_child_category_articles":"0","levels":"1","count":"2","columns":"2","ordering":"a.ordering","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"","item_title":"0","link_titles":"","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h4","header_class":"","style":"0"}', 0, '*'),
(227, 566, 'About', '', '', 1, 'megamenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{"article_id":"168","item_heading":"h4","item_title":"0","link_titles":"","published_on":"0","show_intro_image":"0","readmore":"0","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h4","header_class":"","style":"0"}', 0, '*'),
(228, 571, 'Company', '', '', 1, 'mainbottom-4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 1, '{"catid":["69"],"show_child_category_articles":"0","levels":"1","count":"3","columns":"3","ordering":"a.ordering","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"Automotive SERVICES","item_title":"0","link_titles":"","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"0","intro_image_align":"none","image":"0","readmore":"0","layout":"_:default","masonry":"0","moduleclass_sfx":"type1","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(229, 572, 'Services 2', '', '', 1, 'mainbottom-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_news_adv', 1, 0, '{"catid":["70"],"show_child_category_articles":"0","levels":"1","count":"4","columns":"4","ordering":"a.ordering","article_ordering_direction":"DESC","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"","item_title":"0","link_titles":"","item_heading":"h4","show_introtext":"1","introtext_limit":"0","show_tags":"0","show_category":"0","show_hits":"0","published":"0","createdby":"0","intro_image":"1","intro_image_align":"none","image":"0","readmore":"0","layout":"theme3288:custom","masonry":"0","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(230, 578, 'OBI II', '', '', 1, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{"article_id":"148","item_heading":"h4","item_title":"0","link_titles":"","published_on":"0","show_intro_image":"0","readmore":"0","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"Diagnostic system","layout":"_:default","moduleclass_sfx":" center","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*'),
(231, 579, 'Parallax 2', '', '{loadmodule articles_single, OBI II}\r\n', 1, 'mainbottom', 0, '0000-00-00 00:00:00', '2016-06-10 06:32:17', '0000-00-00 00:00:00', 1, 'mod_tm_parallax', 1, 0, '{"prepare_content":"1","backgroundimage":"images\\/parallax\\/parallax2.jpg","speed":"0.8","direction":"1","mobile":"1","blur":"0","pretext":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(232, 580, 'IN A NUTSHELL', '', '', 1, 'content-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_single', 1, 1, '{"article_id":"147","item_heading":"h4","item_title":"0","link_titles":"","published_on":"0","show_intro_image":"1","readmore":"1","mod_button":"0","custom_link_title":"","custom_link_route":"0","custom_link_url":"http:\\/\\/","custom_link_menu":"525","pretext":"About CaRrepair","layout":"_:default","moduleclass_sfx":"center ","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"12","header_tag":"h1","header_class":"","style":"0"}', 0, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(79, 0),
(86, 0),
(94, 0),
(97, 101),
(103, 0),
(104, 0),
(107, 0),
(115, 142),
(118, 336),
(122, 336),
(124, 0),
(126, 0),
(127, 0),
(128, 0),
(129, 0),
(130, 0),
(131, 0),
(134, 101),
(141, 101),
(141, 142),
(142, 426),
(144, 426),
(145, 426),
(149, 137),
(153, 134),
(159, 0),
(160, 343),
(161, 0),
(162, 0),
(163, 0),
(164, 0),
(165, 0),
(166, 305),
(167, 305),
(168, 305),
(169, 305),
(170, -101),
(171, 136),
(173, 138),
(180, 0),
(181, 0),
(183, 426),
(184, 426),
(186, 426),
(189, 426),
(190, 426),
(192, 426),
(198, 0),
(200, 101),
(206, 101),
(210, 101),
(214, 0),
(215, 0),
(216, 0),
(217, 101),
(218, 101),
(219, 0),
(220, 101),
(221, 101),
(222, 0),
(223, 101),
(224, 101),
(225, 101),
(226, 0),
(227, 0),
(228, 134),
(229, 134),
(230, 0),
(231, 134),
(232, 134);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7072 ;

INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(1, 'SEND_DATE', 'Send Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(2, 'ACTIVATED', 'Activated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(3, 'AFFECTED', 'Attached', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(4, 'PROCESS_CONFIRMATION', 'Are you sure you want to proceed?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(5, 'ERROR_SAVING', 'Error Saving', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(6, 'JOOMEXT_SUCC_SAVED', 'Successfully Saved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(7, 'SUCC_DELETE_ELEMENTS', 'Successfully deleted %s record(s)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(8, 'CONTACT', 'Please Contact us at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(9, 'SUCC_MOVED', 'Successfully Moved Element', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(10, 'ERROR_ORDERING', 'Error Ordering Elements', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(11, 'PUBLISH_CLICK', 'Click here to Publish', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(12, 'UNPUBLISH_CLICK', 'Click here to Unpublish', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(13, 'UNSCHEDULE_CLICK', 'Click here to Unschedule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(14, 'SUBSCRIBE_CLICK', 'Click here to Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(15, 'UNSUBSCRIBE_CLICK', 'Click here to Unsubscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(16, 'CONFIRMATION_CLICK', 'Click here to Confirm the Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(17, 'ENTER_SUBJECT', 'Please enter a Subject', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(18, 'CREATED_DATE', 'Created Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(19, 'RECEIVE_HTML', 'Receive HTML', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(20, 'JOOMEXT_YES', 'Yes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(21, 'JOOMEXT_NO', 'No', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(22, 'JOOMEXT_FILTER', 'Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(23, 'JOOMEXT_GO', 'Go', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(24, 'JOOMEXT_RESET', 'Reset', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(25, 'ACY_CPANEL', 'Dashboard', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(26, 'NAMECAPTION', 'Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(27, 'EMAILCAPTION', 'E-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(28, 'SUBSCRIBECAPTION', 'Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(29, 'UNSUBSCRIBECAPTION', 'Unsubscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(30, 'ALREADY_CONFIRMED', 'You have already confirmed your subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(31, 'SUBSCRIPTION_CONFIRMED', 'Your subscription has been confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(32, 'JOOMEXT_SUBJECT', 'Subject', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(33, 'MAILING_LISTS', 'Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(34, 'CONFIRMATION_SENT', 'A confirmation e-mail has been sent, please click on the confirmation link in order to confirm your subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(35, 'SUBSCRIPTION_OK', 'You have successfully subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(36, 'UNSUBSCRIPTION_OK', 'You have successfully unsubscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(37, 'UNSUBSCRIPTION_NOT_IN_LIST', 'You were not subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(38, 'SUBSCRIPTION_UPDATED_OK', 'Subscription successfully updated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(39, 'ALREADY_SUBSCRIBED', 'You are already subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(40, 'NOT_IN_LIST', 'The e-mail address %s is not in the list of users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(41, 'SCHEDULE', 'Schedule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(42, 'UNSCHEDULE', 'Unschedule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(43, 'SUCC_UNSCHED', 'Newsletter unscheduled Successfully', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(44, 'SPECIFY_DATE', 'Please specify a date to schedule your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(45, 'DATE_FUTURE', 'Please specify a date in the future', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(46, 'AUTOSEND_DATE', 'The Newsletter %s will be automatically sent at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(47, 'NB_SCHED_NEWS', '%s Newsletters scheduled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(48, 'NO_SCHED', 'No Scheduled Newsletter needed to be generated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(49, 'SCHED_NEWS', 'The Newsletter is scheduled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(50, 'SCHEDULE_NEWS', 'Scheduled Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(51, 'SEND_CONTINUE', 'Do you want to continue the send process?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(52, 'CONTINUE', 'Continue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(53, 'SENT_BY', 'Sent by', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(54, 'WRITABLE_FOLDER', 'Please make sure the folder ( %s ) is writeable', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(55, 'ACCEPTED_TYPE', 'This file type ( %s ) is not accepted, the accepted file types are : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(56, 'FAIL_UPLOAD', 'Could not upload the file %s to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(57, 'FAIL_SAVE', 'Could not save the file %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(58, 'BROWSE_FILE', 'Please browse for a file to import', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(59, 'FAIL_OPEN', 'Could not open the file %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(60, 'ADD_ATTACHMENT', 'Attach a new file', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(61, 'MAX_UPLOAD', '( total max upload file size : %s )', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(62, 'ALLOWED_FILES', 'Allowed files', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(63, 'UPLOAD_FOLDER', 'Upload folder', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(64, 'VALID_EMAIL', 'Please enter a valid e-mail address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(65, 'ONLY_LOGGED', 'The subscription is restricted to logged in users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(66, 'ASK_LOG', 'Please log in', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(67, 'INVALID_KEY', 'Key/User not found, please contact the Administrator of this website', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(68, 'NOT_VALID_EMAIL', 'The e-mail address %s is not valid', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(69, 'NAME_MISSING', 'Please enter your name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(70, 'AUTONEWSLETTERS', 'Auto-Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(71, 'AUTONEW', 'Auto-Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(72, 'NO_AUTONEWSLETTERS', 'No Auto-Newsletter needed to be generated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(73, 'NEWSLETTER_GENERATED', 'Newsletter Generated [%s] : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(74, 'NEWSLETTER_NOT_GENERATED', 'Auto-Newsletter [%s] not generated : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(75, 'AUTONEWS_SEND', 'Send the generated Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(76, 'AUTONEWS_WAIT', 'Wait for the confirmation before sending', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(77, 'GENERATE', 'Generate', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(78, 'AUTONEWS_NOT_PUBLISHED', 'The Auto-Newsletter %s is not published', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(79, 'AUTONEWS_NOT_READY', 'The next generate date of the Auto-Newsletter %s has not been reached', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(80, 'EMPTY_LOG', 'The log file is empty', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(81, 'SUCC_DELETE_LOG', 'Log file successfully deleted', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(82, 'ERROR_DELETE_LOG', 'Could not delete the Log file', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(83, 'EXIST_LOG', 'Log file does not exists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(84, 'THANK_YOU_SHARING', 'Thank you for your contribution', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(85, 'ALLOW_VISITOR', 'Allow non-logged in users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(86, 'REQUIRE_CONFIRM', 'Require Confirmation (double opt-in)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(87, 'MESSAGES', 'Messages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(88, 'DISPLAY_MSG_SUBSCRIPTION', 'Display a message on subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(89, 'DISPLAY_MSG_CONFIRM', 'Display a message on confirmation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(90, 'DISPLAY_MSG_WELCOME', 'Display a message when sending the welcome e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(91, 'DISPLAY_MSG_UNSUB', 'Display a message when sending the unsubscribe e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(92, 'NOTIFICATIONS', 'Notifications', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(93, 'NOTIF_CREATE', 'When a new user is created, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(94, 'NOTIF_REFUSE', 'When a user refuses to receive e-mails, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(95, 'NOTIF_UNSUBALL', 'When a user unsubscribes from all Lists, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(96, 'REDIRECTIONS', 'Redirections', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(97, 'REDIRECTION_CONFIRM', 'Redirection after Confirmation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(98, 'REDIRECTION_UNSUB', 'Redirection after Unsubscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(99, 'JOOMEXT_NAME', 'Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(100, 'JOOMEXT_EMAIL', 'E-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(101, 'USERS', 'Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(102, 'NO_SUBSCRIBER', 'No subscriber found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(103, 'NO_RECEIVER', 'No receiver found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(104, 'USER_INFORMATIONS', 'User Information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(105, 'IP', 'IP', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(106, 'USER_ID', 'User ID', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(107, 'VISITOR', 'Visitor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(108, 'ACY_GROUP', 'Group', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(109, 'EDIT_JOOMLA_USER', 'Edit User Profile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(110, 'QUEUE', 'Queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(111, 'CONFIRM_DELETE_QUEUE', 'Are you sure you want to delete those %s records?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(112, 'PRIORITY', 'Priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(113, 'NEWS_PRIORITY', 'Newsletter priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(114, 'FOLLOW_PRIORITY', 'Follow-up priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(115, 'TRY', 'Try', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(116, 'ADDED_QUEUE', '%s e-mails have been added to the queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(117, 'AUTOSEND_CONFIRMATION', 'The system will send them automatically as soon as possible', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(118, 'ALREADY_QUEUED', 'There are already %s e-mails in the queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(119, 'DELETE_QUEUE', 'Please delete those e-mails before scheduling your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(120, 'QUEUE_NEXT_TRY', 'Next try in %s minutes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(121, 'QUEUE_DOUBLE', 'Send process running in parallel detected, the system stopped but you will be able to resume it', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(122, 'ADDED_QUEUE_SCHEDULE', '%s emails have been added to the queue for the Scheduled Newsletter [ID %s] %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(123, 'QUEUE_READY', 'The following e-mails are ready to be sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(124, 'EMAIL_READY', '[ID %s] %s to %s users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(125, 'QUEUE_SCHED', '[ID %s] %s will be sent after %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(126, 'QUEUE_STATUS', 'Queue status at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(127, 'QUEUE_NEXT_SCHEDULE', 'The next e-mail will be sent after %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(128, 'PROCESS', 'Process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(129, 'NO_PROCESS', 'There is nothing to send', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(130, 'NB_PENDING_EMAIL', 'There are %s e-mails in the queue for the Newsletter %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(131, 'ACY_CRON_TRIGGERED', 'AcyMailing Triggered at %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(132, 'CRON_NEXT', 'The system won''t be triggered before %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(133, 'ACY_CRON_PROCESS', '%s messages processed : %s successful, %s failed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(134, 'CREATE_CRON', 'Create/Edit your Cron task', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(135, 'UNSUB_CURRENT', 'Unsubscribe from this Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(136, 'UNSUB_ALL', 'Unsubscribe from all Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(137, 'UNSUB_FULL', 'Do not receive any e-mails from this website in the future', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(138, 'CONFIRM_UNSUB_FULL', 'You won''t receive any e-mails from this website in the future', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(139, 'CONFIRM_UNSUB_ALL', 'You have been unsubscribed from all Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(140, 'CONFIRM_UNSUB_CURRENT', 'You have been unsubscribed from the Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(141, 'ERROR_NOT_SUBSCRIBED', 'You were not subscribed to any Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(142, 'ERROR_NOT_SUBSCRIBED_CURRENT', 'You were not subscribed to the selected Mailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(143, 'ACCEPT_TERMS', 'Please check the Terms and Conditions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(144, 'JOOMEXT_TERMS', 'Terms and Conditions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(145, 'UNSUBSCRIBE', 'Unsubscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(146, 'UNSUBSCRIBED', 'Unsubscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(147, 'NO_SUBSCRIPTION', 'No Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(148, 'PENDING_SUBSCRIPTION', 'Wait Confirmation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(149, 'SUBSCRIBED', 'Subscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(150, 'ALL_STATUS', 'All Status', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(151, 'ACCEPT_REFUSE', 'Accept / Refuse', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(152, 'ACCEPT_EMAIL', 'Accept E-Mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(153, 'REFUSE_EMAIL', 'Refuse E-Mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(154, 'SUBSCRIPTION', 'Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(155, 'ENABLED_DISABLED', 'Enabled / Disabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(156, 'ENABLED', 'Enabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(157, 'DISABLED', 'Disabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(158, 'UNSUBSCRIBERS', 'Unsubscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(159, 'SUBSCRIBERS', 'Subscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(160, 'SUBSCRIBE_ALL', 'Subscribe to all', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(161, 'SUBSCRIBE', 'Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(162, 'REMOVE', 'Remove', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(163, 'CONFIRMED', 'Confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(164, 'STATUS', 'Status', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(165, 'SUBSCRIPTION_DATE', 'Subscription Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(166, 'UNSUBSCRIPTION_DATE', 'Unsubscription Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(167, 'USER_REFUSE', 'This user refuses to receive future messages from your website', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(168, 'SAVE_CHANGES', 'Save Changes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(169, 'SEND_EMPTY', 'There is no Subject or Body in this e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(170, 'SEND_ERROR', 'Error Sending Message %s to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(171, 'SEND_SUCCESS', 'Message %s successfully sent to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(172, 'SEND_ERROR_PUBLISHED', 'The e-mail ID %s is not published', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(173, 'SEND_ERROR_USER', 'User not found : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(174, 'SEND_ERROR_CONFIRMED', 'The User %s is not confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(175, 'SEND_ERROR_APPROVED', 'The User %s is not enabled', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(176, 'SEND_ERROR_ACCEPT', 'The User %s does not accept e-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(177, 'SEND_PROCESS', 'Send Process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(178, 'SEND_REFRESH_TIMEOUT', 'Process refreshed to avoid a time limit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(179, 'SEND_REFRESH_CONNECTION', 'Process refreshed to avoid a possible loss of connection', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(180, 'SEND_STOPED', 'The Send Process stopped because there are too many errors', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(181, 'SEND_KEPT_ALL', 'The system kept all non delivered e-mails in the queue, so you will be able to resume the send process later', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(182, 'SEND_CHECKONE', 'Please verify your mail configuration and make sure you can send a test of this e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(183, 'SEND_ADVISE_LIMITATION', 'If you recently, successfully, sent a lot of e-mails, those errors may also be due to your server limitations', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(184, 'SEND_REFUSE', 'Your server apparently refuses to send more e-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(185, 'SEND_CONTINUE_COMMERCIAL', 'Using one of our commercial versions, the system would be able to continue automatically the send process using a Cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(186, 'SEND_CONTINUE_AUTO', 'If you configured a cron task, the system will automatically continue the send process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(187, 'TITLE_ONLY', 'Title Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(188, 'INTRO_ONLY', 'Intro Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(189, 'FULL_TEXT', 'Full text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(190, 'ACY_EACH_TIME', 'Each time AcyMailing is triggered', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(191, 'ACY_ONLY_ACTION', 'Only if AcyMailing executes an action', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(192, 'SIMPLIFIED_REPORT', 'Simplified Report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(193, 'DETAILED_REPORT', 'Detailed Report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(194, 'ALL_EMAILS', 'All E-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(195, 'FILTER_SELECT', 'Select a filter type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(196, 'ACYMAILING_LIST', 'AcyMailing List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(197, 'ACYMAILING_FIELD', 'AcyMailing Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(198, 'JOOMLA_FIELD', 'Joomla User Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(199, 'CB_FIELD', 'Community Builder Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(200, 'ALL_CREATORS', 'All Creators', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(201, 'ALL_LISTS', 'All lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(202, 'ALL_USERS', 'All Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(203, 'AUTO_ONLY', 'Automatic Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(204, 'AUTO_MAN', 'Automatic / Manual', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(205, 'MANUAL_ONLY', 'Manual Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(206, 'OTHER', 'Other', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(207, 'MANAGER', 'Manager', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(208, 'ADMINISTRATOR', 'Administrator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(209, 'SUPER_ADMIN', 'Super Administrator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(210, 'NO_UNSUB_MESSAGE', 'No unsubscribe message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(211, 'NO_WELCOME_MESSAGE', 'No welcome message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(212, 'EDIT_EMAIL', 'Edit the e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(213, 'CREATE_EMAIL', 'Create a new e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(214, 'ALL_URLS', 'All URLs', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(215, 'HTML_VERSION', 'HTML Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(216, 'TEXT_VERSION', 'Text Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(217, 'INFOS', 'Infos', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(218, 'HOURS', 'Hours', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(219, 'DAYS', 'Days', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(220, 'WEEKS', 'Weeks', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(221, 'MONTHS', 'Months', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(222, 'NB_SUB_UNSUB', 'Number of subscribers/unsubscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(223, 'SUB_HISTORY', 'Subscription History', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(224, 'STATISTICS', 'Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(225, 'GLOBAL_STATISTICS', 'Global Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(226, 'DETAILED_STATISTICS', 'Detailed Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(227, 'OPEN', 'E-mail Opens', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(228, 'OPEN_UNIQUE', 'Unique Opens', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(229, 'OPEN_TOTAL', 'Total Opens', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(230, 'NOT_OPEN', 'Not Opened', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(231, 'OPEN_DATE', 'Open Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(232, 'PERCENT_OPEN', '%s of HTML e-mails have been opened', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(233, 'SENT_HTML', 'Sent in HTML', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(234, 'SENT_TEXT', 'Sent in Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(235, 'FAILED', 'Failed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(236, 'CHARTS', 'Charts', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(237, 'RECEIVED_VERSION', 'Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(238, 'URL', 'URL', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(239, 'URL_NAME', 'URL Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(240, 'URL_EDIT', 'Edit the URL', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(241, 'UNIQUE_HITS', 'Unique Hits', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(242, 'TOTAL_HITS', 'Total Hits', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(243, 'CLICK_STATISTICS', 'Click Statistics', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(244, 'CLICKED_LINK', 'Clicked a link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(245, 'PERCENT_CLICK', '%s of users clicked on a link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(246, 'TOTAL_EMAIL_SENT', '%s e-mails sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(247, 'FORWARDED', 'Forwarded', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(248, 'EMAIL_NAME', 'E-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(249, 'SEND_HTML', 'Send HTML Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(250, 'NEXT_GENERATE', 'Next Generate Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(251, 'GENERATE_FREQUENCY', 'Generate Frequency', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(252, 'FREQUENCY', 'Frequency', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(253, 'ISSUE_NB', 'Issue Number', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(254, 'GENERATE_MODE', 'Generating mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(255, 'NOTIFICATION_TO', 'Send notification to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(256, 'EVERY', 'Every', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(257, 'CREATOR', 'Creator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(258, 'ATTACHMENTS', 'Attachments', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(259, 'ATTACHED_FILES', 'Attached Files', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(260, 'NEWSLETTERS', 'Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(261, 'NEWSLETTER', 'Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(262, 'JOOMEXT_VISIBLE', 'Visible', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(263, 'JOOMEXT_ALIAS', 'Alias', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(264, 'TEMPLATE_NAME', 'Template Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(265, 'ACY_TEMPLATE', 'Template', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(266, 'BACKGROUND_COLOUR', 'Background Colour', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(267, 'FOLLOWUP', 'Follow up', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(268, 'CAMPAIGN', 'Campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(269, 'DELAY', 'Delay', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(270, 'FOLLOWUP_ADD', 'Add a new follow-up', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(271, 'CAMPAIGN_START', 'When a user subscribes to one of the following lists, this user will start receiving the campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(272, 'NUM_FOLLOWUP_CAMPAIGN', 'There are %s follow-ups in this Campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(273, 'SENDER_INFORMATIONS', 'Sender Information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(274, 'FROM_NAME', 'From Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(275, 'FROM_ADDRESS', 'From Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(276, 'REPLYTO_NAME', 'Reply-to Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(277, 'REPLYTO_ADDRESS', 'Reply-to Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(278, 'BOUNCE_ADDRESS', 'Bounce Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(279, 'LIST', 'List', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(280, 'LISTS', 'Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(281, 'LIST_NAME', 'List Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(282, 'RECEIVE', 'Receive', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(283, 'LIST_CREATE', 'Please create a list first', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(284, 'LIST_RECEIVERS', 'The Newsletter will be sent to the following selected lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(285, 'NEWSLETTER_SENT_TO', 'This Newsletter will be sent to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(286, 'LIST_PUBLISH', 'Please enable this list first', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(287, 'EMAIL_AFFECT', 'Please assign this Email to one or several enabled lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(288, 'COLOUR', 'Colour', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(289, 'MSG_UNSUB', 'Unsubscribe Message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(290, 'MSG_WELCOME', 'Welcome Message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(291, 'NB_PENDING', 'Number of pending users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(292, 'SUB_USERS', 'Subscribe Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(293, 'ACCESS_LEVEL', 'Access Level', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(294, 'ACCESS_LEVEL_SUB', 'View/Subscription Access', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(295, 'ACCESS_LEVEL_MANAGE', 'Front-End Management', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(296, 'SEND_TEST', 'Send a test', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(297, 'SEND_TEST_TO', 'Send a test to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(298, 'EMAIL_ADDRESS', 'Email Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(299, 'SEND_VERSION', 'Send Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(300, 'HTML', 'HTML', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(301, 'JOOMEXT_TEXT', 'Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(302, 'SEND', 'Send', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(303, 'CRON', 'Cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(304, 'NEXT_RUN', 'Next Run time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(305, 'CRON_URL', 'Cron URL', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(306, 'REPORT', 'Report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(307, 'REPORT_SEND', 'Send a report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(308, 'REPORT_SEND_TO', 'Send the report to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(309, 'REPORT_SAVE', 'Save the report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(310, 'REPORT_SAVE_TO', 'Save the report to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(311, 'REPORT_DELETE', 'Delete the report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(312, 'REPORT_SEE', 'See the report', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(313, 'REPORT_EDIT', 'Edit Report Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(314, 'LAST_CRON', 'Last Cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(315, 'LAST_RUN', 'Last Run time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(316, 'CRON_TRIGGERED_IP', 'Triggered from the IP', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(317, 'MAIL_CONFIG', 'Mail Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(318, 'QUEUE_PROCESS', 'Queue process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(319, 'PLUGINS', 'Plugins', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(320, 'LANGUAGES', 'Languages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(321, 'MAILER_METHOD', 'Mailer Method', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(322, 'ENCODING_FORMAT', 'Encoding Format', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(323, 'CHARSET', 'Charset', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(324, 'WORD_WRAPPING', 'Word Wrapping', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(325, 'HOSTNAME', 'Hostname', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(326, 'EMBED_IMAGES', 'Embed Images', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(327, 'EMBED_ATTACHMENTS', 'Embed Attachments', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(328, 'MULTIPLE_PART', 'Send Multiple Part', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(329, 'SENDMAIL_PATH', 'SendMail Path', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(330, 'SMTP_CONFIG', 'SMTP Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(331, 'SMTP_SERVER', 'Server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(332, 'SMTP_PORT', 'Port', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(333, 'SMTP_SECURE', 'Secure Method', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(334, 'SMTP_ALIVE', 'Keep Alive', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(335, 'SMTP_AUTHENT', 'Authentication', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(336, 'SMTP_PASSWORD', 'Password', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(337, 'MAX_NB_TRY', 'Maximum number of tries', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(338, 'QUEUE_PROCESSING', 'Queue Processing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(339, 'EDIT_CONF_MAIL', 'Edit Confirmation Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(340, 'EDIT_NOTIFICATION_MAIL', 'Edit Notification Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(341, 'EDIT_LANGUAGE_FILE', 'Edit the language File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(342, 'ADD_LANGUAGE_FILE', 'Add the language File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(343, 'CONFIGURATION', 'Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(344, 'SHARE', 'Share', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(345, 'SHARE_CONFIRMATION_1', 'This Language File will be sent to the Acyba translation team and may be included in the next version.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(346, 'SHARE_CONFIRMATION_2', 'By sharing this file, you allow Acyba to use your work for any purpose.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(347, 'SHARE_CONFIRMATION_3', 'You can add a personal message in the following area which will be included in the e-mail sent to the team.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(348, 'LOAD_ENGLISH_1', 'AcyMailing is actually not translated in this language.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(349, 'LOAD_ENGLISH_2', 'The English version will be loaded so that you can translate it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(350, 'LOAD_ENGLISH_3', 'Once you are done, don''t forget to share your translation with the rest of the community!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(351, 'LOAD_LATEST_LANGUAGE', 'Load the latest version from our server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(352, 'INTERFACE', 'Interfaces', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(353, 'SHOW_FOOTER', 'Display the brand', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(354, 'FOOTER', 'Footer', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(355, 'MENU', 'Menu', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(356, 'ACYMAILING_MENU', 'Menu Linked to AcyMailing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(357, 'PLUG_INTE', 'Integrations with AcyMailing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(358, 'PLUG_TAG', 'Plugins for the tag system', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(359, 'FORWARD_FEATURE', 'Enable the Forward to a friend', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(360, 'FEATURES', 'Features', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(361, 'ADD_NAMES', 'Add Names', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(362, 'TEST_EMAIL', 'If you receive this message, that means your configuration is Ok', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(363, 'USE_SEF', 'Use SEF Urls', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(364, 'CSS_MODULE_DESC', 'Select the css file you want to load for the front-end Module', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(365, 'CSS_FRONTEND_DESC', 'Select the css file you want to load for the front-end Component', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(366, 'CSS_BACKEND_DESC', 'Select the css file you want to load for the back-end', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(367, 'CSS_MODULE', 'Module CSS File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(368, 'CSS_FRONTEND', 'Component Front-end CSS File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(369, 'CSS_BACKEND', 'Back-end CSS File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(370, 'USE_SEF_DESC', 'You have the possibility to add SEF Urls in the Newsletter itself or keep normal URLs.<br />This option will only apply to e-mails sent from the front-end.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(371, 'ADD_NAMES_DESC', 'Add the Name of the user in the header of the e-mail.<br />Some Mail Servers don''t accept names, in that case you have to disable this option.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(372, 'FROM_NAME_DESC', 'Default From Name used in all your Newsletters.<br />You can override this property for each Newsletter you write', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(373, 'FROM_ADDRESS_DESC', 'Default E-mail address used as <b><i>from</i></b> in all your Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(374, 'REPLYTO_NAME_DESC', 'Default <b><i>Reply To</i></b> Name used in all your Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(375, 'REPLYTO_ADDRESS_DESC', 'Default E-mail address used as <b><i>reply-to</i></b> in all your Newsletters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(376, 'BOUNCE_ADDRESS_DESC', 'This e-mail address will receive all the automatic responses from your receivers.<br />If you don''t know what this field is, please leave it empty as this field can block your send process if it''s not configured properly.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(377, 'MAILER_METHOD_DESC', 'Mailer method used to send your e-mails.<br />We recommend the <b><i>PHP Mail Function</i></b>.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(378, 'ENCODING_FORMAT_DESC', 'Encoding format used for all your Newsletters.<br />We recommend <b><i>8-Bit</i></b>.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(379, 'CHARSET_DESC', 'Charset used for all your Newsletters.<br />We recommend <b><i>UTF-8</i></b>.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(380, 'WORD_WRAPPING_DESC', 'Some servers don''t allow you to send e-mails with more than xx characters per line.<br />This parameter enables you to set this limitation.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(381, 'HOSTNAME_DESC', 'Sets the host name to use in Message-Id and Received headers and as default HELO string.<br />Leave this field empty if you don''t know what is it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(382, 'EMBED_IMAGES_DESC', 'Should AcyMailing embed your pictures inside the Newsletter?<br />If so, the send process will take more time but the recipient won''t have to download the picture from your website.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(383, 'EMBED_ATTACHMENTS_DESC', 'Should AcyMailing embed your attachments inside the Newsletter?<br />If not, AcyMailing will add a list of attachments with links to your website in order to download them.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(384, 'MULTIPLE_PART_DESC', 'Should AcyMailing send multiple part e-mails?<br />If so, AcyMailing will send the text and the html version in the e-mail so that depending on the recipient, the appropriate version will be opened.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(385, 'SENDMAIL_PATH_DESC', 'Path used to call the SendMail function.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(386, 'SMTP_SERVER_DESC', 'SMTP Server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(387, 'SMTP_PORT_DESC', 'SMTP Port', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(388, 'SMTP_SECURE_DESC', 'Should AcyMailing use an SMTP Secure Connection?<br />For GMail, you should select SSL.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(389, 'SMTP_ALIVE_DESC', 'Should AcyMailing keep your SMTP Connection opened during the send Process?<br />We recommend to turn ON this option.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(390, 'SMTP_AUTHENT_DESC', 'If you need a username and a password to connect to your SMTP Server, please turn ON this option.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(391, 'USERNAME_DESC', 'Username used to connect to your SMTP Server.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(392, 'SMTP_PASSWORD_DESC', 'Password used to connect to your SMTP Server.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(393, 'CRON_URL_DESC', 'Cron URL to trigger AcyMailing.<br />You should enter this URL to create your cron task.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(394, 'REPORT_SEND_DESC', 'When should AcyMailing send a report?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(395, 'REPORT_SAVE_DESC', 'Which report should AcyMailing save in the log file?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(396, 'REPORT_SEND_TO_DESC', 'You can enter one or several e-mail addresses so that AcyMailing will send the report to those users.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(397, 'REPORT_SAVE_TO_DESC', 'Location of the log file.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(398, 'LAST_RUN_DESC', 'Last time AcyMailing executed actions via the cron URL.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini');
INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(399, 'CRON_TRIGGERED_IP_DESC', 'AcyMailing has been triggered by the following IP.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(400, 'REPORT_DESC', 'Latest report generated by AcyMailing.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(401, 'ALLOWED_FILES_DESC', 'List of allowed file extensions for the attachments.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(402, 'UPLOAD_FOLDER_DESC', 'Folder in which the attachments will be uploaded.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(403, 'DISPLAY_MSG_SUBSCRIPTION_DESC', 'Should AcyMailing display a confirmation message when the user subscribes to your website?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(404, 'DISPLAY_MSG_CONFIRM_DESC', 'Should AcyMailing display a confirmation message when the user confirms their subscription?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(405, 'DISPLAY_MSG_WELCOME_DESC', 'Should AcyMailing display a confirmation message when AcyMailing sends a welcome e-mail?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(406, 'DISPLAY_MSG_UNSUB_DESC', 'Should AcyMailing display a confirmation message when AcyMailing sends an unsubscribe e-mail?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(407, 'ACYMAILING_MENU_DESC', 'Select the Menu you want to link to AcyMailing.<br />Users having problems with access levels should select a menu which is accessible to non-registered users.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(408, 'EDITOR_DESC', 'Select the editor you want to use when editing your AcyMailing E-mails.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(409, 'SHOW_FOOTER_DESC', 'Display the AcyMailing footer on each page?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(410, 'MAX_NB_TRY_DESC', 'If AcyMailing can not send the e-mail after X tries, AcyMailing will delete the e-mail from the queue.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(411, 'QUEUE_PROCESSING_DESC', 'If you use the <b><i>automatic only</i></b> method, AcyMailing will always use the automatic process and won''t even start the manual send process if you send an e-mail from the back-end.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(412, 'NEWS_PRIORITY_DESC', 'When AcyMailing queues your e-mails, it will order them depending on the send date and the priority.<br />So, if you want your Newsletter to be sent immediately, you can enter a lower number and it will be sent before the others.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(413, 'FOLLOW_PRIORITY_DESC', 'Priority for the Follow-up messages.<br />Usually, you want those e-mails to be sent immediately, so they need a lower number than Newsletters.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(414, 'ALLOW_VISITOR_DESC', 'Do you allow non-logged in visitors to subscribe to your Mailing Lists?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(415, 'REQUIRE_CONFIRM_DESC', 'Should the user have to click on a confirmation link before being considered as a subscriber?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(416, 'NOTIF_CREATE_DESC', 'Send an e-mail to those e-mail addresses each time a new user is created.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(417, 'NOTIF_UNSUBALL_DESC', 'Send an e-mail to those e-mail addresses if a user unsubscribes from all your lists.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(418, 'NOTIF_REFUSE_DESC', 'Send an e-mail to those e-mail addresses if a user refuses to receive messages from your website.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(419, 'REDIRECTION_CONFIRM_DESC', 'Enter the url you want the user to be redirected to after he clicks on the confirmation link in the confirmation e-mail.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(420, 'REDIRECTION_UNSUB_DESC', 'Enter the url you want the user to be redirected to after he unsubscribes.<br />This redirection URL does not apply to the Module Unsubscription! Please edit the AcyMailing module for that.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(421, 'FORWARD_DESC', 'If you select <b><i>No</i></b>, the forward to a friend function won''t be enabled on your website.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(422, 'FE_INTERFACE', 'Front-end Interface', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(423, 'DEFAULT_SENDER', 'Creator as <b><i>Sender</i></b>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(424, 'DEFAULT_REPLY', 'Creator as <b><i>Reply-to</i></b>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(425, 'DEFAULT_SENDER_DESC', 'Do you want the logged-in user to be the default <b><i>sender</i></b> of a Newsletter created from the front-end?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(426, 'DEFAULT_REPLY_DESC', 'Do you want the logged-in user to be the default <b><i>reply-to</i></b> of a Newsletter created from the front-end?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(427, 'FRONTEND_PRINT', 'Print Icon', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(428, 'FRONTEND_PDF', 'PDF Icon', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(429, 'FRONTEND_PRINT_DESC', 'Do you want AcyMailing to add a Print Icon on the archive Newsletter?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(430, 'FRONTEND_PDF_DESC', 'Do you want AcyMailing to add a PDF Icon on the archive Newsletter?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(431, 'ALLOW_MODIFICATION_DESC', 'Do you allow the user to modify his data without being identified?<br />If you select <b><i>No</i></b>, the data entered by the user cannot be changed afterwards except if he''s identified by the system.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(432, 'ALLOW_MODIFICATION', 'Allow user data modifications without identification', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(433, 'ONLY_SUBSCRIPTION', 'Only his subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(434, 'IDENTIFICATION_SENT', 'An email to verify your identity has been sent to you.<br />Please click on the link in the email to be able to modify your subscription.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(435, 'QUEUE_PAUSE', 'Pause between two batches', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(436, 'QUEUE_PAUSE_DESC', 'If you use the manual send process, you can configure AcyMailing to make a pause between two batches to throttle your send process (in seconds).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(437, 'SHOW_DESCRIPTION', 'Display list description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(438, 'SHOW_DESCRIPTION_DESC', 'Display the list description on the archive Newsletters?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(439, 'SHOW_SENDDATE', 'Display send-date column', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(440, 'SHOW_SENDDATE_DESC', 'Display the send-date on the archive Newsletters?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(441, 'SHOW_FILTER', 'Display Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(442, 'SHOW_FILTER_DESC', 'Display the filter on the archive Newsletters?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(443, 'ACY_ERROR_INSTALLAGAIN', 'And then click here to trigger the install process again.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(444, 'DISPLAY_MSG_CONFIRMATION', 'Display a message when sending the confirmation e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(445, 'DISPLAY_MSG_CONFIRMATION_DESC', 'Should AcyMailing display a confirmation message when AcyMailing sends the confirmation e-mails?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(446, 'DISPLAY_MSG_UNSUBSCRIPTION', 'Display a message on unsubscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(447, 'DISPLAY_MSG_UNSUBSCRIPTION_DESC', 'Should AcyMailing display a message when the user unsubscribes from your website?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(448, 'REDIRECTION_MODIF', 'Redirection after Subscription modification', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(449, 'REDIRECTION_SUB', 'Redirection after Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(450, 'REDIRECTION_SUB_DESC', 'Enter the url you want the user to be redirected to after he subscribes.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(451, 'REDIRECTION_MODIF_DESC', 'Enter the url you want the user to be redirected to after he modified his subscription.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(452, 'REDIRECTION_NOT_MODULE', 'This redirection URL does not apply to the Module! Please edit the AcyMailing module for that.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(453, 'FIELD_EXPORT', 'Fields to export', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(454, 'EXPORT_FORMAT', 'Exporting format', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(455, 'EXPORT_SUB_LIST', 'Only Users subscribed to at least one of the selected lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(456, 'EXPORT_CONFIRMED', 'Only Confirmed Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(457, 'EXPORT_REGISTERED', 'Only Registered Users (Joomla users)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(458, 'UPLOAD_FILE', 'Upload a file', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(459, 'CHARSET_FILE', 'File Charset', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(460, 'IMPORT', 'Import', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(461, 'IMPORT_HEADER', 'The first line of your file ( %s ) must contain only columns of the acymailing_subscriber table', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(462, 'IMPORT_EMAIL', 'You need at least the column <b><i>email</i></b>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(463, 'IMPORT_EXAMPLE', 'Example : name,email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(464, 'IMPORT_ARGUMENTS', 'You need %s arguments per line', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(465, 'IMPORT_ERRORLINE', 'The line %s could not be imported', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(466, 'ACY_IMPORT_REPORT', '%s Users in the imported file : %s new Users Imported, %s Invalid Email addresses, %s already existing users or duplicate entries', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(467, 'IMPORT_SUBSCRIBE_CONFIRMATION', '%s users have been subscribed to the list %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(468, 'IMPORT_REMOVE', '%s users removed from the list %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(469, 'IMPORT_ERROR_FIELD', 'The column %s is not in the list of possible columns : %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(470, 'IMPORT_UPDATE', '%s AcyMailing users updated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(471, 'IMPORT_DELETE', '%s AcyMailing users deleted', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(472, 'IMPORT_NEW', '%s new users imported', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(473, 'IMPORT_SUBSCRIPTION', '%s subscriptions have been inserted', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(474, 'IMPORT_LIST', 'List %s imported', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(475, 'IMPORT_JOOMLA', 'Joomla Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(476, 'UNKNOWN', 'Unknown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(477, 'IMPORT_FROM', 'Import Data from', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(478, 'IMPORT_SUBSCRIBE', 'Subscribe the imported users to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(479, 'IMPORT_SUBSCRIBE_REMOVE', 'Subscribe (or Remove) the selected users to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(480, 'CONTENT_AREA', 'Style for the article area', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(481, 'CONTENT_HEADER', 'Style for the article titles', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(482, 'CONTENT_READMORE', 'Style for the <b><i>read more</i></b> link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(483, 'ADD_STYLE', 'Add a new Style', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(484, 'STYLES', 'Style : Classes replaced by inline CSS', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(485, 'CLASS_NAME', 'Name of the CSS Class', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(486, 'CSS_STYLE', 'CSS applied to the class', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(487, 'STYLE_UNSUB', 'Style for the Unsubscribe Link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(488, 'STYLE_VIEW', 'Style for the <b><i>View it online</i></b> Link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(489, 'TAGS', 'Tags', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(490, 'INSERT_TAG', 'Insert the tag', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(491, 'CONFIRM_SUBSCRIPTION', 'Click here to confirm your Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(492, 'MODIFY_SUBSCRIPTION', 'Modify your Subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(493, 'CONFIRM_SUBSCRIPTION_LINK', 'Insert a <b><i>confirm your subscription</i></b> link in your e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(494, 'MODIFY_SUBSCRIPTION_LINK', 'Insert a <b><i>modify your subscription</i></b> link in your e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(495, 'UNSUBSCRIBE_LINK', 'Insert an <b><i>unsubscribe</i></b> link in your e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(496, 'VIEW_ONLINE', 'Click here to view it online', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(497, 'FORWARD_FRIEND', 'Forward this e-mail to a friend', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(498, 'VIEW_ONLINE_LINK', 'Insert a <b><i>view it online</i></b> link in your e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(499, 'FORWARD_FRIEND_LINK', 'Insert a <b><i>forward</i></b> link in your e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(500, 'WEBSITE_LINKS', 'Website Links', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(501, 'JOOMLA_CONTENT', 'Joomla Content', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(502, 'DISPLAY', 'Display', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(503, 'CLICKABLE_TITLE', 'Clickable Title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(504, 'AUTHOR_NAME', 'Author Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(505, 'JOOMEXT_READ_MORE', 'Read More', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(506, 'JOOMLA_CONTENT_AUTO', 'Automatic Joomla Content', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(507, 'MIN_ARTICLE', 'Min. number of items', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(508, 'MIN_ARTICLE_TIP', 'Minimum number of Elements in order to generate the tag', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(509, 'MAX_ARTICLE', 'Max. number of items', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(510, 'ONLY_NEW_CREATED', 'Only newly created', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(511, 'ONLY_NEW_MODIFIED', 'Only newly created or modified', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(512, 'MODIFIED_DATE', 'Modified Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(513, 'REPLACE_TAGS', 'Replace Tags', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(514, 'ACY_COUPON', 'Coupon', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(515, 'COUPON_PERCENT', 'Percent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(516, 'COUPON_TOTAL', 'Total', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(517, 'COUPON_PERMANENT', 'Permanent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(518, 'COUPON_GIFT', 'Gift', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(519, 'COUPON_NAME', 'Coupon Code', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(520, 'COUPON_VALUE', 'Value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(521, 'ACY_PRODUCTS', 'Products', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(522, 'JOOMEXT_EVENT', 'Event', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(523, 'ACY_ORDERS', 'Orders', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(524, 'ACY_ONE_PRODUCT', 'At least one product', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(525, 'ACY_DIDNOTBOUGHT', 'didn''t buy', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(526, 'ACY_BOUGHT', 'bought', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(527, 'SHOPPER_GROUP', 'Shopper Group', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(528, 'UPCOMING_EVENTS', 'Upcoming Events', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(529, 'MAX_STARTING_DATE', 'Maximum Starting Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(530, 'SUBSCRIBER_SUBSCRIBER', 'Subscriber', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(531, 'SUBSCRIBER_ID', 'ID of the subscriber', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(532, 'SUBSCRIBER_EMAIL', 'Email of the subscriber', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(533, 'SUBSCRIBER_NAME', 'Name of the subscriber', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(534, 'SUBSCRIBER_USERID', 'ID of the subscriber in the Joomla User table', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(535, 'SUBSCRIBER_IP', 'IP of the subscriber when he opted in', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(536, 'SUBSCRIBER_CREATED', 'Creation date of the subscriber', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(537, 'SUBSCRIBER_FIRSTPART', 'First part of the subscriber name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(538, 'SUBSCRIBER_LASTPART', 'Last part of the subscriber name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(539, 'SUBSCRIBER_FIRSTPART_DESC', '(the first part of the subscriber <b><i>John Doe</i></b> is <b><i>John</i></b>)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(540, 'SUBSCRIBER_LASTPART_DESC', '(the last part of the subscriber <b><i>John Doe</i></b> is <b><i>Doe</i></b>)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(541, 'TAGUSER_TAGUSER', 'Joomla User', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(542, 'TAGUSER_ID', 'Joomla ID of the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(543, 'TAGUSER_EMAIL', 'Email of the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(544, 'TAGUSER_NAME', 'Name of the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(545, 'TAGUSER_USERNAME', 'Username of the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(546, 'TAGUSER_GROUP', 'Main group of the user (Super Administrator, Manager, Author...)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(547, 'TAGUSER_LASTVISIT', 'Date of the last visit of the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(548, 'TAGUSER_REGISTRATION', 'Registration date of the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(549, 'DISPLAY_PICTURES', 'Display pictures', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(550, 'TAG_ELEMENTS', 'Elements', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(551, 'TAG_CATEGORIES', 'Categories', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(552, 'USERS_DESC_CREATE', 'Create / Modify / Delete your users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(553, 'USERS_DESC_MANAGE', 'Manage the subscription of each user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(554, 'USERS_DESC_IMPORT', 'Import / Export Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(555, 'LISTS_DESC_CREATE', 'Create / Modify / Delete your Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(556, 'LISTS_DESC_SUBSCRIPTION', 'Mass Subscription using filters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(557, 'TEMPLATES_DESC_CREATE', 'Create / Modify / Delete Newsletter templates that you will be able to use on each e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(558, 'NEWSLETTERS_DESC_CREATE', 'Create / Modify / Delete a Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(559, 'NEWSLETTERS_DESC_TEST', 'Test your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(560, 'NEWSLETTERS_DESC_SEND', 'Send a Newsletter to one or several Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(561, 'QUEUE_DESC_CONTROL', 'Control the list of e-mails which are ready to be sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(562, 'QUEUE_DESC_BOUNCE', 'Launch the bounce handling', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(563, 'CONFIG_DESC_CONFIG', 'Configure AcyMailing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(564, 'CONFIG_DESC_MODIFY', 'Modify any string used in AcyMailing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(565, 'CONFIG_DESC_PLUGIN', 'Turn ON/OFF AcyMailing Plugins', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(566, 'ONLY_FROM_ESSENTIAL', 'Only available from AcyMailing Essential', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(567, 'ONLY_FROM_BUSINESS', 'Only available from AcyMailing Business', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(568, 'ONLY_FROM_ENTERPRISE', 'Only available with AcyMailing Enterprise', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(569, 'STATS_DESC_CHARTS', 'Subscription Charts', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(570, 'STATS_DESC_CLICK', 'How many users clicked on which link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(571, 'STATS_DESC_VIEW', 'How many e-mail sent, how many received, who received, who opened...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(572, 'AUTONEWS_DESC', 'Manage your automatic Newsletters which can be sent regularly to one or several Mailing Lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(573, 'CAMPAIGN_DESC_CREATE', 'Create your Marketing Campaigns with follow-up autoresponders messages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(574, 'CAMPAIGN_DESC_AFFECT', 'Attach each Campaign to one or several Mailing Lists so each new subscriber will start receiving your campaign based on his own subscription date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(575, 'UPDATE_ABOUT', 'Update / About', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(576, 'UPDATE_DESC', 'Check for new update', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(577, 'ABOUT_DESC', 'About', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(578, 'CHANGELOG_DESC', 'See the changelog', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(579, 'BOUNCE_HANDLING', 'Bounce Handling', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(580, 'BOUNCE_FEATURE', 'Enable the Automatic Bounce Handling', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(581, 'BOUNCE_FEATURE_DESC', 'Turn ON or OFF the Bounce Handling system.<br />If you turn it on, AcyMailing will automatically connect to your account in order to handle bounce messages.<br />If you turn it off, you can only use the Bounce Handling system manually by clicking on the button <b><i>Handle Bounces</i></b> on the queue page.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(582, 'BOUNCE_CONNECTION', 'Connection Method', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(583, 'BOUNCE_CERTIF', 'Self-signed Certificates', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(584, 'BOUNCE_CONNECT_SUCC', 'Successfully connected to %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(585, 'NB_MAIL_MAILBOX', 'There are %s messages in your mailbox', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(586, 'BOUNCE_TIMEOUT', 'Connection timeout (seconds)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(587, 'BOUNCE_PROCESS', 'Bounce Handling', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(588, 'BOUNCE_MAX_EMAIL', 'Maximum Number of e-mails', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(589, 'BOUNCE_RULES', 'Rules', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(590, 'BOUNCE_REGEX', 'Regex', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(591, 'BOUNCE_ACTION', 'Action on the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(592, 'EMAIL_ACTION', 'Action on the e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(593, 'FORWARD_EMAIL', 'Forward the message to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(594, 'DELETE_EMAIL', 'Delete the message from your mailbox', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(595, 'UNSUB_USER', 'Unsubscribe the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(596, 'SUBSCRIBE_USER', 'Subscribe the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(597, 'DELETE_USER', 'Delete the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(598, 'BOUNCES', 'Bounces', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(599, 'PLUG_INSTALLED', 'Plugin %s installed successfully', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(600, 'PLUG_ERROR', 'Error installing Plugin %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(601, 'MODULE_INSTALLED', 'Module %s installed successfully', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(602, 'MODULE_ERROR', 'Error installing Module %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(603, 'INSTALL_CONTINUE', 'Continue the Install Process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(604, 'TEMPLATES_INSTALL', '%s Templates Installed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(605, 'ADVICE_BOUNCE', 'The specified bounce e-mail address %s might cause the problem, please delete it (leave the field bounce address empty) and try again.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(606, 'ADVICE_SMTP_AUTH', 'You specified an SMTP password but you don''t require an authentification, you might want to turn the SMTP authentication ON.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(607, 'ADVICE_LOCALHOST', 'Your local website may not have a mail server. Please make sure you can send e-mails with Joomla first (password request, registration confirmation...).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(608, 'DEFAULT_LANGUAGE', 'Default language', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(609, 'ACY_CUSTOM', 'Custom', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(610, 'FIELD_LABEL', 'Label', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(611, 'FIELD_COLUMN', 'Column name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(612, 'FIELD_TYPE', 'Field type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(613, 'REQUIRED', 'Required', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(614, 'CORE', 'Core', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(615, 'FIELD_SIZE', 'Size', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(616, 'FIELD_DEFAULT', 'Default value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(617, 'FIELD_VALUES', 'Values', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(618, 'FIELD_COLUMNS', 'Columns', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(619, 'FIELD_ROWS', 'Rows', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(620, 'FIELD_TEXT', 'Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(621, 'FIELD_TEXTAREA', 'Textarea', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(622, 'FIELD_RADIO', 'Radio Button', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(623, 'FIELD_CHECKBOX', 'Checkbox', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(624, 'EXTRA_INFORMATION', 'Extra information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(625, 'EXTRA_FIELDS', 'Custom Fields', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(626, 'FIELD', 'Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(627, 'FIELD_SINGLEDROPDOWN', 'Single Dropdown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(628, 'FIELD_MULTIPLEDROPDOWN', 'Multiple Dropdown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(629, 'FIELD_DATE', 'Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(630, 'FIELD_VALUE', 'Value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(631, 'FIELD_TITLE', 'Title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(632, 'FIELD_ADDVALUE', 'Add a new value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(633, 'FIELD_VALID', 'Please enter a value for the field %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(634, 'FIELD_ERROR', 'Custom Error Message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(635, 'FORMAT', 'Format', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(636, 'FIRSTNAMECAPTION', 'First Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(637, 'LASTNAMECAPTION', 'Last Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(638, 'CITYCAPTION', 'City', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(639, 'COUNTRYCAPTION', 'Country', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(640, 'PHONECAPTION', 'Phone Number', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(641, 'ADDRESSCAPTION', 'Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(642, 'BIRTHDAYCAPTION', 'Birthday', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(643, 'FIELD_BIRTHDAY', 'Birthday', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(644, 'SOCIAL_SHARE', 'Share on %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(645, 'SHARE_TEXT', 'Currently reading %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(646, 'SECURITY', 'Security', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(647, 'CAPTCHA', 'Captcha', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(648, 'ENABLE_CATCHA', 'Enable the captcha', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(649, 'CAPTCHA_CHARS', 'Characters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(650, 'CAPTCHA_CHARS_DESC', 'List of characters used to create the captcha text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(651, 'SECURITY_KEY', 'Security Key', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(652, 'SECURITY_KEY_DESC', 'If you use the subscription via URL, you will have to add this key in the url otherwise the submission won''t be accepted<br /><br />%s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(653, 'MODULE_VIEW', 'Subscription via the AcyMailing Module', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(654, 'COMPONENT_VIEW', 'Subscription via the AcyMailing Component', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(655, 'CAPTCHA_NBCHAR', 'Number of characters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(656, 'CAPTCHA_HEIGHT', 'Height', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(657, 'CAPTCHA_WIDTH', 'Width', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(658, 'CAPTCHA_BACKGROUND', 'Background color', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(659, 'CAPTCHA_COLOR', 'Font color', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(660, 'ERROR_SECURE_KEY', 'The secure key is not the right one', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(661, 'ERROR_CAPTCHA', 'Please enter the security code displayed in the image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(662, 'FE_EDITION', 'Front-end edition', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(663, 'FE_MODIFICATION', 'Allow modifications', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(664, 'FE_MODIFICATION_DESC', 'Do you allow a user to edit the Newsletter created by another user?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(665, 'FE_MODIFICATION_SENT', 'Allow post-sent edit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(666, 'FE_MODIFICATION_SENT_DESC', 'Do you allow the user to edit the Newsletter after the Newsletter has been sent?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(667, 'ARCHIVE_SECTION', 'Archive section', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(668, 'SUBJECT_DISPLAY_DESC', 'Display the Newsletter subject on the archive Newsletter?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(669, 'SUBJECT_DISPLAY', 'Display subject', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(670, 'ALREADY_SENT', '%s e-mails have already been sent for this Newsletter.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(671, 'REMOVE_ALREADY_SENT', 'Do you want to send this Newsletter only to your new users?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(672, 'SEND_TO_ALL', 'No, send to all users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(673, 'CLICK_BOUNCE', 'CLICK HERE to handle the messages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(674, 'NOTIF_UNSUB', 'When a user unsubscribes from a list, send an e-mail to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(675, 'NOTIF_UNSUB_DESC', 'Send an e-mail to those e-mail addresses if a user unsubscribes from a list.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(676, 'TEMPLATE_STYLESHEET', 'Stylesheet', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(677, 'BLOCK_USER', 'Block the user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(678, 'COMMENTS_ENABLED', 'User Comments', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(679, 'COMMENTS_ENABLED_DESC', 'Add user comments on your archive section', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(680, 'IMPORT_CONFIRMED', 'Import the users as confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(681, 'IMPORT_TEXTAREA', 'Textarea', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(682, 'GENERATE_NAME', 'Auto-generate User''s name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(683, 'ACTION_SELECT', 'Select an action', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(684, 'ADD_FILTER', 'Add a filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(685, 'ADD_ACTION', 'Add an action', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(686, 'ACTIONS', 'Actions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(687, 'ACY_ORDER', 'Order by', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(688, 'ACY_ID', 'ID', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(689, 'ACY_AUTHOR', 'Author', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(690, 'ACY_DESCRIPTION', 'Description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(691, 'ACY_ORDERING', 'Ordering', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(692, 'OPEN_POPUP_DESC', 'Do you want to open the archive Newsletter in a popup?<br /> If not, the Newsletter archive will be opened inside your Joomla template.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(693, 'OPEN_POPUP', 'Open the archive in a popup', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(694, 'SUBSCRIBE_TO', 'Subscribe users to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(695, 'REMOVE_FROM', 'Remove users from', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(696, 'ENTER_TITLE', 'Please enter a title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(697, 'REMOVE_SUB', 'Delete the user subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(698, 'MORE_PLUGINS', 'Click here to download more plugins', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(699, 'MORE_TEMPLATES', 'Click here to download more templates', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(700, 'ACY_LOAD', 'Load', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(701, 'ACY_FILTERS', 'Filters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(702, 'ACY_FILTER', 'Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(703, 'CONFIRM_USERS', 'Confirm users'' subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(704, 'BLOCK_USERS', 'Block users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(705, 'ENABLE_USERS', 'Enable users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(706, 'NB_CONFIRMED', '%s users confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(707, 'AUTO_TRIGGER_FILTER', 'Automatically trigger the filter:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(708, 'AUTO_CRON_FILTER', 'Every day (using the cron task) at', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(709, 'ON_USER_CREATE', 'On user creation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(710, 'ON_USER_CHANGE', 'On user modification', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(711, 'ON_USER_CLICK', 'When the user clicks on an url from your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(712, 'ON_OPEN_NEWS', 'When the user opens your Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(713, 'SUBSCRIBE_LIST', 'Click here to subscribe users to this list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(714, 'MISSING_LANGUAGE', 'Your language file is currently not installed.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(715, 'UPDATE_LANGUAGE', 'Your language file is not up to date.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(716, 'DONT_REMIND', 'I know, don''t remind me', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(717, 'META_DATA', 'Metadata', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(718, 'META_KEYWORDS', 'Meta Keywords', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(719, 'META_DESC', 'Meta Description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(720, 'STYLE_IND', 'Individual styling', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(721, 'CUSTOM_TEXT', 'Custom text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(722, 'RESIZED', 'Resized', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(723, 'EXISTING_FILTERS', 'Existing filters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(724, 'SELECT', 'Selection', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(725, 'SELECT_LISTS', 'Select one or several lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(726, 'AUTO_SUBSCRIBE', 'Auto-subscribe on Joomla registration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(727, 'AUTO_SUBSCRIBE_DESC', 'Users will be automatically subscribed to the selected lists if they register on your website via the Joomla registration page', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(728, 'FOLLOWUP_PUBLISHED_INFORMED', 'You just published this follow-up.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(729, 'FOLLOWUP_CHANGED_DELAY_INFORMED', 'You just changed the delay for this follow-up.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(730, 'FOLLOWUP_CHANGED_DELAY', 'Click here to update the send date with this new delay on the follow-up already inserted in your queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(731, 'NB_EMAILS_UPDATED', '%s e-mails have been updated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(732, 'ADD_QUEUE', 'Add an e-mail in the queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(733, 'REMOVE_QUEUE', 'Remove an e-mail from the queue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(734, 'TABLENAME', 'Table Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(735, 'SPECIFYTABLE', 'Please enter a table name from your database: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(736, 'SPECIFYFIELD', 'The field %s could not be found. Please specify a field from the table: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(737, 'SPECIFYFIELDEMAIL', 'An equivalent for the email field is required', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(738, 'DATABASE', 'Database', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(739, 'CATEGORY_VIEW', 'Category View', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(740, 'DETAILS_VIEW', 'Details View', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(741, 'ACY_HELP', 'Help', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(742, 'ACY_TEMPLATES', 'Templates', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(743, 'ACY_PREVIEW', 'Preview', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(744, 'ACY_COPY', 'Copy', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(745, 'ACY_PUBLISHED', 'Published', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(746, 'ACY_DELETE', 'Delete', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(747, 'ACY_USER', 'User', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(748, 'ACY_EXPORT', 'Export', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(749, 'ACY_NAME', 'Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(750, 'ACY_EDIT', 'Edit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(751, 'ACY_SAVE', 'Save', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(752, 'ACY_CLOSE', 'Close', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(753, 'ACY_CANCEL', 'Cancel', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(754, 'ACY_FILES', 'Files', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(755, 'ACY_APPLY', 'Apply', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(756, 'ACY_USERNAME', 'Username', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(757, 'ACY_FILE', 'File', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(758, 'ACY_NUM', '#', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(759, 'ACY_TITLE', 'Title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(760, 'ACY_EDITOR', 'Editor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(761, 'ACY_NONE', 'None', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(762, 'ACY_DEFAULT', 'Default', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(763, 'ACY_VALIDDELETEITEMS', 'Are you sure you want to delete the selected Items?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(764, 'ACY_MINUTES', 'Minutes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(765, 'ACY_SECONDS', 'Seconds', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(766, 'ACY_TIME', 'Time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(767, 'ACY_ALL', 'All', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(768, 'ACY_CREATED', 'Created', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(769, 'YES_SUBSCRIBE_ME', 'Yes, I want to receive Newsletters from your website', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(770, 'OVERWRITE_EXISTING', 'Overwrite existing user''s information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(771, 'WARNING_LIMITATION', 'Most hosting companies apply some limitations on the number of e-mails you can send per hour.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(772, 'WARNING_LIMITATION_CONFIG', 'Please make sure you configured AcyMailing to stay under these limitations.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(773, 'USERS_IN_COMP', 'There are %s users in %s.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini');
INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(774, 'ACY_NOTALLOWED', 'You are not authorized to view this resource.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(775, 'DISPLAY_EFFECT', 'Display Effect', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(776, 'VISIBLE_LISTS', 'Display the lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(777, 'AUTO_SUBSCRIBE_TO', 'Automatically subscribe to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(778, 'DISPLAY_MODE', 'Display Mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(779, 'LISTS_CHECKED_DEFAULT', 'Lists checked by default', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(780, 'CHECKED_MODE', 'Check the lists according to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(781, 'DROPDOWN_LISTS', 'Lists in a dropdown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(782, 'DESC_OVERLAY', 'Description as an overlay', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(783, 'LINKED_ARCHIVE', 'Add a link to the archive section', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(784, 'DISP_FIELDS', 'Displayed fields', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(785, 'CAPT_NAME', 'Name Caption', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(786, 'CAPT_EMAIL', 'Email Caption', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(787, 'DISP_TEXT_MODE', 'Display Text Mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(788, 'INTRO_TEXT', 'Intro Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(789, 'POST_TEXT', 'Post Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(790, 'DISP_SUB_BUTTON', 'Subscribe button', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(791, 'CAPT_SUB', 'Subscribe Caption', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(792, 'CAPT_SUB_LOGGED', 'Subscribe Caption for logged-in users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(793, 'DISP_UNSUB_BUTTON', 'Unsubscribe button', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(794, 'CAPT_UNSUB', 'Unsubscribe Caption', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(795, 'TERMS_CONTENT', 'Terms and Conditions Article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(796, 'TERMS_POPUP', 'Article displayed in a popup', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(797, 'MOO_BOX_HEIGHT', 'Popup Box height', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(798, 'MOO_BOX_WIDTH', 'Popup Box width', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(799, 'MOO_BUTTON', 'Mootools Button Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(800, 'MOO_INTRO', 'Intro Text for Mootools', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(801, 'REDIRECT_MODE', 'Redirect Mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(802, 'REDIRECT_LINK', 'Redirect Link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(803, 'ACY_IN', 'In', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(804, 'ACY_NOT_IN', 'Not in', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(805, 'ACY_NUMERIC', 'Numeric', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(806, 'ACY_STRING', 'String', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(807, 'ACY_BEGINS_WITH', 'Begins with', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(808, 'ACY_ENDS_WITH', 'Ends with', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(809, 'ACY_CONTAINS', 'Contains', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(810, 'EXPIRY_DATE', 'Expiry Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(811, 'CLICK_DATE', 'Click date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(812, 'ACY_DKIM', 'DKIM', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(813, 'ACY_DKIM_DESC', 'DomainKeys Identified Mail enables you to sign your messages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(814, 'DKIM_DOMAIN', 'Domain', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(815, 'DKIM_SELECTOR', 'Selector', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(816, 'DKIM_PASSPHRASE', 'Passphrase', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(817, 'DKIM_IDENTITY', 'Identity', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(818, 'DKIM_PRIVATE', 'Private key', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(819, 'DKIM_PUBLIC', 'Public Key', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(820, 'ACY_TABLECONTENTS', 'Table of Contents', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(821, 'ACY_EXISTINGANCHOR', 'Existing anchors', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(822, 'ACY_GENERATEANCHOR', 'Generate the table of contents based on', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(823, 'ACY_SENT_EMAILS', 'E-mails sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(824, 'ACY_VIEW', 'View', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(825, 'ACY_MANAGE', 'Manage', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(826, 'ACY_SUBSCRIBER', 'Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(827, 'ACY_SEPARATOR', 'Separator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(828, 'ACL_WRONG_CONFIG', 'You can not exclude yourself from the configuration management', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(829, 'NO_LIST_SELECTED', 'Please select the lists you want to subscribe to', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(830, 'ACY_LEVEL', 'Level %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(831, 'ACY_HISTORY', 'History', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(832, 'ACY_SOURCE', 'Source', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(833, 'ACY_DETAILS', 'Details', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(834, 'ACY_ACTION', 'Action', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(835, 'ACTION_CREATED', 'Created', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(836, 'ACTION_MODIFIED', 'Modified', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(837, 'ACTION_CONFIRMED', 'Confirmed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(838, 'ACTION_UNSUBSCRIBED', 'Unsubscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(839, 'EXECUTED_BY', 'Executed by', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(840, 'REASON', 'Reason', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(841, 'VIEW_DETAILS', 'View details', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(842, 'DATABASE_MAINTENANCE', 'Database Maintenance', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(843, 'DATABASE_MAINTENANCE_DESC', 'AcyMailing may save an important amount of information in the database.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(844, 'DATABASE_MAINTENANCE_DESC2', 'This area enables you to automatically delete some old information after X days.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(845, 'DELETE_DETAILED_STATS', 'Delete detailed statistics after', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(846, 'DELETE_HISTORY', 'Delete user history after', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(847, 'UNSUB_INTRO', 'Hello {user:name}, <br /><br />We are sorry to find you are no longer interested in our newsletters.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(848, 'UNSUB_SURVEY', 'Before you go, we''d be grateful if you''d let us know why you''re unsubscribing.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(849, 'UNSUB_SURVEY_FREQUENT', 'The emails we send you are too frequent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(850, 'UNSUB_SURVEY_RELEVANT', 'The emails we send are not relevant to you', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(851, 'UNSUB_SURVEY_OTHER', 'Please add any other reasons here:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(852, 'UNSUB_PAGE', 'Unsubscribe page', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(853, 'UNSUB_DISP_CHOICE', 'Display unsubscribe options', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(854, 'UNSUB_DISP_SURVEY', 'Display a survey', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(855, 'UNSUB_INTRODUCTION', 'Introduction text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(856, 'PLEASE_SELECT_USERS', 'Please select some users on the list first', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(857, 'AUTO_SEND_PROCESS', 'Automatic send process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(858, 'SEND_X_EVERY_Y', 'Send %s e-mails every %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(859, 'MANUAL_SEND_PROCESS', 'Manual send process', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(860, 'SEND_X_WAIT_Y', 'Send %s e-mails and then wait %s before sending another batch', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(861, 'CREATE_CRON_REMINDER', 'Your cron does not seem to be enabled, don''t forget to create it!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(862, 'DELETE_USERS', 'Delete Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(863, 'BOUNCE_SAVE_MESSAGE', 'Save message in database', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(864, 'ACTION_BOUNCE', 'Bounced', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(865, 'ACY_THEME', 'Theme', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(866, 'ACY_DOWNLOAD', 'Download', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(867, 'FILTER_AND', 'And', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(868, 'SELECTED_USERS', '%s users selected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(869, 'ACY_NEW', 'New', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(870, 'MENU_POSITION', 'Menu Position', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(871, 'UNDER_TITLE', 'Under the title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(872, 'ABOVE_MAIN_AREA', 'Above the main area', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(873, 'NB_UNSUB_USERS', '%s users unsubscribed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(874, 'NB_OPEN_USERS', '%s users opened the Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(875, 'NB_CLICK_USERS', '%s users clicked on a link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(876, 'NB_BOUNCED_USERS', '%s bounced', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(877, 'MOST_POPULAR_LINKS', 'Most popular links', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(878, 'NB_USERS_CLICKED_ON', '%s users clicked on %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(879, 'ACY_PRINT', 'Print', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(880, 'ACY_LINK_STYLE', 'Style of the links', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(881, 'ACY_RULE', 'Rule', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(882, 'REGEX_ON', 'Execute the regex on', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(883, 'ACY_BODY', 'Body', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(884, 'BOUNCE_EXEC_MIN', 'Execute the following actions only after receiving %s bounce messages from this user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(885, 'BOUNCE_STATS', 'Increment the bounce statistics if the rule matches', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(886, 'BOUNCE_RECEIVED', 'We received %s messages from the user %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(887, 'BOUNCE_MIN_EXEC', 'Actions will be executed after %s messages', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(888, 'PLEASE_SELECT', 'Please make a selection from the list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(889, 'CONFIRM_REINSTALL_RULES', 'AcyMailing will delete your existing rules and install the default ones.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(890, 'REINSTALL_RULES', 'Re-install rules', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(891, 'SEND_SERVER', 'Send e-mails using your server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(892, 'SEND_EXTERNAL', 'Send e-mails using an external server', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(893, 'SMTP_DESC', '%s is a delivery service you can use to send your e-mails.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(894, 'NO_ACCOUNT_YET', 'No account yet?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(895, 'CREATE_ACCOUNT', 'Create your account', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(896, 'ACTION_FORWARD', 'Forwarded a Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(897, 'TELL_ME_MORE', 'Tell me more about it', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(898, 'ACY_RANDOM', 'Random', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(899, 'RECEIVER_INFORMATION', 'Receiver Information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(900, 'ACY_DAY', 'Day', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(901, 'ACY_MONTH', 'Month', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(902, 'ACY_YEAR', 'Year', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(903, 'RECEIVER_LISTS', 'Only users subscribed to at least one of the above selected lists will receive the Newsletter.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(904, 'RECEIVER_FILTER', 'You can refine the user selection by adding criteria:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(905, 'FILTER_ONLY_IF', 'They should also meet ALL of the following criteria:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(906, 'USER_FIELDS', 'User Fields', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(907, 'ADVANCED_EMAIL_VERIFICATION', 'Advanced email verification', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(908, 'CHECK_DOMAIN_EXISTS', 'Check if the domain exists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(909, 'LATEST_NEWSLETTER', 'Latest Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(910, 'CUSTOM_TRANS', 'Custom translations', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(911, 'CUSTOM_TRANS_DESC', 'The following strings won''t be overwritten if you update/upgrade AcyMailing.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(912, 'CONFIRM_SHARE_TRANS', 'Are you sure you want to send us this translation? Please do not send it if you didn''t modify the translation.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(913, 'PLEASE_CONFIRM_SUB', 'Please confirm your subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(914, 'CONFIRM_MSG', 'You''ve subscribed to our Newsletters from our website', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(915, 'CONFIRM_MSG_ACTIVATE', 'We need you to activate your subscription by clicking the link below:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(916, 'LIST_RECEIVE', 'Recipient', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(917, 'IN_TEMPLATE', 'In your template', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(918, 'WITHOUT_TEMPLATE', 'Without template', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(919, 'MINUTES_AGO', '%s minutes ago', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(920, 'SENT_TO_NUMBER', 'This e-mail will be sent to %s users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(921, 'FIELD_FILE', 'File upload', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(922, 'CONFIG_TRY', 'Try %s times to deliver the message.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(923, 'CONFIG_TRY_ACTION', 'If it still fails, %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(924, 'DO_NOTHING', 'Do nothing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(925, 'TAG_MODULES', 'Modules', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(926, 'ACY_NOT_CONTAINS', 'Does not contain', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(927, 'SPAM_TEST', 'Spam Test', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(928, 'CREATE_NEWSLETTER', 'New newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(929, 'MODULE_ALIGNMENT', 'Module Alignment', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(930, 'MODULE_AUTOID', 'Display user information if logged in', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(931, 'MODULE_CACHING', 'Caching', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(932, 'MODULE_JS', 'Include JS files', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(933, 'ACY_ITEMID', 'Menu ID', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(934, 'MODULE_CLASSSUF', 'Module Class Suffix', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(935, 'SHOW_COLUMN_X', 'Display the column %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(936, 'RECEIVE_VIA_EMAIL', 'Receive via e-mail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(937, 'SEND_SELECT_NEWS', 'Send the selected Newsletters to...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(938, 'ACY_FROM_DATE', 'From', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(939, 'ACY_TO_DATE', 'To', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(940, 'X_INTEGRATION', '%s integration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(941, 'ACY_PERIOD', 'Date range', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(942, 'ACY_INTERVAL', 'Interval', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(943, 'CHART_TYPE', 'Chart type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(944, 'COLUMN_CHART', 'Column chart', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(945, 'LINE_CHART', 'Line chart', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(946, 'ACY_COMPARE', 'Compare...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(947, 'ACY_YEARS', 'Years', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(948, 'GENERATE_CHART', 'Generate chart', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(949, 'ACY_IMAGE', 'Image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(950, 'FIELD_PHONE', 'Phone', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(951, 'ADVICE_PORT', 'The port you specified (%s) is not a common port for smtp connexions... Please leave the port empty and give it a new try', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(952, 'SET_SUBSCRIBER_VALUE', 'Set subscriber''s profile value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(953, 'NB_MODIFIED', '%s users modified', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(954, 'ONLY_SOMETHING_WRONG', 'Only if an error occurs', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(955, 'MESSAGE_TO_FORWARD', 'Hello {subtag:name},<br /> {user:name} ( {user:email} ) wanted to forward you this email with the message :<br /> {forwardmsg}', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(956, 'ADD_FORWARD_MESSAGE', 'Do you want to add a note to the message sent?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(957, 'YOUR_NAME', 'Your name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(958, 'YOUR_EMAIL', 'Your email address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(959, 'FRIEND_NAME', 'Friend''s name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(960, 'FRIEND_EMAIL', 'Friend''s email address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(961, 'ADD_FRIEND', 'Add another friend', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(962, 'FILL_ALL', 'Please fill all information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(963, 'EXPORT_ENABLED', 'Only Enabled Users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(964, 'ACY_NEW_ORDERING_SAVED', 'New ordering saved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(965, 'ACY_GUESSPORT', 'What port can I use from my website?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(966, 'ACY_SELECTUSER', 'Select a user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(967, 'NOT_SENT', 'Not sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(968, 'CHANGE_TEMPLATE', 'The new template will replace the whole newsletter, the content you wrote will be deleted', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(969, 'REDIRECTION_MODULE', 'Allowed domains for the redirection via the module', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(970, 'REDIRECTION_MODULE_DESC', 'Write here the list of domains allowed to be used in the module redirection.<br />You should separate each domain by a | .', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(971, 'NO_REASON', 'No reason specified', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(972, 'COM_ACYMAILING_ARCHIVE_VIEW_DEFAULT_TITLE', 'Mailing List Archive (single list)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(973, 'COM_ACYMAILING_FRONTSUBSCRIBER_VIEW_DEFAULT_TITLE', 'Front-end user management', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(974, 'COM_ACYMAILING_LISTS_VIEW_DEFAULT_TITLE', 'Mailing Lists Archive (All lists)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(975, 'COM_ACYMAILING_FRONTNEWSLETTER_VIEW_DEFAULT_TITLE', 'Create Newsletter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(976, 'COM_ACYMAILING_USER_VIEW_DEFAULT_TITLE', 'Create/modify a subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(977, 'SEPARATOR_COMMA', 'Comma ( , )', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(978, 'SEPARATOR_SEMICOLON', 'Semicolon ( ; )', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(979, 'DKIM_CONFIGURE', 'Configure your DNS by adding a TXT record on your domain %s using the key/value as shown below.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(980, 'DKIM_LET_ME', 'Let me enter my own keys.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(981, 'DKIM_KEY', 'Key', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(982, 'DKIM_VALUE', 'Value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(983, 'ACY_STATS_ADDUP', 'Add up the results', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(984, 'ACY_THUMBNAIL', 'Thumbnail', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(985, 'READMORE_PICTURE', 'Read more picture', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(986, 'DELETE_PICT', 'Delete picture', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(987, 'ACYEDITOR_DELETEAREA', 'Are you sure you want to delete this area?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(988, 'ACYEDITOR_TEMPLATEDELETE', 'Deletable', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(989, 'ACYEDITOR_TEMPLATETEXT', 'Editable (Text)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(990, 'ACYEDITOR_TEMPLATEPICTURE', 'Editable (Picture)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(991, 'ACYEDITOR_SHOWAREAS', 'Show areas', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(992, 'ACYEDITOR_ADDAREAS', 'Your template does not contain editable areas, click here if you want the software to add them automatically.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(993, 'ACYEDITOR_ADDAREAS_ONLYFINISHED', 'You should do that only once your template is finished.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(994, 'ACYEDITOR_ADDAREAS_DONE', 'Editable areas successfully added', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(995, 'USER_ALREADY_EXISTS', 'A user already exists with the e-mail address %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(996, 'CLICK_EDIT_USER', 'Click here to edit this user', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(997, 'TRUNCATE_AFTER', 'Truncate the text after %s characters', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(998, 'STATS_PER_LIST', 'Stats per list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(999, 'ACY_SSLCHOICE_DESC', 'Do you use the https protocol on your front-end? If so, turn this option ON.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1000, 'ACY_SSLCHOICE', 'Use https urls', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1001, 'TRACKING', 'Tracking', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1002, 'TRACKINGSYSTEM', 'Track clicks with', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1003, 'USE_BOOTSTRAP_FRONTEND', 'Use Bootstrap on the front-end', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1004, 'NEWSLETTER_INSTALLED', 'Newsletter imported successfully', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1005, 'ACY_TYPE', 'Type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1006, 'GEOLOCATION', 'Geolocation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1007, 'GEOLOCATION_TYPE', 'When does AcyMailing save the user''s position?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1008, 'GEOLOCATION_TYPE_DESC', 'AcyMailing will save the user''s location at distinct times to provide more information about the user.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1009, 'GEOLOC_CONFIRM_SUB', 'Confirmation of subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1010, 'GEOLOCATION_API_KEY_DESC', 'You need an api key to use the geolocation. Please create an account and enter your API key here.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1011, 'GEOLOC_UNSUB', 'Unsubscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1012, 'STATECAPTION', 'State', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1013, 'GEOLOC_NB_ACTIONS', 'Number of actions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1014, 'GEOLOC_COUNTRYCODE', 'Code of the country', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1015, 'GEOLOC_STATECODE', 'Code of the region/state', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1016, 'GEOLOC_POSTALCODE', 'Zipcode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1017, 'GEOLOC_LATITUDE', 'Latitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1018, 'GEOLOC_LONGITUDE', 'Longitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1019, 'GEOLOC_RECENT', 'Most recent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1020, 'GEOLOC_TEST_API_KEY', 'Test the geolocation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1021, 'ACY_SEARCH', 'Search...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1022, 'ACY_NEIGHBOUR', 'Users with same IP', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1023, 'GEOLOC_NB_USERS', 'Number of users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1024, 'IMPORT_BLOCKED', 'Import users as blocked', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1025, 'JOOMEXT_YES_CAMPAIGN', 'Yes + Campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1026, 'JOOMEXT_YES_FORWARD', 'Yes + Captcha', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1027, 'NOTIF_CONTACT_DESC', 'Send an e-mail to those e-mail addresses if a user submits the subscription form.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1028, 'NOTIF_CONTACT', 'When a user submits the subscription form', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1029, 'NOTIF_CONFIRM_DESC', 'Send an e-mail to those e-mail addresses if a user confirms his subscription.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1030, 'NOTIF_CONFIRM', 'When a user confirms his subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1031, 'LINK_ID', 'Link id', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1032, 'ACY_ASAP', 'As soon as possible', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1033, 'ACY_ONTHE', 'On the', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1034, 'ACY_DAYOFMONTH', 'of the month', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1035, 'FREQUENCY_FIRST', '1st', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1036, 'FREQUENCY_SECOND', '2nd', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1037, 'FREQUENCY_THIRD', '3rd', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1038, 'FREQUENCY_LAST', 'Last', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1039, 'JOOMLA_CONFIRM_LINK', 'Insert a Joomla user confirmation link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1040, 'JOOMLA_CONFIRM_ACCOUNT', 'Confirm your account', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1041, 'CURRENT_USER_INFO', 'Current user information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1042, 'CLICK_HANDLE_ALL_BOUNCES', 'Click here to handle all messages until your mailbox is empty', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1043, 'FIELD_AUTHORIZED_CONTENT', 'Authorized content', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1044, 'ONLY_NUMBER', 'Numbers Only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1045, 'ONLY_LETTER', 'Letters only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1046, 'ONLY_NUMBER_LETTER', 'Numbers and letters only', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1047, 'MY_REGEXP', 'My regular expression', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1048, 'FIELD_ERROR_AUTHORIZED_CONTENT', 'Error message if invalid', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1049, 'FIELD_CONTENT_VALID', 'Please enter a correct value for the field %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1050, 'DISPLAY_FRONTJOOMLEREGISTRATION', 'J! Registration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1051, 'DISPLAY_JOOMLAPROFILE', 'J! User Profile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1052, 'FRONTEND', 'Front-end', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1053, 'BACKEND', 'Back-end', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1054, 'DISPLAY_ACYPROFILE', 'Profile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1055, 'DISPLAY_ACYLISTING', 'Listing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1056, 'FILTER_VIEW_USERS', 'View users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1057, 'ACY_FILTEREDUSERS', 'First %1$s users filtered out of %2$s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1058, 'TRIGGER_CAMPAIGN', 'Trigger the campaign %1$s %2$s after the filter is executed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1059, 'SEND_COMMENT', 'Comment', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1060, 'SEND_COMMENT_DESC', 'This comment will be displayed at the begining of your test email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1061, 'JGRID_CHECKBOX_ROW_N', 'Checkbox for row %d', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1062, 'LISTS_IN_COMP', 'There are %s lists in %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1063, 'IMPORT_X_LISTS', 'You can import those %s lists and so keep the subscription assigned to each user.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1064, 'IMPORT_LIST_TOO', 'Import the %s lists too?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1065, 'ACYTEMPLATE_EXPORTED', 'Your template has been exported successfully in the media/com_acymailing/tmp folder. Click %1$sHERE%2$s to download it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1066, 'NEWS_IN_COMP', 'There are %s newsletters in %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1067, 'IMPORT_NEWSLETTERS_TOO', 'Import the %s newsletters too?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1068, 'NB_IMPORT_NEWSLETTER', '%s newsletters imported', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1069, 'ACY_START_CAMPAIGN', 'Start the campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1070, 'START_ON_SUBSCRIBE', 'When the user subscribes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1071, 'START_ON_DAY', 'The next %s after the user subscription', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1072, 'AUTO_GENERATED_HTML', 'Auto-generated from the HTML version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1073, 'USE_DEFAULT_VALUE', 'Use default value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1074, 'SUCCESS_FILE_UPLOAD', 'Image successfully uploaded', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1075, 'NO_FILE_FOUND', 'No file found in this folder', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1076, 'IMAGE_RESIZED', 'Image has been resized to be 700px', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1077, 'ACY_OR', 'or', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1078, 'MEDIA_BACK', 'Back', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1079, 'INSERT_IMAGE_FROM_URL', 'Insert image from url', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1080, 'UPLOAD_NEW_IMAGE', 'Upload a new image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1081, 'ALIGNMENT', 'Alignment', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1082, 'NOT_SET', 'Not set', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1083, 'ACY_MARGIN', 'Margin', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1084, 'ACY_BORDER', 'Border', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1085, 'ACY_LINK', 'Link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1086, 'INSERT', 'Insert', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1087, 'MEDIA_FOLDER_DESC', 'Folders used to browse images when using the Acyeditor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1088, 'MEDIA_FOLDER', 'Media Folder', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1089, 'FILE_RENAMED', 'An image with this name already exists. Image has been renamed as %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1090, 'IMAGE_NOT_FOUND', 'Sorry, but we did not find anything there...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1091, 'IMAGE_FOUND', 'Looks like we found it!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1092, 'IMAGE_TIMEOUT', 'Image cannot be loaded due to timeout', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1093, 'NO_ACCESS_NEWSLETTER', 'You can not have access to this Newsletter (%s)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1094, 'ACY_RIGHT', 'Right', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1095, 'ACY_LEFT', 'Left', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1096, 'LIST_POSITION', 'Display the lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1097, 'ACY_BEFORE_FIELDS', 'Before the fields', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1098, 'ACY_AFTER_FIELDS', 'After the fields', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1099, 'IPTIMECHECK', 'Limit same IP subscriptions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1100, 'IPTIMECHECK_DESC', 'Limit the subscriptions to maximum 3 per two hours from the same IP', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1101, 'DBVALUES', 'Values from Database', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1102, 'ACY_WHERE', 'Where', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1103, 'ACY_ANY_CATEGORY', 'Any category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1104, 'IMPORT_SUBSCRIBE_CREATE', 'Subscribe users to a new list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1105, 'JOOMLA_NOTIFICATIONS', 'Joomla notifications', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1106, 'ACY_SENT', 'Sent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1107, 'WANNA_REINSTALL_RULES', 'The bounce rules have been updated, you may want to reinstall your rules to use the latest version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1108, 'AUTONEWS_GENERATE_INTRO', 'Hi {subtag:name},<br />The Newsletter below has been generated.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1109, 'AUTONEWS_GENERATE_INTRO_SENT', 'This Newsletter has been scheduled and will be sent asap.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1110, 'AUTONEWS_GENERATE_INTRO_REVIEW', 'Please review it and click on this link to send it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1111, 'AUTONEWS_GENERATE_DONE', 'The Newsletter is published, maybe it has been sent already?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1112, 'ARCHIVE_INDEX_FOLLOW_DESC', 'Do you want your archived newsletters not to be indexed by search engines (noindex) and that they don''t follow the links contained in your newsletter (nofollow)?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1113, 'ARCHIVE_INDEX_FOLLOW', 'Index/Follow Archive', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1114, 'DATABASE_INTEGRITY', 'Check database integrity', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1115, 'ACYEDITOR_TEMPLATEMORE', 'More actions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1116, 'ACYEDITOR_DUPLICATE_AFTER', 'Duplicate after', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1117, 'ACYEDITOR_DEFAULTTEXT', 'Click here to edit your text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1118, 'CREATE_FOLDER', 'Create Folder', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1119, 'FOLDER_NAME', 'Folder''s Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1120, 'FOLDER_ALREADY_EXISTS', 'This folder already exists, please try again.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1121, 'CUSTOM_VIEW', 'Custom view', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1122, 'CUSTOM_VIEW_DESC', 'Set a custom view name from Zoho CRM to only import users from this view', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1123, 'FOLLOWUP_ADDQUEUE_USERS', 'Click here to add this follow-up in the queue for users subscribed to your campaign since %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1124, 'FOLLOWUP_ADDQUEUE_ALLUSERS', 'Click here to add this follow-up in the queue for all users subscribed to your campaign', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1125, 'ACY_MAX_RUN', 'Based on our check, we can run each batch for %s seconds', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1126, 'ACY_TIMEOUT_AGAIN', 'Calculate the real maximum execution time again', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1127, 'ACY_TIMEOUT_CURRENT', 'We are currently checking your real maximum execution time... At least %s seconds so far', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1128, 'ACY_MAX_EXECUTION_TIME', 'Maximum execution time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1129, 'ACY_TIMEOUT_SERVER', 'Based on your server configuration, each batch can run for %s seconds', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1130, 'ACY_LANGUAGE', 'Language', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1131, 'ACY_CLOSE_TIMEOUT', 'You can close this configuration page while we are checking your timeout', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1132, 'ACYEDITOR_REINIT_ZONE_TOOLTIP', 'Reinitialize areas', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1133, 'ACYEDITOR_REINIT_ZONE_CONFIRMATION', 'Are you sure you want to reinitialize all areas?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1134, 'ACY_JPAGETITLE', '%1$s - %2$s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1135, 'ACY_ACTION_UNCONFIRM', 'Unconfirm users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1136, 'ACY_LOADZOHOFIELDS', 'Load ZohoCRM fields list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1137, 'ACY_LOADFIELDS', 'Load fields', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1138, 'ACY_FIELDSLOADED', 'Fields loaded successfully', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1139, 'ACY_NOFIELD', 'ZohoCRM returned no field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1140, 'ACY_ZOHOLIST', 'ZohoCRM list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1141, 'ACY_SUB_NOT_CONFIRMED', 'Your subscription to our newsletter is not confirmed.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1142, 'ACY_RELATIVE_DATE', 'Relative date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1143, 'ACY_SPECIFIC_DATE', 'Specific date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1144, 'ACY_BEFORE', 'Before', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1145, 'ACY_AFTER', 'After', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1146, 'ACY_EXECUTION_TIME', 'Execution time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1147, 'ACY_PHONE_NOCOUNTRY', 'No Country', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1148, 'ACY_ZOHO_GENERATE_NAME', 'Generate name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1149, 'ACY_ZOHO_GENERATE_NAME_DESC', 'Choose whether to generate the name of the user created from the email or from the fields title, first and last name (if the name field is not assigned to any Zoho field)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1150, 'ACY_ZOHO_GENERATE_NAME_FROM_EMAIL', 'From email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1151, 'ACY_ZOHO_GENERATE_NAME_FROM_FIELDS', 'From concatenation of title, first and last name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1152, 'ACY_SSLCHOICE_CONFIRMATION', 'If you turn this option on but do not support HTTPS, images, urls and other things could break within your site. Are you sure?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1153, 'ACY_TRACKINGSYSTEM_EXTERNAL_LINKS', 'Track links for external websites', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1154, 'ABTESTING', 'A/B Testing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1155, 'PLEASE_SELECT_NEWSLETTERS', 'Please select at least two newsletters first', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1156, 'ABTESTING_TITLE', '%s Testing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1157, 'ABTESTING_PART_RECEIVER', 'Test sending on %s of the receivers. The test will be equally divided between the following newsletters:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1158, 'ABTESTING_MODIFY_RECEIVERS', 'Modify these receivers by editing %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1159, 'ABTESTING_DELAY_ACTION', 'After %s days:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1160, 'ABTESTING_ACTION_GENERATE_OPEN', 'Generate and send automatically the newsletter with the best open rate', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1161, 'ABTESTING_ACTION_GENERATE_CLICK', 'Generate and send automatically the newsletter with the best click rate', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1162, 'ABTESTING_ACTION_GENERATE_MIX', 'Generate and send automatically a newsletter with the subject of the best open rate and the body of the best click rate', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1163, 'ABTESTING_TEST', 'Test', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1164, 'ABTESTING_STAT_WARNING', 'Launching a new test will delete existing statistics on the selected newsletters.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini');
INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(1165, 'ABTESTING_INPROGRESS', 'There is a test saved. Modifying it will stop the test and start from the beginning. This may send again newsletter to the same users.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1166, 'ABTESTING_TESTMAILINQUEUE', 'At least one of these newsletters is currently in the queue. You need to remove them from the queue or wait the end of sending before continuing.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1167, 'ABTESTING_FINALMAILINQUEUE', 'You are currently sending the final message. Please wait the end of the sending or empty the queue before you can launch a new test.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1168, 'ABTESTING_SUCCESSADD', 'The A/B test has been launched successfully. %s emails have been added in the queue.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1169, 'ABTESTING_SENTTO_NUMBER', 'This test will be sent to %1$s / %2$s users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1170, 'ABTESTING_READYTOSEND', 'The test is finished, you can choose which mail to send to the remaining subscribers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1171, 'ABTESTING_COMPLETE', 'The test and corresponding sending are finished', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1172, 'ABTESTING_FINALSEND', 'The newsletter %s has been added into queue for the remaining receivers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1173, 'ABTESTING_TESTEXIST', 'One of the newsletters is used in another test. This test will be displayed here.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1174, 'ABTESTING_NEEDVALUE', 'You need to set a percentage of receivers before proceeding', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1175, 'ABTESTING_NOTENOUGHUSER', 'You need at least 50 subscribers to the lists to launch your test (you only have %s)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1176, 'ACY_CLASS', 'Class', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1177, 'ACY_IMPORT_NO_CONTENT', 'The imported data must contain some content', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1178, 'ACY_FIRST_LINES', 'First %s lines of your file', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1179, 'ACY_IMPORT_LISTS', 'The imported users will be subscribed to the lists', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1180, 'ACY_IGNORE', 'Ignore', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1181, 'ACY_IGNORE_LINE', 'This first line will be ignored', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1182, 'ACY_CREATE_FIELD', 'Create a new field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1183, 'ACY_ASSIGN_COLUMNS', 'Assign columns', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1184, 'ACY_ASSIGN_COLUMNS_DESC', 'Assign the imported columns to an AcyMailing field, create new custom fields or ignore some imported columns.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1185, 'ACY_MATCH_DATA', 'Match the data', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1186, 'ACY_DOWNLOAD_IMPORT_ERRORS', 'Click here to download all lines containing errors', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1187, 'NOTIF_CONTACT_MENU_DESC', 'Send an e-mail to those e-mail addresses if a user submits the subscription form from menu Subscribe/Modify your subscription.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1188, 'NOTIF_CONTACT_MENU', 'When a user submits the menu subscription form', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1189, 'ACY_ONLYAUTOPROCESS', 'You configured AcyMailing to use the automatic send process only. You can''t trigger the send process via this button unless you allow the manual send process via the AcyMailing configuration page', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1190, 'ACY_RAND_LIMIT', 'Randomly select %s users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1191, 'ACY_IGNORE_UNASSIGNED', 'Ignore unassigned columns', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1192, 'ACY_ZOHO_IMPORT_NEW', 'Only new and modified users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1193, 'ACY_ORDER_SEND_QUEUE', 'Order the send process by', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1194, 'ACY_NO_RAND_FOR_MULTQUEUE', 'You should not use the random ordering if you use the multiple queue system.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1195, 'ABTESTING_MISSINGEMAIL', 'At least one email of this test has been deleted. There is nothing to display.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1196, 'ACY_CATEGORY', 'Category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1197, 'ACY_NEW_CATEGORY', 'Create a new category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1198, 'ACYEDITOR_SORTABLE_AREA_TOOLTIP', 'Sortable areas', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1199, 'ACY_CRON_CHANGE_FREQUENCY_WARNING', 'Our web cron service triggers your website every 15 minutes, you should keep a 15 minutes frequency here unless you create your own cron', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1200, 'ACY_OPERATOR_ADDEND', 'Add at the end', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1201, 'ACY_OPERATOR_ADDBEGINNING', 'Add at the beginning', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1202, 'ACY_SUB_GROUPS', 'Include sub-groups', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1203, 'ACYEXPORT_GEOLOC_VALUE', 'Geolocation values', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1204, 'ACYEXPORT_LAST_GEOL_SAVED', 'Last saved data', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1205, 'SEPARATOR_FIRST_GEOL_SAVED', 'First saved data', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1206, 'ACYFIELD_EDITABLE_CREATE_FRONT', 'Editable on user creation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1207, 'ACYFIELD_EDITABLE_MODIFY_FRONT', 'Editable on user modification', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1208, 'ACY_SUMMARY', 'Summary', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1209, 'ACY_SUMMARY_PLACEHOLDER', 'This description will be displayed in the archive zone.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1210, 'ACY_SENT_ON', 'Sent on %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1211, 'ACY_ALL_CATEGORIES', 'All categories', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1212, 'ACY_FIELD_CAT_TAG', 'HTML tag for categories', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1213, 'ACY_FIELD_CAT_CLASS', 'CSS class', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1214, 'ACY_INBOX_ACTIONS', 'Inbox actions', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1215, 'ACY_BUTTON_CONFIRM', 'One clic confirm', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1216, 'ACY_BUTTON_SAVE', 'One clic save', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1217, 'ACY_GOTO', 'Go-To', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1218, 'ACY_BUTTON_TEXT', 'Button text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1219, 'ACY_INBOX_ACTIONS_WHITELIST', 'You MUST ask Google to whitelist you in order to be able to use the inbox actions otherwise no button will be displayed in the receiver''s inbox.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1220, 'ACY_STARTER_SPAMTEST', 'Our spam test tool is a feature available in all our paid versions.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1221, 'ACY_FEATURES', 'Check out our extra features', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1222, 'ACY_FIELD_DISPLAYLIMITED', 'Display only if', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1223, 'ACY_NO_CATEGORY', 'No category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1224, 'ACY_VALID_DELETE_FROM_QUEUE', 'Are you sure you want to delete these %s emails from the queue?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1225, 'ACY_FE_DELETE_BUTTON', 'Delete button behavior', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1226, 'ACY_FE_DELETE_BUTTON_DESC', 'Should the delete button really delete the user or simply unsubscribe him from the current list?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1227, 'ACY_UNSUB_FROM', 'Unsubscribe users from', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1228, 'ACY_NON_LOGGED_IN', 'Non-logged in users', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1229, 'ALL_RULES', 'All rules', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1230, 'NO_RULE_SAVED', 'No rule recorded', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1231, 'ACY_CLICK_EFFICIENCY', 'Efficiency', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1232, 'ACY_CLICK_EFFICIENCY_DESC', '%s users who opened the email clicked on a link', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1233, 'ACY_STAT_OPEN_RATE', 'Open rate', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1234, 'ACY_STAT_OPEN_CLICK', 'Open / Click total', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1235, 'ACY_STAT_OPEN_CLICK_DAY', 'Open / Click per day', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1236, 'ACY_STAT_BROWSER', 'Browsers', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1237, 'ACY_STAT_MOBILE_USAGE', 'Devices', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1238, 'ACY_STAT_MOBILE', 'Mobile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1239, 'ACY_STAT_NOMOBILE', 'Computer', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1240, 'ACY_STAT_MOBILEOS', 'Mobile OS', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1241, 'ACY_LANG_VERSION', '4.9.3', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_acymailing.ini'),
(1242, 'COM_AJAX', 'Ajax Interface', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_ajax.ini'),
(1243, 'COM_AJAX_XML_DESCRIPTION', 'An extendable Ajax interface for Joomla.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_ajax.ini'),
(1244, 'COM_AJAX_SPECIFY_FORMAT', 'Please specify a valid response format, other than that of HTML, such as json, raw, debug, etc.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_ajax.ini'),
(1245, 'COM_AJAX_METHOD_NOT_EXISTS', 'Method %s does not exist.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_ajax.ini'),
(1246, 'COM_AJAX_FILE_NOT_EXISTS', 'The file at %s does not exist.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_ajax.ini'),
(1247, 'COM_AJAX_MODULE_NOT_ACCESSIBLE', 'Module %s is not published, you do not have access to it, or it''s not assigned to the current menu item.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_ajax.ini'),
(1248, 'COM_CONFIG', 'Admin Services', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1249, 'COM_CONFIG_CONFIGURATION', 'Admin Services Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1250, 'COM_CONFIG_ERROR_CONTROLLER_NOT_FOUND', 'Controller Not found!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1251, 'COM_CONFIG_FIELD_DEFAULT_ACCESS_LEVEL_DESC', 'Select the default access level for new content, menu items and other items created on your site.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1252, 'COM_CONFIG_FIELD_DEFAULT_ACCESS_LEVEL_LABEL', 'Default Access Level', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1253, 'COM_CONFIG_FIELD_DEFAULT_LIST_LIMIT_DESC', 'Sets the default length of lists in the Control Panel for all users.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1254, 'COM_CONFIG_FIELD_DEFAULT_LIST_LIMIT_LABEL', 'Default List Limit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1255, 'COM_CONFIG_FIELD_METADESC_DESC', 'Enter a description of the overall website that is to be used by search engines. Generally, a maximum of 20 words is optimal.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1256, 'COM_CONFIG_FIELD_METADESC_LABEL', 'Site Meta Description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1257, 'COM_CONFIG_FIELD_METAKEYS_DESC', 'Enter the keywords and phrases that best describe your website. Separate keywords and phrases with a comma.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1258, 'COM_CONFIG_FIELD_METAKEYS_LABEL', 'Site Meta Keywords', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1259, 'COM_CONFIG_FIELD_SEF_URL_DESC', 'Select whether or not the URLs are optimised for Search Engines.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1260, 'COM_CONFIG_FIELD_SEF_URL_LABEL', 'Search Engine Friendly URLs', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1261, 'COM_CONFIG_FIELD_SITE_NAME_DESC', 'Enter the name of your website. This will be used in various locations (eg the Backend browser title bar and <em>Site Offline</em> pages).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1262, 'COM_CONFIG_FIELD_SITE_NAME_LABEL', 'Site Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1263, 'COM_CONFIG_FIELD_VALUE_AFTER', 'After', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1264, 'COM_CONFIG_FIELD_VALUE_BEFORE', 'Before', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1265, 'COM_CONFIG_FIELD_SITE_OFFLINE_DESC', 'Select whether access to the Site Frontend is available. If Yes, the Frontend will display a message if set such in Backend.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1266, 'COM_CONFIG_FIELD_SITE_OFFLINE_LABEL', 'Site Offline', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1267, 'COM_CONFIG_FIELD_SITENAME_PAGETITLES_DESC', 'Begin or end all Page Titles with the site name (for example, My Site Name - My Article Name).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1268, 'COM_CONFIG_FIELD_SITENAME_PAGETITLES_LABEL', 'Include Site Name in Page Titles', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1269, 'COM_CONFIG_METADATA_SETTINGS', 'Metadata Settings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1270, 'COM_CONFIG_MODULES_MODULE_NAME', 'Module Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1271, 'COM_CONFIG_MODULES_MODULE_TYPE', 'Module Type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1272, 'COM_CONFIG_MODULES_SETTINGS_TITLE', 'Module Settings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1273, 'COM_CONFIG_MODULES_SAVE_SUCCESS', 'Module successfully saved.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1274, 'COM_CONFIG_SAVE_SUCCESS', 'Configuration successfully saved.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1275, 'COM_CONFIG_SEO_SETTINGS', 'SEO Settings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1276, 'COM_CONFIG_SITE_SETTINGS', 'Site Settings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1277, 'COM_CONFIG_TEMPLATE_SETTINGS', 'Template Settings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1278, 'COM_CONFIG_XML_DESCRIPTION', 'Frontend Admin Services Configuration Manager.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_config.ini'),
(1279, 'COM_CONTACT_ADDRESS', 'Address', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1280, 'COM_CONTACT_ARTICLES_HEADING', 'Contact''s articles', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1281, 'COM_CONTACT_CAPTCHA_LABEL', 'Captcha', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1282, 'COM_CONTACT_CAPTCHA_DESC', 'Type in the textbox what you see in the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1283, 'COM_CONTACT_CAT_NUM', '# of Contacts :', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1284, 'COM_CONTACT_CONTACT_EMAIL_A_COPY_DESC', 'Sends a copy of the message to the address you have supplied.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1285, 'COM_CONTACT_CONTACT_EMAIL_A_COPY_LABEL', 'Send Copy to Yourself', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1286, 'COM_CONTACT_CONTACT_EMAIL_NAME_DESC', 'Your name.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1287, 'COM_CONTACT_CONTACT_EMAIL_NAME_LABEL', 'Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1288, 'COM_CONTACT_CONTACT_ENTER_MESSAGE_DESC', 'Enter your message here.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1289, 'COM_CONTACT_CONTACT_ENTER_MESSAGE_LABEL', 'Message', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1290, 'COM_CONTACT_CONTACT_ENTER_VALID_EMAIL', 'Please enter a valid email address.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1291, 'COM_CONTACT_CONTENT_TYPE_CONTACT', 'Contact', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1292, 'COM_CONTACT_CONTENT_TYPE_CATEGORY', 'Contact Category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1293, 'COM_CONTACT_FILTER_LABEL', 'Filter Field', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1294, 'COM_CONTACT_FILTER_SEARCH_DESC', 'Contact Filter Search', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1295, 'COM_CONTACT_CONTACT_MESSAGE_SUBJECT_DESC', 'Enter the subject of your message here.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1296, 'COM_CONTACT_CONTACT_MESSAGE_SUBJECT_LABEL', 'Subject', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1297, 'COM_CONTACT_CONTACT_SEND', 'Send Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1298, 'COM_CONTACT_COPYSUBJECT_OF', 'Copy of: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1299, 'COM_CONTACT_COPYTEXT_OF', 'This is a copy of the following message you sent to %s via %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1300, 'COM_CONTACT_COUNT', 'Contact count:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1301, 'COM_CONTACT_COUNTRY', 'Country', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1302, 'COM_CONTACT_DEFAULT_PAGE_TITLE', 'Contacts', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1303, 'COM_CONTACT_DETAILS', 'Contact', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1304, 'COM_CONTACT_DOWNLOAD_INFORMATION_AS', 'Download information as:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1305, 'COM_CONTACT_EMAIL_BANNEDTEXT', 'The %s of your email contains banned text.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1306, 'COM_CONTACT_EMAIL_DESC', 'Email Address for contact.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1307, 'COM_CONTACT_EMAIL_FORM', 'Contact Form', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1308, 'COM_CONTACT_EMAIL_LABEL', 'Email', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1309, 'COM_CONTACT_EMAIL_THANKS', 'Thank you for your email.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1310, 'COM_CONTACT_ENQUIRY_TEXT', 'This is an enquiry email via %s from:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1311, 'COM_CONTACT_ERROR_CONTACT_NOT_FOUND', 'Contact not found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1312, 'COM_CONTACT_FAX', 'Fax', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1313, 'COM_CONTACT_FAX_NUMBER', 'Fax: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1314, 'COM_CONTACT_FORM_LABEL', 'Send an Email. All fields with an * are required.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1315, 'COM_CONTACT_FORM_NC', 'Please make sure the form is complete and valid.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1316, 'COM_CONTACT_IMAGE_DETAILS', 'Contact image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1317, 'COM_CONTACT_LINKS', 'Links', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1318, 'COM_CONTACT_MAILENQUIRY', '%s Enquiry', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1319, 'COM_CONTACT_MOBILE', 'Mobile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1320, 'COM_CONTACT_MOBILE_NUMBER', 'Mobile: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1321, 'COM_CONTACT_NO_CONTACTS', 'There are no Contacts to display', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1322, 'COM_CONTACT_NOT_MORE_THAN_ONE_EMAIL_ADDRESS', 'You can''t enter more than one email address.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1323, 'COM_CONTACT_OPTIONAL', '(optional)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1324, 'COM_CONTACT_OTHER_INFORMATION', 'Miscellaneous Information', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1325, 'COM_CONTACT_POSITION', 'Position', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1326, 'COM_CONTACT_PROFILE', 'Profile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1327, 'COM_CONTACT_PROFILE_HEADING', 'Contact profile', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1328, 'COM_CONTACT_SELECT_CONTACT', 'Select a contact:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1329, 'COM_CONTACT_STATE', 'State', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1330, 'COM_CONTACT_SUBURB', 'Suburb', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1331, 'COM_CONTACT_TELEPHONE', 'Phone', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1332, 'COM_CONTACT_TELEPHONE_NUMBER', 'Phone: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1333, 'COM_CONTACT_VCARD', 'vCard', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_contact.ini'),
(1334, 'COM_CONTENT_ACCESS_DELETE_DESC', 'Inherited state for <strong>delete actions</strong> on this article and the calculated state based on the menu selection.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1335, 'COM_CONTENT_ACCESS_EDITSTATE_DESC', 'Inherited state for <strong>edit state actions</strong> on this article and the calculated state based on the menu selection.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1336, 'COM_CONTENT_ACCESS_EDIT_DESC', 'Inherited state for <strong>edit actions</strong> on this article and the calculated state based on the menu selection.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1337, 'COM_CONTENT_ARTICLE_CONTENT', 'Content', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1338, 'COM_CONTENT_ARTICLE_HITS', 'Hits: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1339, 'COM_CONTENT_ARTICLE_INFO', 'Details', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1340, 'COM_CONTENT_ARTICLE_VOTE_SUCCESS', 'Thank You for rating this Article.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1341, 'COM_CONTENT_ARTICLE_VOTE_FAILURE', 'You already rated this Article today!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1342, 'COM_CONTENT_AUTHOR_FILTER_LABEL', 'Author Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1343, 'COM_CONTENT_CATEGORY', 'Category: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1344, 'COM_CONTENT_CHECKED_OUT_BY', 'Checked out by %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1345, 'COM_CONTENT_CONTENT_TYPE_ARTICLE', 'Article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1346, 'COM_CONTENT_CONTENT_TYPE_CATEGORY', 'Article Category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1347, 'COM_CONTENT_CREATE_ARTICLE', 'Submit new article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1348, 'COM_CONTENT_CREATED_DATE', 'Created Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1349, 'COM_CONTENT_CREATED_DATE_ON', 'Created: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1350, 'COM_CONTENT_EDIT_ITEM', 'Edit Article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1351, 'COM_CONTENT_ERROR_ARTICLE_NOT_FOUND', 'Article not found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1352, 'COM_CONTENT_ERROR_LOGIN_TO_VIEW_ARTICLE', 'Please login to view the article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1353, 'COM_CONTENT_ERROR_PARENT_CATEGORY_NOT_FOUND', 'Parent category not found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1354, 'COM_CONTENT_FEED_READMORE', 'Read More ...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1355, 'COM_CONTENT_FILTER_SEARCH_DESC', 'Content Filter Search', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1356, 'COM_CONTENT_FORM_EDIT_ARTICLE', 'Edit an article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1357, 'COM_CONTENT_HEADING_TITLE', 'Title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1358, 'COM_CONTENT_HITS_FILTER_LABEL', 'Hits Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1359, 'COM_CONTENT_INTROTEXT', 'Article must have some content.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1360, 'COM_CONTENT_INVALID_RATING', 'Article Rating: Invalid Rating: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1361, 'COM_CONTENT_LAST_UPDATED', 'Last Updated: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1362, 'COM_CONTENT_METADATA', 'Metadata', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1363, 'COM_CONTENT_MODIFIED_DATE', 'Modified Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1364, 'COM_CONTENT_MONTH', 'Month', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1365, 'COM_CONTENT_MORE_ARTICLES', 'More Articles ...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1366, 'COM_CONTENT_NEW_ARTICLE', 'New Article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1367, 'COM_CONTENT_NO_ARTICLES', 'There are no articles in this category. If subcategories display on this page, they may contain articles.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1368, 'COM_CONTENT_NONE', 'None', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1369, 'COM_CONTENT_NUM_ITEMS', 'Article Count:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1370, 'COM_CONTENT_ON_NEW_CONTENT', 'A new Article has been submitted by ''%1$s'' entitled ''%2$s''.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1371, 'COM_CONTENT_ORDERING', 'Ordering:<br />New articles default to the first position in the Category. The ordering can be changed in Backend.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1372, 'COM_CONTENT_PAGEBREAK_DOC_TITLE', 'Page Break', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1373, 'COM_CONTENT_PAGEBREAK_INSERT_BUTTON', 'Insert Page Break', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1374, 'COM_CONTENT_PAGEBREAK_TITLE', 'Page Title:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1375, 'COM_CONTENT_PAGEBREAK_TOC', 'Table of Contents Alias:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1376, 'COM_CONTENT_PARENT', 'Parent Category: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1377, 'COM_CONTENT_PUBLISHED_DATE', 'Published Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1378, 'COM_CONTENT_PUBLISHED_DATE_ON', 'Published: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1379, 'COM_CONTENT_PUBLISHING', 'Publishing', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1380, 'COM_CONTENT_READ_MORE', 'Read more: ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1381, 'COM_CONTENT_READ_MORE_TITLE', 'Read more ...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1382, 'COM_CONTENT_REGISTER_TO_READ_MORE', 'Register to read more ...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1383, 'COM_CONTENT_SAVE_SUCCESS', 'Article successfully saved.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1384, 'COM_CONTENT_SAVE_WARNING', 'Alias already existed so a number was added at the end. If you want to change the alias, please contact a site administrator', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1385, 'COM_CONTENT_SELECT_AN_ARTICLE', 'Select an Article', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1386, 'COM_CONTENT_SUBMIT_SAVE_SUCCESS', 'Article successfully submitted.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1387, 'COM_CONTENT_TITLE_FILTER_LABEL', 'Title Filter', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1388, 'COM_CONTENT_WRITTEN_BY', 'Written by %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1389, 'COM_CONTENT_FIELD_FULL_DESC', 'Image for the single article display.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1390, 'COM_CONTENT_FIELD_FULL_LABEL', 'Full Article Image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1391, 'COM_CONTENT_FIELD_IMAGE_DESC', 'The image to be displayed.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1392, 'COM_CONTENT_FIELD_IMAGE_ALT_DESC', 'Alternative text used for visitors without access to images. Replaced with caption text if it is present.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1393, 'COM_CONTENT_FIELD_IMAGE_ALT_LABEL', 'Alt Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1394, 'COM_CONTENT_FIELD_IMAGE_CAPTION_DESC', 'Caption attached to the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1395, 'COM_CONTENT_FIELD_IMAGE_CAPTION_LABEL', 'Caption', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1396, 'COM_CONTENT_FIELD_INTRO_DESC', 'Image for the intro text layouts such as blogs and featured.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1397, 'COM_CONTENT_FIELD_INTRO_LABEL', 'Intro Image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1398, 'COM_CONTENT_FIELD_URLC_LABEL', 'Link C', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1399, 'COM_CONTENT_FIELD_URL_DESC', 'Link for display.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1400, 'COM_CONTENT_FIELD_URLA_LABEL', 'Link A', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1401, 'COM_CONTENT_FIELD_URLA_LINK_TEXT_LABEL', 'Link A Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1402, 'COM_CONTENT_FIELD_URLB_LABEL', 'Link B', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1403, 'COM_CONTENT_FIELD_URL_LINK_TEXT_DESC', 'Text to display for the link.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1404, 'COM_CONTENT_FIELD_URLB_LINK_TEXT_LABEL', 'Link B Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1405, 'COM_CONTENT_FIELD_URLC_LINK_TEXT_LABEL', 'Link C Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1406, 'COM_CONTENT_FLOAT_DESC', 'Controls placement of the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1407, 'COM_CONTENT_FLOAT_LABEL', 'Image Float', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1408, 'COM_CONTENT_FLOAT_INTRO_LABEL', 'Intro Image float', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1409, 'COM_CONTENT_FLOAT_FULLTEXT_LABEL', 'Full text image float.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1410, 'COM_CONTENT_LEFT', 'Left', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1411, 'COM_CONTENT_RIGHT', 'Right', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1412, 'COM_CONTENT_FIELD_URL_LINK_TEXT_LABEL', 'Link Text', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1413, 'COM_CONTENT_IMAGES_AND_URLS', 'Images and Links', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_content.ini'),
(1414, 'COM_FINDER', 'Smart Search', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1415, 'COM_FINDER_ADVANCED_SEARCH_TOGGLE', 'Advanced Search', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1416, 'COM_FINDER_ADVANCED_TIPS', '<p>Here are a few examples of how you can use the search feature:</p><p>Entering <span class="term">this and that</span> into the search form will return results containing both &quot;this&quot; and &quot;that&quot;.</p><p>Entering <span class="term">this not that</span> into the search form will return results containing &quot;this&quot; and not &quot;that&quot;.</p><p>Entering <span class="term">this or that</span> into the search form will return results containing either &quot;this&quot; or &quot;that&quot;.</p><p>Entering <span class="term">&quot;this and that&quot;</span> (with quotes) into the search form will return results containing the exact phrase &quot;this and that&quot;.</p><p>Search results can also be filtered using a variety of criteria. Select one or more filters below to get started.</p>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1417, 'COM_FINDER_DEFAULT_PAGE_TITLE', 'Search Results', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1418, 'COM_FINDER_FILTER_BRANCH_LABEL', 'Search by %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1419, 'COM_FINDER_FILTER_DATE_BEFORE', 'Before', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1420, 'COM_FINDER_FILTER_DATE_EXACTLY', 'Exactly', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1421, 'COM_FINDER_FILTER_DATE_AFTER', 'After', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1422, 'COM_FINDER_FILTER_DATE1', 'Start Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1423, 'COM_FINDER_FILTER_DATE1_DESC', 'Enter a date in YYYY-MM-DD format.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1424, 'COM_FINDER_FILTER_DATE2', 'End Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1425, 'COM_FINDER_FILTER_DATE2_DESC', 'Enter a date in YYYY-MM-DD format.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1426, 'COM_FINDER_FILTER_SELECT_ALL_LABEL', 'Search All', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1427, 'COM_FINDER_FILTER_WHEN_AFTER', 'After', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1428, 'COM_FINDER_FILTER_WHEN_BEFORE', 'Before', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1429, 'COM_FINDER_QUERY_DATE_CONDITION_AFTER', 'after', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1430, 'COM_FINDER_QUERY_DATE_CONDITION_BEFORE', 'before', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1431, 'COM_FINDER_QUERY_DATE_CONDITION_EXACT', 'exactly on', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1432, 'COM_FINDER_QUERY_END_DATE', 'ending date <span class="when">%s</span> <span class="date">%s</span>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1433, 'COM_FINDER_QUERY_OPERATOR_AND', 'and', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1434, 'COM_FINDER_QUERY_OPERATOR_OR', 'or', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1435, 'COM_FINDER_QUERY_OPERATOR_NOT', 'not', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1436, 'COM_FINDER_QUERY_FILTER_BRANCH_VENUE', 'venue', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1437, 'COM_FINDER_QUERY_START_DATE', 'beginning date <span class="when">%s</span> <span class="date">%s</span>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1438, 'COM_FINDER_QUERY_TAXONOMY_NODE', 'with <span class="node">%s</span> as <span class="branch">%s</span> ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1439, 'COM_FINDER_QUERY_TOKEN_EXCLUDED', '<span class="term">%s</span> should be excluded.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1440, 'COM_FINDER_QUERY_TOKEN_GLUE', ', and ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1441, 'COM_FINDER_QUERY_TOKEN_INTERPRETED', 'Assuming %s, the following results were found.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1442, 'COM_FINDER_QUERY_TOKEN_OPTIONAL', '<span class="term">%s</span> is optional.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1443, 'COM_FINDER_QUERY_TOKEN_REQUIRED', '<span class="term">%s</span> is required.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1444, 'COM_FINDER_SEARCH_NO_RESULTS_BODY', 'No search results could be found for query: %s.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1445, 'COM_FINDER_SEARCH_NO_RESULTS_BODY_MULTILANG', 'No search results (in English-UK) could be found for query: %s.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1446, 'COM_FINDER_SEARCH_NO_RESULTS_HEADING', 'No Results Found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1447, 'COM_FINDER_SEARCH_RESULTS_OF', 'Results <strong>%s</strong> - <strong>%s</strong> of <strong>%s</strong>', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1448, 'COM_FINDER_SEARCH_SIMILAR', 'Did you mean: %s?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1449, 'COM_FINDER_SEARCH_TERMS', 'Search Terms:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_finder.ini'),
(1450, 'COM_JOOMGALLERY_EXIF_DATA', 'Exif-Data', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1451, 'COM_JOOMGALLERY_GPSTAGS', 'GPS-Tags', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1452, 'COM_JOOMGALLERY_GPS_GPSALTITUDE', 'Altitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1453, 'COM_JOOMGALLERY_GPS_GPSALTITUDEREF', 'Altitude Reference', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1454, 'COM_JOOMGALLERY_GPS_GPSALTITUDEREF_0', 'Sea level', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1455, 'COM_JOOMGALLERY_GPS_GPSALTITUDEREF_1', 'Sea level reference (negative value)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1456, 'COM_JOOMGALLERY_GPS_GPSALTITUDEREF_DESCRIPTION', 'Indicates the altitude used as the reference altitude.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1457, 'COM_JOOMGALLERY_GPS_GPSALTITUDE_DESCRIPTION', 'Indicates the altitude based on the reference in GPSAltitudeRef.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1458, 'COM_JOOMGALLERY_GPS_GPSALTITUDE_UNIT', 'metres', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1459, 'COM_JOOMGALLERY_GPS_GPSLATITUDE', 'Latitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1460, 'COM_JOOMGALLERY_GPS_GPSLATITUDEREF', 'North or South Latitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1461, 'COM_JOOMGALLERY_GPS_GPSLATITUDEREF_DESCRIPTION', 'Indicates whether the latitude is north or south latitude.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1462, 'COM_JOOMGALLERY_GPS_GPSLATITUDEREF_N', 'North latitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1463, 'COM_JOOMGALLERY_GPS_GPSLATITUDEREF_S', 'South latitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1464, 'COM_JOOMGALLERY_GPS_GPSLATITUDE_DESCRIPTION', 'Indicates the latitude.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1465, 'COM_JOOMGALLERY_GPS_GPSLONGITUDE', 'Longitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1466, 'COM_JOOMGALLERY_GPS_GPSLONGITUDEREF', 'East or West Longitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1467, 'COM_JOOMGALLERY_GPS_GPSLONGITUDEREF_DESCRIPTION', 'Indicates whether the longitude is east or west longitude.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1468, 'COM_JOOMGALLERY_GPS_GPSLONGITUDEREF_E', 'East longitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1469, 'COM_JOOMGALLERY_GPS_GPSLONGITUDEREF_W', 'West longitude', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1470, 'COM_JOOMGALLERY_GPS_GPSLONGITUDE_DESCRIPTION', 'Indicates the longitude.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1471, 'COM_JOOMGALLERY_IFD0TAGS', 'IFD0-Tags', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1472, 'COM_JOOMGALLERY_IFD0_ARTIST', 'Artist Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1473, 'COM_JOOMGALLERY_IFD0_ARTIST_DESCRIPTION', 'Name of Artist.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1474, 'COM_JOOMGALLERY_IFD0_COPYRIGHT', 'Copyright', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1475, 'COM_JOOMGALLERY_IFD0_COPYRIGHT_DESCRIPTION', 'Shows copyright information.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1476, 'COM_JOOMGALLERY_IFD0_DATETIME', 'Last Modified Date/Time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1477, 'COM_JOOMGALLERY_IFD0_DATETIME_DESCRIPTION', 'Date and Time of image was last modified.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1478, 'COM_JOOMGALLERY_IFD0_DOTSPERRESOLUTIONUNIT', 'Dots per Resolution Unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1479, 'COM_JOOMGALLERY_IFD0_IMAGEDESCRIPTION', 'Image Description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1480, 'COM_JOOMGALLERY_IFD0_IMAGEDESCRIPTION_DESCRIPTION', 'Describes image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1481, 'COM_JOOMGALLERY_IFD0_MAKE', 'Camera Make (Manufacturer)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1482, 'COM_JOOMGALLERY_IFD0_MAKE_DESCRIPTION', 'Shows manufacturer of digicam.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1483, 'COM_JOOMGALLERY_IFD0_MODEL', 'Camera Model', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1484, 'COM_JOOMGALLERY_IFD0_MODEL_DESCRIPTION', 'Shows model number of digicam.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1485, 'COM_JOOMGALLERY_IFD0_ORIENTATION', 'Picture Orientation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1486, 'COM_JOOMGALLERY_IFD0_ORIENTATION_1', 'The 0th row is at the visual top of the image, and the 0th column is the visual left-hand side.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1487, 'COM_JOOMGALLERY_IFD0_ORIENTATION_2', 'The 0th row is at the visual top of the image, and the 0th column is the visual right-hand side.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1488, 'COM_JOOMGALLERY_IFD0_ORIENTATION_3', 'The 0th row is at the visual bottom of the image, and the 0th column is the visual right-hand side.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1489, 'COM_JOOMGALLERY_IFD0_ORIENTATION_4', 'The 0th row is at the visual bottom of the image, and the 0th column is the visual left-hand side.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1490, 'COM_JOOMGALLERY_IFD0_ORIENTATION_5', 'The 0th row is the visual left-hand side of the image, and the 0th column is the visual top.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1491, 'COM_JOOMGALLERY_IFD0_ORIENTATION_6', 'The 0th row is the visual right-hand side of the image, and the 0th column is the visual top.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1492, 'COM_JOOMGALLERY_IFD0_ORIENTATION_7', 'The 0th row is the visual right-hand side of the image, and the 0th column is the visual bottom.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1493, 'COM_JOOMGALLERY_IFD0_ORIENTATION_8', 'The 0th row is the visual left-hand side of the image, and the 0th column is the visual bottom.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1494, 'COM_JOOMGALLERY_IFD0_ORIENTATION_DESCRIPTION', 'The orientation of the camera relative to the scene, when the image was captured.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1495, 'COM_JOOMGALLERY_IFD0_PRIMARYCHROMATICITIES', 'Primary Chromaticities', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1496, 'COM_JOOMGALLERY_IFD0_PRIMARYCHROMATICITIES_DESCRIPTION', 'Defines chromaticity of the primaries of the image (Red x,y, Green x,y, Blue x,y coordinates on a 1931 CIE xy chromaticity diagram).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1497, 'COM_JOOMGALLERY_IFD0_REFERENCEBLACKWHITE', 'Reference Black point and White point', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1498, 'COM_JOOMGALLERY_IFD0_REFERENCEBLACKWHITE_DESCRIPTION', 'Shows reference value of black point/white point. In case of YCbCr format, first 2 show black/white of Y, next 2 are Cb, last 2 are Cr. In case of RGB format, first 2 show black/white of R, next 2 are G, last 2 are B.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1499, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT', 'X/Y-Resolution Unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1500, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT_1', 'no-unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1501, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT_2', 'inch', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1502, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT_3', 'cm', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1503, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT_4', 'mm', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1504, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT_5', '&micro;m', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1505, 'COM_JOOMGALLERY_IFD0_RESOLUTIONUNIT_DESCRIPTION', 'Resolution Unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1506, 'COM_JOOMGALLERY_IFD0_SOFTWARE', 'Software/Firmware', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1507, 'COM_JOOMGALLERY_IFD0_SOFTWARE_DESCRIPTION', 'Shows firmware(internal software of digicam) version number.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini');
INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(1508, 'COM_JOOMGALLERY_IFD0_WHITEPOINT', 'White Point Chromaticity', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1509, 'COM_JOOMGALLERY_IFD0_WHITEPOINT_DESCRIPTION', 'Defines chromaticity of white point of the image (x,y coordinates on a 1931 CIE xy chromaticity diagram).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1510, 'COM_JOOMGALLERY_IFD0_XRESOLUTION', 'X-Resolution', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1511, 'COM_JOOMGALLERY_IFD0_XRESOLUTION_DESCRIPTION', 'Display/Print x-resolution of image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1512, 'COM_JOOMGALLERY_IFD0_YCBCRCOEFFICIENTS', 'Y/Cb/Cr Coefficients', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1513, 'COM_JOOMGALLERY_IFD0_YCBCRCOEFFICIENTS_DESCRIPTION', 'When image format is YCbCr, this value shows a constant to translate it to RGB format.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1514, 'COM_JOOMGALLERY_IFD0_YCBCRPOSITIONING', 'Y/Cb/Cr Positioning (Subsampling)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1515, 'COM_JOOMGALLERY_IFD0_YCBCRPOSITIONING_1', 'Chrominance components centred in relation to luminance components', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1516, 'COM_JOOMGALLERY_IFD0_YCBCRPOSITIONING_2', 'Chrominance and luminance components Co-Sited', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1517, 'COM_JOOMGALLERY_IFD0_YCBCRPOSITIONING_DESCRIPTION', 'Specifies location of chrominance and luminance components.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1518, 'COM_JOOMGALLERY_IFD0_YRESOLUTION', 'Y-Resolution', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1519, 'COM_JOOMGALLERY_IFD0_YRESOLUTION_DESCRIPTION', 'Display/Print y-resolution of image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1520, 'COM_JOOMGALLERY_SECONDS', 'seconds', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1521, 'COM_JOOMGALLERY_SUBIFDTAGS', 'Sub-IFD-Tags', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1522, 'COM_JOOMGALLERY_SUBIFD_APERTUREVALUE', 'APEX Aperture Value (Av)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1523, 'COM_JOOMGALLERY_SUBIFD_APERTUREVALUE_DESCRIPTION', 'The actual aperture value of lens when the image was taken. Unit is APEX.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1524, 'COM_JOOMGALLERY_SUBIFD_APERTUREVALUE_UNIT', 'Av', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1525, 'COM_JOOMGALLERY_SUBIFD_BRIGHTNESSVALUE', 'APEX Brightness Value (Bv)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1526, 'COM_JOOMGALLERY_SUBIFD_BRIGHTNESSVALUE_DESCRIPTION', 'Brightness of taken subject, unit is APEX.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1527, 'COM_JOOMGALLERY_SUBIFD_BRIGHTNESSVALUE_UNIT', 'Bv', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1528, 'COM_JOOMGALLERY_SUBIFD_COLORSPACE', 'Color Space', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1529, 'COM_JOOMGALLERY_SUBIFD_COLORSPACE_65535', 'Uncalibrated', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1530, 'COM_JOOMGALLERY_SUBIFD_COLORSPACE_DESCRIPTION', 'Defines Color Space.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1531, 'COM_JOOMGALLERY_SUBIFD_COLORSPACE_SRGB', 'sRGB', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1532, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION', 'Components Configuration', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1533, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_0', 'Does not exist', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1534, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_1', 'Y (Luminance)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1535, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_2', 'Cb (Chroma minus Blue)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1536, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_3', 'Cr(Chroma minus Red)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1537, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_4', 'R (Red)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1538, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_5', 'G (Green)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1539, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_6', 'B (Blue)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1540, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_COMPONENT', 'Component ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1541, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_DESCRIPTION', 'Information specific to compressed data.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1542, 'COM_JOOMGALLERY_SUBIFD_COMPONENTSCONFIGURATION_UNKNOWN', 'Unknown value:', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1543, 'COM_JOOMGALLERY_SUBIFD_COMPRESSEDBITSPERPIXEL', 'Compressed Bits Per Pixel', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1544, 'COM_JOOMGALLERY_SUBIFD_COMPRESSEDBITSPERPIXEL_DESCRIPTION', 'The compression mode used for a compressed image is indicated in unit bits per pixel.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1545, 'COM_JOOMGALLERY_SUBIFD_COMPRESSEDBITSPERPIXEL_UNIT', 'bpp', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1546, 'COM_JOOMGALLERY_SUBIFD_CONTRAST', 'Contrast', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1547, 'COM_JOOMGALLERY_SUBIFD_CONTRAST_0', 'Normal', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1548, 'COM_JOOMGALLERY_SUBIFD_CONTRAST_1', 'Soft', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1549, 'COM_JOOMGALLERY_SUBIFD_CONTRAST_2', 'Hard', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1550, 'COM_JOOMGALLERY_SUBIFD_CONTRAST_DESCRIPTION', 'This tag indicates the direction of contrast processing applied by the camera when the image was shot.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1551, 'COM_JOOMGALLERY_SUBIFD_DATETIMEDIGITIZED', 'Date and Time when Digitized', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1552, 'COM_JOOMGALLERY_SUBIFD_DATETIMEDIGITIZED_DESCRIPTION', 'Date/Time of image digitized.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1553, 'COM_JOOMGALLERY_SUBIFD_DATETIMEORIGINAL', 'Date and Time of Original', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1554, 'COM_JOOMGALLERY_SUBIFD_DATETIMEORIGINAL_DESCRIPTION', 'Date/Time of original image taken.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1555, 'COM_JOOMGALLERY_SUBIFD_DIGITALZOOMRATIO', 'Digital Zoom Ratio', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1556, 'COM_JOOMGALLERY_SUBIFD_DIGITALZOOMRATIO_DESCRIPTION', 'This tag indicates the digital zoom ratio when the image was shot.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1557, 'COM_JOOMGALLERY_SUBIFD_EXIFIMAGELENGTH', 'Image Height', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1558, 'COM_JOOMGALLERY_SUBIFD_EXIFIMAGELENGTH_DESCRIPTION', 'Size of main image (height).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1559, 'COM_JOOMGALLERY_SUBIFD_EXIFIMAGEWIDTH', 'Image Width', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1560, 'COM_JOOMGALLERY_SUBIFD_EXIFIMAGEWIDTHLENGTH_UNIT', 'px', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1561, 'COM_JOOMGALLERY_SUBIFD_EXIFIMAGEWIDTH_DESCRIPTION', 'Size of main image (width).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1562, 'COM_JOOMGALLERY_SUBIFD_EXIFVERSION', 'Exif Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1563, 'COM_JOOMGALLERY_SUBIFD_EXIFVERSION_DESCRIPTION', 'Exif version number.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1564, 'COM_JOOMGALLERY_SUBIFD_EXIFVERSION_VERSION', 'Version', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1565, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREBIASVALUE', 'APEX Exposure Bias Value (Ev)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1566, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREBIASVALUE_DESCRIPTION', 'The exposure bias. The unit is the APEX value.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1567, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREBIASVALUE_UNIT', 'Ev', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1568, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREINDEX', 'Exposure Index', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1569, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREINDEX_DESCRIPTION', 'Indicates the exposure index selected on the camera or input device at the time the image is captured.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1570, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREMODE', 'Exposure Mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1571, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREMODE_0', 'Auto Exposure', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1572, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREMODE_1', 'Manual Exposure', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1573, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREMODE_2', 'Auto Bracket', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1574, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREMODE_DESCRIPTION', 'Indicates the exposure mode selected on the camera or input device at the time the image is captured.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1575, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM', 'Exposure Program', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1576, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_0', 'Not defined', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1577, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_1', 'Manual', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1578, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_2', 'Normal program', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1579, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_3', 'Aperture priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1580, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_4', 'Shutter priority', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1581, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_5', 'Creative program (biased toward depth of field)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1582, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_6', 'Action program (biased toward fast shutter speed)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1583, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_7', 'Portrait mode (for closeup photos with the background out of focus)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1584, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_8', 'Landscape mode (for landscape photos with the background in focus)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1585, 'COM_JOOMGALLERY_SUBIFD_EXPOSUREPROGRAM_DESCRIPTION', 'Exposure program that the camera used when image was taken.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1586, 'COM_JOOMGALLERY_SUBIFD_EXPOSURETIME', 'Exposure Time', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1587, 'COM_JOOMGALLERY_SUBIFD_EXPOSURETIME_DESCRIPTION', 'Exposure time (reciprocal of shutter speed).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1588, 'COM_JOOMGALLERY_SUBIFD_FILESOURCE', 'File Source', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1589, 'COM_JOOMGALLERY_SUBIFD_FILESOURCE_3', 'Digital Still Camera', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1590, 'COM_JOOMGALLERY_SUBIFD_FILESOURCE_DESCRIPTION', 'Shows source of image file.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1591, 'COM_JOOMGALLERY_SUBIFD_FILESOURCE_UNKNOWN', 'Source unknown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1592, 'COM_JOOMGALLERY_SUBIFD_FLASH', 'Flash', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1593, 'COM_JOOMGALLERY_SUBIFD_FLASH_0', 'Flash did not fire', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1594, 'COM_JOOMGALLERY_SUBIFD_FLASH_13', 'Flash fired, compulsory flash mode, return light not detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1595, 'COM_JOOMGALLERY_SUBIFD_FLASH_15', 'Flash fired, compulsory flash mode, return light detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1596, 'COM_JOOMGALLERY_SUBIFD_FLASH_16', 'Flash did not fire, compulsory flash mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1597, 'COM_JOOMGALLERY_SUBIFD_FLASH_1', 'Flash fired', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1598, 'COM_JOOMGALLERY_SUBIFD_FLASH_20', 'Off, Flash did not fire, return light not detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1599, 'COM_JOOMGALLERY_SUBIFD_FLASH_24', 'Flash did not fire, auto mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1600, 'COM_JOOMGALLERY_SUBIFD_FLASH_25', 'Flash fired, auto mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1601, 'COM_JOOMGALLERY_SUBIFD_FLASH_29', 'Flash fired, auto mode, return light not detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1602, 'COM_JOOMGALLERY_SUBIFD_FLASH_31', 'Flash fired, auto mode, return light detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1603, 'COM_JOOMGALLERY_SUBIFD_FLASH_32', 'No flash function', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1604, 'COM_JOOMGALLERY_SUBIFD_FLASH_48', 'Off, no flash function', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1605, 'COM_JOOMGALLERY_SUBIFD_FLASH_5', 'Strobe return light not detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1606, 'COM_JOOMGALLERY_SUBIFD_FLASH_65', 'Flash fired, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1607, 'COM_JOOMGALLERY_SUBIFD_FLASH_69', 'Flash fired, red-eye reduction mode, return light not detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1608, 'COM_JOOMGALLERY_SUBIFD_FLASH_71', 'Flash fired, red-eye reduction mode, return light detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1609, 'COM_JOOMGALLERY_SUBIFD_FLASH_73', 'Flash fired, compulsory flash mode, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1610, 'COM_JOOMGALLERY_SUBIFD_FLASH_77', 'Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1611, 'COM_JOOMGALLERY_SUBIFD_FLASH_79', 'Flash fired, compulsory flash mode, red-eye reduction mode, return light detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1612, 'COM_JOOMGALLERY_SUBIFD_FLASH_7', 'Strobe return light detected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1613, 'COM_JOOMGALLERY_SUBIFD_FLASH_80', 'Off, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1614, 'COM_JOOMGALLERY_SUBIFD_FLASH_88', 'Flash did not fire, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1615, 'COM_JOOMGALLERY_SUBIFD_FLASH_89', 'Flash fired, auto mode, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1616, 'COM_JOOMGALLERY_SUBIFD_FLASH_8', 'On, Flash did not fire', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1617, 'COM_JOOMGALLERY_SUBIFD_FLASH_93', 'Flash fired, auto mode, return light not detected, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1618, 'COM_JOOMGALLERY_SUBIFD_FLASH_95', 'Flash fired, auto mode, return light detected, red-eye reduction mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1619, 'COM_JOOMGALLERY_SUBIFD_FLASH_9', 'Flash fired, compulsory flash mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1620, 'COM_JOOMGALLERY_SUBIFD_FLASH_DESCRIPTION', 'Shows information about flash if used.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1621, 'COM_JOOMGALLERY_SUBIFD_FNUMBER', 'Aperture F Number', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1622, 'COM_JOOMGALLERY_SUBIFD_FNUMBER_DESCRIPTION', 'The actual F-number(F-stop) of lens when the image was taken.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1623, 'COM_JOOMGALLERY_SUBIFD_FNUMBER_F', 'F', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1624, 'COM_JOOMGALLERY_SUBIFD_FOCALLENGTH', 'Focal Length', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1625, 'COM_JOOMGALLERY_SUBIFD_FOCALLENGTHIN35MMFILM', 'Equivalent Focal Length In 35mm Film', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1626, 'COM_JOOMGALLERY_SUBIFD_FOCALLENGTHIN35MMFILM_DESCRIPTION', 'This tag indicates the equivalent focal length assuming a 35mm film camera, in mm.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1627, 'COM_JOOMGALLERY_SUBIFD_FOCALLENGTHIN35MMFILM_UNIT', 'mm', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1628, 'COM_JOOMGALLERY_SUBIFD_FOCALLENGTH_DESCRIPTION', 'Focal length of lens used to take image. Unit is millimeter.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1629, 'COM_JOOMGALLERY_SUBIFD_FOCALLENGTH_UNIT', 'mm', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1630, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANERESOLUTIONUNIT', 'Focal Plane Resolution Unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1631, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANERESOLUTIONUNIT_1', 'No unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1632, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANERESOLUTIONUNIT_2', 'Inches', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1633, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANERESOLUTIONUNIT_3', 'Centimetres', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1634, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANERESOLUTIONUNIT_DESCRIPTION', 'Indicates the unit for measuring FocalPlaneXResolution and FocalPlaneYResolution.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1635, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANEXRESOLUTION', 'Focal Plane X Resolution', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1636, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANEXRESOLUTION_DESCRIPTION', 'Indicates the number of pixels in the image width (X) direction per FocalPlaneResolutionUnit on the camera focal plane.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1637, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANEXYRESOLUTION_UNIT', 'Pixel per Focal Plane Resolution Unit', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1638, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANEYRESOLUTION', 'Focal Plane Y Resolution', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1639, 'COM_JOOMGALLERY_SUBIFD_FOCALPLANEYRESOLUTION_DESCRIPTION', 'Indicates the number of pixels in the image height (Y) direction per FocalPlaneResolutionUnit on t he camera focal plane.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1640, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL', 'Gain Control', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1641, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL_0', 'None', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1642, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL_1', 'Low gain up', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1643, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL_2', 'High gain up', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1644, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL_3', 'Low gain down', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1645, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL_4', 'High gain down', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1646, 'COM_JOOMGALLERY_SUBIFD_GAINCONTROL_DESCRIPTION', 'This tag indicates the degree of overall image gain adjustment.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1647, 'COM_JOOMGALLERY_SUBIFD_ISOSPEEDRATINGS', 'ISO Speed Ratings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1648, 'COM_JOOMGALLERY_SUBIFD_ISOSPEEDRATINGS_DESCRIPTION', 'CCD sensitivity equivalent to Ag-Hr film speedrate.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1649, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE', 'Light Source', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1650, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_0', 'Unknown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1651, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_10', 'Cloudy weather', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1652, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_11', 'Shade', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1653, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_12', 'Daylight fluorescent (D 5700 - 7100K)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1654, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_13', 'Day white fluorescent (N 4600 - 5400K)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1655, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_14', 'Cool white fluorescent (W 3900 - 4500K)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1656, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_15', 'White fluorescent (WW 3200 - 3700K)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1657, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_17', 'Standard light A', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1658, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_18', 'Standard light B', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1659, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_19', 'Standard light C', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1660, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_1', 'Daylight', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1661, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_20', 'D55', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1662, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_21', 'D65', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1663, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_22', 'D75', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1664, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_23', 'D50', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1665, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_24', 'ISO studio tungsten', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1666, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_255', 'Other light source', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1667, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_2', 'Fluorescent', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1668, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_3', 'Tungsten (incandescent light)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1669, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_4', 'Flash', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1670, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_9', 'Fine weather', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1671, 'COM_JOOMGALLERY_SUBIFD_LIGHTSOURCE_DESCRIPTION', 'Light source, actually this means white balance setting.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1672, 'COM_JOOMGALLERY_SUBIFD_MAXAPERTUREVALUE', 'APEX Maximum Aperture Value', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1673, 'COM_JOOMGALLERY_SUBIFD_MAXAPERTUREVALUE_DESCRIPTION', 'The smallest F number of the lens. The unit is the APEX value.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1674, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE', 'Metering Mode', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1675, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_0', 'Unknown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1676, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_1', 'Average', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1677, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_255', 'Other', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1678, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_2', 'Center Weighted Average', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1679, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_3', 'Spot', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1680, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_4', 'Multi-Spot', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1681, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_5', 'Pattern', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1682, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_6', 'Partial', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1683, 'COM_JOOMGALLERY_SUBIFD_METERINGMODE_DESCRIPTION', 'Exposure metering method.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1684, 'COM_JOOMGALLERY_SUBIFD_SATURATION', 'Saturation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1685, 'COM_JOOMGALLERY_SUBIFD_SATURATION_0', 'Normal', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1686, 'COM_JOOMGALLERY_SUBIFD_SATURATION_1', 'low Saturation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1687, 'COM_JOOMGALLERY_SUBIFD_SATURATION_2', 'high Saturation', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1688, 'COM_JOOMGALLERY_SUBIFD_SATURATION_DESCRIPTION', 'This tag indicates the direction of saturation processing applied by the camera when the image was shot.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1689, 'COM_JOOMGALLERY_SUBIFD_SCENECAPTURETYPE', 'Scene Capture Type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1690, 'COM_JOOMGALLERY_SUBIFD_SCENECAPTURETYPE_0', 'Standard', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1691, 'COM_JOOMGALLERY_SUBIFD_SCENECAPTURETYPE_1', 'Landscape', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1692, 'COM_JOOMGALLERY_SUBIFD_SCENECAPTURETYPE_2', 'Portrait', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1693, 'COM_JOOMGALLERY_SUBIFD_SCENECAPTURETYPE_3', 'Night scene', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1694, 'COM_JOOMGALLERY_SUBIFD_SCENECAPTURETYPE_DESCRIPTION', 'This tag indicates the type of scene that was shot. It can also be used to record the mode in which the image was shot. Note that this differs from the scene type (SceneType) tag.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1695, 'COM_JOOMGALLERY_SUBIFD_SCENETYPE', 'Scene Type', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1696, 'COM_JOOMGALLERY_SUBIFD_SCENETYPE_1', 'A directly photographed image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1697, 'COM_JOOMGALLERY_SUBIFD_SCENETYPE_DESCRIPTION', 'Shows type of scene', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1698, 'COM_JOOMGALLERY_SUBIFD_SCENETYPE_UNKNOWN', 'Type unknown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1699, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD', 'Sensing Method', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1700, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_1', 'Not defined', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1701, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_2', 'One-chip color area sensor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1702, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_3', 'Two-chip color area sensor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1703, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_4', 'Three-chip color area sensor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1704, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_5', 'Color sequential area sensor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1705, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_7', 'Trilinear sensor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1706, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_8', 'Color sequential linear sensor', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1707, 'COM_JOOMGALLERY_SUBIFD_SENSINGMETHOD_DESCRIPTION', 'Shows type of image sensor unit.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1708, 'COM_JOOMGALLERY_SUBIFD_SHARPNESS', 'Sharpness', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1709, 'COM_JOOMGALLERY_SUBIFD_SHARPNESS_0', 'Normal', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1710, 'COM_JOOMGALLERY_SUBIFD_SHARPNESS_1', 'Soft', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1711, 'COM_JOOMGALLERY_SUBIFD_SHARPNESS_2', 'Hard', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1712, 'COM_JOOMGALLERY_SUBIFD_SHARPNESS_DESCRIPTION', 'This tag indicates the direction of sharpness processing applied by the camera when the image was shot.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1713, 'COM_JOOMGALLERY_SUBIFD_SHUTTERSPEEDVALUE', 'APEX Shutter Speed Value (Tv)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1714, 'COM_JOOMGALLERY_SUBIFD_SHUTTERSPEEDVALUE_DESCRIPTION', 'Shutter speed. The unit is the APEX (Additive System of Photographic Exposure) setting.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1715, 'COM_JOOMGALLERY_SUBIFD_SHUTTERSPEEDVALUE_UNIT', 'Tv', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1716, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCE', 'Subject Distance', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1717, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCERANGE', 'Subject Distance Range', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1718, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCERANGE_0', 'Unknown', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1719, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCERANGE_1', 'Macro', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1720, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCERANGE_2', 'Close view', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1721, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCERANGE_3', 'Distant view', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1722, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCERANGE_DESCRIPTION', 'This tag indicates the distance to the subject.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1723, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCE_DESCRIPTION', 'The distance to the subject, given in meters.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1724, 'COM_JOOMGALLERY_SUBIFD_SUBJECTDISTANCE_UNIT', 'metres', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1725, 'COM_JOOMGALLERY_SUBIFD_WHITEBALANCE', 'White Balance', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1726, 'COM_JOOMGALLERY_SUBIFD_WHITEBALANCE_0', 'Auto', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1727, 'COM_JOOMGALLERY_SUBIFD_WHITEBALANCE_1', 'Manual', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1728, 'COM_JOOMGALLERY_SUBIFD_WHITEBALANCE_DESCRIPTION', 'This tag indicates the white balance mode set when the image was shot.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1729, 'COM_JOOMGALLERY_TAG', 'Tag', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1730, 'COM_JOOMGALLERY_TAGDESCRIPTION', 'Description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1731, 'COM_JOOMGALLERY_TAGNAME', 'Tag-Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1732, 'COM_JOOMGALLERY_TAGNR', 'Tag-Nr.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.exif.ini'),
(1733, 'COM_JOOMGALLERY_AJAXUPLOAD_ALERT_FILENAME_DOUBLE', 'You already have selected that image for upload', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1734, 'COM_JOOMGALLERY_AJAXUPLOAD_ALERT_FILE_EMPTY', 'Image is empty, please select files again without it.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1735, 'COM_JOOMGALLERY_AJAXUPLOAD_ALERT_FILE_TOO_SMALL', 'Image is too small, minimum file size is', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1736, 'COM_JOOMGALLERY_AJAXUPLOAD_ALERT_NO_FILES', 'No images to upload.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1737, 'COM_JOOMGALLERY_AJAXUPLOAD_ALERT_ON_LEAVE', 'The images are being uploaded, if you leave now the upload will be cancelled.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1738, 'COM_JOOMGALLERY_AJAXUPLOAD_CLEAR_UPLOAD_LIST', 'Clear list', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1739, 'COM_JOOMGALLERY_AJAXUPLOAD_DRAGNDROPHINT', '* Note that Drag and Drop may not be supported with your browser.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1740, 'COM_JOOMGALLERY_AJAXUPLOAD_DRAGZONETEXT', 'Drop images here', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1741, 'COM_JOOMGALLERY_AJAXUPLOAD_DROPPROCESSINGTEXT', 'Processing dropped images...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1742, 'COM_JOOMGALLERY_AJAXUPLOAD_ERROR_CHUNKSDIR_NOTWRITABLE', 'Directory %s for saving image chunks isn''t writable.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1743, 'COM_JOOMGALLERY_AJAXUPLOAD_PROCESSING', 'Processing...', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1744, 'COM_JOOMGALLERY_AJAXUPLOAD_SELECT_IMAGES', 'Select or drop images here for upload *', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1745, 'COM_JOOMGALLERY_AJAXUPLOAD_UPLOAD_FAILED', 'Upload failed', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1746, 'COM_JOOMGALLERY_CATEGORY_COOLIRISLINK_TEXT', 'Start Cooliris!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1747, 'COM_JOOMGALLERY_CATEGORY_FEED_SUBCATEGORIES_TIPTEXT', 'Here you can subscribe to a news feed for the images in this category and all of its sub-categories.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1748, 'COM_JOOMGALLERY_CATEGORY_FEED_TIPCAPTION', 'Subscribe', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1749, 'COM_JOOMGALLERY_CATEGORY_FEED_TIPTEXT', 'Here you can subscribe to a news feed for the images in this category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1750, 'COM_JOOMGALLERY_CATEGORY_MSG_DELETE_NOT_PERMITTED', 'You are not allowed to delete this category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1751, 'COM_JOOMGALLERY_CATEGORY_MSG_EDITSTATE_NOT_PERMITTED', 'You are not allowed to edit the state of this category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1752, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY', 'Sort by', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1753, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_ASC', 'ascending', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1754, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_AUTHOR', 'Author', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1755, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_DATE', 'Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1756, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_DEFAULT', 'General Settings', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1757, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_DESC', 'descending', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1758, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_HITS', 'Number of Hits', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1759, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_RATING', 'Rating', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1760, 'COM_JOOMGALLERY_CATEGORY_OPTION_USER_ORDERBY_TITLE', 'Title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1761, 'COM_JOOMGALLERY_CATEGORY_THERE_ARE_IMAGES_IN_CATEGORY', 'There are %s images in category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1762, 'COM_JOOMGALLERY_CATEGORY_THERE_ARE_SUBCATEGORIES_IN_CATEGORY', 'There are %d sub-categories in this category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1763, 'COM_JOOMGALLERY_COMMON_ACCESS', 'Access', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1764, 'COM_JOOMGALLERY_COMMON_ACTION', 'Action', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1765, 'COM_JOOMGALLERY_COMMON_ALERT_CATEGORY_MUST_HAVE_TITLE', 'Category must have a title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1766, 'COM_JOOMGALLERY_COMMON_ALERT_IMAGE_MUST_HAVE_TITLE', 'Image must have a title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1767, 'COM_JOOMGALLERY_COMMON_ALERT_NO_DETAILVIEW_FOR_GUESTS', 'Guests are not allowed to view image details. Please login.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1768, 'COM_JOOMGALLERY_COMMON_ALERT_SURE_DELETE_SELECTED_ITEM', 'Are you sure you want to delete selected item?', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1769, 'COM_JOOMGALLERY_COMMON_ALERT_WRONG_EXTENSION', 'Wrong Filetype! Only .jpg, .jpeg, .jpe, .gif and .png are acceptable.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1770, 'COM_JOOMGALLERY_COMMON_ALERT_WRONG_FILENAME', 'No special characters are allowed in this field (a-z, A-Z, -, Blanks and _ are acceptable).', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1771, 'COM_JOOMGALLERY_COMMON_ALERT_WRONG_VALUE', 'Incorrect entry in field!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1772, 'COM_JOOMGALLERY_COMMON_ALERT_YOU_MUST_SELECT_CATEGORY', 'You must select a category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1773, 'COM_JOOMGALLERY_COMMON_ALERT_YOU_MUST_SELECT_ONE_FILE', 'Please select a file. ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1774, 'COM_JOOMGALLERY_COMMON_ALERT_YOU_MUST_SELECT_ONE_IMAGE', 'Please select an image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1775, 'COM_JOOMGALLERY_COMMON_ALIAS', 'Alias', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1776, 'COM_JOOMGALLERY_COMMON_ALL', '- Select Category -', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1777, 'COM_JOOMGALLERY_COMMON_APPROVED', 'Approved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1778, 'COM_JOOMGALLERY_COMMON_AUTHOR', 'Author', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1779, 'COM_JOOMGALLERY_COMMON_AUTHOR_OWNER', 'Author/Owner', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1780, 'COM_JOOMGALLERY_COMMON_AUTHOR_VAR', 'Author: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1781, 'COM_JOOMGALLERY_COMMON_BACK_TO_CATEGORY', 'Back to Category Overview', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1782, 'COM_JOOMGALLERY_COMMON_BACK_TO_GALLERY', 'Back to Gallery Overview', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1783, 'COM_JOOMGALLERY_COMMON_BACK_TO_USER_PANEL', 'Back to ''My Gallery''', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1784, 'COM_JOOMGALLERY_COMMON_CANCEL', 'Cancel', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1785, 'COM_JOOMGALLERY_COMMON_CATEGORIES', 'Categories', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1786, 'COM_JOOMGALLERY_COMMON_CATEGORIES_MORE_RESULTS', 'More Results', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1787, 'COM_JOOMGALLERY_COMMON_CATEGORIES_NO_RESULTS', 'No suitable categories found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1788, 'COM_JOOMGALLERY_COMMON_CATEGORY', 'Category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1789, 'COM_JOOMGALLERY_COMMON_CATEGORY_VAR', 'Category: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1790, 'COM_JOOMGALLERY_COMMON_CHECK_PERMISSIONS', 'Check permissions.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1791, 'COM_JOOMGALLERY_COMMON_COMMENT', 'Comment', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1792, 'COM_JOOMGALLERY_COMMON_COMMENTS_LASTDATE', 'Last commented:<br />%s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1793, 'COM_JOOMGALLERY_COMMON_COMMENTS_VAR', 'Comments: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1794, 'COM_JOOMGALLERY_COMMON_COMMENT_WITH_AUTHOR', '%1$s: "%2$s"', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1795, 'COM_JOOMGALLERY_COMMON_DATE', 'Date', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1796, 'COM_JOOMGALLERY_COMMON_DECIMAL_SEPARATOR', '.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1797, 'COM_JOOMGALLERY_COMMON_DELETE', 'Delete', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1798, 'COM_JOOMGALLERY_COMMON_DELETE_CATEGORY_TIPCAPTION', 'Delete category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1799, 'COM_JOOMGALLERY_COMMON_DELETE_CATEGORY_TIPTEXT', 'Click to delete the category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1800, 'COM_JOOMGALLERY_COMMON_DELETE_IMAGE_TIPCAPTION', 'Delete image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1801, 'COM_JOOMGALLERY_COMMON_DELETE_IMAGE_TIPTEXT', 'Click to delete the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1802, 'COM_JOOMGALLERY_COMMON_DESCRIPTION', 'Description', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1803, 'COM_JOOMGALLERY_COMMON_DESCRIPTION_VAR', 'Description: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1804, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_ADD_IMAGES_NOT_ALLOWED_TIPTEXT', 'Sorry, you have not enough rights to use the zip download.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1805, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_ADD_IMAGES_TIPCAPTION', 'Add all images to list of zip download', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1806, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_ADD_IMAGES_TIPTEXT', 'Here you can add all images of this category (without the ones of the sub-categories) to your list for the zip download. With the link <i>Zip Download</i> you can see all chosen images and download them in a zipfile.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1807, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_ADD_IMAGE_NOT_ALLOWED_TIPTEXT', 'Sorry, you have not enough rights to use the zip download.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1808, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_ADD_IMAGE_TIPCAPTION', 'Add image to list of zip download', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1809, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_ADD_IMAGE_TIPTEXT', 'Here you can add this image to your list for the zip download. With the link <i>Zip Download</i> you can see all chosen images and download them in a zipfile.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1810, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_DOWNLOAD_ALLOWED_TIPTEXT', 'You are then able to download these images all together in a zipfile, too.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1811, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_DOWNLOAD_NOT_ALLOWED_TIPTEXT', 'Sorry, you have not enough rights to use the zip download.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1812, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_DOWNLOAD_TIPTEXT', 'Here you can see all the images chosen by you for the zip download (These images can be downloaded all together in a zipfile). In order to add an image to this list you have to click on the respective symbol near to the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1813, 'COM_JOOMGALLERY_COMMON_DOWNLOADZIP_MY', 'Zip Download', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1814, 'COM_JOOMGALLERY_COMMON_DOWNLOAD_LOGIN_TIPTEXT', 'You need to login to download the image! ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1815, 'COM_JOOMGALLERY_COMMON_DOWNLOAD_TIPCAPTION', 'Download', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1816, 'COM_JOOMGALLERY_COMMON_DOWNLOAD_TIPTEXT', 'Click to download the image. ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1817, 'COM_JOOMGALLERY_COMMON_EDIT_CATEGORY_TIPCAPTION', 'Edit category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1818, 'COM_JOOMGALLERY_COMMON_EDIT_CATEGORY_TIPTEXT', 'Click to edit the category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1819, 'COM_JOOMGALLERY_COMMON_EDIT_IMAGE_TIPCAPTION', 'Edit image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1820, 'COM_JOOMGALLERY_COMMON_EDIT_IMAGE_TIPTEXT', 'Click to edit the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini');
INSERT INTO `#__overrider` (`id`, `constant`, `string`, `file`) VALUES
(1821, 'COM_JOOMGALLERY_COMMON_ERROR_CATEGORY_MUST_HAVE_TITLE', 'Category must have a title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1822, 'COM_JOOMGALLERY_COMMON_ERROR_IMAGE_MUST_HAVE_TITLE', 'Image must have a title', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1823, 'COM_JOOMGALLERY_COMMON_ERROR_IMAGE_NOT_FOUND', 'Image with ID %d not found', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1824, 'COM_JOOMGALLERY_COMMON_ERROR_INVALID_FILENAME', 'Invalid name of image for file system. Please ask your administrator for more information.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1825, 'COM_JOOMGALLERY_COMMON_ERROR_NO_CATEGORY_SELECTED', 'No category selected', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1826, 'COM_JOOMGALLERY_COMMON_FAVOURITES_ADD_IMAGES_NOT_ALLOWED_TIPTEXT', 'Sorry, you have not enough rights to use the favourites function.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1827, 'COM_JOOMGALLERY_COMMON_FAVOURITES_ADD_IMAGES_TIPCAPTION', 'Add all images to favourites', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1828, 'COM_JOOMGALLERY_COMMON_FAVOURITES_ADD_IMAGES_TIPTEXT', 'Here you can add all images of this category (without the ones of the sub-categories) to your favourites. With the link <i>My Favourites</i> you can see all images chosen by you.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1829, 'COM_JOOMGALLERY_COMMON_FAVOURITES_ADD_IMAGE_NOT_ALLOWED_TIPTEXT', 'Sorry, you have not enough rights to use the favourites function.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1830, 'COM_JOOMGALLERY_COMMON_FAVOURITES_ADD_IMAGE_TIPCAPTION', 'Add image to favourites', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1831, 'COM_JOOMGALLERY_COMMON_FAVOURITES_ADD_IMAGE_TIPTEXT', 'Here you can add this image to your favourites. With the link <i>My Favourites</i> you can see all images chosen by you.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1832, 'COM_JOOMGALLERY_COMMON_FAVOURITES_DOWNLOAD_NOT_ALLOWED_TIPTEXT', 'Sorry, you have not enough rights to use the favourites function.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1833, 'COM_JOOMGALLERY_COMMON_FAVOURITES_DOWNLOAD_TIPTEXT', 'Here you can see all your favourite images. In order to add an image to your favourites you have to click on the respective symbol near to the image.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1834, 'COM_JOOMGALLERY_COMMON_FAVOURITES_MY', 'My Favourites', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1835, 'COM_JOOMGALLERY_COMMON_FILTER_SEARCH', 'Search', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1836, 'COM_JOOMGALLERY_COMMON_GALLERY', 'Gallery', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1837, 'COM_JOOMGALLERY_COMMON_GUEST', 'Guest', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1838, 'COM_JOOMGALLERY_COMMON_HIDDEN_ASTERISK', '*', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1839, 'COM_JOOMGALLERY_COMMON_HITS', 'Hits', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1840, 'COM_JOOMGALLERY_COMMON_HITS_VAR', 'Hits: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1841, 'COM_JOOMGALLERY_COMMON_HOME', 'Home', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1842, 'COM_JOOMGALLERY_COMMON_ID', 'ID', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1843, 'COM_JOOMGALLERY_COMMON_IMAGE', 'Image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1844, 'COM_JOOMGALLERY_COMMON_IMAGE_NAME', 'Image Name', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1845, 'COM_JOOMGALLERY_COMMON_IMG_HW', '%s KB (%s x %s px)', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1846, 'COM_JOOMGALLERY_COMMON_IMPORTANT_NOTICE', 'I M P O R T A N T &nbsp;&nbsp;&nbsp; N O T I C E ! !', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1847, 'COM_JOOMGALLERY_COMMON_MSG_CATEGORY_SAVED', 'Category saved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1848, 'COM_JOOMGALLERY_COMMON_MSG_FORM_NOT_FILLED', 'Unfortunately, the form wasn''t filled completely.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1849, 'COM_JOOMGALLERY_COMMON_MSG_IMAGE_NOT_EXIST', 'Image does not exist', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1850, 'COM_JOOMGALLERY_COMMON_MSG_IMAGE_SAVED', 'Image saved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1851, 'COM_JOOMGALLERY_COMMON_MSG_MIME_NOT_ALLOWED', 'MIME not allowed: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1852, 'COM_JOOMGALLERY_COMMON_MSG_NOT_ALLOWED_STORE_IMAGE_IN_CATEGORY', 'You tried to store the image in a category for which you don''t have the permission to use. Because of that the image was stored in the old category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1853, 'COM_JOOMGALLERY_COMMON_MSG_NOT_ALLOWED_TO_EDIT_CATEGORY', 'You are not allowed to edit this category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1854, 'COM_JOOMGALLERY_COMMON_MSG_NOT_ALLOWED_TO_EDIT_IMAGE', 'You are not allowed to edit this image', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1855, 'COM_JOOMGALLERY_COMMON_MSG_NOT_ALLOWED_VIEW_IMAGE', 'You are not allowed to view this image!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1856, 'COM_JOOMGALLERY_COMMON_MSG_NO_ACCESS', 'No access', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1857, 'COM_JOOMGALLERY_COMMON_MSG_NO_VALID_CATEGORY_SELECTED', 'You haven''t selected a valid category, so the image was stored in the previous category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1858, 'COM_JOOMGALLERY_COMMON_MSG_ORIGINAL_NOT_AVAILABLE', 'Original image not available', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1859, 'COM_JOOMGALLERY_COMMON_MSG_SUCCESS_CHANGE_PUBLISH_STATE', 'The status of the publication has been successfully changed!', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1860, 'COM_JOOMGALLERY_COMMON_MSG_SUCCESS_DELETING_CATEGORY', 'Category successfully deleted. ', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1861, 'COM_JOOMGALLERY_COMMON_MSG_YOU_ARE_NOT_ALLOWED_TO_UPLOAD', 'You are not allowed to upload.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1862, 'COM_JOOMGALLERY_COMMON_MSG_YOU_ARE_NOT_ALLOWED_TO_UPLOAD_INTO_THIS_CATEGORY', 'You are not allowed to upload into this category.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1863, 'COM_JOOMGALLERY_COMMON_MSG_YOU_ARE_NOT_LOGGED', 'You are not logged in.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1864, 'COM_JOOMGALLERY_COMMON_NEW_CATEGORY', 'New category', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1865, 'COM_JOOMGALLERY_COMMON_NOT_ALLOWED_TO_PUBLISH_CATEGORY', 'The category with ID %d cannot be published because its parent category isn''t published.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1866, 'COM_JOOMGALLERY_COMMON_NOT_ALLOWED_TO_PUBLISH_IMAGE', 'The image with ID %d cannot be published because its category isn''t published.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1867, 'COM_JOOMGALLERY_COMMON_NOT_ALLOWED_TO_PUBLISH_NEW_CATEGORY', 'The category cannot be published because its parent category isn''t published.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1868, 'COM_JOOMGALLERY_COMMON_NOT_ALLOWED_TO_PUBLISH_NEW_IMAGE', 'The image cannot be published because its category isn''t published.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1869, 'COM_JOOMGALLERY_COMMON_NO_ACCESS', 'No access', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1870, 'COM_JOOMGALLERY_COMMON_NO_CATEGORY', '[None]', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1871, 'COM_JOOMGALLERY_COMMON_NO_CATEGORY_SPECIFIED', 'There wasn''t any category specified.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1872, 'COM_JOOMGALLERY_COMMON_NO_COMMENTS', 'No Comments', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1873, 'COM_JOOMGALLERY_COMMON_NO_DATA', 'No Data', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1874, 'COM_JOOMGALLERY_COMMON_NO_IMAGE_SPECIFIED', 'There wasn''t any image specified.', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1875, 'COM_JOOMGALLERY_COMMON_NO_VOTES', 'No Votes', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1876, 'COM_JOOMGALLERY_COMMON_NUMB_HITS_ALL_IMAGES', 'Total number of hits on all images: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1877, 'COM_JOOMGALLERY_COMMON_NUMB_IMAGES_ALL_CATEGORIES', 'Total images in all categories: %s', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1878, 'COM_JOOMGALLERY_COMMON_OF', 'of', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1879, 'COM_JOOMGALLERY_COMMON_ONE_VOTE', 'Vote', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1880, 'COM_JOOMGALLERY_COMMON_OPTION_APPROVED_ONLY', 'only approved', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1881, 'COM_JOOMGALLERY_COMMON_OPTION_CENTERED', 'Centered', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgallery.ini'),
(1882, 'COM_JOOMGALLERY_COMMON_OPTION_FLUSH_LEFT', 'Flush Left', 'C:\\wamp\\www\\framework\\language\\en-GB\\en-GB.com_joomgall