(function(){

// module factory: start

var moduleFactory = function($) {
// module body: start

var module = this; 
var exports = function() { 

 /*!
 * Buttons helper for fancyBox
 * version: 1.0.2
 * @requires fancyBox v2.0 or later
 *
 * Usage:
 *     $(".fancybox").fancybox({
 *         buttons: {
 *             position : 'top'
 *         }
 *     });
 *
 * Options:
 *     tpl - HTML template
 *     position - 'top' or 'bottom'
 *
 */

//Shortcut for fancyBox object
var F = $.fancybox;

//Add helper object
F.helpers.buttons = {
	tpl: '<div id="fancybox-buttons"><ul><li><a class="btnPrev" title="Previous" href="javascript:;"></a></li><li><a class="btnPlay" title="Start slideshow" href="javascript:;"></a></li><li><a class="btnNext" title="Next" href="javascript:;"></a></li><li><a class="btnToggle" title="Toggle size" href="javascript:;"></a></li><li><a class="btnClose" title="Close" href="javascript:jQuery.fancybox.close();"></a></li></ul></div>',
	list: null,
	buttons: {},

	update: function () {
		var toggle = this.buttons.toggle.removeClass('btnDisabled btnToggleOn');

		//Size toggle button
		if (F.current.canShrink) {
			toggle.addClass('btnToggleOn');

		} else if (!F.current.canExpand) {
			toggle.addClass('btnDisabled');
		}
	},

	beforeLoad: function (opts) {
		//Remove self if gallery do not have at least two items
		if (F.group.length < 2) {
			F.coming.helpers.buttons = false;
			F.coming.closeBtn = true;

			return;
		}

		//Increase top margin to give space for buttons
		F.coming.margin[ opts.position === 'bottom' ? 2 : 0 ] += 30;
	},

	onPlayStart: function () {
		if (this.list) {
			this.buttons.play.attr('title', 'Pause slideshow').addClass('btnPlayOn');
		}
	},

	onPlayEnd: function () {
		if (this.list) {
			this.buttons.play.attr('title', 'Start slideshow').removeClass('btnPlayOn');
		}
	},

	afterShow: function (opts) {
		var buttons;

		if (!this.list) {
			this.list = $(opts.tpl || this.tpl).addClass(opts.position || 'top').appendTo('body');

			this.buttons = {
				prev : this.list.find('.btnPrev').click( F.prev ),
				next : this.list.find('.btnNext').click( F.next ),
				play : this.list.find('.btnPlay').click( F.play ),
				toggle : this.list.find('.btnToggle').click( F.toggle )
			}
		}

		buttons = this.buttons;

		//Prev
		if (F.current.index > 0 || F.current.loop) {
			buttons.prev.removeClass('btnDisabled');
		} else {
			buttons.prev.addClass('btnDisabled');
		}

		//Next / Play
		if (F.current.loop || F.current.index < F.group.length - 1) {
			buttons.next.removeClass('btnDisabled');
			buttons.play.removeClass('btnDisabled');

		} else {
			buttons.next.addClass('btnDisabled');
			buttons.play.addClass('btnDisabled');
		}

		this.update();
	},

	onUpdate: function () {
		this.update();
	},

	beforeClose: function () {
		if (this.list) {
			this.list.remove();
		}

		this.list = null;
		this.buttons = {};
	}
};

}; 

exports(); 
module.resolveWith(exports); 

// module body: end

}; 
// module factory: end

FD31.module("fancybox/buttons", moduleFactory);

}());